# Amp CLI

[Amp](https://ampcode.com) is the frontier coding agent for your terminal and editor.

- **Multi-Model:** Claude Opus 4.5, GPT-5.2, fast models—Amp uses them all, for what each model is best at.
- **Opinionated:** You're always using the good parts of Amp. If we don't use and love a feature, we kill it.
- **On the Frontier:** Amp goes where the models take it. No backcompat, no legacy features.
- **Threads:** You can save and share your interactions with Amp. You wouldn't code without version control, would you?

Amp has [2 agent modes](https://ampcode.com/models):

- `smart`: unconstrained state-of-the-art model use (Claude Opus 4.5, GPT-5.2, and more)
- `rush`: fast and efficient, for narrowly defined tasks (Claude Haiku 4.5)

New users receive a [$10 daily grant](https://ampcode.com/free) for free usage across all modes.

<br/>

<img src="https://static.ampcode.com/content/amp-cli-20251026-1.gif" width="800" height="463" alt="Amp CLI">

## Get Started

1. Sign into [ampcode.com/install](https://ampcode.com/install) and follow the instructions to install the Amp CLI.
2. Run `amp` and ask Amp to do something in your codebase.

See the [Amp Owner's Manual](https://ampcode.com/manual) and [Switch to Amp](https://ampcode.com/manual/switch-from) for more information, and see [ampcode.com/news](https://ampcode.com/news) for what we've recently shipped.

## Recommended Installation

We recommend using our install script for macOS, Linux and WSL. It supports auto-updating and fast launch via Bun:

```bash
curl -fsSL https://ampcode.com/install.sh | bash
```

## Alternative Installation (npm)

If necessary, you can install via npm instead:

```bash
npm install -g @sourcegraph/amp@latest
# or
yarn global add @sourcegraph/amp@latest
```

Or run without installing:

```bash
npx -y @sourcegraph/amp@latest
```

## Usage

After installation, run `amp`.

For non-interactive environments (e.g. scripts, CI/CD pipelines), set your API key in the `AMP_API_KEY` environment variable.

See `amp --help` and the [Amp CLI documentation](https://ampcode.com/manual#cli) for more information.

## Support

For help and feedback: mention [@AmpCode](https://x.com/AmpCode) on X, or email [amp-devs@ampcode.com](mailto:amp-devs@ampcode.com). You can also join our community [Build Crew](https://buildcrew.team).

For account and billing help, contact [amp-devs@ampcode.com](mailto:amp-devs@ampcode.com).

---

## Development

**Binary Distribution (Experimental)**

Pre-compiled binaries for platforms without Node.js/Bun. Version must match npm for update checks.

```bash
# Build all platforms
LATEST_VERSION=$(npm view @sourcegraph/amp version)
AMP_BUILD_VERSION="$LATEST_VERSION" ./scripts/build-all-binaries.sh

# Test
./scripts/test-binary-release.sh
```

See scripts: `build-all-binaries.sh`, `upload-binaries.sh`, `test-binary-release.sh`
