#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-9rfM4AQJc8RK4tu80nAyuf
key:                  arch-hs-0.12.1-9rfM4AQJc8RK4tu80nAyuf
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  78082e23b56231a33120f4a26a23ed46
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.6.6/arch-hs-0.12.1
hs-libraries:         HSarch-hs-0.12.1-9rfM4AQJc8RK4tu80nAyuf
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.10.3.0 Diff-0.5-9iFzYwbbznxCTrvC5fevGO
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK
    algebraic-graphs-0.7-A9gWRuyx6CUAbpqlWVLXnW
    arch-web-0.3.2-FH5SFmo991fLmQ3Evrg169 base-4.18.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-4cc2yOSL2sy5iK6rZQd5vm
    conduit-extra-1.3.8-KyGJKsBlxeR6aLyGVSa94z containers-0.6.7
    deepseq-1.4.8.1 directory-1.3.8.5 filepath-1.4.300.1
    hackage-db-2.1.3-L2sz1bwQ98VKuZH2I39Ek6
    http-client-0.7.19-4rucZD6prn1Bn7NkqCpiFR
    http-client-tls-0.3.6.4-LhFztqm7Yl955SnS7vNn0b
    megaparsec-9.7.0-4yWx9K7i1Xa7WY3KCISRfK
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw
    neat-interpolation-0.5.1.4-AMExTIYnCI9E84uKNzmCbp
    optparse-simple-0.1.1.4-LUrYgzqe6kdGT9EoTRH6J7
    polysemy-1.9.2.0-8YsT2JYmdxfHDe1zT3uPBd
    prettyprinter-1.7.1-4PNEjQDcFkU8z4wKR8XxHs
    prettyprinter-ansi-terminal-1.1.3-16T9vhA2HoNHCC5fXPVq0T
    servant-client-0.20.3.0-IUxLwk8wnlmIyrMbJRkk0n
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8
    tar-conduit-0.4.1-Igs0d4Yn08h6oafM4jnh9u template-haskell-2.20.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs-git/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs-git/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

