/* automatically generated by rust-bindgen 0.69.5 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!(
            (bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len(),
        );
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!(
            (bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len(),
        );
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        *self
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const BCH_ACCOUNTING_MAX_COUNTERS: u32 = 3;
pub const BCH_SB_LABEL_SIZE: u32 = 32;
pub const BCH_LRU_BUCKET_FRAGMENTATION: u32 = 65535;
pub const BCH_LRU_STRIPE_FRAGMENTATION: u32 = 65534;
pub const BCH_ALLOC_V4_U64s_V0: u32 = 6;
pub const BCH_EXTENT_ENTRY_MAX: u32 = 9;
pub const BCH_DT_MAX: u32 = 17;
pub const BCH_NAME_MAX: u32 = 512;
pub const BCH_SB_MEMBERS_MAX: u32 = 64;
pub const BCH_SB_MEMBER_INVALID: u32 = 255;
pub const BCH_MIN_NR_NBUCKETS: u32 = 512;
pub const BCH_MI_BTREE_BITMAP_SHIFT_MAX: u32 = 58;
pub const BCH_MEMBER_V1_BYTES: u32 = 56;
pub const BCH_SB_SECTOR: u32 = 8;
pub const BCH_SB_LAYOUT_SIZE_BITS_MAX: u32 = 16;
pub const BCH_SB_LAYOUT_SECTOR: u32 = 7;
pub const BCH_SB_EXTENT_BP_SHIFT_DEFAULT: u32 = 10;
pub const BCH_REPLICAS_MAX: u32 = 4;
pub const BCH_BKEY_PTRS_MAX: u32 = 16;
pub const BCH_JOURNAL_BUCKETS_MIN: u32 = 8;
pub const BCH_WATERMARK_BITS: u32 = 3;
pub const BCH_WATERMARK_MASK: u32 = 7;
pub const BTREE_ITER_INITIAL: u32 = 64;
pub const BTREE_ITER_NORMAL_LIMIT: u32 = 256;
pub const BTREE_ITER_MAX: u32 = 1024;
pub const BCH_TRANSACTIONS_NR: u32 = 128;
pub const BCH_FORCE_IF_DATA_LOST: u32 = 1;
pub const BCH_FORCE_IF_METADATA_LOST: u32 = 2;
pub const BCH_FORCE_IF_DATA_DEGRADED: u32 = 4;
pub const BCH_FORCE_IF_METADATA_DEGRADED: u32 = 8;
pub const BCH_FORCE_IF_LOST: u32 = 3;
pub const BCH_FORCE_IF_DEGRADED: u32 = 12;
pub const BCH_BY_INDEX: u32 = 16;
pub const BCH_READ_DEV: u32 = 32;
pub const BCH_SUBVOL_SNAPSHOT_CREATE: u32 = 1;
pub const BCH_SUBVOL_SNAPSHOT_RO: u32 = 2;
pub const BCH_IOCTL_QUERY_COUNTERS_MOUNT: u32 = 1;
pub const BCH_SB_READ_SCRATCH_BUF_SIZE: u32 = 4096;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
pub type __time_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __loff_t = __off64_t;
pub type pid_t = __pid_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    const UNINIT: ::std::mem::MaybeUninit<timespec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec)),
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(timespec), "::", stringify!(tv_sec)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_nsec) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(timespec), "::", stringify!(tv_nsec)),
    );
}
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type uid_t = __uid_t;
pub type loff_t = __loff_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_internal_list> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list)),
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__prev) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__next) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next),
        ),
    );
}
impl Default for __pthread_internal_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_mutex_s> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s)),
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__lock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__owner) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__nusers) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__kind) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__spins) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__elision) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__list) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list),
        ),
    );
}
impl Default for __pthread_mutex_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_rwlock_arch_t() {
    const UNINIT: ::std::mem::MaybeUninit<__pthread_rwlock_arch_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__pthread_rwlock_arch_t>(),
        56usize,
        concat!("Size of: ", stringify!(__pthread_rwlock_arch_t)),
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_rwlock_arch_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_rwlock_arch_t)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__readers) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__readers),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__writers) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__wrphase_futex) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__wrphase_futex),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__writers_futex) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers_futex),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad3) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad3),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad4) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad4),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__cur_writer) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__cur_writer),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__shared) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__shared),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rwelision) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__rwelision),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad1) as usize - ptr as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad1),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad2) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad2),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__flags) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__flags),
        ),
    );
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    const UNINIT: ::std::mem::MaybeUninit<pthread_mutex_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t)),
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__align) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align),
        ),
    );
}
impl Default for pthread_mutex_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    const UNINIT: ::std::mem::MaybeUninit<pthread_rwlock_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t)),
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__align) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align),
        ),
    );
}
impl Default for pthread_rwlock_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type umode_t = ::std::os::raw::c_ushort;
pub type gfp_t = ::std::os::raw::c_uint;
pub type u64_ = __u64;
pub type s64 = __s64;
pub type u32_ = __u32;
pub type u16_ = __u16;
pub type s16 = __s16;
pub type u8_ = __u8;
pub type __le16 = __u16;
pub type __le32 = __u32;
pub type __le64 = __u64;
pub type sector_t = u64_;
pub type va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct static_key {
    pub v: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_static_key() {
    const UNINIT: ::std::mem::MaybeUninit<static_key> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<static_key>(),
        4usize,
        concat!("Size of: ", stringify!(static_key)),
    );
    assert_eq!(
        ::std::mem::align_of::<static_key>(),
        4usize,
        concat!("Alignment of ", stringify!(static_key)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(static_key), "::", stringify!(v)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct static_key_false {
    pub key: static_key,
}
#[test]
fn bindgen_test_layout_static_key_false() {
    const UNINIT: ::std::mem::MaybeUninit<static_key_false> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<static_key_false>(),
        4usize,
        concat!("Size of: ", stringify!(static_key_false)),
    );
    assert_eq!(
        ::std::mem::align_of::<static_key_false>(),
        4usize,
        concat!("Alignment of ", stringify!(static_key_false)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(static_key_false), "::", stringify!(key)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __uuid_t {
    pub b: [__u8; 16usize],
}
#[test]
fn bindgen_test_layout___uuid_t() {
    const UNINIT: ::std::mem::MaybeUninit<__uuid_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__uuid_t>(),
        16usize,
        concat!("Size of: ", stringify!(__uuid_t)),
    );
    assert_eq!(
        ::std::mem::align_of::<__uuid_t>(),
        1usize,
        concat!("Alignment of ", stringify!(__uuid_t)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).b) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(__uuid_t), "::", stringify!(b)),
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cds_list_head {
    pub next: *mut cds_list_head,
    pub prev: *mut cds_list_head,
}
#[test]
fn bindgen_test_layout_cds_list_head() {
    const UNINIT: ::std::mem::MaybeUninit<cds_list_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cds_list_head>(),
        16usize,
        concat!("Size of: ", stringify!(cds_list_head)),
    );
    assert_eq!(
        ::std::mem::align_of::<cds_list_head>(),
        8usize,
        concat!("Alignment of ", stringify!(cds_list_head)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cds_list_head), "::", stringify!(next)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prev) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(cds_list_head), "::", stringify!(prev)),
    );
}
impl Default for cds_list_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cds_hlist_head {
    pub next: *mut cds_hlist_node,
}
#[test]
fn bindgen_test_layout_cds_hlist_head() {
    const UNINIT: ::std::mem::MaybeUninit<cds_hlist_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cds_hlist_head>(),
        8usize,
        concat!("Size of: ", stringify!(cds_hlist_head)),
    );
    assert_eq!(
        ::std::mem::align_of::<cds_hlist_head>(),
        8usize,
        concat!("Alignment of ", stringify!(cds_hlist_head)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cds_hlist_head), "::", stringify!(next)),
    );
}
impl Default for cds_hlist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cds_hlist_node {
    pub next: *mut cds_hlist_node,
    pub prev: *mut cds_hlist_node,
}
#[test]
fn bindgen_test_layout_cds_hlist_node() {
    const UNINIT: ::std::mem::MaybeUninit<cds_hlist_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cds_hlist_node>(),
        16usize,
        concat!("Size of: ", stringify!(cds_hlist_node)),
    );
    assert_eq!(
        ::std::mem::align_of::<cds_hlist_node>(),
        8usize,
        concat!("Alignment of ", stringify!(cds_hlist_node)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cds_hlist_node), "::", stringify!(next)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prev) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(cds_hlist_node), "::", stringify!(prev)),
    );
}
impl Default for cds_hlist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct atomic_t {
    pub counter: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_atomic_t() {
    const UNINIT: ::std::mem::MaybeUninit<atomic_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<atomic_t>(),
        4usize,
        concat!("Size of: ", stringify!(atomic_t)),
    );
    assert_eq!(
        ::std::mem::align_of::<atomic_t>(),
        4usize,
        concat!("Alignment of ", stringify!(atomic_t)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).counter) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(atomic_t), "::", stringify!(counter)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct atomic_long_t {
    pub counter: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_atomic_long_t() {
    const UNINIT: ::std::mem::MaybeUninit<atomic_long_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<atomic_long_t>(),
        8usize,
        concat!("Size of: ", stringify!(atomic_long_t)),
    );
    assert_eq!(
        ::std::mem::align_of::<atomic_long_t>(),
        8usize,
        concat!("Alignment of ", stringify!(atomic_long_t)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).counter) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(atomic_long_t),
            "::",
            stringify!(counter),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct atomic64_t {
    pub counter: u64_,
}
#[test]
fn bindgen_test_layout_atomic64_t() {
    const UNINIT: ::std::mem::MaybeUninit<atomic64_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<atomic64_t>(),
        8usize,
        concat!("Size of: ", stringify!(atomic64_t)),
    );
    assert_eq!(
        ::std::mem::align_of::<atomic64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(atomic64_t)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).counter) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(atomic64_t), "::", stringify!(counter)),
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct raw_spinlock_t {
    pub lock: pthread_mutex_t,
}
#[test]
fn bindgen_test_layout_raw_spinlock_t() {
    const UNINIT: ::std::mem::MaybeUninit<raw_spinlock_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<raw_spinlock_t>(),
        40usize,
        concat!("Size of: ", stringify!(raw_spinlock_t)),
    );
    assert_eq!(
        ::std::mem::align_of::<raw_spinlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(raw_spinlock_t)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(raw_spinlock_t), "::", stringify!(lock)),
    );
}
impl Default for raw_spinlock_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type spinlock_t = raw_spinlock_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct wait_queue_head {
    pub lock: spinlock_t,
    pub task_list: cds_list_head,
}
#[test]
fn bindgen_test_layout_wait_queue_head() {
    const UNINIT: ::std::mem::MaybeUninit<wait_queue_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<wait_queue_head>(),
        56usize,
        concat!("Size of: ", stringify!(wait_queue_head)),
    );
    assert_eq!(
        ::std::mem::align_of::<wait_queue_head>(),
        8usize,
        concat!("Alignment of ", stringify!(wait_queue_head)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait_queue_head), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).task_list) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(wait_queue_head),
            "::",
            stringify!(task_list),
        ),
    );
}
impl Default for wait_queue_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type wait_queue_head_t = wait_queue_head;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct shrink_control {
    pub gfp_mask: gfp_t,
    pub nr_to_scan: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_shrink_control() {
    const UNINIT: ::std::mem::MaybeUninit<shrink_control> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shrink_control>(),
        16usize,
        concat!("Size of: ", stringify!(shrink_control)),
    );
    assert_eq!(
        ::std::mem::align_of::<shrink_control>(),
        8usize,
        concat!("Alignment of ", stringify!(shrink_control)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gfp_mask) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shrink_control),
            "::",
            stringify!(gfp_mask),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_to_scan) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(shrink_control),
            "::",
            stringify!(nr_to_scan),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct seq_buf {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shrinker {
    pub count_objects: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut shrinker,
            sc: *mut shrink_control,
        ) -> ::std::os::raw::c_ulong,
    >,
    pub scan_objects: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut shrinker,
            sc: *mut shrink_control,
        ) -> ::std::os::raw::c_ulong,
    >,
    pub to_text: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut seq_buf, arg2: *mut shrinker),
    >,
    pub seeks: ::std::os::raw::c_int,
    pub batch: ::std::os::raw::c_long,
    pub list: cds_list_head,
    pub private_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_shrinker() {
    const UNINIT: ::std::mem::MaybeUninit<shrinker> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<shrinker>(),
        64usize,
        concat!("Size of: ", stringify!(shrinker)),
    );
    assert_eq!(
        ::std::mem::align_of::<shrinker>(),
        8usize,
        concat!("Alignment of ", stringify!(shrinker)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count_objects) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shrinker),
            "::",
            stringify!(count_objects),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scan_objects) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(shrinker),
            "::",
            stringify!(scan_objects),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).to_text) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(shrinker), "::", stringify!(to_text)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seeks) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(shrinker), "::", stringify!(seeks)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).batch) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(shrinker), "::", stringify!(batch)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(shrinker), "::", stringify!(list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).private_data) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(shrinker),
            "::",
            stringify!(private_data),
        ),
    );
}
impl Default for shrinker {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn linux_shrinkers_init();
}
pub type mempool_alloc_t = ::std::option::Option<
    unsafe extern "C" fn(
        gfp_mask: gfp_t,
        pool_data: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type mempool_free_t = ::std::option::Option<
    unsafe extern "C" fn(
        element: *mut ::std::os::raw::c_void,
        pool_data: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mempool_s {
    pub lock: spinlock_t,
    pub min_nr: ::std::os::raw::c_int,
    pub curr_nr: ::std::os::raw::c_int,
    pub elements: *mut *mut ::std::os::raw::c_void,
    pub pool_data: *mut ::std::os::raw::c_void,
    pub alloc: mempool_alloc_t,
    pub free: mempool_free_t,
    pub wait: wait_queue_head_t,
}
#[test]
fn bindgen_test_layout_mempool_s() {
    const UNINIT: ::std::mem::MaybeUninit<mempool_s> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<mempool_s>(),
        136usize,
        concat!("Size of: ", stringify!(mempool_s)),
    );
    assert_eq!(
        ::std::mem::align_of::<mempool_s>(),
        8usize,
        concat!("Alignment of ", stringify!(mempool_s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(mempool_s), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_nr) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(mempool_s), "::", stringify!(min_nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).curr_nr) as usize - ptr as usize },
        44usize,
        concat!("Offset of field: ", stringify!(mempool_s), "::", stringify!(curr_nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).elements) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(mempool_s), "::", stringify!(elements)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pool_data) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(mempool_s), "::", stringify!(pool_data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alloc) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(mempool_s), "::", stringify!(alloc)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).free) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(mempool_s), "::", stringify!(free)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(mempool_s), "::", stringify!(wait)),
    );
}
impl Default for mempool_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type mempool_t = mempool_s;
pub type congested_fn = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct backing_dev_info {
    pub bdi_list: cds_list_head,
    pub ra_pages: ::std::os::raw::c_uint,
    pub capabilities: ::std::os::raw::c_uint,
    pub congested_fn: congested_fn,
    pub congested_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_backing_dev_info() {
    const UNINIT: ::std::mem::MaybeUninit<backing_dev_info> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<backing_dev_info>(),
        40usize,
        concat!("Size of: ", stringify!(backing_dev_info)),
    );
    assert_eq!(
        ::std::mem::align_of::<backing_dev_info>(),
        8usize,
        concat!("Alignment of ", stringify!(backing_dev_info)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bdi_list) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(backing_dev_info),
            "::",
            stringify!(bdi_list),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ra_pages) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(backing_dev_info),
            "::",
            stringify!(ra_pages),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).capabilities) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(backing_dev_info),
            "::",
            stringify!(capabilities),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).congested_fn) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(backing_dev_info),
            "::",
            stringify!(congested_fn),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).congested_data) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(backing_dev_info),
            "::",
            stringify!(congested_data),
        ),
    );
}
impl Default for backing_dev_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bio_vec {
    pub bv_addr: *mut ::std::os::raw::c_void,
    pub bv_len: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_bio_vec() {
    const UNINIT: ::std::mem::MaybeUninit<bio_vec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bio_vec>(),
        16usize,
        concat!("Size of: ", stringify!(bio_vec)),
    );
    assert_eq!(
        ::std::mem::align_of::<bio_vec>(),
        8usize,
        concat!("Alignment of ", stringify!(bio_vec)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bv_addr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bio_vec), "::", stringify!(bv_addr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bv_len) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bio_vec), "::", stringify!(bv_len)),
    );
}
impl Default for bio_vec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bvec_iter {
    pub bi_sector: sector_t,
    pub bi_size: ::std::os::raw::c_uint,
    pub bi_idx: ::std::os::raw::c_uint,
    pub bi_bvec_done: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_bvec_iter() {
    const UNINIT: ::std::mem::MaybeUninit<bvec_iter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bvec_iter>(),
        24usize,
        concat!("Size of: ", stringify!(bvec_iter)),
    );
    assert_eq!(
        ::std::mem::align_of::<bvec_iter>(),
        8usize,
        concat!("Alignment of ", stringify!(bvec_iter)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_sector) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bvec_iter), "::", stringify!(bi_sector)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bvec_iter), "::", stringify!(bi_size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_idx) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(bvec_iter), "::", stringify!(bi_idx)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_bvec_done) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bvec_iter),
            "::",
            stringify!(bi_bvec_done),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bvec_iter_all {
    pub idx: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bvec_iter_all() {
    const UNINIT: ::std::mem::MaybeUninit<bvec_iter_all> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bvec_iter_all>(),
        4usize,
        concat!("Size of: ", stringify!(bvec_iter_all)),
    );
    assert_eq!(
        ::std::mem::align_of::<bvec_iter_all>(),
        4usize,
        concat!("Alignment of ", stringify!(bvec_iter_all)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).idx) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bvec_iter_all), "::", stringify!(idx)),
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct attribute {
    pub name: *const ::std::os::raw::c_char,
    pub mode: umode_t,
}
#[test]
fn bindgen_test_layout_attribute() {
    const UNINIT: ::std::mem::MaybeUninit<attribute> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<attribute>(),
        16usize,
        concat!("Size of: ", stringify!(attribute)),
    );
    assert_eq!(
        ::std::mem::align_of::<attribute>(),
        8usize,
        concat!("Alignment of ", stringify!(attribute)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(attribute), "::", stringify!(name)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mode) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(attribute), "::", stringify!(mode)),
    );
}
impl Default for attribute {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct attribute_group {
    pub attrs: *mut *mut attribute,
}
#[test]
fn bindgen_test_layout_attribute_group() {
    const UNINIT: ::std::mem::MaybeUninit<attribute_group> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<attribute_group>(),
        8usize,
        concat!("Size of: ", stringify!(attribute_group)),
    );
    assert_eq!(
        ::std::mem::align_of::<attribute_group>(),
        8usize,
        concat!("Alignment of ", stringify!(attribute_group)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).attrs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(attribute_group),
            "::",
            stringify!(attrs),
        ),
    );
}
impl Default for attribute_group {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sysfs_ops {
    pub show: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut kobject,
            arg2: *mut attribute,
            arg3: *mut ::std::os::raw::c_char,
        ) -> isize,
    >,
    pub store: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut kobject,
            arg2: *mut attribute,
            arg3: *const ::std::os::raw::c_char,
            arg4: usize,
        ) -> isize,
    >,
}
#[test]
fn bindgen_test_layout_sysfs_ops() {
    const UNINIT: ::std::mem::MaybeUninit<sysfs_ops> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sysfs_ops>(),
        16usize,
        concat!("Size of: ", stringify!(sysfs_ops)),
    );
    assert_eq!(
        ::std::mem::align_of::<sysfs_ops>(),
        8usize,
        concat!("Alignment of ", stringify!(sysfs_ops)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).show) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sysfs_ops), "::", stringify!(show)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).store) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(sysfs_ops), "::", stringify!(store)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timer_list {
    pub expires: ::std::os::raw::c_ulong,
    pub function: ::std::option::Option<unsafe extern "C" fn(timer: *mut timer_list)>,
    pub pending: bool,
}
#[test]
fn bindgen_test_layout_timer_list() {
    const UNINIT: ::std::mem::MaybeUninit<timer_list> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timer_list>(),
        24usize,
        concat!("Size of: ", stringify!(timer_list)),
    );
    assert_eq!(
        ::std::mem::align_of::<timer_list>(),
        8usize,
        concat!("Alignment of ", stringify!(timer_list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).expires) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(timer_list), "::", stringify!(expires)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).function) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(timer_list), "::", stringify!(function)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(timer_list), "::", stringify!(pending)),
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct workqueue_struct {
    _unused: [u8; 0],
}
pub type work_func_t = ::std::option::Option<
    unsafe extern "C" fn(work: *mut work_struct),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct work_struct {
    pub data: atomic_long_t,
    pub entry: cds_list_head,
    pub func: work_func_t,
}
#[test]
fn bindgen_test_layout_work_struct() {
    const UNINIT: ::std::mem::MaybeUninit<work_struct> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<work_struct>(),
        32usize,
        concat!("Size of: ", stringify!(work_struct)),
    );
    assert_eq!(
        ::std::mem::align_of::<work_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(work_struct)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(work_struct), "::", stringify!(data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entry) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(work_struct), "::", stringify!(entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).func) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(work_struct), "::", stringify!(func)),
    );
}
impl Default for work_struct {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct delayed_work {
    pub work: work_struct,
    pub timer: timer_list,
    pub wq: *mut workqueue_struct,
}
#[test]
fn bindgen_test_layout_delayed_work() {
    const UNINIT: ::std::mem::MaybeUninit<delayed_work> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<delayed_work>(),
        64usize,
        concat!("Size of: ", stringify!(delayed_work)),
    );
    assert_eq!(
        ::std::mem::align_of::<delayed_work>(),
        8usize,
        concat!("Alignment of ", stringify!(delayed_work)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).work) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(delayed_work), "::", stringify!(work)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timer) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(delayed_work), "::", stringify!(timer)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wq) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(delayed_work), "::", stringify!(wq)),
    );
}
impl Default for delayed_work {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kobj_type {
    pub release: ::std::option::Option<unsafe extern "C" fn(kobj: *mut kobject)>,
    pub sysfs_ops: *const sysfs_ops,
    pub default_groups: *mut *const attribute_group,
    pub child_ns_type: ::std::option::Option<
        unsafe extern "C" fn(kobj: *mut kobject) -> *mut kobj_ns_type_operations,
    >,
    pub namespace: ::std::option::Option<
        unsafe extern "C" fn(kobj: *mut kobject) -> *const ::std::os::raw::c_void,
    >,
}
#[test]
fn bindgen_test_layout_kobj_type() {
    const UNINIT: ::std::mem::MaybeUninit<kobj_type> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kobj_type>(),
        40usize,
        concat!("Size of: ", stringify!(kobj_type)),
    );
    assert_eq!(
        ::std::mem::align_of::<kobj_type>(),
        8usize,
        concat!("Alignment of ", stringify!(kobj_type)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).release) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(kobj_type), "::", stringify!(release)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sysfs_ops) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(kobj_type), "::", stringify!(sysfs_ops)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).default_groups) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kobj_type),
            "::",
            stringify!(default_groups),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).child_ns_type) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kobj_type),
            "::",
            stringify!(child_ns_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).namespace) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(kobj_type), "::", stringify!(namespace)),
    );
}
impl Default for kobj_type {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kobject {
    pub parent: *mut kobject,
    pub kset: *mut kset,
    pub ktype: *const kobj_type,
    pub sd: *mut kernfs_node,
    pub ref_: atomic_t,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_kobject() {
    const UNINIT: ::std::mem::MaybeUninit<kobject> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kobject>(),
        40usize,
        concat!("Size of: ", stringify!(kobject)),
    );
    assert_eq!(
        ::std::mem::align_of::<kobject>(),
        8usize,
        concat!("Alignment of ", stringify!(kobject)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(kobject), "::", stringify!(parent)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kset) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(kobject), "::", stringify!(kset)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ktype) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(kobject), "::", stringify!(ktype)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sd) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(kobject), "::", stringify!(sd)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ref_) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(kobject), "::", stringify!(ref_)),
    );
}
impl Default for kobject {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl kobject {
    #[inline]
    pub fn state_initialized(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_state_initialized(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn state_in_sysfs(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_state_in_sysfs(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn state_add_uevent_sent(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_state_add_uevent_sent(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn state_remove_uevent_sent(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_state_remove_uevent_sent(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uevent_suppress(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uevent_suppress(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        state_initialized: ::std::os::raw::c_uint,
        state_in_sysfs: ::std::os::raw::c_uint,
        state_add_uevent_sent: ::std::os::raw::c_uint,
        state_remove_uevent_sent: ::std::os::raw::c_uint,
        uevent_suppress: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let state_initialized: u32 = unsafe {
                        ::std::mem::transmute(state_initialized)
                    };
                    state_initialized as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                1usize,
                1u8,
                {
                    let state_in_sysfs: u32 = unsafe {
                        ::std::mem::transmute(state_in_sysfs)
                    };
                    state_in_sysfs as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                2usize,
                1u8,
                {
                    let state_add_uevent_sent: u32 = unsafe {
                        ::std::mem::transmute(state_add_uevent_sent)
                    };
                    state_add_uevent_sent as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                3usize,
                1u8,
                {
                    let state_remove_uevent_sent: u32 = unsafe {
                        ::std::mem::transmute(state_remove_uevent_sent)
                    };
                    state_remove_uevent_sent as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                4usize,
                1u8,
                {
                    let uevent_suppress: u32 = unsafe {
                        ::std::mem::transmute(uevent_suppress)
                    };
                    uevent_suppress as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kset {
    pub kobj: kobject,
}
#[test]
fn bindgen_test_layout_kset() {
    const UNINIT: ::std::mem::MaybeUninit<kset> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kset>(),
        40usize,
        concat!("Size of: ", stringify!(kset)),
    );
    assert_eq!(
        ::std::mem::align_of::<kset>(),
        8usize,
        concat!("Alignment of ", stringify!(kset)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kobj) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(kset), "::", stringify!(kobj)),
    );
}
impl Default for kset {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mutex {
    pub lock: pthread_mutex_t,
}
#[test]
fn bindgen_test_layout_mutex() {
    const UNINIT: ::std::mem::MaybeUninit<mutex> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<mutex>(),
        40usize,
        concat!("Size of: ", stringify!(mutex)),
    );
    assert_eq!(
        ::std::mem::align_of::<mutex>(),
        8usize,
        concat!("Alignment of ", stringify!(mutex)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(mutex), "::", stringify!(lock)),
    );
}
impl Default for mutex {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rw_semaphore {
    pub lock: pthread_rwlock_t,
}
#[test]
fn bindgen_test_layout_rw_semaphore() {
    const UNINIT: ::std::mem::MaybeUninit<rw_semaphore> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rw_semaphore>(),
        56usize,
        concat!("Size of: ", stringify!(rw_semaphore)),
    );
    assert_eq!(
        ::std::mem::align_of::<rw_semaphore>(),
        8usize,
        concat!("Alignment of ", stringify!(rw_semaphore)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(rw_semaphore), "::", stringify!(lock)),
    );
}
impl Default for rw_semaphore {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type bio_end_io_t = ::std::option::Option<unsafe extern "C" fn(arg1: *mut bio)>;
pub type blk_mode_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct inode {
    pub i_ino: ::std::os::raw::c_ulong,
    pub i_size: loff_t,
    pub i_sb: *mut super_block,
    pub mode: blk_mode_t,
}
#[test]
fn bindgen_test_layout_inode() {
    const UNINIT: ::std::mem::MaybeUninit<inode> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<inode>(),
        32usize,
        concat!("Size of: ", stringify!(inode)),
    );
    assert_eq!(
        ::std::mem::align_of::<inode>(),
        8usize,
        concat!("Alignment of ", stringify!(inode)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i_ino) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(inode), "::", stringify!(i_ino)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i_size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(inode), "::", stringify!(i_size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i_sb) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(inode), "::", stringify!(i_sb)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mode) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(inode), "::", stringify!(mode)),
    );
}
impl Default for inode {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct request_queue {
    pub backing_dev_info: *mut backing_dev_info,
}
#[test]
fn bindgen_test_layout_request_queue() {
    const UNINIT: ::std::mem::MaybeUninit<request_queue> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<request_queue>(),
        8usize,
        concat!("Size of: ", stringify!(request_queue)),
    );
    assert_eq!(
        ::std::mem::align_of::<request_queue>(),
        8usize,
        concat!("Alignment of ", stringify!(request_queue)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).backing_dev_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(request_queue),
            "::",
            stringify!(backing_dev_info),
        ),
    );
}
impl Default for request_queue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct gendisk {
    pub _bindgen_opaque_blob: [u64; 6usize],
}
#[test]
fn bindgen_test_layout_gendisk() {
    assert_eq!(
        ::std::mem::size_of::<gendisk>(),
        48usize,
        concat!("Size of: ", stringify!(gendisk)),
    );
    assert_eq!(
        ::std::mem::align_of::<gendisk>(),
        8usize,
        concat!("Alignment of ", stringify!(gendisk)),
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct block_device {
    pub kobj: kobject,
    pub bd_device: block_device__bindgen_ty_1,
    pub bd_dev: dev_t,
    pub name: [::std::os::raw::c_char; 32usize],
    pub bd_inode: *mut inode,
    pub __bd_inode: inode,
    pub queue: request_queue,
    pub bd_holder: *mut ::std::os::raw::c_void,
    pub bd_disk: *mut gendisk,
    pub __bd_disk: gendisk,
    pub bd_fd: ::std::os::raw::c_int,
    pub bd_holder_lock: mutex,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct block_device__bindgen_ty_1 {
    pub kobj: kobject,
}
#[test]
fn bindgen_test_layout_block_device__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<block_device__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<block_device__bindgen_ty_1>(),
        40usize,
        concat!("Size of: ", stringify!(block_device__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<block_device__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(block_device__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kobj) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(block_device__bindgen_ty_1),
            "::",
            stringify!(kobj),
        ),
    );
}
impl Default for block_device__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_block_device() {
    const UNINIT: ::std::mem::MaybeUninit<block_device> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<block_device>(),
        280usize,
        concat!("Size of: ", stringify!(block_device)),
    );
    assert_eq!(
        ::std::mem::align_of::<block_device>(),
        8usize,
        concat!("Alignment of ", stringify!(block_device)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kobj) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(block_device), "::", stringify!(kobj)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bd_device) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(block_device),
            "::",
            stringify!(bd_device),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bd_dev) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(block_device), "::", stringify!(bd_dev)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        88usize,
        concat!("Offset of field: ", stringify!(block_device), "::", stringify!(name)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bd_inode) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(block_device),
            "::",
            stringify!(bd_inode),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__bd_inode) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(block_device),
            "::",
            stringify!(__bd_inode),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).queue) as usize - ptr as usize },
        160usize,
        concat!("Offset of field: ", stringify!(block_device), "::", stringify!(queue)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bd_holder) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(block_device),
            "::",
            stringify!(bd_holder),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bd_disk) as usize - ptr as usize },
        176usize,
        concat!("Offset of field: ", stringify!(block_device), "::", stringify!(bd_disk)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__bd_disk) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(block_device),
            "::",
            stringify!(__bd_disk),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bd_fd) as usize - ptr as usize },
        232usize,
        concat!("Offset of field: ", stringify!(block_device), "::", stringify!(bd_fd)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bd_holder_lock) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(block_device),
            "::",
            stringify!(bd_holder_lock),
        ),
    );
}
impl Default for block_device {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type blk_status_t = u8_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bio {
    pub bi_next: *mut bio,
    pub bi_bdev: *mut block_device,
    pub bi_status: blk_status_t,
    pub bi_opf: ::std::os::raw::c_uint,
    pub bi_flags: ::std::os::raw::c_ushort,
    pub bi_ioprio: ::std::os::raw::c_ushort,
    pub bi_iter: bvec_iter,
    pub __bi_remaining: atomic_t,
    pub bi_end_io: bio_end_io_t,
    pub bi_private: *mut ::std::os::raw::c_void,
    pub bi_vcnt: ::std::os::raw::c_ushort,
    pub bi_max_vecs: ::std::os::raw::c_ushort,
    pub __bi_cnt: atomic_t,
    pub bi_io_vec: *mut bio_vec,
    pub bi_pool: *mut bio_set,
}
#[test]
fn bindgen_test_layout_bio() {
    const UNINIT: ::std::mem::MaybeUninit<bio> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bio>(),
        104usize,
        concat!("Size of: ", stringify!(bio)),
    );
    assert_eq!(
        ::std::mem::align_of::<bio>(),
        8usize,
        concat!("Alignment of ", stringify!(bio)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_next) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_next)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_bdev) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_bdev)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_status) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_status)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_opf) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_opf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_flags) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_ioprio) as usize - ptr as usize },
        26usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_ioprio)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_iter) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_iter)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__bi_remaining) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(__bi_remaining)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_end_io) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_end_io)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_private) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_private)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_vcnt) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_vcnt)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_max_vecs) as usize - ptr as usize },
        82usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_max_vecs)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__bi_cnt) as usize - ptr as usize },
        84usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(__bi_cnt)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_io_vec) as usize - ptr as usize },
        88usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_io_vec)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_pool) as usize - ptr as usize },
        96usize,
        concat!("Offset of field: ", stringify!(bio), "::", stringify!(bi_pool)),
    );
}
impl Default for bio {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type blk_opf_t = __u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct file {
    pub f_inode: *mut inode,
}
#[test]
fn bindgen_test_layout_file() {
    const UNINIT: ::std::mem::MaybeUninit<file> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<file>(),
        8usize,
        concat!("Size of: ", stringify!(file)),
    );
    assert_eq!(
        ::std::mem::align_of::<file>(),
        8usize,
        concat!("Alignment of ", stringify!(file)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).f_inode) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(file), "::", stringify!(f_inode)),
    );
}
impl Default for file {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct super_block {
    pub s_fs_info: *mut ::std::os::raw::c_void,
    pub s_umount: rw_semaphore,
}
#[test]
fn bindgen_test_layout_super_block() {
    const UNINIT: ::std::mem::MaybeUninit<super_block> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<super_block>(),
        64usize,
        concat!("Size of: ", stringify!(super_block)),
    );
    assert_eq!(
        ::std::mem::align_of::<super_block>(),
        8usize,
        concat!("Alignment of ", stringify!(super_block)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s_fs_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(super_block),
            "::",
            stringify!(s_fs_info),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s_umount) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(super_block), "::", stringify!(s_umount)),
    );
}
impl Default for super_block {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bio_split(
        bio: *mut bio,
        sectors: ::std::os::raw::c_int,
        gfp: gfp_t,
        bs: *mut bio_set,
    ) -> *mut bio;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bio_set {
    pub front_pad: ::std::os::raw::c_uint,
    pub back_pad: ::std::os::raw::c_uint,
    pub bio_pool: mempool_t,
    pub bvec_pool: mempool_t,
}
#[test]
fn bindgen_test_layout_bio_set() {
    const UNINIT: ::std::mem::MaybeUninit<bio_set> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bio_set>(),
        280usize,
        concat!("Size of: ", stringify!(bio_set)),
    );
    assert_eq!(
        ::std::mem::align_of::<bio_set>(),
        8usize,
        concat!("Alignment of ", stringify!(bio_set)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).front_pad) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bio_set), "::", stringify!(front_pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).back_pad) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bio_set), "::", stringify!(back_pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bio_pool) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bio_set), "::", stringify!(bio_pool)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bvec_pool) as usize - ptr as usize },
        144usize,
        concat!("Offset of field: ", stringify!(bio_set), "::", stringify!(bvec_pool)),
    );
}
impl Default for bio_set {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bio_alloc_bioset(
        arg1: *mut block_device,
        arg2: ::std::os::raw::c_uint,
        arg3: blk_opf_t,
        arg4: gfp_t,
        arg5: *mut bio_set,
    ) -> *mut bio;
}
extern "C" {
    pub fn bio_put(arg1: *mut bio);
}
extern "C" {
    pub fn bio_add_virt_nofail(
        arg1: *mut bio,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bio_alloc_clone(
        arg1: *mut block_device,
        arg2: *mut bio,
        arg3: gfp_t,
        arg4: *mut bio_set,
    ) -> *mut bio;
}
extern "C" {
    pub fn bio_alloc(
        arg1: *mut block_device,
        arg2: ::std::os::raw::c_uint,
        arg3: blk_opf_t,
        arg4: gfp_t,
    ) -> *mut bio;
}
extern "C" {
    pub fn bio_kmalloc(arg1: ::std::os::raw::c_uint, arg2: gfp_t) -> *mut bio;
}
extern "C" {
    pub fn bio_endio(arg1: *mut bio);
}
extern "C" {
    pub fn bio_advance(arg1: *mut bio, arg2: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn bio_reset(
        arg1: *mut bio,
        arg2: *mut block_device,
        arg3: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bio_chain(arg1: *mut bio, arg2: *mut bio);
}
extern "C" {
    pub fn bio_copy_data_iter(
        dst: *mut bio,
        dst_iter: *mut bvec_iter,
        src: *mut bio,
        src_iter: *mut bvec_iter,
    );
}
extern "C" {
    pub fn bio_copy_data(dst: *mut bio, src: *mut bio);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bio_list {
    pub head: *mut bio,
    pub tail: *mut bio,
}
#[test]
fn bindgen_test_layout_bio_list() {
    const UNINIT: ::std::mem::MaybeUninit<bio_list> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bio_list>(),
        16usize,
        concat!("Size of: ", stringify!(bio_list)),
    );
    assert_eq!(
        ::std::mem::align_of::<bio_list>(),
        8usize,
        concat!("Alignment of ", stringify!(bio_list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).head) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bio_list), "::", stringify!(head)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tail) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bio_list), "::", stringify!(tail)),
    );
}
impl Default for bio_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct llist_head {
    pub first: *mut llist_node,
}
#[test]
fn bindgen_test_layout_llist_head() {
    const UNINIT: ::std::mem::MaybeUninit<llist_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<llist_head>(),
        8usize,
        concat!("Size of: ", stringify!(llist_head)),
    );
    assert_eq!(
        ::std::mem::align_of::<llist_head>(),
        8usize,
        concat!("Alignment of ", stringify!(llist_head)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).first) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(llist_head), "::", stringify!(first)),
    );
}
impl Default for llist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct llist_node {
    pub next: *mut llist_node,
}
#[test]
fn bindgen_test_layout_llist_node() {
    const UNINIT: ::std::mem::MaybeUninit<llist_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<llist_node>(),
        8usize,
        concat!("Size of: ", stringify!(llist_node)),
    );
    assert_eq!(
        ::std::mem::align_of::<llist_node>(),
        8usize,
        concat!("Alignment of ", stringify!(llist_node)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(llist_node), "::", stringify!(next)),
    );
}
impl Default for llist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct completion {
    pub done: ::std::os::raw::c_uint,
    pub wait: wait_queue_head_t,
}
#[test]
fn bindgen_test_layout_completion() {
    const UNINIT: ::std::mem::MaybeUninit<completion> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<completion>(),
        64usize,
        concat!("Size of: ", stringify!(completion)),
    );
    assert_eq!(
        ::std::mem::align_of::<completion>(),
        8usize,
        concat!("Alignment of ", stringify!(completion)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).done) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(completion), "::", stringify!(done)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(completion), "::", stringify!(wait)),
    );
}
impl Default for completion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type time64_t = __s64;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct task_struct {
    pub thread: pthread_t,
    pub thread_fn: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub thread_data: *mut ::std::os::raw::c_void,
    pub prio: ::std::os::raw::c_int,
    pub usage: atomic_t,
    pub state: ::std::os::raw::c_int,
    pub kthread_flags: ::std::os::raw::c_ulong,
    pub exited: completion,
    pub flags: ::std::os::raw::c_uint,
    pub on_cpu: bool,
    pub comm: [::std::os::raw::c_char; 16usize],
    pub pid: pid_t,
    pub bio_list: *mut bio_list,
    pub signal: *mut task_struct_signal_struct,
    pub _signal: task_struct_signal_struct,
    pub se: task_struct__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct task_struct_signal_struct {
    pub exec_update_lock: rw_semaphore,
}
#[test]
fn bindgen_test_layout_task_struct_signal_struct() {
    const UNINIT: ::std::mem::MaybeUninit<task_struct_signal_struct> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<task_struct_signal_struct>(),
        56usize,
        concat!("Size of: ", stringify!(task_struct_signal_struct)),
    );
    assert_eq!(
        ::std::mem::align_of::<task_struct_signal_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(task_struct_signal_struct)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exec_update_lock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_struct_signal_struct),
            "::",
            stringify!(exec_update_lock),
        ),
    );
}
impl Default for task_struct_signal_struct {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct task_struct__bindgen_ty_1 {
    pub sum_exec_runtime: u64_,
    pub exec_start: u64_,
}
#[test]
fn bindgen_test_layout_task_struct__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<task_struct__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<task_struct__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(task_struct__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<task_struct__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(task_struct__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sum_exec_runtime) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_struct__bindgen_ty_1),
            "::",
            stringify!(sum_exec_runtime),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exec_start) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_struct__bindgen_ty_1),
            "::",
            stringify!(exec_start),
        ),
    );
}
#[test]
fn bindgen_test_layout_task_struct() {
    const UNINIT: ::std::mem::MaybeUninit<task_struct> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<task_struct>(),
        232usize,
        concat!("Size of: ", stringify!(task_struct)),
    );
    assert_eq!(
        ::std::mem::align_of::<task_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(task_struct)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(thread)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread_fn) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_struct),
            "::",
            stringify!(thread_fn),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread_data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_struct),
            "::",
            stringify!(thread_data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prio) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(prio)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).usage) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(usage)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(state)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kthread_flags) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(task_struct),
            "::",
            stringify!(kthread_flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exited) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(exited)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        112usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).on_cpu) as usize - ptr as usize },
        116usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(on_cpu)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).comm) as usize - ptr as usize },
        117usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(comm)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pid) as usize - ptr as usize },
        136usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(pid)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bio_list) as usize - ptr as usize },
        144usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(bio_list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).signal) as usize - ptr as usize },
        152usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(signal)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._signal) as usize - ptr as usize },
        160usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(_signal)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).se) as usize - ptr as usize },
        216usize,
        concat!("Offset of field: ", stringify!(task_struct), "::", stringify!(se)),
    );
}
impl Default for task_struct {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ratelimit_state {
    pub lock: raw_spinlock_t,
    pub interval: ::std::os::raw::c_int,
    pub burst: ::std::os::raw::c_int,
    pub rs_n_left: atomic_t,
    pub missed: atomic_t,
    pub flags: ::std::os::raw::c_uint,
    pub begin: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_ratelimit_state() {
    const UNINIT: ::std::mem::MaybeUninit<ratelimit_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ratelimit_state>(),
        72usize,
        concat!("Size of: ", stringify!(ratelimit_state)),
    );
    assert_eq!(
        ::std::mem::align_of::<ratelimit_state>(),
        8usize,
        concat!("Alignment of ", stringify!(ratelimit_state)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(ratelimit_state), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interval) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ratelimit_state),
            "::",
            stringify!(interval),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).burst) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(ratelimit_state),
            "::",
            stringify!(burst),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rs_n_left) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ratelimit_state),
            "::",
            stringify!(rs_n_left),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).missed) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(ratelimit_state),
            "::",
            stringify!(missed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ratelimit_state),
            "::",
            stringify!(flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).begin) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(ratelimit_state),
            "::",
            stringify!(begin),
        ),
    );
}
impl Default for ratelimit_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type closure_fn = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut work_struct),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct closure_waitlist {
    pub list: llist_head,
}
#[test]
fn bindgen_test_layout_closure_waitlist() {
    const UNINIT: ::std::mem::MaybeUninit<closure_waitlist> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<closure_waitlist>(),
        8usize,
        concat!("Size of: ", stringify!(closure_waitlist)),
    );
    assert_eq!(
        ::std::mem::align_of::<closure_waitlist>(),
        8usize,
        concat!("Alignment of ", stringify!(closure_waitlist)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(closure_waitlist),
            "::",
            stringify!(list),
        ),
    );
}
impl Default for closure_waitlist {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct closure {
    pub __bindgen_anon_1: closure__bindgen_ty_1,
    pub parent: *mut closure,
    pub remaining: atomic_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union closure__bindgen_ty_1 {
    pub __bindgen_anon_1: closure__bindgen_ty_1__bindgen_ty_1,
    pub work: work_struct,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct closure__bindgen_ty_1__bindgen_ty_1 {
    pub wq: *mut workqueue_struct,
    pub sleeper: *mut task_struct,
    pub list: llist_node,
    pub fn_: closure_fn,
}
#[test]
fn bindgen_test_layout_closure__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<closure__bindgen_ty_1__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<closure__bindgen_ty_1__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(closure__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<closure__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(closure__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wq) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(closure__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(wq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sleeper) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(closure__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(sleeper),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(closure__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(list),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fn_) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(closure__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(fn_),
        ),
    );
}
impl Default for closure__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_closure__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<closure__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<closure__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(closure__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<closure__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(closure__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).work) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(closure__bindgen_ty_1),
            "::",
            stringify!(work),
        ),
    );
}
impl Default for closure__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_closure() {
    const UNINIT: ::std::mem::MaybeUninit<closure> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<closure>(),
        48usize,
        concat!("Size of: ", stringify!(closure)),
    );
    assert_eq!(
        ::std::mem::align_of::<closure>(),
        8usize,
        concat!("Alignment of ", stringify!(closure)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(closure), "::", stringify!(parent)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).remaining) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(closure), "::", stringify!(remaining)),
    );
}
impl Default for closure {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bch2_closure_sub(cl: *mut closure, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn __bch2_closure_wake_up(list: *mut closure_waitlist);
}
extern "C" {
    pub fn bch2_closure_wait(list: *mut closure_waitlist, cl: *mut closure) -> bool;
}
extern "C" {
    pub fn __bch2_closure_sync(cl: *mut closure);
}
extern "C" {
    pub fn __bch2_closure_sync_timeout(
        cl: *mut closure,
        timeout: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_closure_return_sync(cl: *mut closure);
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone)]
pub struct u128_u {
    pub hi: u64_,
    pub lo: u64_,
}
#[test]
fn bindgen_test_layout_u128_u() {
    const UNINIT: ::std::mem::MaybeUninit<u128_u> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<u128_u>(),
        16usize,
        concat!("Size of: ", stringify!(u128_u)),
    );
    assert_eq!(
        ::std::mem::align_of::<u128_u>(),
        16usize,
        concat!("Alignment of ", stringify!(u128_u)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hi) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(u128_u), "::", stringify!(hi)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lo) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(u128_u), "::", stringify!(lo)),
    );
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone)]
pub struct mean_and_variance {
    pub n: s64,
    pub sum: s64,
    pub sum_squares: u128_u,
}
#[test]
fn bindgen_test_layout_mean_and_variance() {
    const UNINIT: ::std::mem::MaybeUninit<mean_and_variance> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<mean_and_variance>(),
        32usize,
        concat!("Size of: ", stringify!(mean_and_variance)),
    );
    assert_eq!(
        ::std::mem::align_of::<mean_and_variance>(),
        16usize,
        concat!("Alignment of ", stringify!(mean_and_variance)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).n) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(mean_and_variance), "::", stringify!(n)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sum) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mean_and_variance),
            "::",
            stringify!(sum),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sum_squares) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mean_and_variance),
            "::",
            stringify!(sum_squares),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct mean_and_variance_weighted {
    pub mean: s64,
    pub variance: u64_,
}
#[test]
fn bindgen_test_layout_mean_and_variance_weighted() {
    const UNINIT: ::std::mem::MaybeUninit<mean_and_variance_weighted> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<mean_and_variance_weighted>(),
        16usize,
        concat!("Size of: ", stringify!(mean_and_variance_weighted)),
    );
    assert_eq!(
        ::std::mem::align_of::<mean_and_variance_weighted>(),
        8usize,
        concat!("Alignment of ", stringify!(mean_and_variance_weighted)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mean) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mean_and_variance_weighted),
            "::",
            stringify!(mean),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).variance) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mean_and_variance_weighted),
            "::",
            stringify!(variance),
        ),
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct darray_char {
    pub nr: usize,
    pub size: usize,
    pub data: *mut ::std::os::raw::c_char,
    pub preallocated: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[test]
fn bindgen_test_layout_darray_char() {
    const UNINIT: ::std::mem::MaybeUninit<darray_char> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<darray_char>(),
        24usize,
        concat!("Size of: ", stringify!(darray_char)),
    );
    assert_eq!(
        ::std::mem::align_of::<darray_char>(),
        8usize,
        concat!("Alignment of ", stringify!(darray_char)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(darray_char), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(darray_char), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(darray_char), "::", stringify!(data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(darray_char),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for darray_char {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct darray_u64 {
    pub nr: usize,
    pub size: usize,
    pub data: *mut u64_,
    pub preallocated: __IncompleteArrayField<u64_>,
}
#[test]
fn bindgen_test_layout_darray_u64() {
    const UNINIT: ::std::mem::MaybeUninit<darray_u64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<darray_u64>(),
        24usize,
        concat!("Size of: ", stringify!(darray_u64)),
    );
    assert_eq!(
        ::std::mem::align_of::<darray_u64>(),
        8usize,
        concat!("Alignment of ", stringify!(darray_u64)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(darray_u64), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(darray_u64), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(darray_u64), "::", stringify!(data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(darray_u64),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for darray_u64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct darray_const_str {
    pub nr: usize,
    pub size: usize,
    pub data: *mut *const ::std::os::raw::c_char,
    pub preallocated: __IncompleteArrayField<*const ::std::os::raw::c_char>,
}
#[test]
fn bindgen_test_layout_darray_const_str() {
    const UNINIT: ::std::mem::MaybeUninit<darray_const_str> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<darray_const_str>(),
        24usize,
        concat!("Size of: ", stringify!(darray_const_str)),
    );
    assert_eq!(
        ::std::mem::align_of::<darray_const_str>(),
        8usize,
        concat!("Alignment of ", stringify!(darray_const_str)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(darray_const_str), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(darray_const_str),
            "::",
            stringify!(size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(darray_const_str),
            "::",
            stringify!(data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(darray_const_str),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for darray_const_str {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn __bch2_darray_resize_noprof(
        arg1: *mut darray_char,
        arg2: usize,
        arg3: usize,
        arg4: gfp_t,
        arg5: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn match_string(
        arg1: *const *const ::std::os::raw::c_char,
        arg2: usize,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct time_unit {
    pub name: *const ::std::os::raw::c_char,
    pub nsecs: u64_,
}
#[test]
fn bindgen_test_layout_time_unit() {
    const UNINIT: ::std::mem::MaybeUninit<time_unit> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<time_unit>(),
        16usize,
        concat!("Size of: ", stringify!(time_unit)),
    );
    assert_eq!(
        ::std::mem::align_of::<time_unit>(),
        8usize,
        concat!("Alignment of ", stringify!(time_unit)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(time_unit), "::", stringify!(name)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nsecs) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(time_unit), "::", stringify!(nsecs)),
    );
}
impl Default for time_unit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bch2_pick_time_units(ns: u64_) -> *const time_unit;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct quantiles {
    pub entries: [quantiles_quantile_entry; 15usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct quantiles_quantile_entry {
    pub m: u64_,
    pub step: u64_,
}
#[test]
fn bindgen_test_layout_quantiles_quantile_entry() {
    const UNINIT: ::std::mem::MaybeUninit<quantiles_quantile_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<quantiles_quantile_entry>(),
        16usize,
        concat!("Size of: ", stringify!(quantiles_quantile_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<quantiles_quantile_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(quantiles_quantile_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).m) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(quantiles_quantile_entry),
            "::",
            stringify!(m),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).step) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(quantiles_quantile_entry),
            "::",
            stringify!(step),
        ),
    );
}
#[test]
fn bindgen_test_layout_quantiles() {
    const UNINIT: ::std::mem::MaybeUninit<quantiles> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<quantiles>(),
        240usize,
        concat!("Size of: ", stringify!(quantiles)),
    );
    assert_eq!(
        ::std::mem::align_of::<quantiles>(),
        8usize,
        concat!("Alignment of ", stringify!(quantiles)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(quantiles), "::", stringify!(entries)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct time_stat_buffer {
    pub nr: ::std::os::raw::c_uint,
    pub entries: [time_stat_buffer_time_stat_buffer_entry; 31usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct time_stat_buffer_time_stat_buffer_entry {
    pub start: u64_,
    pub end: u64_,
}
#[test]
fn bindgen_test_layout_time_stat_buffer_time_stat_buffer_entry() {
    const UNINIT: ::std::mem::MaybeUninit<time_stat_buffer_time_stat_buffer_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<time_stat_buffer_time_stat_buffer_entry>(),
        16usize,
        concat!("Size of: ", stringify!(time_stat_buffer_time_stat_buffer_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<time_stat_buffer_time_stat_buffer_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(time_stat_buffer_time_stat_buffer_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(time_stat_buffer_time_stat_buffer_entry),
            "::",
            stringify!(start),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(time_stat_buffer_time_stat_buffer_entry),
            "::",
            stringify!(end),
        ),
    );
}
#[test]
fn bindgen_test_layout_time_stat_buffer() {
    const UNINIT: ::std::mem::MaybeUninit<time_stat_buffer> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<time_stat_buffer>(),
        504usize,
        concat!("Size of: ", stringify!(time_stat_buffer)),
    );
    assert_eq!(
        ::std::mem::align_of::<time_stat_buffer>(),
        8usize,
        concat!("Alignment of ", stringify!(time_stat_buffer)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(time_stat_buffer), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(time_stat_buffer),
            "::",
            stringify!(entries),
        ),
    );
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub struct bch2_time_stats {
    pub lock: spinlock_t,
    pub have_quantiles: bool,
    pub buffer: *mut time_stat_buffer,
    pub min_duration: u64_,
    pub max_duration: u64_,
    pub total_duration: u64_,
    pub max_freq: u64_,
    pub min_freq: u64_,
    pub last_event: u64_,
    pub last_event_start: u64_,
    pub start_time: u64_,
    pub __bindgen_padding_0: u64,
    pub duration_stats: mean_and_variance,
    pub freq_stats: mean_and_variance,
    pub duration_stats_weighted: mean_and_variance_weighted,
    pub freq_stats_weighted: mean_and_variance_weighted,
}
#[test]
fn bindgen_test_layout_bch2_time_stats() {
    const UNINIT: ::std::mem::MaybeUninit<bch2_time_stats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch2_time_stats>(),
        224usize,
        concat!("Size of: ", stringify!(bch2_time_stats)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch2_time_stats>(),
        16usize,
        concat!("Alignment of ", stringify!(bch2_time_stats)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch2_time_stats), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).have_quantiles) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(have_quantiles),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(buffer),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_duration) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(min_duration),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_duration) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(max_duration),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_duration) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(total_duration),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_freq) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(max_freq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_freq) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(min_freq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_event) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(last_event),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_event_start) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(last_event_start),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_time) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(start_time),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).duration_stats) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(duration_stats),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).freq_stats) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(freq_stats),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).duration_stats_weighted) as usize - ptr as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(duration_stats_weighted),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).freq_stats_weighted) as usize - ptr as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats),
            "::",
            stringify!(freq_stats_weighted),
        ),
    );
}
impl Default for bch2_time_stats {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub struct bch2_time_stats_quantiles {
    pub stats: bch2_time_stats,
    pub quantiles: quantiles,
}
#[test]
fn bindgen_test_layout_bch2_time_stats_quantiles() {
    const UNINIT: ::std::mem::MaybeUninit<bch2_time_stats_quantiles> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch2_time_stats_quantiles>(),
        464usize,
        concat!("Size of: ", stringify!(bch2_time_stats_quantiles)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch2_time_stats_quantiles>(),
        16usize,
        concat!("Alignment of ", stringify!(bch2_time_stats_quantiles)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stats) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats_quantiles),
            "::",
            stringify!(stats),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).quantiles) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(bch2_time_stats_quantiles),
            "::",
            stringify!(quantiles),
        ),
    );
}
impl Default for bch2_time_stats_quantiles {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn __bch2_time_stats_clear_buffer(
        arg1: *mut bch2_time_stats,
        arg2: *mut time_stat_buffer,
    );
}
extern "C" {
    pub fn __bch2_time_stats_update(stats: *mut bch2_time_stats, arg1: u64_, arg2: u64_);
}
extern "C" {
    pub fn bch2_time_stats_reset(arg1: *mut bch2_time_stats);
}
extern "C" {
    pub fn bch2_time_stats_to_seq_buf(
        arg1: *mut seq_buf,
        arg2: *mut bch2_time_stats,
        epoch_name: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bch2_time_stats_to_json(
        arg1: *mut seq_buf,
        arg2: *mut bch2_time_stats,
        epoch_name: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bch2_time_stats_exit(arg1: *mut bch2_time_stats);
}
extern "C" {
    pub fn bch2_time_stats_init(arg1: *mut bch2_time_stats);
}
extern "C" {
    pub fn bch2_time_stats_init_no_pcpu(arg1: *mut bch2_time_stats);
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum printbuf_si {
    PRINTBUF_UNITS_2 = 0,
    PRINTBUF_UNITS_10 = 1,
}
#[repr(C)]
#[derive(Debug)]
pub struct printbuf {
    pub buf: *mut ::std::os::raw::c_char,
    pub size: ::std::os::raw::c_uint,
    pub pos: ::std::os::raw::c_uint,
    pub last_newline: ::std::os::raw::c_uint,
    pub last_field: ::std::os::raw::c_uint,
    pub indent: ::std::os::raw::c_uint,
    pub atomic: u8_,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub nr_tabstops: u8_,
    pub cur_tabstop: u8_,
    pub _tabstops: [u8_; 8usize],
}
#[test]
fn bindgen_test_layout_printbuf() {
    const UNINIT: ::std::mem::MaybeUninit<printbuf> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<printbuf>(),
        40usize,
        concat!("Size of: ", stringify!(printbuf)),
    );
    assert_eq!(
        ::std::mem::align_of::<printbuf>(),
        8usize,
        concat!("Alignment of ", stringify!(printbuf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(printbuf), "::", stringify!(buf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(printbuf), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(printbuf), "::", stringify!(pos)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_newline) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(printbuf),
            "::",
            stringify!(last_newline),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_field) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(printbuf), "::", stringify!(last_field)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).indent) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(printbuf), "::", stringify!(indent)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).atomic) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(printbuf), "::", stringify!(atomic)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_tabstops) as usize - ptr as usize },
        30usize,
        concat!("Offset of field: ", stringify!(printbuf), "::", stringify!(nr_tabstops)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cur_tabstop) as usize - ptr as usize },
        31usize,
        concat!("Offset of field: ", stringify!(printbuf), "::", stringify!(cur_tabstop)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._tabstops) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(printbuf), "::", stringify!(_tabstops)),
    );
}
impl Default for printbuf {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl printbuf {
    #[inline]
    pub fn allocation_failure(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_allocation_failure(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn heap_allocated(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_heap_allocated(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overflow(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_overflow(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn suppress(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_suppress(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn si_units(&self) -> printbuf_si {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_si_units(&mut self, val: printbuf_si) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn human_readable_units(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_human_readable_units(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_indent_or_tabstops(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_indent_or_tabstops(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn may_vmalloc(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_may_vmalloc(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        allocation_failure: bool,
        heap_allocated: bool,
        overflow: bool,
        suppress: bool,
        si_units: printbuf_si,
        human_readable_units: bool,
        has_indent_or_tabstops: bool,
        may_vmalloc: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let allocation_failure: u8 = unsafe {
                        ::std::mem::transmute(allocation_failure)
                    };
                    allocation_failure as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                1usize,
                1u8,
                {
                    let heap_allocated: u8 = unsafe {
                        ::std::mem::transmute(heap_allocated)
                    };
                    heap_allocated as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                2usize,
                1u8,
                {
                    let overflow: u8 = unsafe { ::std::mem::transmute(overflow) };
                    overflow as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                3usize,
                1u8,
                {
                    let suppress: u8 = unsafe { ::std::mem::transmute(suppress) };
                    suppress as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                4usize,
                1u8,
                {
                    let si_units: u32 = unsafe { ::std::mem::transmute(si_units) };
                    si_units as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                5usize,
                1u8,
                {
                    let human_readable_units: u8 = unsafe {
                        ::std::mem::transmute(human_readable_units)
                    };
                    human_readable_units as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                6usize,
                1u8,
                {
                    let has_indent_or_tabstops: u8 = unsafe {
                        ::std::mem::transmute(has_indent_or_tabstops)
                    };
                    has_indent_or_tabstops as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                1u8,
                {
                    let may_vmalloc: u8 = unsafe { ::std::mem::transmute(may_vmalloc) };
                    may_vmalloc as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct printbuf_restore {
    pub pos: ::std::os::raw::c_uint,
    pub cur_tabstop: u8_,
}
#[test]
fn bindgen_test_layout_printbuf_restore() {
    const UNINIT: ::std::mem::MaybeUninit<printbuf_restore> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<printbuf_restore>(),
        8usize,
        concat!("Size of: ", stringify!(printbuf_restore)),
    );
    assert_eq!(
        ::std::mem::align_of::<printbuf_restore>(),
        4usize,
        concat!("Alignment of ", stringify!(printbuf_restore)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(printbuf_restore), "::", stringify!(pos)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cur_tabstop) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(printbuf_restore),
            "::",
            stringify!(cur_tabstop),
        ),
    );
}
extern "C" {
    pub fn bch2_printbuf_make_room_gfp(
        arg1: *mut printbuf,
        arg2: ::std::os::raw::c_uint,
        arg3: gfp_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_printbuf_make_room(
        arg1: *mut printbuf,
        arg2: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_prt_printf(out: *mut printbuf, fmt: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn bch2_printbuf_str(arg1: *const printbuf) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn bch2_printbuf_exit(arg1: *mut printbuf);
}
extern "C" {
    pub fn bch2_printbuf_tabstops_reset(arg1: *mut printbuf);
}
extern "C" {
    pub fn bch2_printbuf_tabstop_pop(arg1: *mut printbuf);
}
extern "C" {
    pub fn bch2_printbuf_tabstop_push(
        arg1: *mut printbuf,
        arg2: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_printbuf_indent_add(arg1: *mut printbuf, arg2: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn bch2_printbuf_indent_add_nextline(
        arg1: *mut printbuf,
        arg2: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bch2_printbuf_indent_sub(arg1: *mut printbuf, arg2: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn bch2_prt_newline(arg1: *mut printbuf);
}
extern "C" {
    pub fn bch2_printbuf_strip_trailing_newline(arg1: *mut printbuf);
}
extern "C" {
    pub fn bch2_prt_tab(arg1: *mut printbuf);
}
extern "C" {
    pub fn bch2_prt_tab_rjust(arg1: *mut printbuf);
}
extern "C" {
    pub fn bch2_prt_bytes_indented(
        arg1: *mut printbuf,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bch2_prt_human_readable_u64(arg1: *mut printbuf, arg2: u64_);
}
extern "C" {
    pub fn bch2_prt_human_readable_s64(arg1: *mut printbuf, arg2: s64);
}
extern "C" {
    pub fn bch2_prt_units_u64(arg1: *mut printbuf, arg2: u64_);
}
extern "C" {
    pub fn bch2_prt_units_s64(arg1: *mut printbuf, arg2: s64);
}
extern "C" {
    pub fn bch2_prt_string_option(
        arg1: *mut printbuf,
        arg2: *const *const ::std::os::raw::c_char,
        arg3: usize,
    );
}
extern "C" {
    pub fn bch2_prt_bitflags(
        arg1: *mut printbuf,
        arg2: *const *const ::std::os::raw::c_char,
        arg3: u64_,
    );
}
extern "C" {
    pub fn bch2_prt_bitflags_vector(
        arg1: *mut printbuf,
        arg2: *const *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_ulong,
        arg4: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bch2_pr_time_units(arg1: *mut printbuf, arg2: u64_);
}
extern "C" {
    pub fn bch2_prt_datetime(arg1: *mut printbuf, arg2: time64_t);
}
extern "C" {
    pub fn bch2_strtoint_h(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_strtouint_h(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_strtoll_h(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_strtoull_h(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_ulonglong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_strtou64_h(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut u64_,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_is_zero(arg1: *const ::std::os::raw::c_void, arg2: usize) -> bool;
}
extern "C" {
    pub fn bch2_read_flag_list(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const *const ::std::os::raw::c_char,
    ) -> u64_;
}
extern "C" {
    pub fn bch2_prt_u64_base2_nbits(
        arg1: *mut printbuf,
        arg2: u64_,
        arg3: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bch2_prt_u64_base2(arg1: *mut printbuf, arg2: u64_);
}
extern "C" {
    pub fn bch2_print_string_as_lines(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_stacktrace {
    pub nr: usize,
    pub size: usize,
    pub data: *mut ::std::os::raw::c_ulong,
    pub preallocated: __IncompleteArrayField<::std::os::raw::c_ulong>,
}
#[test]
fn bindgen_test_layout_bch_stacktrace() {
    const UNINIT: ::std::mem::MaybeUninit<bch_stacktrace> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_stacktrace>(),
        24usize,
        concat!("Size of: ", stringify!(bch_stacktrace)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_stacktrace>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_stacktrace)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_stacktrace), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_stacktrace), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bch_stacktrace), "::", stringify!(data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_stacktrace),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for bch_stacktrace {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn bch2_save_backtrace(
        stack: *mut bch_stacktrace,
        arg1: *mut task_struct,
        arg2: ::std::os::raw::c_uint,
        arg3: gfp_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_prt_backtrace(arg1: *mut printbuf, arg2: *mut bch_stacktrace);
}
extern "C" {
    pub fn bch2_prt_task_backtrace(
        arg1: *mut printbuf,
        arg2: *mut task_struct,
        arg3: ::std::os::raw::c_uint,
        arg4: gfp_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_time_stats_to_text(arg1: *mut printbuf, arg2: *mut bch2_time_stats);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_ratelimit {
    pub next: u64_,
    pub rate: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_bch_ratelimit() {
    const UNINIT: ::std::mem::MaybeUninit<bch_ratelimit> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_ratelimit>(),
        16usize,
        concat!("Size of: ", stringify!(bch_ratelimit)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_ratelimit>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_ratelimit)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_ratelimit), "::", stringify!(next)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rate) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_ratelimit), "::", stringify!(rate)),
    );
}
extern "C" {
    pub fn bch2_ratelimit_delay(arg1: *mut bch_ratelimit) -> u64_;
}
extern "C" {
    pub fn bch2_ratelimit_increment(arg1: *mut bch_ratelimit, arg2: u64_);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_pd_controller {
    pub rate: bch_ratelimit,
    pub last_update: ::std::os::raw::c_ulong,
    pub last_actual: s64,
    pub smoothed_derivative: s64,
    pub p_term_inverse: ::std::os::raw::c_uint,
    pub d_smooth: ::std::os::raw::c_uint,
    pub d_term: ::std::os::raw::c_uint,
    pub last_derivative: s64,
    pub last_proportional: s64,
    pub last_change: s64,
    pub last_target: s64,
    pub backpressure: bool,
}
#[test]
fn bindgen_test_layout_bch_pd_controller() {
    const UNINIT: ::std::mem::MaybeUninit<bch_pd_controller> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_pd_controller>(),
        96usize,
        concat!("Size of: ", stringify!(bch_pd_controller)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_pd_controller>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_pd_controller)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rate) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(rate),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_update) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(last_update),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_actual) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(last_actual),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).smoothed_derivative) as usize - ptr as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(smoothed_derivative),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).p_term_inverse) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(p_term_inverse),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_smooth) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(d_smooth),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_term) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(d_term),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_derivative) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(last_derivative),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).last_proportional) as usize - ptr as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(last_proportional),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_change) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(last_change),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_target) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(last_target),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).backpressure) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_pd_controller),
            "::",
            stringify!(backpressure),
        ),
    );
}
extern "C" {
    pub fn bch2_pd_controller_update(
        arg1: *mut bch_pd_controller,
        arg2: s64,
        arg3: s64,
        arg4: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn bch2_pd_controller_init(arg1: *mut bch_pd_controller);
}
extern "C" {
    pub fn bch2_pd_controller_debug_to_text(
        arg1: *mut printbuf,
        arg2: *mut bch_pd_controller,
    );
}
extern "C" {
    pub fn bch2_bio_map(bio: *mut bio, base: *mut ::std::os::raw::c_void, arg1: usize);
}
extern "C" {
    pub fn bch2_bio_alloc_pages(
        arg1: *mut bio,
        arg2: ::std::os::raw::c_uint,
        arg3: usize,
        arg4: gfp_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_get_random_u64_below(arg1: u64_) -> u64_;
}
extern "C" {
    pub fn bch2_bio_to_text(arg1: *mut printbuf, arg2: *mut bio);
}
extern "C" {
    pub fn bch2_acc_percpu_u64s(
        arg1: *mut u64_,
        arg2: ::std::os::raw::c_uint,
    ) -> *mut u64_;
}
extern "C" {
    pub fn bch2_split_devs(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut darray_const_str,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bkey_format {
    pub key_u64s: __u8,
    pub nr_fields: __u8,
    pub bits_per_field: [__u8; 6usize],
    pub field_offset: [__le64; 6usize],
}
#[test]
fn bindgen_test_layout_bkey_format() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_format> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_format>(),
        56usize,
        concat!("Size of: ", stringify!(bkey_format)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_format>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_format)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_u64s) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bkey_format), "::", stringify!(key_u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_fields) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_format),
            "::",
            stringify!(nr_fields),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bits_per_field) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_format),
            "::",
            stringify!(bits_per_field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field_offset) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_format),
            "::",
            stringify!(field_offset),
        ),
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bpos {
    pub snapshot: __u32,
    pub offset: __u64,
    pub inode: __u64,
}
#[test]
fn bindgen_test_layout_bpos() {
    const UNINIT: ::std::mem::MaybeUninit<bpos> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bpos>(),
        20usize,
        concat!("Size of: ", stringify!(bpos)),
    );
    assert_eq!(
        ::std::mem::align_of::<bpos>(),
        4usize,
        concat!("Alignment of ", stringify!(bpos)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).snapshot) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bpos), "::", stringify!(snapshot)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bpos), "::", stringify!(offset)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inode) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(bpos), "::", stringify!(inode)),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_val {
    pub __nothing: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_bch_val() {
    const UNINIT: ::std::mem::MaybeUninit<bch_val> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_val>(),
        0usize,
        concat!("Size of: ", stringify!(bch_val)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_val>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_val)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__nothing) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_val), "::", stringify!(__nothing)),
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bversion {
    pub lo: __u64,
    pub hi: __u32,
}
#[test]
fn bindgen_test_layout_bversion() {
    const UNINIT: ::std::mem::MaybeUninit<bversion> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bversion>(),
        12usize,
        concat!("Size of: ", stringify!(bversion)),
    );
    assert_eq!(
        ::std::mem::align_of::<bversion>(),
        4usize,
        concat!("Alignment of ", stringify!(bversion)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lo) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bversion), "::", stringify!(lo)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hi) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bversion), "::", stringify!(hi)),
    );
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bkey {
    pub u64s: __u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub type_: __u8,
    pub pad: [__u8; 1usize],
    pub bversion: bversion,
    pub size: __u32,
    pub p: bpos,
}
#[test]
fn bindgen_test_layout_bkey() {
    const UNINIT: ::std::mem::MaybeUninit<bkey> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey>(),
        40usize,
        concat!("Size of: ", stringify!(bkey)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bkey), "::", stringify!(u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(bkey), "::", stringify!(type_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        3usize,
        concat!("Offset of field: ", stringify!(bkey), "::", stringify!(pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bversion) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bkey), "::", stringify!(bversion)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bkey), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).p) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(bkey), "::", stringify!(p)),
    );
}
impl bkey {
    #[inline]
    pub fn format(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u8) }
    }
    #[inline]
    pub fn set_format(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn needs_whiteout(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_whiteout(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        format: __u8,
        needs_whiteout: __u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                7u8,
                {
                    let format: u8 = unsafe { ::std::mem::transmute(format) };
                    format as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                1u8,
                {
                    let needs_whiteout: u8 = unsafe {
                        ::std::mem::transmute(needs_whiteout)
                    };
                    needs_whiteout as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(8))]
pub struct bkey_packed {
    pub _data: __IncompleteArrayField<__u64>,
    pub u64s: __u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub type_: __u8,
    pub key_start: __IncompleteArrayField<__u8>,
    pub pad: [__u8; 37usize],
}
#[test]
fn bindgen_test_layout_bkey_packed() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_packed> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_packed>(),
        40usize,
        concat!("Size of: ", stringify!(bkey_packed)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_packed>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_packed)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bkey_packed), "::", stringify!(_data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bkey_packed), "::", stringify!(u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(bkey_packed), "::", stringify!(type_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_start) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_packed),
            "::",
            stringify!(key_start),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        3usize,
        concat!("Offset of field: ", stringify!(bkey_packed), "::", stringify!(pad)),
    );
}
impl Default for bkey_packed {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bkey_packed {
    #[inline]
    pub fn format(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u8) }
    }
    #[inline]
    pub fn set_format(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn needs_whiteout(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_whiteout(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        format: __u8,
        needs_whiteout: __u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                7u8,
                {
                    let format: u8 = unsafe { ::std::mem::transmute(format) };
                    format as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                1u8,
                {
                    let needs_whiteout: u8 = unsafe {
                        ::std::mem::transmute(needs_whiteout)
                    };
                    needs_whiteout as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_le128 {
    pub lo: __le64,
    pub hi: __le64,
}
#[test]
fn bindgen_test_layout_bch_le128() {
    const UNINIT: ::std::mem::MaybeUninit<bch_le128> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_le128>(),
        16usize,
        concat!("Size of: ", stringify!(bch_le128)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_le128>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_le128)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lo) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_le128), "::", stringify!(lo)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hi) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_le128), "::", stringify!(hi)),
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_bkey_fields {
    BKEY_FIELD_INODE = 0,
    BKEY_FIELD_OFFSET = 1,
    BKEY_FIELD_SNAPSHOT = 2,
    BKEY_FIELD_SIZE = 3,
    BKEY_FIELD_VERSION_HI = 4,
    BKEY_FIELD_VERSION_LO = 5,
    BKEY_NR_FIELDS = 6,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bkey_i {
    pub _data: __IncompleteArrayField<__u64>,
    pub k: bkey,
    pub v: bch_val,
}
#[test]
fn bindgen_test_layout_bkey_i() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_i> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_i>(),
        40usize,
        concat!("Size of: ", stringify!(bkey_i)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_i>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_i)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bkey_i), "::", stringify!(_data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bkey_i), "::", stringify!(k)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(bkey_i), "::", stringify!(v)),
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_bkey_type_flags {
    BKEY_TYPE_strict_btree_checks = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_bkey_type {
    KEY_TYPE_deleted = 0,
    KEY_TYPE_whiteout = 1,
    KEY_TYPE_error = 2,
    KEY_TYPE_cookie = 3,
    KEY_TYPE_hash_whiteout = 4,
    KEY_TYPE_btree_ptr = 5,
    KEY_TYPE_extent = 6,
    KEY_TYPE_reservation = 7,
    KEY_TYPE_inode = 8,
    KEY_TYPE_inode_generation = 9,
    KEY_TYPE_dirent = 10,
    KEY_TYPE_xattr = 11,
    KEY_TYPE_alloc = 12,
    KEY_TYPE_quota = 13,
    KEY_TYPE_stripe = 14,
    KEY_TYPE_reflink_p = 15,
    KEY_TYPE_reflink_v = 16,
    KEY_TYPE_inline_data = 17,
    KEY_TYPE_btree_ptr_v2 = 18,
    KEY_TYPE_indirect_inline_data = 19,
    KEY_TYPE_alloc_v2 = 20,
    KEY_TYPE_subvolume = 21,
    KEY_TYPE_snapshot = 22,
    KEY_TYPE_inode_v2 = 23,
    KEY_TYPE_alloc_v3 = 24,
    KEY_TYPE_set = 25,
    KEY_TYPE_lru = 26,
    KEY_TYPE_alloc_v4 = 27,
    KEY_TYPE_backpointer = 28,
    KEY_TYPE_inode_v3 = 29,
    KEY_TYPE_bucket_gens = 30,
    KEY_TYPE_snapshot_tree = 31,
    KEY_TYPE_logged_op_truncate = 32,
    KEY_TYPE_logged_op_finsert = 33,
    KEY_TYPE_accounting = 34,
    KEY_TYPE_inode_alloc_cursor = 35,
    KEY_TYPE_extent_whiteout = 36,
    KEY_TYPE_MAX = 37,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_deleted {
    pub v: bch_val,
}
#[test]
fn bindgen_test_layout_bch_deleted() {
    const UNINIT: ::std::mem::MaybeUninit<bch_deleted> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_deleted>(),
        0usize,
        concat!("Size of: ", stringify!(bch_deleted)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_deleted>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_deleted)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_deleted), "::", stringify!(v)),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_whiteout {
    pub v: bch_val,
}
#[test]
fn bindgen_test_layout_bch_whiteout() {
    const UNINIT: ::std::mem::MaybeUninit<bch_whiteout> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_whiteout>(),
        0usize,
        concat!("Size of: ", stringify!(bch_whiteout)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_whiteout>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_whiteout)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_whiteout), "::", stringify!(v)),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_extent_whiteout {
    pub v: bch_val,
}
#[test]
fn bindgen_test_layout_bch_extent_whiteout() {
    const UNINIT: ::std::mem::MaybeUninit<bch_extent_whiteout> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_extent_whiteout>(),
        0usize,
        concat!("Size of: ", stringify!(bch_extent_whiteout)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_whiteout>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_whiteout)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_whiteout),
            "::",
            stringify!(v),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_error {
    pub v: bch_val,
    pub err: u8_,
    pub pad: [u8_; 7usize],
}
#[test]
fn bindgen_test_layout_bch_error() {
    const UNINIT: ::std::mem::MaybeUninit<bch_error> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_error>(),
        8usize,
        concat!("Size of: ", stringify!(bch_error)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_error>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_error)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_error), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).err) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_error), "::", stringify!(err)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        1usize,
        concat!("Offset of field: ", stringify!(bch_error), "::", stringify!(pad)),
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_key_type_errors {
    KEY_TYPE_ERROR_unknown = 0,
    KEY_TYPE_ERROR_device_removed = 1,
    KEY_TYPE_ERROR_double_allocation = 2,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_cookie {
    pub v: bch_val,
    pub cookie: __le64,
}
#[test]
fn bindgen_test_layout_bch_cookie() {
    const UNINIT: ::std::mem::MaybeUninit<bch_cookie> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_cookie>(),
        8usize,
        concat!("Size of: ", stringify!(bch_cookie)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_cookie>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_cookie)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_cookie), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cookie) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_cookie), "::", stringify!(cookie)),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_hash_whiteout {
    pub v: bch_val,
}
#[test]
fn bindgen_test_layout_bch_hash_whiteout() {
    const UNINIT: ::std::mem::MaybeUninit<bch_hash_whiteout> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_hash_whiteout>(),
        0usize,
        concat!("Size of: ", stringify!(bch_hash_whiteout)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_hash_whiteout>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_hash_whiteout)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_hash_whiteout), "::", stringify!(v)),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_set {
    pub v: bch_val,
}
#[test]
fn bindgen_test_layout_bch_set() {
    const UNINIT: ::std::mem::MaybeUninit<bch_set> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_set>(),
        0usize,
        concat!("Size of: ", stringify!(bch_set)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_set>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_set)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_set), "::", stringify!(v)),
    );
}
#[repr(C, packed(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_csum {
    pub lo: __le64,
    pub hi: __le64,
}
#[test]
fn bindgen_test_layout_bch_csum() {
    const UNINIT: ::std::mem::MaybeUninit<bch_csum> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_csum>(),
        16usize,
        concat!("Size of: ", stringify!(bch_csum)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_csum>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_csum)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lo) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_csum), "::", stringify!(lo)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hi) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_csum), "::", stringify!(hi)),
    );
}
#[repr(C, packed(8))]
pub struct bch_backpointer {
    pub v: bch_val,
    pub btree_id: __u8,
    pub level: __u8,
    pub data_type: __u8,
    pub bucket_gen: __u8,
    pub flags: __u32,
    pub bucket_len: __u32,
    pub pos: bpos,
}
#[test]
fn bindgen_test_layout_bch_backpointer() {
    const UNINIT: ::std::mem::MaybeUninit<bch_backpointer> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_backpointer>(),
        32usize,
        concat!("Size of: ", stringify!(bch_backpointer)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_backpointer>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_backpointer)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_backpointer), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btree_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_backpointer),
            "::",
            stringify!(btree_id),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_backpointer),
            "::",
            stringify!(level),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_type) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_backpointer),
            "::",
            stringify!(data_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bucket_gen) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_backpointer),
            "::",
            stringify!(bucket_gen),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_backpointer),
            "::",
            stringify!(flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bucket_len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_backpointer),
            "::",
            stringify!(bucket_len),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(bch_backpointer), "::", stringify!(pos)),
    );
}
impl Default for bch_backpointer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field {
    pub _data: __IncompleteArrayField<__u64>,
    pub u64s: __le32,
    pub type_: __le32,
}
#[test]
fn bindgen_test_layout_bch_sb_field() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_sb_field), "::", stringify!(_data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_sb_field), "::", stringify!(u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bch_sb_field), "::", stringify!(type_)),
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum btree_id {
    BTREE_ID_extents = 0,
    BTREE_ID_inodes = 1,
    BTREE_ID_dirents = 2,
    BTREE_ID_xattrs = 3,
    BTREE_ID_alloc = 4,
    BTREE_ID_quotas = 5,
    BTREE_ID_stripes = 6,
    BTREE_ID_reflink = 7,
    BTREE_ID_subvolumes = 8,
    BTREE_ID_snapshots = 9,
    BTREE_ID_lru = 10,
    BTREE_ID_freespace = 11,
    BTREE_ID_need_discard = 12,
    BTREE_ID_backpointers = 13,
    BTREE_ID_bucket_gens = 14,
    BTREE_ID_snapshot_trees = 15,
    BTREE_ID_deleted_inodes = 16,
    BTREE_ID_logged_ops = 17,
    BTREE_ID_reconcile_work = 18,
    BTREE_ID_subvolume_children = 19,
    BTREE_ID_accounting = 20,
    BTREE_ID_reconcile_hipri = 21,
    BTREE_ID_reconcile_pending = 22,
    BTREE_ID_reconcile_scan = 23,
    BTREE_ID_reconcile_work_phys = 24,
    BTREE_ID_reconcile_hipri_phys = 25,
    BTREE_ID_bucket_to_stripe = 26,
    BTREE_ID_NR = 27,
}
#[repr(C, packed)]
pub struct bch_replicas_entry_v0 {
    pub data_type: __u8,
    pub nr_devs: __u8,
    pub devs: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_replicas_entry_v0() {
    const UNINIT: ::std::mem::MaybeUninit<bch_replicas_entry_v0> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_replicas_entry_v0>(),
        2usize,
        concat!("Size of: ", stringify!(bch_replicas_entry_v0)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_replicas_entry_v0>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_replicas_entry_v0)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_entry_v0),
            "::",
            stringify!(data_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_devs) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_entry_v0),
            "::",
            stringify!(nr_devs),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).devs) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_entry_v0),
            "::",
            stringify!(devs),
        ),
    );
}
impl Default for bch_replicas_entry_v0 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_sb_field_replicas_v0 {
    pub field: bch_sb_field,
    pub entries: __IncompleteArrayField<bch_replicas_entry_v0>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_replicas_v0() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_replicas_v0> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_replicas_v0>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_replicas_v0)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_replicas_v0>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_replicas_v0)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_replicas_v0),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_replicas_v0),
            "::",
            stringify!(entries),
        ),
    );
}
impl Default for bch_sb_field_replicas_v0 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
pub struct bch_replicas_entry_v1 {
    pub data_type: __u8,
    pub nr_devs: __u8,
    pub nr_required: __u8,
    pub devs: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_replicas_entry_v1() {
    const UNINIT: ::std::mem::MaybeUninit<bch_replicas_entry_v1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_replicas_entry_v1>(),
        3usize,
        concat!("Size of: ", stringify!(bch_replicas_entry_v1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_replicas_entry_v1>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_replicas_entry_v1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_entry_v1),
            "::",
            stringify!(data_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_devs) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_entry_v1),
            "::",
            stringify!(nr_devs),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_required) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_entry_v1),
            "::",
            stringify!(nr_required),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).devs) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_entry_v1),
            "::",
            stringify!(devs),
        ),
    );
}
impl Default for bch_replicas_entry_v1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_sb_field_replicas {
    pub field: bch_sb_field,
    pub entries: __IncompleteArrayField<bch_replicas_entry_v1>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_replicas() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_replicas> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_replicas>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_replicas)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_replicas>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_replicas)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_replicas),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_replicas),
            "::",
            stringify!(entries),
        ),
    );
}
impl Default for bch_sb_field_replicas {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_accounting {
    pub v: bch_val,
    pub d: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_bch_accounting() {
    const UNINIT: ::std::mem::MaybeUninit<bch_accounting> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_accounting>(),
        0usize,
        concat!("Size of: ", stringify!(bch_accounting)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_accounting>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_accounting)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_accounting), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_accounting), "::", stringify!(d)),
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_data_type {
    BCH_DATA_free = 0,
    BCH_DATA_sb = 1,
    BCH_DATA_journal = 2,
    BCH_DATA_btree = 3,
    BCH_DATA_user = 4,
    BCH_DATA_cached = 5,
    BCH_DATA_parity = 6,
    BCH_DATA_stripe = 7,
    BCH_DATA_need_gc_gens = 8,
    BCH_DATA_need_discard = 9,
    BCH_DATA_unstriped = 10,
    BCH_DATA_NR = 11,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_nr_inodes {}
#[test]
fn bindgen_test_layout_bch_acct_nr_inodes() {
    assert_eq!(
        ::std::mem::size_of::<bch_acct_nr_inodes>(),
        0usize,
        concat!("Size of: ", stringify!(bch_acct_nr_inodes)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_nr_inodes>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_acct_nr_inodes)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_persistent_reserved {
    pub nr_replicas: __u8,
}
#[test]
fn bindgen_test_layout_bch_acct_persistent_reserved() {
    const UNINIT: ::std::mem::MaybeUninit<bch_acct_persistent_reserved> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_acct_persistent_reserved>(),
        1usize,
        concat!("Size of: ", stringify!(bch_acct_persistent_reserved)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_persistent_reserved>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_acct_persistent_reserved)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_replicas) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_acct_persistent_reserved),
            "::",
            stringify!(nr_replicas),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_dev_data_type {
    pub dev: __u8,
    pub data_type: __u8,
}
#[test]
fn bindgen_test_layout_bch_acct_dev_data_type() {
    const UNINIT: ::std::mem::MaybeUninit<bch_acct_dev_data_type> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_acct_dev_data_type>(),
        2usize,
        concat!("Size of: ", stringify!(bch_acct_dev_data_type)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_dev_data_type>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_acct_dev_data_type)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dev) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_acct_dev_data_type),
            "::",
            stringify!(dev),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_type) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_acct_dev_data_type),
            "::",
            stringify!(data_type),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_compression {
    pub type_: __u8,
}
#[test]
fn bindgen_test_layout_bch_acct_compression() {
    const UNINIT: ::std::mem::MaybeUninit<bch_acct_compression> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_acct_compression>(),
        1usize,
        concat!("Size of: ", stringify!(bch_acct_compression)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_compression>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_acct_compression)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_acct_compression),
            "::",
            stringify!(type_),
        ),
    );
}
#[repr(C, packed)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_snapshot {
    pub id: __u32,
}
#[test]
fn bindgen_test_layout_bch_acct_snapshot() {
    const UNINIT: ::std::mem::MaybeUninit<bch_acct_snapshot> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_acct_snapshot>(),
        4usize,
        concat!("Size of: ", stringify!(bch_acct_snapshot)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_snapshot>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_acct_snapshot)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_acct_snapshot), "::", stringify!(id)),
    );
}
#[repr(C, packed)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_btree {
    pub id: __u32,
}
#[test]
fn bindgen_test_layout_bch_acct_btree() {
    const UNINIT: ::std::mem::MaybeUninit<bch_acct_btree> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_acct_btree>(),
        4usize,
        concat!("Size of: ", stringify!(bch_acct_btree)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_btree>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_acct_btree)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_acct_btree), "::", stringify!(id)),
    );
}
#[repr(C, packed)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_inum {
    pub inum: __u64,
}
#[test]
fn bindgen_test_layout_bch_acct_inum() {
    const UNINIT: ::std::mem::MaybeUninit<bch_acct_inum> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_acct_inum>(),
        8usize,
        concat!("Size of: ", stringify!(bch_acct_inum)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_inum>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_acct_inum)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inum) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_acct_inum), "::", stringify!(inum)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_rebalance_work {}
#[test]
fn bindgen_test_layout_bch_acct_rebalance_work() {
    assert_eq!(
        ::std::mem::size_of::<bch_acct_rebalance_work>(),
        0usize,
        concat!("Size of: ", stringify!(bch_acct_rebalance_work)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_rebalance_work>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_acct_rebalance_work)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_reconcile_work {
    pub type_: __u8,
}
#[test]
fn bindgen_test_layout_bch_acct_reconcile_work() {
    const UNINIT: ::std::mem::MaybeUninit<bch_acct_reconcile_work> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_acct_reconcile_work>(),
        1usize,
        concat!("Size of: ", stringify!(bch_acct_reconcile_work)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_reconcile_work>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_acct_reconcile_work)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_acct_reconcile_work),
            "::",
            stringify!(type_),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_acct_dev_leaving {
    pub dev: __u32,
}
#[test]
fn bindgen_test_layout_bch_acct_dev_leaving() {
    const UNINIT: ::std::mem::MaybeUninit<bch_acct_dev_leaving> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_acct_dev_leaving>(),
        4usize,
        concat!("Size of: ", stringify!(bch_acct_dev_leaving)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_acct_dev_leaving>(),
        4usize,
        concat!("Alignment of ", stringify!(bch_acct_dev_leaving)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dev) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_acct_dev_leaving),
            "::",
            stringify!(dev),
        ),
    );
}
#[repr(C, packed(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_disk_group {
    pub label: [__u8; 32usize],
    pub flags: [__le64; 2usize],
}
#[test]
fn bindgen_test_layout_bch_disk_group() {
    const UNINIT: ::std::mem::MaybeUninit<bch_disk_group> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_disk_group>(),
        48usize,
        concat!("Size of: ", stringify!(bch_disk_group)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_disk_group>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_disk_group)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).label) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_disk_group), "::", stringify!(label)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(bch_disk_group), "::", stringify!(flags)),
    );
}
pub const BCH_GROUP_DELETED_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_GROUP_DELETED_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_GROUP_DELETED_MAX: __u64 = 1;
pub const BCH_GROUP_DATA_ALLOWED_OFFSET: ::std::os::raw::c_uint = 1;
pub const BCH_GROUP_DATA_ALLOWED_BITS: ::std::os::raw::c_uint = 5;
pub const BCH_GROUP_DATA_ALLOWED_MAX: __u64 = 31;
pub const BCH_GROUP_PARENT_OFFSET: ::std::os::raw::c_uint = 6;
pub const BCH_GROUP_PARENT_BITS: ::std::os::raw::c_uint = 18;
pub const BCH_GROUP_PARENT_MAX: __u64 = 262143;
#[repr(C, packed(8))]
pub struct bch_sb_field_disk_groups {
    pub field: bch_sb_field,
    pub entries: __IncompleteArrayField<bch_disk_group>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_disk_groups() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_disk_groups> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_disk_groups>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_disk_groups)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_disk_groups>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_disk_groups)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_disk_groups),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_disk_groups),
            "::",
            stringify!(entries),
        ),
    );
}
impl Default for bch_sb_field_disk_groups {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_lru {
    pub v: bch_val,
    pub idx: __le64,
}
#[test]
fn bindgen_test_layout_bch_lru() {
    const UNINIT: ::std::mem::MaybeUninit<bch_lru> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_lru>(),
        8usize,
        concat!("Size of: ", stringify!(bch_lru)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_lru>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_lru)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_lru), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).idx) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_lru), "::", stringify!(idx)),
    );
}
impl Default for bch_lru {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_lru_type {
    BCH_LRU_read = 0,
    BCH_LRU_fragmentation = 1,
    BCH_LRU_stripes = 2,
}
#[repr(C, packed(8))]
pub struct bch_alloc {
    pub v: bch_val,
    pub fields: __u8,
    pub gen: __u8,
    pub data: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_alloc() {
    const UNINIT: ::std::mem::MaybeUninit<bch_alloc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_alloc>(),
        8usize,
        concat!("Size of: ", stringify!(bch_alloc)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_alloc>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_alloc)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_alloc), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_alloc), "::", stringify!(fields)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gen) as usize - ptr as usize },
        1usize,
        concat!("Offset of field: ", stringify!(bch_alloc), "::", stringify!(gen)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(bch_alloc), "::", stringify!(data)),
    );
}
impl Default for bch_alloc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BCH_ALLOC_FIELD_V1_read_time: _bindgen_ty_17 = _bindgen_ty_17::BCH_ALLOC_FIELD_V1_read_time;
pub const BCH_ALLOC_FIELD_V1_write_time: _bindgen_ty_17 = _bindgen_ty_17::BCH_ALLOC_FIELD_V1_write_time;
pub const BCH_ALLOC_FIELD_V1_data_type: _bindgen_ty_17 = _bindgen_ty_17::BCH_ALLOC_FIELD_V1_data_type;
pub const BCH_ALLOC_FIELD_V1_dirty_sectors: _bindgen_ty_17 = _bindgen_ty_17::BCH_ALLOC_FIELD_V1_dirty_sectors;
pub const BCH_ALLOC_FIELD_V1_cached_sectors: _bindgen_ty_17 = _bindgen_ty_17::BCH_ALLOC_FIELD_V1_cached_sectors;
pub const BCH_ALLOC_FIELD_V1_oldest_gen: _bindgen_ty_17 = _bindgen_ty_17::BCH_ALLOC_FIELD_V1_oldest_gen;
pub const BCH_ALLOC_FIELD_V1_stripe: _bindgen_ty_17 = _bindgen_ty_17::BCH_ALLOC_FIELD_V1_stripe;
pub const BCH_ALLOC_FIELD_V1_stripe_redundancy: _bindgen_ty_17 = _bindgen_ty_17::BCH_ALLOC_FIELD_V1_stripe_redundancy;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_17 {
    BCH_ALLOC_FIELD_V1_read_time = 0,
    BCH_ALLOC_FIELD_V1_write_time = 1,
    BCH_ALLOC_FIELD_V1_data_type = 2,
    BCH_ALLOC_FIELD_V1_dirty_sectors = 3,
    BCH_ALLOC_FIELD_V1_cached_sectors = 4,
    BCH_ALLOC_FIELD_V1_oldest_gen = 5,
    BCH_ALLOC_FIELD_V1_stripe = 6,
    BCH_ALLOC_FIELD_V1_stripe_redundancy = 7,
}
#[repr(C, packed(8))]
pub struct bch_alloc_v2 {
    pub v: bch_val,
    pub nr_fields: __u8,
    pub gen: __u8,
    pub oldest_gen: __u8,
    pub data_type: __u8,
    pub data: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_alloc_v2() {
    const UNINIT: ::std::mem::MaybeUninit<bch_alloc_v2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_alloc_v2>(),
        8usize,
        concat!("Size of: ", stringify!(bch_alloc_v2)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_alloc_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_alloc_v2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v2), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_fields) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v2),
            "::",
            stringify!(nr_fields),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gen) as usize - ptr as usize },
        1usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v2), "::", stringify!(gen)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).oldest_gen) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v2),
            "::",
            stringify!(oldest_gen),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_type) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v2),
            "::",
            stringify!(data_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v2), "::", stringify!(data)),
    );
}
impl Default for bch_alloc_v2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_alloc_v3 {
    pub v: bch_val,
    pub journal_seq: __le64,
    pub flags: __le32,
    pub nr_fields: __u8,
    pub gen: __u8,
    pub oldest_gen: __u8,
    pub data_type: __u8,
    pub data: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_alloc_v3() {
    const UNINIT: ::std::mem::MaybeUninit<bch_alloc_v3> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_alloc_v3>(),
        16usize,
        concat!("Size of: ", stringify!(bch_alloc_v3)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_alloc_v3>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_alloc_v3)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v3), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_seq) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v3),
            "::",
            stringify!(journal_seq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v3), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_fields) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v3),
            "::",
            stringify!(nr_fields),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gen) as usize - ptr as usize },
        13usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v3), "::", stringify!(gen)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).oldest_gen) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v3),
            "::",
            stringify!(oldest_gen),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_type) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v3),
            "::",
            stringify!(data_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v3), "::", stringify!(data)),
    );
}
impl Default for bch_alloc_v3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BCH_ALLOC_V3_NEED_DISCARD_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_ALLOC_V3_NEED_DISCARD_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_ALLOC_V3_NEED_DISCARD_MAX: __u32 = 1;
pub const BCH_ALLOC_V3_NEED_INC_GEN_OFFSET: ::std::os::raw::c_uint = 1;
pub const BCH_ALLOC_V3_NEED_INC_GEN_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_ALLOC_V3_NEED_INC_GEN_MAX: __u32 = 1;
#[repr(C, packed(8))]
pub struct bch_alloc_v4 {
    pub v: bch_val,
    pub journal_seq_nonempty: __u64,
    pub flags: __u32,
    pub gen: __u8,
    pub oldest_gen: __u8,
    pub data_type: __u8,
    pub stripe_redundancy_obsolete: __u8,
    pub dirty_sectors: __u32,
    pub cached_sectors: __u32,
    pub io_time: [__u64; 2usize],
    pub stripe_refcount: __u32,
    pub nr_external_backpointers: __u32,
    pub journal_seq_empty: __u64,
    pub stripe_sectors: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_bch_alloc_v4() {
    const UNINIT: ::std::mem::MaybeUninit<bch_alloc_v4> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_alloc_v4>(),
        64usize,
        concat!("Size of: ", stringify!(bch_alloc_v4)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_alloc_v4>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_alloc_v4)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v4), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).journal_seq_nonempty) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(journal_seq_nonempty),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v4), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gen) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v4), "::", stringify!(gen)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).oldest_gen) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(oldest_gen),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_type) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(data_type),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).stripe_redundancy_obsolete) as usize
                - ptr as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(stripe_redundancy_obsolete),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dirty_sectors) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(dirty_sectors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cached_sectors) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(cached_sectors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).io_time) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v4), "::", stringify!(io_time)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_refcount) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(stripe_refcount),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).nr_external_backpointers) as usize - ptr as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(nr_external_backpointers),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).journal_seq_empty) as usize - ptr as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(journal_seq_empty),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_sectors) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_alloc_v4),
            "::",
            stringify!(stripe_sectors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        60usize,
        concat!("Offset of field: ", stringify!(bch_alloc_v4), "::", stringify!(pad)),
    );
}
impl Default for bch_alloc_v4 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BCH_ALLOC_V4_NEED_DISCARD_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_ALLOC_V4_NEED_DISCARD_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_ALLOC_V4_NEED_INC_GEN_OFFSET: ::std::os::raw::c_uint = 1;
pub const BCH_ALLOC_V4_NEED_INC_GEN_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_ALLOC_V4_BACKPOINTERS_START_OFFSET: ::std::os::raw::c_uint = 2;
pub const BCH_ALLOC_V4_BACKPOINTERS_START_BITS: ::std::os::raw::c_uint = 6;
pub const BCH_ALLOC_V4_NR_BACKPOINTERS_OFFSET: ::std::os::raw::c_uint = 8;
pub const BCH_ALLOC_V4_NR_BACKPOINTERS_BITS: ::std::os::raw::c_uint = 6;
#[repr(C, packed(8))]
pub struct bch_bucket_gens {
    pub v: bch_val,
    pub gens: [u8_; 256usize],
}
#[test]
fn bindgen_test_layout_bch_bucket_gens() {
    const UNINIT: ::std::mem::MaybeUninit<bch_bucket_gens> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_bucket_gens>(),
        256usize,
        concat!("Size of: ", stringify!(bch_bucket_gens)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_bucket_gens>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_bucket_gens)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_bucket_gens), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gens) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_bucket_gens), "::", stringify!(gens)),
    );
}
impl Default for bch_bucket_gens {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_extent_entry_type {
    BCH_EXTENT_ENTRY_ptr = 0,
    BCH_EXTENT_ENTRY_crc32 = 1,
    BCH_EXTENT_ENTRY_crc64 = 2,
    BCH_EXTENT_ENTRY_crc128 = 3,
    BCH_EXTENT_ENTRY_stripe_ptr = 4,
    BCH_EXTENT_ENTRY_rebalance_v1 = 5,
    BCH_EXTENT_ENTRY_flags = 6,
    BCH_EXTENT_ENTRY_reconcile = 7,
    BCH_EXTENT_ENTRY_reconcile_bp = 8,
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_crc32 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub csum: __u32,
}
#[test]
fn bindgen_test_layout_bch_extent_crc32() {
    const UNINIT: ::std::mem::MaybeUninit<bch_extent_crc32> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_extent_crc32>(),
        8usize,
        concat!("Size of: ", stringify!(bch_extent_crc32)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_crc32>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_crc32)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc32),
            "::",
            stringify!(csum),
        ),
    );
}
impl bch_extent_crc32 {
    #[inline]
    pub fn type_(&self) -> __u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: __u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn _compressed_size(&self) -> __u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set__compressed_size(&mut self, val: __u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn _uncompressed_size(&self) -> __u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set__uncompressed_size(&mut self, val: __u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn offset(&self) -> __u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_offset(&mut self, val: __u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> __u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: __u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn csum_type(&self) -> __u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_csum_type(&mut self, val: __u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn compression_type(&self) -> __u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_compression_type(&mut self, val: __u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: __u32,
        _compressed_size: __u32,
        _uncompressed_size: __u32,
        offset: __u32,
        _unused: __u32,
        csum_type: __u32,
        compression_type: __u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                2u8,
                {
                    let type_: u32 = unsafe { ::std::mem::transmute(type_) };
                    type_ as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                2usize,
                7u8,
                {
                    let _compressed_size: u32 = unsafe {
                        ::std::mem::transmute(_compressed_size)
                    };
                    _compressed_size as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                9usize,
                7u8,
                {
                    let _uncompressed_size: u32 = unsafe {
                        ::std::mem::transmute(_uncompressed_size)
                    };
                    _uncompressed_size as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                16usize,
                7u8,
                {
                    let offset: u32 = unsafe { ::std::mem::transmute(offset) };
                    offset as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                23usize,
                1u8,
                {
                    let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
                    _unused as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                24usize,
                4u8,
                {
                    let csum_type: u32 = unsafe { ::std::mem::transmute(csum_type) };
                    csum_type as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                28usize,
                4u8,
                {
                    let compression_type: u32 = unsafe {
                        ::std::mem::transmute(compression_type)
                    };
                    compression_type as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_crc64 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub csum_lo: __u64,
}
#[test]
fn bindgen_test_layout_bch_extent_crc64() {
    const UNINIT: ::std::mem::MaybeUninit<bch_extent_crc64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_extent_crc64>(),
        16usize,
        concat!("Size of: ", stringify!(bch_extent_crc64)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_crc64>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_crc64)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum_lo) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc64),
            "::",
            stringify!(csum_lo),
        ),
    );
}
impl bch_extent_crc64 {
    #[inline]
    pub fn type_(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u64) }
    }
    #[inline]
    pub fn set_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn _compressed_size(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 9u8) as u64) }
    }
    #[inline]
    pub fn set__compressed_size(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn _uncompressed_size(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 9u8) as u64) }
    }
    #[inline]
    pub fn set__uncompressed_size(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn offset(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 9u8) as u64) }
    }
    #[inline]
    pub fn set_offset(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn nonce(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 10u8) as u64) }
    }
    #[inline]
    pub fn set_nonce(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn csum_type(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 4u8) as u64) }
    }
    #[inline]
    pub fn set_csum_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn compression_type(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(44usize, 4u8) as u64) }
    }
    #[inline]
    pub fn set_compression_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(44usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn csum_hi(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(48usize, 16u8) as u64) }
    }
    #[inline]
    pub fn set_csum_hi(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(48usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: __u64,
        _compressed_size: __u64,
        _uncompressed_size: __u64,
        offset: __u64,
        nonce: __u64,
        csum_type: __u64,
        compression_type: __u64,
        csum_hi: __u64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                3u8,
                {
                    let type_: u64 = unsafe { ::std::mem::transmute(type_) };
                    type_ as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                3usize,
                9u8,
                {
                    let _compressed_size: u64 = unsafe {
                        ::std::mem::transmute(_compressed_size)
                    };
                    _compressed_size as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                12usize,
                9u8,
                {
                    let _uncompressed_size: u64 = unsafe {
                        ::std::mem::transmute(_uncompressed_size)
                    };
                    _uncompressed_size as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                21usize,
                9u8,
                {
                    let offset: u64 = unsafe { ::std::mem::transmute(offset) };
                    offset as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                30usize,
                10u8,
                {
                    let nonce: u64 = unsafe { ::std::mem::transmute(nonce) };
                    nonce as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                40usize,
                4u8,
                {
                    let csum_type: u64 = unsafe { ::std::mem::transmute(csum_type) };
                    csum_type as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                44usize,
                4u8,
                {
                    let compression_type: u64 = unsafe {
                        ::std::mem::transmute(compression_type)
                    };
                    compression_type as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                48usize,
                16u8,
                {
                    let csum_hi: u64 = unsafe { ::std::mem::transmute(csum_hi) };
                    csum_hi as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C, align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_crc128 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub csum: bch_csum,
}
#[test]
fn bindgen_test_layout_bch_extent_crc128() {
    const UNINIT: ::std::mem::MaybeUninit<bch_extent_crc128> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_extent_crc128>(),
        24usize,
        concat!("Size of: ", stringify!(bch_extent_crc128)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_crc128>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_crc128)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc128),
            "::",
            stringify!(csum),
        ),
    );
}
impl bch_extent_crc128 {
    #[inline]
    pub fn type_(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u64) }
    }
    #[inline]
    pub fn set_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn _compressed_size(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 13u8) as u64) }
    }
    #[inline]
    pub fn set__compressed_size(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub fn _uncompressed_size(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 13u8) as u64) }
    }
    #[inline]
    pub fn set__uncompressed_size(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub fn offset(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 13u8) as u64) }
    }
    #[inline]
    pub fn set_offset(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub fn nonce(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(43usize, 13u8) as u64) }
    }
    #[inline]
    pub fn set_nonce(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(43usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub fn csum_type(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(56usize, 4u8) as u64) }
    }
    #[inline]
    pub fn set_csum_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(56usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn compression_type(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(60usize, 4u8) as u64) }
    }
    #[inline]
    pub fn set_compression_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(60usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: __u64,
        _compressed_size: __u64,
        _uncompressed_size: __u64,
        offset: __u64,
        nonce: __u64,
        csum_type: __u64,
        compression_type: __u64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                4u8,
                {
                    let type_: u64 = unsafe { ::std::mem::transmute(type_) };
                    type_ as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                4usize,
                13u8,
                {
                    let _compressed_size: u64 = unsafe {
                        ::std::mem::transmute(_compressed_size)
                    };
                    _compressed_size as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                17usize,
                13u8,
                {
                    let _uncompressed_size: u64 = unsafe {
                        ::std::mem::transmute(_uncompressed_size)
                    };
                    _uncompressed_size as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                30usize,
                13u8,
                {
                    let offset: u64 = unsafe { ::std::mem::transmute(offset) };
                    offset as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                43usize,
                13u8,
                {
                    let nonce: u64 = unsafe { ::std::mem::transmute(nonce) };
                    nonce as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                56usize,
                4u8,
                {
                    let csum_type: u64 = unsafe { ::std::mem::transmute(csum_type) };
                    csum_type as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                60usize,
                4u8,
                {
                    let compression_type: u64 = unsafe {
                        ::std::mem::transmute(compression_type)
                    };
                    compression_type as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_ptr {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bch_extent_ptr() {
    assert_eq!(
        ::std::mem::size_of::<bch_extent_ptr>(),
        8usize,
        concat!("Size of: ", stringify!(bch_extent_ptr)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_ptr>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_ptr)),
    );
}
impl bch_extent_ptr {
    #[inline]
    pub fn type_(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cached(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_cached(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unused(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_unused(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unwritten(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_unwritten(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn offset(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 44u8) as u64) }
    }
    #[inline]
    pub fn set_offset(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 44u8, val as u64)
        }
    }
    #[inline]
    pub fn dev(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(48usize, 8u8) as u64) }
    }
    #[inline]
    pub fn set_dev(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(48usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn gen(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(56usize, 8u8) as u64) }
    }
    #[inline]
    pub fn set_gen(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(56usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: __u64,
        cached: __u64,
        unused: __u64,
        unwritten: __u64,
        offset: __u64,
        dev: __u64,
        gen: __u64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let type_: u64 = unsafe { ::std::mem::transmute(type_) };
                    type_ as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                1usize,
                1u8,
                {
                    let cached: u64 = unsafe { ::std::mem::transmute(cached) };
                    cached as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                2usize,
                1u8,
                {
                    let unused: u64 = unsafe { ::std::mem::transmute(unused) };
                    unused as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                3usize,
                1u8,
                {
                    let unwritten: u64 = unsafe { ::std::mem::transmute(unwritten) };
                    unwritten as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                4usize,
                44u8,
                {
                    let offset: u64 = unsafe { ::std::mem::transmute(offset) };
                    offset as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                48usize,
                8u8,
                {
                    let dev: u64 = unsafe { ::std::mem::transmute(dev) };
                    dev as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                56usize,
                8u8,
                {
                    let gen: u64 = unsafe { ::std::mem::transmute(gen) };
                    gen as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_stripe_ptr {
    pub _bitfield_align_1: [u64; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bch_extent_stripe_ptr() {
    assert_eq!(
        ::std::mem::size_of::<bch_extent_stripe_ptr>(),
        8usize,
        concat!("Size of: ", stringify!(bch_extent_stripe_ptr)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_stripe_ptr>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_stripe_ptr)),
    );
}
impl bch_extent_stripe_ptr {
    #[inline]
    pub fn type_(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 5u8) as u64) }
    }
    #[inline]
    pub fn set_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn block(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 8u8) as u64) }
    }
    #[inline]
    pub fn set_block(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn redundancy(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 4u8) as u64) }
    }
    #[inline]
    pub fn set_redundancy(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn idx(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 47u8) as u64) }
    }
    #[inline]
    pub fn set_idx(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 47u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: __u64,
        block: __u64,
        redundancy: __u64,
        idx: __u64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                5u8,
                {
                    let type_: u64 = unsafe { ::std::mem::transmute(type_) };
                    type_ as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                5usize,
                8u8,
                {
                    let block: u64 = unsafe { ::std::mem::transmute(block) };
                    block as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                13usize,
                4u8,
                {
                    let redundancy: u64 = unsafe { ::std::mem::transmute(redundancy) };
                    redundancy as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                17usize,
                47u8,
                {
                    let idx: u64 = unsafe { ::std::mem::transmute(idx) };
                    idx as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_extent_flags_e {
    BCH_EXTENT_FLAG_poisoned = 0,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_flags {
    pub _bitfield_align_1: [u64; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bch_extent_flags() {
    assert_eq!(
        ::std::mem::size_of::<bch_extent_flags>(),
        8usize,
        concat!("Size of: ", stringify!(bch_extent_flags)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_flags>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_flags)),
    );
}
impl bch_extent_flags {
    #[inline]
    pub fn type_(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u64) }
    }
    #[inline]
    pub fn set_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn flags(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 57u8) as u64) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 57u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: __u64,
        flags: __u64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                7u8,
                {
                    let type_: u64 = unsafe { ::std::mem::transmute(type_) };
                    type_ as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                57u8,
                {
                    let flags: u64 = unsafe { ::std::mem::transmute(flags) };
                    flags as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_rebalance_v1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bch_extent_rebalance_v1() {
    assert_eq!(
        ::std::mem::size_of::<bch_extent_rebalance_v1>(),
        8usize,
        concat!("Size of: ", stringify!(bch_extent_rebalance_v1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_rebalance_v1>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_rebalance_v1)),
    );
}
impl bch_extent_rebalance_v1 {
    #[inline]
    pub fn type_(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 6u8) as u64) }
    }
    #[inline]
    pub fn set_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 6u8, val as u64)
        }
    }
    #[inline]
    pub fn unused(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 3u8) as u64) }
    }
    #[inline]
    pub fn set_unused(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn promote_target_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_promote_target_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn erasure_code_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_erasure_code_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_checksum_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_data_checksum_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn background_compression_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_background_compression_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_replicas_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_data_replicas_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn background_target_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_background_target_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn promote_target(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 16u8) as u64) }
    }
    #[inline]
    pub fn set_promote_target(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn erasure_code(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_erasure_code(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_checksum(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 4u8) as u64) }
    }
    #[inline]
    pub fn set_data_checksum(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn data_replicas(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(36usize, 4u8) as u64) }
    }
    #[inline]
    pub fn set_data_replicas(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(36usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn background_compression(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 8u8) as u64) }
    }
    #[inline]
    pub fn set_background_compression(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn background_target(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(48usize, 16u8) as u64) }
    }
    #[inline]
    pub fn set_background_target(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(48usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: __u64,
        unused: __u64,
        promote_target_from_inode: __u64,
        erasure_code_from_inode: __u64,
        data_checksum_from_inode: __u64,
        background_compression_from_inode: __u64,
        data_replicas_from_inode: __u64,
        background_target_from_inode: __u64,
        promote_target: __u64,
        erasure_code: __u64,
        data_checksum: __u64,
        data_replicas: __u64,
        background_compression: __u64,
        background_target: __u64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                6u8,
                {
                    let type_: u64 = unsafe { ::std::mem::transmute(type_) };
                    type_ as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                6usize,
                3u8,
                {
                    let unused: u64 = unsafe { ::std::mem::transmute(unused) };
                    unused as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                9usize,
                1u8,
                {
                    let promote_target_from_inode: u64 = unsafe {
                        ::std::mem::transmute(promote_target_from_inode)
                    };
                    promote_target_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                10usize,
                1u8,
                {
                    let erasure_code_from_inode: u64 = unsafe {
                        ::std::mem::transmute(erasure_code_from_inode)
                    };
                    erasure_code_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                11usize,
                1u8,
                {
                    let data_checksum_from_inode: u64 = unsafe {
                        ::std::mem::transmute(data_checksum_from_inode)
                    };
                    data_checksum_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                12usize,
                1u8,
                {
                    let background_compression_from_inode: u64 = unsafe {
                        ::std::mem::transmute(background_compression_from_inode)
                    };
                    background_compression_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                13usize,
                1u8,
                {
                    let data_replicas_from_inode: u64 = unsafe {
                        ::std::mem::transmute(data_replicas_from_inode)
                    };
                    data_replicas_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                14usize,
                1u8,
                {
                    let background_target_from_inode: u64 = unsafe {
                        ::std::mem::transmute(background_target_from_inode)
                    };
                    background_target_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                15usize,
                16u8,
                {
                    let promote_target: u64 = unsafe {
                        ::std::mem::transmute(promote_target)
                    };
                    promote_target as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                31usize,
                1u8,
                {
                    let erasure_code: u64 = unsafe {
                        ::std::mem::transmute(erasure_code)
                    };
                    erasure_code as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                32usize,
                4u8,
                {
                    let data_checksum: u64 = unsafe {
                        ::std::mem::transmute(data_checksum)
                    };
                    data_checksum as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                36usize,
                4u8,
                {
                    let data_replicas: u64 = unsafe {
                        ::std::mem::transmute(data_replicas)
                    };
                    data_replicas as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                40usize,
                8u8,
                {
                    let background_compression: u64 = unsafe {
                        ::std::mem::transmute(background_compression)
                    };
                    background_compression as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                48usize,
                16u8,
                {
                    let background_target: u64 = unsafe {
                        ::std::mem::transmute(background_target)
                    };
                    background_target as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_reconcile {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bch_extent_reconcile() {
    assert_eq!(
        ::std::mem::size_of::<bch_extent_reconcile>(),
        8usize,
        concat!("Size of: ", stringify!(bch_extent_reconcile)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_reconcile>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_reconcile)),
    );
}
impl bch_extent_reconcile {
    #[inline]
    pub fn type_(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u64) }
    }
    #[inline]
    pub fn set_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn unused(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u64) }
    }
    #[inline]
    pub fn set_unused(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn ptrs_moving(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 5u8) as u64) }
    }
    #[inline]
    pub fn set_ptrs_moving(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn hipri(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_hipri(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pending(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_pending(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn need_rb(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 5u8) as u64) }
    }
    #[inline]
    pub fn set_need_rb(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn data_replicas_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_data_replicas_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_checksum_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_data_checksum_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn erasure_code_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_erasure_code_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn background_compression_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_background_compression_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn background_target_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_background_target_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn promote_target_from_inode(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_promote_target_from_inode(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_replicas(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 3u8) as u64) }
    }
    #[inline]
    pub fn set_data_replicas(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn data_checksum(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 4u8) as u64) }
    }
    #[inline]
    pub fn set_data_checksum(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn erasure_code(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(35usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_erasure_code(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(35usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn background_compression(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(36usize, 8u8) as u64) }
    }
    #[inline]
    pub fn set_background_compression(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(36usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn background_target(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(44usize, 10u8) as u64) }
    }
    #[inline]
    pub fn set_background_target(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(44usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn promote_target(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(54usize, 10u8) as u64) }
    }
    #[inline]
    pub fn set_promote_target(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(54usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: __u64,
        unused: __u64,
        ptrs_moving: __u64,
        hipri: __u64,
        pending: __u64,
        need_rb: __u64,
        data_replicas_from_inode: __u64,
        data_checksum_from_inode: __u64,
        erasure_code_from_inode: __u64,
        background_compression_from_inode: __u64,
        background_target_from_inode: __u64,
        promote_target_from_inode: __u64,
        data_replicas: __u64,
        data_checksum: __u64,
        erasure_code: __u64,
        background_compression: __u64,
        background_target: __u64,
        promote_target: __u64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                8u8,
                {
                    let type_: u64 = unsafe { ::std::mem::transmute(type_) };
                    type_ as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                8usize,
                2u8,
                {
                    let unused: u64 = unsafe { ::std::mem::transmute(unused) };
                    unused as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                10usize,
                5u8,
                {
                    let ptrs_moving: u64 = unsafe { ::std::mem::transmute(ptrs_moving) };
                    ptrs_moving as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                15usize,
                1u8,
                {
                    let hipri: u64 = unsafe { ::std::mem::transmute(hipri) };
                    hipri as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                16usize,
                1u8,
                {
                    let pending: u64 = unsafe { ::std::mem::transmute(pending) };
                    pending as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                17usize,
                5u8,
                {
                    let need_rb: u64 = unsafe { ::std::mem::transmute(need_rb) };
                    need_rb as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                22usize,
                1u8,
                {
                    let data_replicas_from_inode: u64 = unsafe {
                        ::std::mem::transmute(data_replicas_from_inode)
                    };
                    data_replicas_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                23usize,
                1u8,
                {
                    let data_checksum_from_inode: u64 = unsafe {
                        ::std::mem::transmute(data_checksum_from_inode)
                    };
                    data_checksum_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                24usize,
                1u8,
                {
                    let erasure_code_from_inode: u64 = unsafe {
                        ::std::mem::transmute(erasure_code_from_inode)
                    };
                    erasure_code_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                25usize,
                1u8,
                {
                    let background_compression_from_inode: u64 = unsafe {
                        ::std::mem::transmute(background_compression_from_inode)
                    };
                    background_compression_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                26usize,
                1u8,
                {
                    let background_target_from_inode: u64 = unsafe {
                        ::std::mem::transmute(background_target_from_inode)
                    };
                    background_target_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                27usize,
                1u8,
                {
                    let promote_target_from_inode: u64 = unsafe {
                        ::std::mem::transmute(promote_target_from_inode)
                    };
                    promote_target_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                28usize,
                3u8,
                {
                    let data_replicas: u64 = unsafe {
                        ::std::mem::transmute(data_replicas)
                    };
                    data_replicas as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                31usize,
                4u8,
                {
                    let data_checksum: u64 = unsafe {
                        ::std::mem::transmute(data_checksum)
                    };
                    data_checksum as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                35usize,
                1u8,
                {
                    let erasure_code: u64 = unsafe {
                        ::std::mem::transmute(erasure_code)
                    };
                    erasure_code as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                36usize,
                8u8,
                {
                    let background_compression: u64 = unsafe {
                        ::std::mem::transmute(background_compression)
                    };
                    background_compression as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                44usize,
                10u8,
                {
                    let background_target: u64 = unsafe {
                        ::std::mem::transmute(background_target)
                    };
                    background_target as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                54usize,
                10u8,
                {
                    let promote_target: u64 = unsafe {
                        ::std::mem::transmute(promote_target)
                    };
                    promote_target as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_reconcile_bp {
    pub _bitfield_align_1: [u64; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_bch_extent_reconcile_bp() {
    assert_eq!(
        ::std::mem::size_of::<bch_extent_reconcile_bp>(),
        8usize,
        concat!("Size of: ", stringify!(bch_extent_reconcile_bp)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_reconcile_bp>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_reconcile_bp)),
    );
}
impl bch_extent_reconcile_bp {
    #[inline]
    pub fn type_(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 9u8) as u64) }
    }
    #[inline]
    pub fn set_type(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn idx(&self) -> __u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 55u8) as u64) }
    }
    #[inline]
    pub fn set_idx(&mut self, val: __u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 55u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: __u64,
        idx: __u64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                9u8,
                {
                    let type_: u64 = unsafe { ::std::mem::transmute(type_) };
                    type_ as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                9usize,
                55u8,
                {
                    let idx: u64 = unsafe { ::std::mem::transmute(idx) };
                    idx as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_reconcile_opts {
    BCH_REBALANCE_data_replicas = 0,
    BCH_REBALANCE_data_checksum = 1,
    BCH_REBALANCE_erasure_code = 2,
    BCH_REBALANCE_background_compression = 3,
    BCH_REBALANCE_background_target = 4,
    BCH_REBALANCE_promote_target = 5,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_reconcile_accounting_type {
    BCH_REBALANCE_ACCOUNTING_replicas = 0,
    BCH_REBALANCE_ACCOUNTING_checksum = 1,
    BCH_REBALANCE_ACCOUNTING_erasure_code = 2,
    BCH_REBALANCE_ACCOUNTING_compression = 3,
    BCH_REBALANCE_ACCOUNTING_target = 4,
    BCH_REBALANCE_ACCOUNTING_high_priority = 5,
    BCH_REBALANCE_ACCOUNTING_pending = 6,
    BCH_REBALANCE_ACCOUNTING_NR = 7,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bch_extent_entry {
    pub type_: ::std::os::raw::c_ulong,
    pub ptr: bch_extent_ptr,
    pub crc32: bch_extent_crc32,
    pub crc64: bch_extent_crc64,
    pub crc128: bch_extent_crc128,
    pub stripe_ptr: bch_extent_stripe_ptr,
    pub rebalance_v1: bch_extent_rebalance_v1,
    pub flags: bch_extent_flags,
    pub reconcile: bch_extent_reconcile,
    pub reconcile_bp: bch_extent_reconcile_bp,
}
#[test]
fn bindgen_test_layout_bch_extent_entry() {
    const UNINIT: ::std::mem::MaybeUninit<bch_extent_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_extent_entry>(),
        24usize,
        concat!("Size of: ", stringify!(bch_extent_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_entry),
            "::",
            stringify!(type_),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_extent_entry), "::", stringify!(ptr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crc32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_entry),
            "::",
            stringify!(crc32),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crc64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_entry),
            "::",
            stringify!(crc64),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crc128) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_entry),
            "::",
            stringify!(crc128),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_ptr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_entry),
            "::",
            stringify!(stripe_ptr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rebalance_v1) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_entry),
            "::",
            stringify!(rebalance_v1),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_entry),
            "::",
            stringify!(flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reconcile) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_entry),
            "::",
            stringify!(reconcile),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reconcile_bp) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_entry),
            "::",
            stringify!(reconcile_bp),
        ),
    );
}
impl Default for bch_extent_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_btree_ptr {
    pub v: bch_val,
    pub _data: __IncompleteArrayField<__u64>,
    pub start: __IncompleteArrayField<bch_extent_ptr>,
}
#[test]
fn bindgen_test_layout_bch_btree_ptr() {
    const UNINIT: ::std::mem::MaybeUninit<bch_btree_ptr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_btree_ptr>(),
        0usize,
        concat!("Size of: ", stringify!(bch_btree_ptr)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_btree_ptr>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_btree_ptr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_btree_ptr), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_btree_ptr), "::", stringify!(_data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_btree_ptr), "::", stringify!(start)),
    );
}
impl Default for bch_btree_ptr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_btree_ptr_v2 {
    pub v: bch_val,
    pub mem_ptr: __u64,
    pub seq: __le64,
    pub sectors_written: __le16,
    pub flags: __le16,
    pub min_key: bpos,
    pub _data: __IncompleteArrayField<__u64>,
    pub start: __IncompleteArrayField<bch_extent_ptr>,
}
#[test]
fn bindgen_test_layout_bch_btree_ptr_v2() {
    const UNINIT: ::std::mem::MaybeUninit<bch_btree_ptr_v2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_btree_ptr_v2>(),
        40usize,
        concat!("Size of: ", stringify!(bch_btree_ptr_v2)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_btree_ptr_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_btree_ptr_v2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_btree_ptr_v2), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mem_ptr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_btree_ptr_v2),
            "::",
            stringify!(mem_ptr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_btree_ptr_v2), "::", stringify!(seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sectors_written) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_btree_ptr_v2),
            "::",
            stringify!(sectors_written),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_btree_ptr_v2),
            "::",
            stringify!(flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_key) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_btree_ptr_v2),
            "::",
            stringify!(min_key),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_btree_ptr_v2),
            "::",
            stringify!(_data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_btree_ptr_v2),
            "::",
            stringify!(start),
        ),
    );
}
impl Default for bch_btree_ptr_v2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_extent {
    pub v: bch_val,
    pub _data: __IncompleteArrayField<__u64>,
    pub start: __IncompleteArrayField<bch_extent_entry>,
}
#[test]
fn bindgen_test_layout_bch_extent() {
    const UNINIT: ::std::mem::MaybeUninit<bch_extent> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_extent>(),
        0usize,
        concat!("Size of: ", stringify!(bch_extent)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_extent), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_extent), "::", stringify!(_data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_extent), "::", stringify!(start)),
    );
}
impl Default for bch_extent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_reservation {
    pub v: bch_val,
    pub generation: __le32,
    pub nr_replicas: __u8,
    pub pad: [__u8; 3usize],
}
#[test]
fn bindgen_test_layout_bch_reservation() {
    const UNINIT: ::std::mem::MaybeUninit<bch_reservation> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_reservation>(),
        8usize,
        concat!("Size of: ", stringify!(bch_reservation)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_reservation>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_reservation)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_reservation), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).generation) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_reservation),
            "::",
            stringify!(generation),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_replicas) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_reservation),
            "::",
            stringify!(nr_replicas),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        5usize,
        concat!("Offset of field: ", stringify!(bch_reservation), "::", stringify!(pad)),
    );
}
impl Default for bch_reservation {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_inline_data {
    pub v: bch_val,
    pub data: __IncompleteArrayField<u8_>,
}
#[test]
fn bindgen_test_layout_bch_inline_data() {
    const UNINIT: ::std::mem::MaybeUninit<bch_inline_data> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_inline_data>(),
        0usize,
        concat!("Size of: ", stringify!(bch_inline_data)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_inline_data>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_inline_data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_inline_data), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_inline_data), "::", stringify!(data)),
    );
}
#[repr(C, packed(8))]
pub struct bch_stripe {
    pub v: bch_val,
    pub sectors: __le16,
    pub algorithm: __u8,
    pub nr_blocks: __u8,
    pub nr_redundant: __u8,
    pub csum_granularity_bits: __u8,
    pub csum_type: __u8,
    pub disk_label: __u8,
    pub ptrs: __IncompleteArrayField<bch_extent_ptr>,
}
#[test]
fn bindgen_test_layout_bch_stripe() {
    const UNINIT: ::std::mem::MaybeUninit<bch_stripe> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_stripe>(),
        8usize,
        concat!("Size of: ", stringify!(bch_stripe)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_stripe>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_stripe)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_stripe), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sectors) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_stripe), "::", stringify!(sectors)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).algorithm) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(bch_stripe), "::", stringify!(algorithm)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_blocks) as usize - ptr as usize },
        3usize,
        concat!("Offset of field: ", stringify!(bch_stripe), "::", stringify!(nr_blocks)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_redundant) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_stripe),
            "::",
            stringify!(nr_redundant),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).csum_granularity_bits) as usize - ptr as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_stripe),
            "::",
            stringify!(csum_granularity_bits),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum_type) as usize - ptr as usize },
        6usize,
        concat!("Offset of field: ", stringify!(bch_stripe), "::", stringify!(csum_type)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).disk_label) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_stripe),
            "::",
            stringify!(disk_label),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptrs) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_stripe), "::", stringify!(ptrs)),
    );
}
impl Default for bch_stripe {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_extent_type_u64s {
    pub field: bch_sb_field,
    pub d: __IncompleteArrayField<u8_>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_extent_type_u64s() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_extent_type_u64s> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_extent_type_u64s>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_extent_type_u64s)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_extent_type_u64s>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_extent_type_u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_extent_type_u64s),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_extent_type_u64s),
            "::",
            stringify!(d),
        ),
    );
}
#[repr(C, packed(8))]
pub struct bch_reflink_p {
    pub v: bch_val,
    pub idx_flags: __le64,
    pub front_pad: __le32,
    pub back_pad: __le32,
}
#[test]
fn bindgen_test_layout_bch_reflink_p() {
    const UNINIT: ::std::mem::MaybeUninit<bch_reflink_p> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_reflink_p>(),
        16usize,
        concat!("Size of: ", stringify!(bch_reflink_p)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_reflink_p>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_reflink_p)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_reflink_p), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).idx_flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_reflink_p),
            "::",
            stringify!(idx_flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).front_pad) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_reflink_p),
            "::",
            stringify!(front_pad),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).back_pad) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_reflink_p),
            "::",
            stringify!(back_pad),
        ),
    );
}
impl Default for bch_reflink_p {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_reflink_v {
    pub v: bch_val,
    pub refcount: __le64,
    pub start: __IncompleteArrayField<bch_extent_entry>,
    pub _data: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_bch_reflink_v() {
    const UNINIT: ::std::mem::MaybeUninit<bch_reflink_v> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_reflink_v>(),
        8usize,
        concat!("Size of: ", stringify!(bch_reflink_v)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_reflink_v>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_reflink_v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_reflink_v), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).refcount) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_reflink_v),
            "::",
            stringify!(refcount),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_reflink_v), "::", stringify!(start)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_reflink_v), "::", stringify!(_data)),
    );
}
impl Default for bch_reflink_v {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_indirect_inline_data {
    pub v: bch_val,
    pub refcount: __le64,
    pub data: __IncompleteArrayField<u8_>,
}
#[test]
fn bindgen_test_layout_bch_indirect_inline_data() {
    const UNINIT: ::std::mem::MaybeUninit<bch_indirect_inline_data> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_indirect_inline_data>(),
        8usize,
        concat!("Size of: ", stringify!(bch_indirect_inline_data)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_indirect_inline_data>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_indirect_inline_data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_indirect_inline_data),
            "::",
            stringify!(v),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).refcount) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_indirect_inline_data),
            "::",
            stringify!(refcount),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_indirect_inline_data),
            "::",
            stringify!(data),
        ),
    );
}
#[repr(C, packed(8))]
pub struct bch_dirent {
    pub v: bch_val,
    pub __bindgen_anon_1: bch_dirent__bindgen_ty_1,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_anon_2: bch_dirent__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bch_dirent__bindgen_ty_1 {
    pub d_inum: __le64,
    pub __bindgen_anon_1: bch_dirent__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_dirent__bindgen_ty_1__bindgen_ty_1 {
    pub d_child_subvol: __le32,
    pub d_parent_subvol: __le32,
}
#[test]
fn bindgen_test_layout_bch_dirent__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bch_dirent__bindgen_ty_1__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_dirent__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(bch_dirent__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dirent__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(bch_dirent__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_child_subvol) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(d_child_subvol),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_parent_subvol) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(d_parent_subvol),
        ),
    );
}
#[test]
fn bindgen_test_layout_bch_dirent__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bch_dirent__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_dirent__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(bch_dirent__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dirent__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_dirent__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_inum) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_1),
            "::",
            stringify!(d_inum),
        ),
    );
}
impl Default for bch_dirent__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed)]
pub struct bch_dirent__bindgen_ty_2 {
    pub d_cf_name_block: __BindgenUnionField<bch_dirent__bindgen_ty_2__bindgen_ty_1>,
    pub __bindgen_anon_1: __BindgenUnionField<bch_dirent__bindgen_ty_2__bindgen_ty_2>,
    pub bindgen_union_field: [u8; 6usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_dirent__bindgen_ty_2__bindgen_ty_1 {
    pub d_pad: __u8,
    pub d_name_len: __le16,
    pub d_cf_name_len: __le16,
    pub d_names: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_dirent__bindgen_ty_2__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bch_dirent__bindgen_ty_2__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_dirent__bindgen_ty_2__bindgen_ty_1>(),
        6usize,
        concat!("Size of: ", stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dirent__bindgen_ty_2__bindgen_ty_1>(),
        2usize,
        concat!("Alignment of ", stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(d_pad),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_name_len) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(d_name_len),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_cf_name_len) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(d_cf_name_len),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_names) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(d_names),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_dirent__bindgen_ty_2__bindgen_ty_2 {
    pub __empty_d_name: bch_dirent__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1,
    pub d_name: __IncompleteArrayField<__u8>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_dirent__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1 {}
#[test]
fn bindgen_test_layout_bch_dirent__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bch_dirent__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1>(),
        0usize,
        concat!(
            "Size of: ",
            stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1),
        ),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dirent__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_2__bindgen_ty_1),
        ),
    );
}
#[test]
fn bindgen_test_layout_bch_dirent__bindgen_ty_2__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<bch_dirent__bindgen_ty_2__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_dirent__bindgen_ty_2__bindgen_ty_2>(),
        0usize,
        concat!("Size of: ", stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_2)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dirent__bindgen_ty_2__bindgen_ty_2>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__empty_d_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_2),
            "::",
            stringify!(__empty_d_name),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_2__bindgen_ty_2),
            "::",
            stringify!(d_name),
        ),
    );
}
#[test]
fn bindgen_test_layout_bch_dirent__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<bch_dirent__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_dirent__bindgen_ty_2>(),
        6usize,
        concat!("Size of: ", stringify!(bch_dirent__bindgen_ty_2)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dirent__bindgen_ty_2>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_dirent__bindgen_ty_2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d_cf_name_block) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dirent__bindgen_ty_2),
            "::",
            stringify!(d_cf_name_block),
        ),
    );
}
impl Default for bch_dirent__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bch_dirent() {
    const UNINIT: ::std::mem::MaybeUninit<bch_dirent> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_dirent>(),
        16usize,
        concat!("Size of: ", stringify!(bch_dirent)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dirent>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_dirent)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_dirent), "::", stringify!(v)),
    );
}
impl Default for bch_dirent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bch_dirent {
    #[inline]
    pub fn d_type(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 5u8) as u8) }
    }
    #[inline]
    pub fn set_d_type(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn d_unused(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 2u8) as u8) }
    }
    #[inline]
    pub fn set_d_unused(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn d_casefold(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_d_casefold(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        d_type: __u8,
        d_unused: __u8,
        d_casefold: __u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                5u8,
                {
                    let d_type: u8 = unsafe { ::std::mem::transmute(d_type) };
                    d_type as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                5usize,
                2u8,
                {
                    let d_unused: u8 = unsafe { ::std::mem::transmute(d_unused) };
                    d_unused as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                1u8,
                {
                    let d_casefold: u8 = unsafe { ::std::mem::transmute(d_casefold) };
                    d_casefold as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(8))]
pub struct bch_inode {
    pub v: bch_val,
    pub bi_hash_seed: __le64,
    pub bi_flags: __le32,
    pub bi_mode: __le16,
    pub fields: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_inode() {
    const UNINIT: ::std::mem::MaybeUninit<bch_inode> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_inode>(),
        16usize,
        concat!("Size of: ", stringify!(bch_inode)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_inode>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_inode)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_inode), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_hash_seed) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode),
            "::",
            stringify!(bi_hash_seed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_flags) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_inode), "::", stringify!(bi_flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_mode) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(bch_inode), "::", stringify!(bi_mode)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        14usize,
        concat!("Offset of field: ", stringify!(bch_inode), "::", stringify!(fields)),
    );
}
impl Default for bch_inode {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_inode_v2 {
    pub v: bch_val,
    pub bi_journal_seq: __le64,
    pub bi_hash_seed: __le64,
    pub bi_flags: __le64,
    pub bi_mode: __le16,
    pub fields: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_inode_v2() {
    const UNINIT: ::std::mem::MaybeUninit<bch_inode_v2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_inode_v2>(),
        32usize,
        concat!("Size of: ", stringify!(bch_inode_v2)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_inode_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_inode_v2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_inode_v2), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_journal_seq) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_v2),
            "::",
            stringify!(bi_journal_seq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_hash_seed) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_v2),
            "::",
            stringify!(bi_hash_seed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_flags) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_v2),
            "::",
            stringify!(bi_flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_mode) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bch_inode_v2), "::", stringify!(bi_mode)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        26usize,
        concat!("Offset of field: ", stringify!(bch_inode_v2), "::", stringify!(fields)),
    );
}
impl Default for bch_inode_v2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_inode_v3 {
    pub v: bch_val,
    pub bi_journal_seq: __le64,
    pub bi_hash_seed: __le64,
    pub bi_flags: __le64,
    pub bi_sectors: __le64,
    pub bi_size: __le64,
    pub bi_version: __le64,
    pub fields: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_inode_v3() {
    const UNINIT: ::std::mem::MaybeUninit<bch_inode_v3> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_inode_v3>(),
        48usize,
        concat!("Size of: ", stringify!(bch_inode_v3)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_inode_v3>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_inode_v3)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_inode_v3), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_journal_seq) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_v3),
            "::",
            stringify!(bi_journal_seq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_hash_seed) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_v3),
            "::",
            stringify!(bi_hash_seed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_flags) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_v3),
            "::",
            stringify!(bi_flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_sectors) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_v3),
            "::",
            stringify!(bi_sectors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_size) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(bch_inode_v3), "::", stringify!(bi_size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_version) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_v3),
            "::",
            stringify!(bi_version),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(bch_inode_v3), "::", stringify!(fields)),
    );
}
impl Default for bch_inode_v3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_inode_generation {
    pub v: bch_val,
    pub bi_generation: __le32,
    pub pad: __le32,
}
#[test]
fn bindgen_test_layout_bch_inode_generation() {
    const UNINIT: ::std::mem::MaybeUninit<bch_inode_generation> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_inode_generation>(),
        8usize,
        concat!("Size of: ", stringify!(bch_inode_generation)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_inode_generation>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_inode_generation)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_generation),
            "::",
            stringify!(v),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bi_generation) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_generation),
            "::",
            stringify!(bi_generation),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_generation),
            "::",
            stringify!(pad),
        ),
    );
}
impl Default for bch_inode_generation {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum inode_opt_id {
    Inode_opt_data_checksum = 0,
    Inode_opt_compression = 1,
    Inode_opt_project = 2,
    Inode_opt_background_compression = 3,
    Inode_opt_data_replicas = 4,
    Inode_opt_promote_target = 5,
    Inode_opt_foreground_target = 6,
    Inode_opt_background_target = 7,
    Inode_opt_erasure_code = 8,
    Inode_opt_nocow = 9,
    Inode_opt_inodes_32bit = 10,
    Inode_opt_casefold = 11,
    Inode_opt_nr = 12,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_inode_flags {
    BCH_INODE_sync = 1,
    BCH_INODE_immutable = 2,
    BCH_INODE_append = 4,
    BCH_INODE_nodump = 8,
    BCH_INODE_noatime = 16,
    BCH_INODE_i_size_dirty = 32,
    BCH_INODE_i_sectors_dirty = 64,
    BCH_INODE_unlinked = 128,
    BCH_INODE_backptr_untrusted = 256,
    BCH_INODE_has_child_snapshot = 512,
    BCH_INODE_has_case_insensitive = 1024,
    BCH_INODE_31bit_dirent_offset = 2048,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_inode_alloc_cursor {
    pub v: bch_val,
    pub bits: __u8,
    pub pad: __u8,
    pub gen: __le32,
    pub idx: __le64,
}
#[test]
fn bindgen_test_layout_bch_inode_alloc_cursor() {
    const UNINIT: ::std::mem::MaybeUninit<bch_inode_alloc_cursor> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_inode_alloc_cursor>(),
        16usize,
        concat!("Size of: ", stringify!(bch_inode_alloc_cursor)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_inode_alloc_cursor>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_inode_alloc_cursor)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_alloc_cursor),
            "::",
            stringify!(v),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bits) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_alloc_cursor),
            "::",
            stringify!(bits),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_alloc_cursor),
            "::",
            stringify!(pad),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gen) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_alloc_cursor),
            "::",
            stringify!(gen),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).idx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_alloc_cursor),
            "::",
            stringify!(idx),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_logged_op_truncate {
    pub v: bch_val,
    pub subvol: __le32,
    pub pad: __le32,
    pub inum: __le64,
    pub new_i_size: __le64,
}
#[test]
fn bindgen_test_layout_bch_logged_op_truncate() {
    const UNINIT: ::std::mem::MaybeUninit<bch_logged_op_truncate> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_logged_op_truncate>(),
        24usize,
        concat!("Size of: ", stringify!(bch_logged_op_truncate)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_logged_op_truncate>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_logged_op_truncate)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_truncate),
            "::",
            stringify!(v),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subvol) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_truncate),
            "::",
            stringify!(subvol),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_truncate),
            "::",
            stringify!(pad),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inum) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_truncate),
            "::",
            stringify!(inum),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).new_i_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_truncate),
            "::",
            stringify!(new_i_size),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_logged_op_finsert {
    pub v: bch_val,
    pub state: __u8,
    pub pad: [__u8; 3usize],
    pub subvol: __le32,
    pub inum: __le64,
    pub dst_offset: __le64,
    pub src_offset: __le64,
    pub pos: __le64,
}
#[test]
fn bindgen_test_layout_bch_logged_op_finsert() {
    const UNINIT: ::std::mem::MaybeUninit<bch_logged_op_finsert> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_logged_op_finsert>(),
        40usize,
        concat!("Size of: ", stringify!(bch_logged_op_finsert)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_logged_op_finsert>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_logged_op_finsert)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_finsert),
            "::",
            stringify!(v),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_finsert),
            "::",
            stringify!(state),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_finsert),
            "::",
            stringify!(pad),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subvol) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_finsert),
            "::",
            stringify!(subvol),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inum) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_finsert),
            "::",
            stringify!(inum),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dst_offset) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_finsert),
            "::",
            stringify!(dst_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src_offset) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_finsert),
            "::",
            stringify!(src_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_logged_op_finsert),
            "::",
            stringify!(pos),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_quota_counter {
    pub hardlimit: __le64,
    pub softlimit: __le64,
}
#[test]
fn bindgen_test_layout_bch_quota_counter() {
    const UNINIT: ::std::mem::MaybeUninit<bch_quota_counter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_quota_counter>(),
        16usize,
        concat!("Size of: ", stringify!(bch_quota_counter)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_quota_counter>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_quota_counter)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hardlimit) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_quota_counter),
            "::",
            stringify!(hardlimit),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).softlimit) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_quota_counter),
            "::",
            stringify!(softlimit),
        ),
    );
}
#[repr(C, packed(8))]
pub struct bch_quota {
    pub v: bch_val,
    pub c: [bch_quota_counter; 2usize],
}
#[test]
fn bindgen_test_layout_bch_quota() {
    const UNINIT: ::std::mem::MaybeUninit<bch_quota> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_quota>(),
        32usize,
        concat!("Size of: ", stringify!(bch_quota)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_quota>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_quota)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_quota), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).c) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_quota), "::", stringify!(c)),
    );
}
impl Default for bch_quota {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_sb_quota_counter {
    pub timelimit: __le32,
    pub warnlimit: __le32,
}
#[test]
fn bindgen_test_layout_bch_sb_quota_counter() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_quota_counter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_quota_counter>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_quota_counter)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_quota_counter>(),
        4usize,
        concat!("Alignment of ", stringify!(bch_sb_quota_counter)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timelimit) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_quota_counter),
            "::",
            stringify!(timelimit),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).warnlimit) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_quota_counter),
            "::",
            stringify!(warnlimit),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_sb_quota_type {
    pub flags: __le64,
    pub c: [bch_sb_quota_counter; 2usize],
}
#[test]
fn bindgen_test_layout_bch_sb_quota_type() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_quota_type> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_quota_type>(),
        24usize,
        concat!("Size of: ", stringify!(bch_sb_quota_type)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_quota_type>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_quota_type)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_quota_type),
            "::",
            stringify!(flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).c) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_sb_quota_type), "::", stringify!(c)),
    );
}
#[repr(C, packed(8))]
pub struct bch_sb_field_quota {
    pub field: bch_sb_field,
    pub q: [bch_sb_quota_type; 3usize],
}
#[test]
fn bindgen_test_layout_bch_sb_field_quota() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_quota> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_quota>(),
        80usize,
        concat!("Size of: ", stringify!(bch_sb_field_quota)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_quota>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_quota)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_quota),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).q) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_sb_field_quota), "::", stringify!(q)),
    );
}
impl Default for bch_sb_field_quota {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bch_xattr {
    pub v: bch_val,
    pub x_type: __u8,
    pub x_name_len: __u8,
    pub x_val_len: __le16,
    pub x_name_and_value: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_bch_xattr() {
    const UNINIT: ::std::mem::MaybeUninit<bch_xattr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_xattr>(),
        8usize,
        concat!("Size of: ", stringify!(bch_xattr)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_xattr>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_xattr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_xattr), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x_type) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_xattr), "::", stringify!(x_type)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x_name_len) as usize - ptr as usize },
        1usize,
        concat!("Offset of field: ", stringify!(bch_xattr), "::", stringify!(x_name_len)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x_val_len) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(bch_xattr), "::", stringify!(x_val_len)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x_name_and_value) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_xattr),
            "::",
            stringify!(x_name_and_value),
        ),
    );
}
impl Default for bch_xattr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_recovery_pass {
    BCH_RECOVERY_PASS_recovery_pass_empty = 0,
    BCH_RECOVERY_PASS_scan_for_btree_nodes = 1,
    BCH_RECOVERY_PASS_check_topology = 2,
    BCH_RECOVERY_PASS_accounting_read = 3,
    BCH_RECOVERY_PASS_alloc_read = 4,
    BCH_RECOVERY_PASS_stripes_read = 5,
    BCH_RECOVERY_PASS_initialize_subvolumes = 6,
    BCH_RECOVERY_PASS_snapshots_read = 7,
    BCH_RECOVERY_PASS_check_allocations = 8,
    BCH_RECOVERY_PASS_trans_mark_dev_sbs = 9,
    BCH_RECOVERY_PASS_fs_journal_alloc = 10,
    BCH_RECOVERY_PASS_set_may_go_rw = 11,
    BCH_RECOVERY_PASS_journal_replay = 12,
    BCH_RECOVERY_PASS_merge_btree_nodes = 13,
    BCH_RECOVERY_PASS_check_alloc_info = 14,
    BCH_RECOVERY_PASS_check_lrus = 15,
    BCH_RECOVERY_PASS_check_btree_backpointers = 16,
    BCH_RECOVERY_PASS_check_backpointers_to_extents = 17,
    BCH_RECOVERY_PASS_check_extents_to_backpointers = 18,
    BCH_RECOVERY_PASS_check_alloc_to_lru_refs = 19,
    BCH_RECOVERY_PASS_fs_freespace_init = 20,
    BCH_RECOVERY_PASS_bucket_gens_init = 21,
    BCH_RECOVERY_PASS_reconstruct_snapshots = 22,
    BCH_RECOVERY_PASS_delete_dead_interior_snapshots = 23,
    BCH_RECOVERY_PASS_check_snapshot_trees = 24,
    BCH_RECOVERY_PASS_check_snapshots = 25,
    BCH_RECOVERY_PASS_check_subvols = 26,
    BCH_RECOVERY_PASS_check_subvol_children = 27,
    BCH_RECOVERY_PASS_delete_dead_snapshots = 28,
    BCH_RECOVERY_PASS_fs_upgrade_for_subvolumes = 29,
    BCH_RECOVERY_PASS_check_inodes = 30,
    BCH_RECOVERY_PASS_check_extents = 31,
    BCH_RECOVERY_PASS_check_indirect_extents = 32,
    BCH_RECOVERY_PASS_check_dirents = 33,
    BCH_RECOVERY_PASS_check_xattrs = 34,
    BCH_RECOVERY_PASS_check_root = 35,
    BCH_RECOVERY_PASS_check_unreachable_inodes = 36,
    BCH_RECOVERY_PASS_check_subvolume_structure = 37,
    BCH_RECOVERY_PASS_check_directory_structure = 38,
    BCH_RECOVERY_PASS_check_nlinks = 39,
    BCH_RECOVERY_PASS_check_reconcile_work = 40,
    BCH_RECOVERY_PASS_resume_logged_ops = 41,
    BCH_RECOVERY_PASS_delete_dead_inodes = 42,
    BCH_RECOVERY_PASS_kill_i_generation_keys = 43,
    BCH_RECOVERY_PASS_fix_reflink_p = 44,
    BCH_RECOVERY_PASS_set_fs_needs_reconcile = 45,
    BCH_RECOVERY_PASS_btree_bitmap_gc = 46,
    BCH_RECOVERY_PASS_lookup_root_inode = 47,
    BCH_RECOVERY_PASS_NR = 48,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_recovery_pass_stable {
    BCH_RECOVERY_PASS_STABLE_recovery_pass_empty = 41,
    BCH_RECOVERY_PASS_STABLE_scan_for_btree_nodes = 37,
    BCH_RECOVERY_PASS_STABLE_check_topology = 4,
    BCH_RECOVERY_PASS_STABLE_accounting_read = 39,
    BCH_RECOVERY_PASS_STABLE_alloc_read = 0,
    BCH_RECOVERY_PASS_STABLE_stripes_read = 1,
    BCH_RECOVERY_PASS_STABLE_initialize_subvolumes = 2,
    BCH_RECOVERY_PASS_STABLE_snapshots_read = 3,
    BCH_RECOVERY_PASS_STABLE_check_allocations = 5,
    BCH_RECOVERY_PASS_STABLE_trans_mark_dev_sbs = 6,
    BCH_RECOVERY_PASS_STABLE_fs_journal_alloc = 7,
    BCH_RECOVERY_PASS_STABLE_set_may_go_rw = 8,
    BCH_RECOVERY_PASS_STABLE_journal_replay = 9,
    BCH_RECOVERY_PASS_STABLE_merge_btree_nodes = 45,
    BCH_RECOVERY_PASS_STABLE_check_alloc_info = 10,
    BCH_RECOVERY_PASS_STABLE_check_lrus = 11,
    BCH_RECOVERY_PASS_STABLE_check_btree_backpointers = 12,
    BCH_RECOVERY_PASS_STABLE_check_backpointers_to_extents = 13,
    BCH_RECOVERY_PASS_STABLE_check_extents_to_backpointers = 14,
    BCH_RECOVERY_PASS_STABLE_check_alloc_to_lru_refs = 15,
    BCH_RECOVERY_PASS_STABLE_fs_freespace_init = 16,
    BCH_RECOVERY_PASS_STABLE_bucket_gens_init = 17,
    BCH_RECOVERY_PASS_STABLE_reconstruct_snapshots = 38,
    BCH_RECOVERY_PASS_STABLE_delete_dead_interior_snapshots = 44,
    BCH_RECOVERY_PASS_STABLE_check_snapshot_trees = 18,
    BCH_RECOVERY_PASS_STABLE_check_snapshots = 19,
    BCH_RECOVERY_PASS_STABLE_check_subvols = 20,
    BCH_RECOVERY_PASS_STABLE_check_subvol_children = 35,
    BCH_RECOVERY_PASS_STABLE_delete_dead_snapshots = 21,
    BCH_RECOVERY_PASS_STABLE_fs_upgrade_for_subvolumes = 22,
    BCH_RECOVERY_PASS_STABLE_check_inodes = 24,
    BCH_RECOVERY_PASS_STABLE_check_extents = 25,
    BCH_RECOVERY_PASS_STABLE_check_indirect_extents = 26,
    BCH_RECOVERY_PASS_STABLE_check_dirents = 27,
    BCH_RECOVERY_PASS_STABLE_check_xattrs = 28,
    BCH_RECOVERY_PASS_STABLE_check_root = 29,
    BCH_RECOVERY_PASS_STABLE_check_unreachable_inodes = 40,
    BCH_RECOVERY_PASS_STABLE_check_subvolume_structure = 36,
    BCH_RECOVERY_PASS_STABLE_check_directory_structure = 30,
    BCH_RECOVERY_PASS_STABLE_check_nlinks = 31,
    BCH_RECOVERY_PASS_STABLE_check_reconcile_work = 43,
    BCH_RECOVERY_PASS_STABLE_resume_logged_ops = 23,
    BCH_RECOVERY_PASS_STABLE_delete_dead_inodes = 32,
    BCH_RECOVERY_PASS_STABLE_kill_i_generation_keys = 47,
    BCH_RECOVERY_PASS_STABLE_fix_reflink_p = 33,
    BCH_RECOVERY_PASS_STABLE_set_fs_needs_reconcile = 34,
    BCH_RECOVERY_PASS_STABLE_btree_bitmap_gc = 46,
    BCH_RECOVERY_PASS_STABLE_lookup_root_inode = 42,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct recovery_pass_entry {
    pub last_run: __le64,
    pub last_runtime: __le32,
    pub flags: __le32,
}
#[test]
fn bindgen_test_layout_recovery_pass_entry() {
    const UNINIT: ::std::mem::MaybeUninit<recovery_pass_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<recovery_pass_entry>(),
        16usize,
        concat!("Size of: ", stringify!(recovery_pass_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<recovery_pass_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(recovery_pass_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_run) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(recovery_pass_entry),
            "::",
            stringify!(last_run),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_runtime) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(recovery_pass_entry),
            "::",
            stringify!(last_runtime),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(recovery_pass_entry),
            "::",
            stringify!(flags),
        ),
    );
}
pub const BCH_RECOVERY_PASS_NO_RATELIMIT_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_RECOVERY_PASS_NO_RATELIMIT_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_RECOVERY_PASS_NO_RATELIMIT_MAX: __u32 = 1;
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_recovery_passes {
    pub field: bch_sb_field,
    pub start: __IncompleteArrayField<recovery_pass_entry>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_recovery_passes() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_recovery_passes> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_recovery_passes>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_recovery_passes)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_recovery_passes>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_recovery_passes)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_recovery_passes),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_recovery_passes),
            "::",
            stringify!(start),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_seq_blacklist_entry {
    pub start: __le64,
    pub end: __le64,
}
#[test]
fn bindgen_test_layout_journal_seq_blacklist_entry() {
    const UNINIT: ::std::mem::MaybeUninit<journal_seq_blacklist_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_seq_blacklist_entry>(),
        16usize,
        concat!("Size of: ", stringify!(journal_seq_blacklist_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_seq_blacklist_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_seq_blacklist_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_seq_blacklist_entry),
            "::",
            stringify!(start),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_seq_blacklist_entry),
            "::",
            stringify!(end),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_journal_seq_blacklist {
    pub field: bch_sb_field,
    pub start: __IncompleteArrayField<journal_seq_blacklist_entry>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_journal_seq_blacklist() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_journal_seq_blacklist> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_journal_seq_blacklist>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_journal_seq_blacklist)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_journal_seq_blacklist>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_journal_seq_blacklist)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_journal_seq_blacklist),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_journal_seq_blacklist),
            "::",
            stringify!(start),
        ),
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_counters_flags {
    TYPE_COUNTER = 1,
    TYPE_SECTORS = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_persistent_counters {
    BCH_COUNTER_sync_fs = 0,
    BCH_COUNTER_fsync = 1,
    BCH_COUNTER_data_read = 2,
    BCH_COUNTER_data_read_inline = 3,
    BCH_COUNTER_data_read_hole = 4,
    BCH_COUNTER_data_read_promote = 5,
    BCH_COUNTER_data_read_nopromote = 6,
    BCH_COUNTER_data_read_nopromote_may_not = 7,
    BCH_COUNTER_data_read_nopromote_already_promoted = 8,
    BCH_COUNTER_data_read_nopromote_unwritten = 9,
    BCH_COUNTER_data_read_nopromote_congested = 10,
    BCH_COUNTER_data_read_nopromote_in_flight = 11,
    BCH_COUNTER_data_read_bounce = 12,
    BCH_COUNTER_data_read_split = 13,
    BCH_COUNTER_data_read_reuse_race = 14,
    BCH_COUNTER_data_read_retry = 15,
    BCH_COUNTER_data_read_fail_and_poison = 16,
    BCH_COUNTER_data_read_narrow_crcs = 17,
    BCH_COUNTER_data_read_narrow_crcs_fail = 18,
    BCH_COUNTER_data_write = 19,
    BCH_COUNTER_data_update_pred = 20,
    BCH_COUNTER_data_update = 21,
    BCH_COUNTER_data_update_no_io = 22,
    BCH_COUNTER_data_update_fail = 23,
    BCH_COUNTER_data_update_read = 24,
    BCH_COUNTER_data_update_write = 25,
    BCH_COUNTER_data_update_key = 26,
    BCH_COUNTER_data_update_key_fail = 27,
    BCH_COUNTER_data_update_start_fail_obsolete = 28,
    BCH_COUNTER_data_update_noop_obsolete = 29,
    BCH_COUNTER_reconcile_scan_fs = 30,
    BCH_COUNTER_reconcile_scan_metadata = 31,
    BCH_COUNTER_reconcile_scan_pending = 32,
    BCH_COUNTER_reconcile_scan_device = 33,
    BCH_COUNTER_reconcile_scan_inum = 34,
    BCH_COUNTER_reconcile_btree = 35,
    BCH_COUNTER_reconcile_data = 36,
    BCH_COUNTER_reconcile_phys = 37,
    BCH_COUNTER_reconcile_set_pending = 38,
    BCH_COUNTER_evacuate_bucket = 39,
    BCH_COUNTER_stripe_create = 40,
    BCH_COUNTER_stripe_create_fail = 41,
    BCH_COUNTER_stripe_update_bucket = 42,
    BCH_COUNTER_stripe_update_extent = 43,
    BCH_COUNTER_stripe_update_extent_fail = 44,
    BCH_COUNTER_copygc = 45,
    BCH_COUNTER_copygc_wait_obsolete = 46,
    BCH_COUNTER_cached_ptr_drop = 47,
    BCH_COUNTER_bucket_invalidate = 48,
    BCH_COUNTER_bucket_discard_worker = 49,
    BCH_COUNTER_bucket_discard_fast_worker = 50,
    BCH_COUNTER_bucket_discard = 51,
    BCH_COUNTER_bucket_discard_fast = 52,
    BCH_COUNTER_bucket_alloc = 53,
    BCH_COUNTER_bucket_alloc_fail = 54,
    BCH_COUNTER_bkey_pack_pos_fail = 55,
    BCH_COUNTER_btree_cache_scan = 56,
    BCH_COUNTER_btree_cache_reap = 57,
    BCH_COUNTER_btree_cache_cannibalize = 58,
    BCH_COUNTER_btree_cache_cannibalize_lock = 59,
    BCH_COUNTER_btree_cache_cannibalize_lock_fail = 60,
    BCH_COUNTER_btree_cache_cannibalize_unlock = 61,
    BCH_COUNTER_btree_node_write = 62,
    BCH_COUNTER_btree_node_read = 63,
    BCH_COUNTER_btree_node_compact = 64,
    BCH_COUNTER_btree_node_merge = 65,
    BCH_COUNTER_btree_node_merge_attempt = 66,
    BCH_COUNTER_btree_node_split = 67,
    BCH_COUNTER_btree_node_rewrite = 68,
    BCH_COUNTER_btree_node_alloc = 69,
    BCH_COUNTER_btree_node_free = 70,
    BCH_COUNTER_btree_node_set_root = 71,
    BCH_COUNTER_btree_key_cache_fill = 72,
    BCH_COUNTER_btree_path_relock_fail = 73,
    BCH_COUNTER_btree_path_upgrade_fail = 74,
    BCH_COUNTER_btree_reserve_get_fail = 75,
    BCH_COUNTER_journal_entry_full = 76,
    BCH_COUNTER_journal_full = 77,
    BCH_COUNTER_journal_reclaim_finish = 78,
    BCH_COUNTER_journal_reclaim_start = 79,
    BCH_COUNTER_journal_write = 80,
    BCH_COUNTER_gc_gens_end = 81,
    BCH_COUNTER_gc_gens_start = 82,
    BCH_COUNTER_trans_blocked_journal_reclaim = 83,
    BCH_COUNTER_trans_restart_btree_node_reused = 84,
    BCH_COUNTER_trans_restart_btree_node_split = 85,
    BCH_COUNTER_trans_restart_fault_inject = 86,
    BCH_COUNTER_trans_restart_iter_upgrade = 87,
    BCH_COUNTER_trans_restart_journal_preres_get = 88,
    BCH_COUNTER_trans_restart_journal_reclaim = 89,
    BCH_COUNTER_trans_restart_journal_res_get = 90,
    BCH_COUNTER_trans_restart_key_cache_key_realloced = 91,
    BCH_COUNTER_trans_restart_key_cache_raced = 92,
    BCH_COUNTER_trans_restart_mark_replicas = 93,
    BCH_COUNTER_trans_restart_mem_realloced = 94,
    BCH_COUNTER_trans_restart_memory_allocation_failure = 95,
    BCH_COUNTER_trans_restart_relock = 96,
    BCH_COUNTER_trans_restart_relock_after_fill = 97,
    BCH_COUNTER_trans_restart_relock_key_cache_fill_obsolete = 98,
    BCH_COUNTER_trans_restart_relock_next_node = 99,
    BCH_COUNTER_trans_restart_relock_parent_for_fill_obsolete = 100,
    BCH_COUNTER_trans_restart_relock_path = 101,
    BCH_COUNTER_trans_restart_relock_path_intent = 102,
    BCH_COUNTER_trans_restart_too_many_iters = 103,
    BCH_COUNTER_trans_restart_traverse = 104,
    BCH_COUNTER_trans_restart_upgrade = 105,
    BCH_COUNTER_trans_restart_would_deadlock = 106,
    BCH_COUNTER_trans_restart_would_deadlock_write = 107,
    BCH_COUNTER_trans_restart_injected = 108,
    BCH_COUNTER_trans_restart_key_cache_upgrade = 109,
    BCH_COUNTER_trans_traverse_all = 110,
    BCH_COUNTER_transaction_commit = 111,
    BCH_COUNTER_write_super = 112,
    BCH_COUNTER_trans_restart_would_deadlock_recursion_limit = 113,
    BCH_COUNTER_trans_restart_write_buffer_flush = 114,
    BCH_COUNTER_trans_restart_split_race = 115,
    BCH_COUNTER_write_buffer_flush = 116,
    BCH_COUNTER_write_buffer_flush_slowpath = 117,
    BCH_COUNTER_write_buffer_flush_sync = 118,
    BCH_COUNTER_write_buffer_maybe_flush = 119,
    BCH_COUNTER_accounting_key_to_wb_slowpath = 120,
    BCH_COUNTER_error_throw = 121,
    BCH_COUNTER_NR = 122,
}
extern "C" {
    pub static bch2_counter_flags: [bch_counters_flags; 122usize];
}
impl bch_persistent_counters_stable {
    pub const BCH_COUNTER_STABLE_NR: bch_persistent_counters_stable = bch_persistent_counters_stable::BCH_COUNTER_STABLE_accounting_key_to_wb_slowpath;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_persistent_counters_stable {
    BCH_COUNTER_STABLE_sync_fs = 110,
    BCH_COUNTER_STABLE_fsync = 111,
    BCH_COUNTER_STABLE_data_read = 0,
    BCH_COUNTER_STABLE_data_read_inline = 80,
    BCH_COUNTER_STABLE_data_read_hole = 81,
    BCH_COUNTER_STABLE_data_read_promote = 30,
    BCH_COUNTER_STABLE_data_read_nopromote = 85,
    BCH_COUNTER_STABLE_data_read_nopromote_may_not = 86,
    BCH_COUNTER_STABLE_data_read_nopromote_already_promoted = 87,
    BCH_COUNTER_STABLE_data_read_nopromote_unwritten = 88,
    BCH_COUNTER_STABLE_data_read_nopromote_congested = 89,
    BCH_COUNTER_STABLE_data_read_nopromote_in_flight = 90,
    BCH_COUNTER_STABLE_data_read_bounce = 31,
    BCH_COUNTER_STABLE_data_read_split = 33,
    BCH_COUNTER_STABLE_data_read_reuse_race = 34,
    BCH_COUNTER_STABLE_data_read_retry = 32,
    BCH_COUNTER_STABLE_data_read_fail_and_poison = 95,
    BCH_COUNTER_STABLE_data_read_narrow_crcs = 97,
    BCH_COUNTER_STABLE_data_read_narrow_crcs_fail = 98,
    BCH_COUNTER_STABLE_data_write = 1,
    BCH_COUNTER_STABLE_data_update_pred = 96,
    BCH_COUNTER_STABLE_data_update = 2,
    BCH_COUNTER_STABLE_data_update_no_io = 91,
    BCH_COUNTER_STABLE_data_update_fail = 82,
    BCH_COUNTER_STABLE_data_update_read = 35,
    BCH_COUNTER_STABLE_data_update_write = 36,
    BCH_COUNTER_STABLE_data_update_key = 37,
    BCH_COUNTER_STABLE_data_update_key_fail = 38,
    BCH_COUNTER_STABLE_data_update_start_fail_obsolete = 39,
    BCH_COUNTER_STABLE_data_update_noop_obsolete = 92,
    BCH_COUNTER_STABLE_reconcile_scan_fs = 113,
    BCH_COUNTER_STABLE_reconcile_scan_metadata = 114,
    BCH_COUNTER_STABLE_reconcile_scan_pending = 115,
    BCH_COUNTER_STABLE_reconcile_scan_device = 116,
    BCH_COUNTER_STABLE_reconcile_scan_inum = 117,
    BCH_COUNTER_STABLE_reconcile_btree = 118,
    BCH_COUNTER_STABLE_reconcile_data = 119,
    BCH_COUNTER_STABLE_reconcile_phys = 120,
    BCH_COUNTER_STABLE_reconcile_set_pending = 83,
    BCH_COUNTER_STABLE_evacuate_bucket = 84,
    BCH_COUNTER_STABLE_stripe_create = 102,
    BCH_COUNTER_STABLE_stripe_create_fail = 103,
    BCH_COUNTER_STABLE_stripe_update_bucket = 104,
    BCH_COUNTER_STABLE_stripe_update_extent = 99,
    BCH_COUNTER_STABLE_stripe_update_extent_fail = 100,
    BCH_COUNTER_STABLE_copygc = 40,
    BCH_COUNTER_STABLE_copygc_wait_obsolete = 41,
    BCH_COUNTER_STABLE_cached_ptr_drop = 121,
    BCH_COUNTER_STABLE_bucket_invalidate = 3,
    BCH_COUNTER_STABLE_bucket_discard_worker = 108,
    BCH_COUNTER_STABLE_bucket_discard_fast_worker = 109,
    BCH_COUNTER_STABLE_bucket_discard = 4,
    BCH_COUNTER_STABLE_bucket_discard_fast = 79,
    BCH_COUNTER_STABLE_bucket_alloc = 5,
    BCH_COUNTER_STABLE_bucket_alloc_fail = 6,
    BCH_COUNTER_STABLE_bkey_pack_pos_fail = 112,
    BCH_COUNTER_STABLE_btree_cache_scan = 7,
    BCH_COUNTER_STABLE_btree_cache_reap = 8,
    BCH_COUNTER_STABLE_btree_cache_cannibalize = 9,
    BCH_COUNTER_STABLE_btree_cache_cannibalize_lock = 10,
    BCH_COUNTER_STABLE_btree_cache_cannibalize_lock_fail = 11,
    BCH_COUNTER_STABLE_btree_cache_cannibalize_unlock = 12,
    BCH_COUNTER_STABLE_btree_node_write = 13,
    BCH_COUNTER_STABLE_btree_node_read = 14,
    BCH_COUNTER_STABLE_btree_node_compact = 15,
    BCH_COUNTER_STABLE_btree_node_merge = 16,
    BCH_COUNTER_STABLE_btree_node_merge_attempt = 101,
    BCH_COUNTER_STABLE_btree_node_split = 17,
    BCH_COUNTER_STABLE_btree_node_rewrite = 18,
    BCH_COUNTER_STABLE_btree_node_alloc = 19,
    BCH_COUNTER_STABLE_btree_node_free = 20,
    BCH_COUNTER_STABLE_btree_node_set_root = 21,
    BCH_COUNTER_STABLE_btree_key_cache_fill = 107,
    BCH_COUNTER_STABLE_btree_path_relock_fail = 22,
    BCH_COUNTER_STABLE_btree_path_upgrade_fail = 23,
    BCH_COUNTER_STABLE_btree_reserve_get_fail = 24,
    BCH_COUNTER_STABLE_journal_entry_full = 25,
    BCH_COUNTER_STABLE_journal_full = 26,
    BCH_COUNTER_STABLE_journal_reclaim_finish = 27,
    BCH_COUNTER_STABLE_journal_reclaim_start = 28,
    BCH_COUNTER_STABLE_journal_write = 29,
    BCH_COUNTER_STABLE_gc_gens_end = 42,
    BCH_COUNTER_STABLE_gc_gens_start = 43,
    BCH_COUNTER_STABLE_trans_blocked_journal_reclaim = 44,
    BCH_COUNTER_STABLE_trans_restart_btree_node_reused = 45,
    BCH_COUNTER_STABLE_trans_restart_btree_node_split = 46,
    BCH_COUNTER_STABLE_trans_restart_fault_inject = 47,
    BCH_COUNTER_STABLE_trans_restart_iter_upgrade = 48,
    BCH_COUNTER_STABLE_trans_restart_journal_preres_get = 49,
    BCH_COUNTER_STABLE_trans_restart_journal_reclaim = 50,
    BCH_COUNTER_STABLE_trans_restart_journal_res_get = 51,
    BCH_COUNTER_STABLE_trans_restart_key_cache_key_realloced = 52,
    BCH_COUNTER_STABLE_trans_restart_key_cache_raced = 53,
    BCH_COUNTER_STABLE_trans_restart_mark_replicas = 54,
    BCH_COUNTER_STABLE_trans_restart_mem_realloced = 55,
    BCH_COUNTER_STABLE_trans_restart_memory_allocation_failure = 56,
    BCH_COUNTER_STABLE_trans_restart_relock = 57,
    BCH_COUNTER_STABLE_trans_restart_relock_after_fill = 58,
    BCH_COUNTER_STABLE_trans_restart_relock_key_cache_fill_obsolete = 59,
    BCH_COUNTER_STABLE_trans_restart_relock_next_node = 60,
    BCH_COUNTER_STABLE_trans_restart_relock_parent_for_fill_obsolete = 61,
    BCH_COUNTER_STABLE_trans_restart_relock_path = 62,
    BCH_COUNTER_STABLE_trans_restart_relock_path_intent = 63,
    BCH_COUNTER_STABLE_trans_restart_too_many_iters = 64,
    BCH_COUNTER_STABLE_trans_restart_traverse = 65,
    BCH_COUNTER_STABLE_trans_restart_upgrade = 66,
    BCH_COUNTER_STABLE_trans_restart_would_deadlock = 67,
    BCH_COUNTER_STABLE_trans_restart_would_deadlock_write = 68,
    BCH_COUNTER_STABLE_trans_restart_injected = 69,
    BCH_COUNTER_STABLE_trans_restart_key_cache_upgrade = 70,
    BCH_COUNTER_STABLE_trans_traverse_all = 71,
    BCH_COUNTER_STABLE_transaction_commit = 72,
    BCH_COUNTER_STABLE_write_super = 73,
    BCH_COUNTER_STABLE_trans_restart_would_deadlock_recursion_limit = 74,
    BCH_COUNTER_STABLE_trans_restart_write_buffer_flush = 75,
    BCH_COUNTER_STABLE_trans_restart_split_race = 76,
    BCH_COUNTER_STABLE_write_buffer_flush = 105,
    BCH_COUNTER_STABLE_write_buffer_flush_slowpath = 77,
    BCH_COUNTER_STABLE_write_buffer_flush_sync = 78,
    BCH_COUNTER_STABLE_write_buffer_maybe_flush = 106,
    BCH_COUNTER_STABLE_accounting_key_to_wb_slowpath = 94,
    BCH_COUNTER_STABLE_error_throw = 93,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_counters {
    pub field: bch_sb_field,
    pub d: __IncompleteArrayField<__le64>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_counters() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_counters> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_counters>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_counters)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_counters>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_counters)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_counters),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_counters),
            "::",
            stringify!(d),
        ),
    );
}
#[repr(C, packed(2))]
pub struct bch_sb_field_downgrade_entry {
    pub version: __le16,
    pub recovery_passes: [__le64; 2usize],
    pub nr_errors: __le16,
    pub errors: __IncompleteArrayField<__le16>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_downgrade_entry() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_downgrade_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_downgrade_entry>(),
        20usize,
        concat!("Size of: ", stringify!(bch_sb_field_downgrade_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_downgrade_entry>(),
        2usize,
        concat!("Alignment of ", stringify!(bch_sb_field_downgrade_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_downgrade_entry),
            "::",
            stringify!(version),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).recovery_passes) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_downgrade_entry),
            "::",
            stringify!(recovery_passes),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_errors) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_downgrade_entry),
            "::",
            stringify!(nr_errors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).errors) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_downgrade_entry),
            "::",
            stringify!(errors),
        ),
    );
}
impl Default for bch_sb_field_downgrade_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_downgrade {
    pub field: bch_sb_field,
    pub entries: __IncompleteArrayField<bch_sb_field_downgrade_entry>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_downgrade() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_downgrade> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_downgrade>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_downgrade)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_downgrade>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_downgrade)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_downgrade),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_downgrade),
            "::",
            stringify!(entries),
        ),
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_fsck_flags {
    FSCK_CAN_FIX = 1,
    FSCK_CAN_IGNORE = 2,
    FSCK_AUTOFIX = 4,
    FSCK_ERR_NO_LOG = 8,
    FSCK_ERR_SILENT = 16,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_sb_error_id {
    BCH_FSCK_ERR_clean_but_journal_not_empty = 0,
    BCH_FSCK_ERR_dirty_but_no_journal_entries = 1,
    BCH_FSCK_ERR_dirty_but_no_journal_entries_post_drop_nonflushes = 2,
    BCH_FSCK_ERR_sb_clean_journal_seq_mismatch = 3,
    BCH_FSCK_ERR_sb_clean_btree_root_mismatch = 4,
    BCH_FSCK_ERR_sb_clean_missing = 5,
    BCH_FSCK_ERR_jset_unsupported_version = 6,
    BCH_FSCK_ERR_jset_unknown_csum = 7,
    BCH_FSCK_ERR_jset_last_seq_newer_than_seq = 8,
    BCH_FSCK_ERR_jset_past_bucket_end = 9,
    BCH_FSCK_ERR_jset_seq_blacklisted = 10,
    BCH_FSCK_ERR_journal_entries_missing = 11,
    BCH_FSCK_ERR_journal_entry_replicas_not_marked = 12,
    BCH_FSCK_ERR_journal_entry_past_jset_end = 13,
    BCH_FSCK_ERR_journal_entry_replicas_data_mismatch = 14,
    BCH_FSCK_ERR_journal_entry_bkey_u64s_0 = 15,
    BCH_FSCK_ERR_journal_entry_bkey_past_end = 16,
    BCH_FSCK_ERR_journal_entry_bkey_bad_format = 17,
    BCH_FSCK_ERR_journal_entry_bkey_invalid = 18,
    BCH_FSCK_ERR_journal_entry_btree_root_bad_size = 19,
    BCH_FSCK_ERR_journal_entry_blacklist_bad_size = 20,
    BCH_FSCK_ERR_journal_entry_blacklist_v2_bad_size = 21,
    BCH_FSCK_ERR_journal_entry_blacklist_v2_start_past_end = 22,
    BCH_FSCK_ERR_journal_entry_usage_bad_size = 23,
    BCH_FSCK_ERR_journal_entry_data_usage_bad_size = 24,
    BCH_FSCK_ERR_journal_entry_clock_bad_size = 25,
    BCH_FSCK_ERR_journal_entry_clock_bad_rw = 26,
    BCH_FSCK_ERR_journal_entry_dev_usage_bad_size = 27,
    BCH_FSCK_ERR_journal_entry_dev_usage_bad_dev = 28,
    BCH_FSCK_ERR_journal_entry_dev_usage_bad_pad = 29,
    BCH_FSCK_ERR_btree_node_unreadable = 30,
    BCH_FSCK_ERR_btree_node_fault_injected = 31,
    BCH_FSCK_ERR_btree_node_bad_magic = 32,
    BCH_FSCK_ERR_btree_node_bad_seq = 33,
    BCH_FSCK_ERR_btree_node_unsupported_version = 34,
    BCH_FSCK_ERR_btree_node_bset_older_than_sb_min = 35,
    BCH_FSCK_ERR_btree_node_bset_newer_than_sb = 36,
    BCH_FSCK_ERR_btree_node_data_missing = 37,
    BCH_FSCK_ERR_btree_node_bset_after_end = 38,
    BCH_FSCK_ERR_btree_node_replicas_sectors_written_mismatch = 39,
    BCH_FSCK_ERR_btree_node_replicas_data_mismatch = 40,
    BCH_FSCK_ERR_bset_unknown_csum = 41,
    BCH_FSCK_ERR_bset_bad_csum = 42,
    BCH_FSCK_ERR_bset_past_end_of_btree_node = 43,
    BCH_FSCK_ERR_bset_wrong_sector_offset = 44,
    BCH_FSCK_ERR_bset_empty = 45,
    BCH_FSCK_ERR_bset_bad_seq = 46,
    BCH_FSCK_ERR_bset_blacklisted_journal_seq = 47,
    BCH_FSCK_ERR_first_bset_blacklisted_journal_seq = 48,
    BCH_FSCK_ERR_btree_node_bad_btree = 49,
    BCH_FSCK_ERR_btree_node_bad_level = 50,
    BCH_FSCK_ERR_btree_node_bad_min_key = 51,
    BCH_FSCK_ERR_btree_node_bad_max_key = 52,
    BCH_FSCK_ERR_btree_node_bad_format = 53,
    BCH_FSCK_ERR_btree_node_bkey_past_bset_end = 54,
    BCH_FSCK_ERR_btree_node_bkey_bad_format = 55,
    BCH_FSCK_ERR_btree_node_bad_bkey = 56,
    BCH_FSCK_ERR_btree_node_bkey_out_of_order = 57,
    BCH_FSCK_ERR_btree_root_bkey_invalid = 58,
    BCH_FSCK_ERR_btree_root_read_error = 59,
    BCH_FSCK_ERR_btree_root_bad_min_key = 60,
    BCH_FSCK_ERR_btree_root_bad_max_key = 61,
    BCH_FSCK_ERR_btree_node_read_error = 62,
    BCH_FSCK_ERR_btree_node_topology_gap_between_nodes = 328,
    BCH_FSCK_ERR_btree_node_topology_bad_min_key = 63,
    BCH_FSCK_ERR_btree_node_topology_bad_max_key = 64,
    BCH_FSCK_ERR_btree_node_topology_bad_root_min_key = 323,
    BCH_FSCK_ERR_btree_node_topology_bad_root_max_key = 324,
    BCH_FSCK_ERR_btree_node_topology_overwritten_by_prev_node = 65,
    BCH_FSCK_ERR_btree_node_topology_overwritten_by_next_node = 66,
    BCH_FSCK_ERR_btree_node_topology_interior_node_empty = 67,
    BCH_FSCK_ERR_fs_usage_hidden_wrong = 68,
    BCH_FSCK_ERR_fs_usage_btree_wrong = 69,
    BCH_FSCK_ERR_fs_usage_data_wrong = 70,
    BCH_FSCK_ERR_fs_usage_cached_wrong = 71,
    BCH_FSCK_ERR_fs_usage_reserved_wrong = 72,
    BCH_FSCK_ERR_fs_usage_persistent_reserved_wrong = 73,
    BCH_FSCK_ERR_fs_usage_nr_inodes_wrong = 74,
    BCH_FSCK_ERR_fs_usage_replicas_wrong = 75,
    BCH_FSCK_ERR_dev_usage_buckets_wrong = 76,
    BCH_FSCK_ERR_dev_usage_sectors_wrong = 77,
    BCH_FSCK_ERR_dev_usage_fragmented_wrong = 78,
    BCH_FSCK_ERR_dev_usage_buckets_ec_wrong = 79,
    BCH_FSCK_ERR_bkey_version_in_future = 80,
    BCH_FSCK_ERR_bkey_u64s_too_small = 81,
    BCH_FSCK_ERR_bkey_invalid_type_for_btree = 82,
    BCH_FSCK_ERR_bkey_extent_size_zero = 83,
    BCH_FSCK_ERR_bkey_extent_size_greater_than_offset = 84,
    BCH_FSCK_ERR_bkey_size_nonzero = 85,
    BCH_FSCK_ERR_bkey_snapshot_nonzero = 86,
    BCH_FSCK_ERR_bkey_snapshot_zero = 87,
    BCH_FSCK_ERR_bkey_at_pos_max = 88,
    BCH_FSCK_ERR_bkey_before_start_of_btree_node = 89,
    BCH_FSCK_ERR_bkey_after_end_of_btree_node = 90,
    BCH_FSCK_ERR_bkey_val_size_nonzero = 91,
    BCH_FSCK_ERR_bkey_val_size_too_small = 92,
    BCH_FSCK_ERR_alloc_v1_val_size_bad = 93,
    BCH_FSCK_ERR_alloc_v2_unpack_error = 94,
    BCH_FSCK_ERR_alloc_v3_unpack_error = 95,
    BCH_FSCK_ERR_alloc_v4_val_size_bad = 96,
    BCH_FSCK_ERR_alloc_v4_backpointers_start_bad = 97,
    BCH_FSCK_ERR_alloc_key_data_type_bad = 98,
    BCH_FSCK_ERR_alloc_key_empty_but_have_data = 99,
    BCH_FSCK_ERR_alloc_key_dirty_sectors_0 = 100,
    BCH_FSCK_ERR_alloc_key_data_type_inconsistency = 101,
    BCH_FSCK_ERR_alloc_key_to_missing_dev_bucket = 102,
    BCH_FSCK_ERR_alloc_key_cached_inconsistency = 103,
    BCH_FSCK_ERR_alloc_key_cached_but_read_time_zero = 104,
    BCH_FSCK_ERR_alloc_key_to_missing_lru_entry = 105,
    BCH_FSCK_ERR_alloc_key_data_type_wrong = 106,
    BCH_FSCK_ERR_alloc_key_gen_wrong = 107,
    BCH_FSCK_ERR_alloc_key_dirty_sectors_wrong = 108,
    BCH_FSCK_ERR_alloc_key_cached_sectors_wrong = 109,
    BCH_FSCK_ERR_alloc_key_stripe_wrong = 110,
    BCH_FSCK_ERR_alloc_key_stripe_redundancy_wrong = 111,
    BCH_FSCK_ERR_alloc_key_journal_seq_in_future = 298,
    BCH_FSCK_ERR_alloc_key_stripe_refcount_wrong = 345,
    BCH_FSCK_ERR_bucket_sector_count_overflow = 112,
    BCH_FSCK_ERR_bucket_metadata_type_mismatch = 113,
    BCH_FSCK_ERR_need_discard_key_wrong = 114,
    BCH_FSCK_ERR_freespace_key_wrong = 115,
    BCH_FSCK_ERR_freespace_hole_missing = 116,
    BCH_FSCK_ERR_bucket_gens_val_size_bad = 117,
    BCH_FSCK_ERR_bucket_gens_key_wrong = 118,
    BCH_FSCK_ERR_bucket_gens_hole_wrong = 119,
    BCH_FSCK_ERR_bucket_gens_to_invalid_dev = 120,
    BCH_FSCK_ERR_bucket_gens_to_invalid_buckets = 121,
    BCH_FSCK_ERR_bucket_gens_nonzero_for_invalid_buckets = 122,
    BCH_FSCK_ERR_need_discard_freespace_key_to_invalid_dev_bucket = 123,
    BCH_FSCK_ERR_need_discard_freespace_key_bad = 124,
    BCH_FSCK_ERR_discarding_bucket_not_in_need_discard_btree = 291,
    BCH_FSCK_ERR_backpointer_bucket_offset_wrong = 125,
    BCH_FSCK_ERR_backpointer_level_bad = 294,
    BCH_FSCK_ERR_backpointer_dev_bad = 297,
    BCH_FSCK_ERR_backpointer_to_missing_device = 126,
    BCH_FSCK_ERR_backpointer_to_missing_alloc = 127,
    BCH_FSCK_ERR_backpointer_to_missing_ptr = 128,
    BCH_FSCK_ERR_lru_entry_at_time_0 = 129,
    BCH_FSCK_ERR_lru_entry_to_invalid_bucket = 130,
    BCH_FSCK_ERR_lru_entry_bad = 131,
    BCH_FSCK_ERR_btree_ptr_val_too_big = 132,
    BCH_FSCK_ERR_btree_ptr_v2_val_too_big = 133,
    BCH_FSCK_ERR_btree_ptr_has_non_ptr = 134,
    BCH_FSCK_ERR_extent_ptrs_invalid_entry = 135,
    BCH_FSCK_ERR_extent_ptrs_no_ptrs = 136,
    BCH_FSCK_ERR_extent_ptrs_too_many_ptrs = 137,
    BCH_FSCK_ERR_extent_ptrs_redundant_crc = 138,
    BCH_FSCK_ERR_extent_ptrs_redundant_stripe = 139,
    BCH_FSCK_ERR_extent_ptrs_unwritten = 140,
    BCH_FSCK_ERR_extent_ptrs_written_and_unwritten = 141,
    BCH_FSCK_ERR_extent_ptrs_all_invalid = 338,
    BCH_FSCK_ERR_extent_reconcile_bad_pending = 332,
    BCH_FSCK_ERR_extent_reconcile_bad_hipri = 333,
    BCH_FSCK_ERR_extent_reconcile_bad_replicas = 339,
    BCH_FSCK_ERR_ptr_to_invalid_device = 142,
    BCH_FSCK_ERR_ptr_to_removed_device = 322,
    BCH_FSCK_ERR_ptr_to_duplicate_device = 143,
    BCH_FSCK_ERR_ptr_after_last_bucket = 144,
    BCH_FSCK_ERR_ptr_before_first_bucket = 145,
    BCH_FSCK_ERR_ptr_spans_multiple_buckets = 146,
    BCH_FSCK_ERR_ptr_to_missing_backpointer = 147,
    BCH_FSCK_ERR_ptr_to_missing_alloc_key = 148,
    BCH_FSCK_ERR_ptr_to_missing_replicas_entry = 149,
    BCH_FSCK_ERR_ptr_to_missing_stripe = 150,
    BCH_FSCK_ERR_ptr_to_incorrect_stripe = 151,
    BCH_FSCK_ERR_ptr_gen_newer_than_bucket_gen = 152,
    BCH_FSCK_ERR_ptr_too_stale = 153,
    BCH_FSCK_ERR_stale_dirty_ptr = 154,
    BCH_FSCK_ERR_stale_ptr_with_no_stale_ptrs_feature = 327,
    BCH_FSCK_ERR_ptr_bucket_data_type_mismatch = 155,
    BCH_FSCK_ERR_ptr_cached_and_erasure_coded = 156,
    BCH_FSCK_ERR_ptr_crc_uncompressed_size_too_small = 157,
    BCH_FSCK_ERR_ptr_crc_uncompressed_size_too_big = 161,
    BCH_FSCK_ERR_ptr_crc_uncompressed_size_mismatch = 300,
    BCH_FSCK_ERR_ptr_crc_csum_type_unknown = 158,
    BCH_FSCK_ERR_ptr_crc_compression_type_unknown = 159,
    BCH_FSCK_ERR_ptr_crc_redundant = 160,
    BCH_FSCK_ERR_ptr_crc_nonce_mismatch = 162,
    BCH_FSCK_ERR_ptr_stripe_redundant = 163,
    BCH_FSCK_ERR_extent_flags_not_at_start = 306,
    BCH_FSCK_ERR_reservation_key_nr_replicas_invalid = 164,
    BCH_FSCK_ERR_reflink_v_refcount_wrong = 165,
    BCH_FSCK_ERR_reflink_v_pos_bad = 292,
    BCH_FSCK_ERR_reflink_p_to_missing_reflink_v = 166,
    BCH_FSCK_ERR_reflink_refcount_underflow = 293,
    BCH_FSCK_ERR_stripe_pos_bad = 167,
    BCH_FSCK_ERR_stripe_val_size_bad = 168,
    BCH_FSCK_ERR_stripe_csum_granularity_bad = 290,
    BCH_FSCK_ERR_stripe_sectors_zero = 340,
    BCH_FSCK_ERR_stripe_sector_count_wrong = 169,
    BCH_FSCK_ERR_stripe_to_missing_bucket_ref = 346,
    BCH_FSCK_ERR_bucket_stripe_ref_to_missing_stripe = 347,
    BCH_FSCK_ERR_bucket_stripe_ref_to_incorrect_stripe = 348,
    BCH_FSCK_ERR_snapshot_tree_pos_bad = 170,
    BCH_FSCK_ERR_snapshot_tree_to_missing_snapshot = 171,
    BCH_FSCK_ERR_snapshot_tree_to_missing_subvol = 172,
    BCH_FSCK_ERR_snapshot_tree_to_wrong_subvol = 173,
    BCH_FSCK_ERR_snapshot_tree_to_snapshot_subvol = 174,
    BCH_FSCK_ERR_snapshot_pos_bad = 175,
    BCH_FSCK_ERR_snapshot_parent_bad = 176,
    BCH_FSCK_ERR_snapshot_children_not_normalized = 177,
    BCH_FSCK_ERR_snapshot_child_duplicate = 178,
    BCH_FSCK_ERR_snapshot_child_bad = 179,
    BCH_FSCK_ERR_snapshot_skiplist_not_normalized = 180,
    BCH_FSCK_ERR_snapshot_skiplist_bad = 181,
    BCH_FSCK_ERR_snapshot_should_not_have_subvol = 182,
    BCH_FSCK_ERR_snapshot_to_bad_snapshot_tree = 183,
    BCH_FSCK_ERR_snapshot_bad_depth = 184,
    BCH_FSCK_ERR_snapshot_bad_skiplist = 185,
    BCH_FSCK_ERR_subvol_pos_bad = 186,
    BCH_FSCK_ERR_subvol_not_master_and_not_snapshot = 187,
    BCH_FSCK_ERR_subvol_to_missing_root = 188,
    BCH_FSCK_ERR_subvol_root_wrong_bi_subvol = 189,
    BCH_FSCK_ERR_bkey_in_missing_snapshot = 190,
    BCH_FSCK_ERR_bkey_in_deleted_snapshot = 315,
    BCH_FSCK_ERR_inode_pos_inode_nonzero = 191,
    BCH_FSCK_ERR_inode_pos_blockdev_range = 192,
    BCH_FSCK_ERR_inode_alloc_cursor_inode_bad = 301,
    BCH_FSCK_ERR_inode_unpack_error = 193,
    BCH_FSCK_ERR_inode_str_hash_invalid = 194,
    BCH_FSCK_ERR_inode_v3_fields_start_bad = 195,
    BCH_FSCK_ERR_inode_snapshot_mismatch = 196,
    BCH_FSCK_ERR_snapshot_key_missing_inode_snapshot = 314,
    BCH_FSCK_ERR_inode_unlinked_but_clean = 197,
    BCH_FSCK_ERR_inode_unlinked_but_nlink_nonzero = 198,
    BCH_FSCK_ERR_inode_unlinked_and_not_open = 281,
    BCH_FSCK_ERR_inode_unlinked_but_has_dirent = 285,
    BCH_FSCK_ERR_inode_checksum_type_invalid = 199,
    BCH_FSCK_ERR_inode_compression_type_invalid = 200,
    BCH_FSCK_ERR_inode_subvol_root_but_not_dir = 201,
    BCH_FSCK_ERR_inode_i_size_dirty_but_clean = 202,
    BCH_FSCK_ERR_inode_i_sectors_dirty_but_clean = 203,
    BCH_FSCK_ERR_inode_i_sectors_wrong = 204,
    BCH_FSCK_ERR_inode_dir_wrong_nlink = 205,
    BCH_FSCK_ERR_inode_dir_multiple_links = 206,
    BCH_FSCK_ERR_inode_dir_missing_backpointer = 284,
    BCH_FSCK_ERR_inode_dir_unlinked_but_not_empty = 286,
    BCH_FSCK_ERR_inode_dir_has_nonzero_i_size = 319,
    BCH_FSCK_ERR_inode_multiple_links_but_nlink_0 = 207,
    BCH_FSCK_ERR_inode_wrong_backpointer = 208,
    BCH_FSCK_ERR_inode_wrong_nlink = 209,
    BCH_FSCK_ERR_inode_has_child_snapshots_wrong = 287,
    BCH_FSCK_ERR_inode_unreachable = 210,
    BCH_FSCK_ERR_inode_journal_seq_in_future = 299,
    BCH_FSCK_ERR_inode_i_sectors_underflow = 312,
    BCH_FSCK_ERR_inode_has_case_insensitive_not_set = 316,
    BCH_FSCK_ERR_inode_parent_has_case_insensitive_not_set = 317,
    BCH_FSCK_ERR_vfs_inode_i_blocks_underflow = 311,
    BCH_FSCK_ERR_vfs_inode_i_blocks_not_zero_at_truncate = 313,
    BCH_FSCK_ERR_vfs_bad_inode_rm = 320,
    BCH_FSCK_ERR_deleted_inode_but_clean = 211,
    BCH_FSCK_ERR_deleted_inode_missing = 212,
    BCH_FSCK_ERR_deleted_inode_is_dir = 213,
    BCH_FSCK_ERR_deleted_inode_not_unlinked = 214,
    BCH_FSCK_ERR_deleted_inode_has_child_snapshots = 288,
    BCH_FSCK_ERR_extent_overlapping = 215,
    BCH_FSCK_ERR_key_in_missing_inode = 216,
    BCH_FSCK_ERR_key_in_wrong_inode_type = 217,
    BCH_FSCK_ERR_extent_past_end_of_inode = 218,
    BCH_FSCK_ERR_dirent_empty_name = 219,
    BCH_FSCK_ERR_dirent_val_too_big = 220,
    BCH_FSCK_ERR_dirent_name_too_long = 221,
    BCH_FSCK_ERR_dirent_name_embedded_nul = 222,
    BCH_FSCK_ERR_dirent_name_dot_or_dotdot = 223,
    BCH_FSCK_ERR_dirent_name_has_slash = 224,
    BCH_FSCK_ERR_dirent_d_type_wrong = 225,
    BCH_FSCK_ERR_inode_bi_parent_wrong = 226,
    BCH_FSCK_ERR_dirent_in_missing_dir_inode = 227,
    BCH_FSCK_ERR_dirent_in_non_dir_inode = 228,
    BCH_FSCK_ERR_dirent_to_missing_inode = 229,
    BCH_FSCK_ERR_dirent_to_overwritten_inode = 302,
    BCH_FSCK_ERR_dirent_to_missing_subvol = 230,
    BCH_FSCK_ERR_dirent_to_itself = 231,
    BCH_FSCK_ERR_dirent_casefold_mismatch = 318,
    BCH_FSCK_ERR_quota_type_invalid = 232,
    BCH_FSCK_ERR_xattr_val_size_too_small = 233,
    BCH_FSCK_ERR_xattr_val_size_too_big = 234,
    BCH_FSCK_ERR_xattr_invalid_type = 235,
    BCH_FSCK_ERR_xattr_name_invalid_chars = 236,
    BCH_FSCK_ERR_xattr_in_missing_inode = 237,
    BCH_FSCK_ERR_root_subvol_missing = 238,
    BCH_FSCK_ERR_root_dir_missing = 239,
    BCH_FSCK_ERR_root_inode_not_dir = 240,
    BCH_FSCK_ERR_dir_loop = 241,
    BCH_FSCK_ERR_hash_table_key_duplicate = 242,
    BCH_FSCK_ERR_hash_table_key_wrong_offset = 243,
    BCH_FSCK_ERR_unlinked_inode_not_on_deleted_list = 244,
    BCH_FSCK_ERR_reflink_p_front_pad_bad = 245,
    BCH_FSCK_ERR_journal_entry_dup_same_device = 246,
    BCH_FSCK_ERR_inode_bi_subvol_missing = 247,
    BCH_FSCK_ERR_inode_bi_subvol_wrong = 248,
    BCH_FSCK_ERR_inode_points_to_missing_dirent = 249,
    BCH_FSCK_ERR_inode_points_to_wrong_dirent = 250,
    BCH_FSCK_ERR_inode_bi_parent_nonzero = 251,
    BCH_FSCK_ERR_missing_inode_with_contents = 321,
    BCH_FSCK_ERR_dirent_to_missing_parent_subvol = 252,
    BCH_FSCK_ERR_dirent_not_visible_in_parent_subvol = 253,
    BCH_FSCK_ERR_subvol_fs_path_parent_wrong = 254,
    BCH_FSCK_ERR_subvol_root_fs_path_parent_nonzero = 255,
    BCH_FSCK_ERR_subvol_children_not_set = 256,
    BCH_FSCK_ERR_subvol_children_bad = 257,
    BCH_FSCK_ERR_subvol_loop = 258,
    BCH_FSCK_ERR_subvol_unreachable = 259,
    BCH_FSCK_ERR_btree_node_bkey_bad_u64s = 260,
    BCH_FSCK_ERR_btree_node_topology_empty_interior_node = 261,
    BCH_FSCK_ERR_btree_ptr_v2_min_key_bad = 262,
    BCH_FSCK_ERR_btree_root_unreadable_and_scan_found_nothing = 263,
    BCH_FSCK_ERR_snapshot_node_missing = 264,
    BCH_FSCK_ERR_dup_backpointer_to_bad_csum_extent = 265,
    BCH_FSCK_ERR_btree_bitmap_not_marked = 266,
    BCH_FSCK_ERR_sb_clean_entry_overrun = 267,
    BCH_FSCK_ERR_btree_ptr_v2_written_0 = 268,
    BCH_FSCK_ERR_subvol_snapshot_bad = 269,
    BCH_FSCK_ERR_subvol_inode_bad = 270,
    BCH_FSCK_ERR_subvol_missing = 308,
    BCH_FSCK_ERR_alloc_key_stripe_sectors_wrong = 271,
    BCH_FSCK_ERR_accounting_mismatch = 272,
    BCH_FSCK_ERR_accounting_replicas_not_marked = 273,
    BCH_FSCK_ERR_accounting_to_invalid_device = 289,
    BCH_FSCK_ERR_invalid_btree_id = 274,
    BCH_FSCK_ERR_alloc_key_io_time_bad = 275,
    BCH_FSCK_ERR_alloc_key_fragmentation_lru_wrong = 276,
    BCH_FSCK_ERR_accounting_key_junk_at_end = 277,
    BCH_FSCK_ERR_accounting_key_replicas_nr_devs_0 = 278,
    BCH_FSCK_ERR_accounting_key_replicas_nr_required_bad = 279,
    BCH_FSCK_ERR_accounting_key_replicas_devs_unsorted = 280,
    BCH_FSCK_ERR_accounting_key_version_0 = 282,
    BCH_FSCK_ERR_accounting_key_nr_counters_wrong = 307,
    BCH_FSCK_ERR_accounting_key_underflow = 325,
    BCH_FSCK_ERR_accounting_key_version_out_of_order = 326,
    BCH_FSCK_ERR_logged_op_but_clean = 283,
    BCH_FSCK_ERR_compression_opt_not_marked_in_sb = 295,
    BCH_FSCK_ERR_compression_type_not_marked_in_sb = 296,
    BCH_FSCK_ERR_compression_error = 342,
    BCH_FSCK_ERR_directory_size_mismatch = 303,
    BCH_FSCK_ERR_dirent_cf_name_too_big = 304,
    BCH_FSCK_ERR_dirent_stray_data_after_cf_name = 305,
    BCH_FSCK_ERR_reconcile_work_incorrectly_set = 309,
    BCH_FSCK_ERR_reconcile_work_phys_incorrectly_set = 341,
    BCH_FSCK_ERR_validate_error_in_commit = 329,
    BCH_FSCK_ERR_extent_io_opts_not_set = 330,
    BCH_FSCK_ERR_extent_io_opts_unneeded = 331,
    BCH_FSCK_ERR_reconcile_bp_to_missing_btree_ptr = 310,
    BCH_FSCK_ERR_reconcile_bp_to_leaf_node_key = 334,
    BCH_FSCK_ERR_btree_ptr_with_no_reconcile_bp = 335,
    BCH_FSCK_ERR_btree_ptr_with_bad_reconcile_bp = 336,
    BCH_FSCK_ERR_btree_ptr_to_bad_reconcile_bp = 337,
    BCH_FSCK_ERR_vfs_i_size_bad = 343,
    BCH_FSCK_ERR_vfs_i_sectors_bad = 344,
    BCH_FSCK_ERR_MAX = 349,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_sb_field_error_entry {
    pub v: __le64,
    pub last_error_time: __le64,
}
#[test]
fn bindgen_test_layout_bch_sb_field_error_entry() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_error_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_error_entry>(),
        16usize,
        concat!("Size of: ", stringify!(bch_sb_field_error_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_error_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_error_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_error_entry),
            "::",
            stringify!(v),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_error_time) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_error_entry),
            "::",
            stringify!(last_error_time),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_errors {
    pub field: bch_sb_field,
    pub entries: __IncompleteArrayField<bch_sb_field_error_entry>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_errors() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_errors> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_errors>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_errors)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_errors>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_errors)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_errors),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_errors),
            "::",
            stringify!(entries),
        ),
    );
}
pub const BCH_SB_ERROR_ENTRY_ID_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SB_ERROR_ENTRY_ID_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_SB_ERROR_ENTRY_ID_MAX: __u64 = 65535;
pub const BCH_SB_ERROR_ENTRY_NR_OFFSET: ::std::os::raw::c_uint = 16;
pub const BCH_SB_ERROR_ENTRY_NR_BITS: ::std::os::raw::c_uint = 48;
pub const BCH_SB_ERROR_ENTRY_NR_MAX: __u64 = 281474976710655;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_iops_measurement {
    BCH_IOPS_seqread = 0,
    BCH_IOPS_seqwrite = 1,
    BCH_IOPS_randread = 2,
    BCH_IOPS_randwrite = 3,
    BCH_IOPS_NR = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_member_error_type {
    BCH_MEMBER_ERROR_read = 0,
    BCH_MEMBER_ERROR_write = 1,
    BCH_MEMBER_ERROR_checksum = 2,
    BCH_MEMBER_ERROR_NR = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bch_member {
    pub uuid: __uuid_t,
    pub nbuckets: __le64,
    pub first_bucket: __le16,
    pub bucket_size: __le16,
    pub btree_bitmap_shift: __u8,
    pub pad: [__u8; 3usize],
    pub last_mount: __le64,
    pub flags: __le64,
    pub iops: [__le32; 4usize],
    pub errors: [__le64; 3usize],
    pub errors_at_reset: [__le64; 3usize],
    pub errors_reset_time: __le64,
    pub seq: __le64,
    pub btree_allocated_bitmap: __le64,
    pub last_journal_bucket: __le32,
    pub last_journal_bucket_offset: __le32,
    pub device_name: [__u8; 16usize],
    pub device_model: [__u8; 64usize],
}
#[test]
fn bindgen_test_layout_bch_member() {
    const UNINIT: ::std::mem::MaybeUninit<bch_member> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_member>(),
        224usize,
        concat!("Size of: ", stringify!(bch_member)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_member>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_member)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uuid) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_member), "::", stringify!(uuid)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nbuckets) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bch_member), "::", stringify!(nbuckets)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).first_bucket) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(first_bucket),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bucket_size) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(bucket_size),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).btree_bitmap_shift) as usize - ptr as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(btree_bitmap_shift),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        29usize,
        concat!("Offset of field: ", stringify!(bch_member), "::", stringify!(pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_mount) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(last_mount),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(bch_member), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iops) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(bch_member), "::", stringify!(iops)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).errors) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(bch_member), "::", stringify!(errors)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).errors_at_reset) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(errors_at_reset),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).errors_reset_time) as usize - ptr as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(errors_reset_time),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        120usize,
        concat!("Offset of field: ", stringify!(bch_member), "::", stringify!(seq)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).btree_allocated_bitmap) as usize - ptr as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(btree_allocated_bitmap),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).last_journal_bucket) as usize - ptr as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(last_journal_bucket),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).last_journal_bucket_offset) as usize
                - ptr as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(last_journal_bucket_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).device_name) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(device_name),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).device_model) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_member),
            "::",
            stringify!(device_model),
        ),
    );
}
impl Default for bch_member {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BCH_MEMBER_BUCKET_SIZE_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_MEMBER_BUCKET_SIZE_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_MEMBER_BUCKET_SIZE_MAX: __u16 = 65535;
pub const BCH_MEMBER_STATE_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_MEMBER_STATE_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_MEMBER_STATE_MAX: __u64 = 15;
pub const BCH_MEMBER_DISCARD_OFFSET: ::std::os::raw::c_uint = 14;
pub const BCH_MEMBER_DISCARD_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_MEMBER_DISCARD_MAX: __u64 = 1;
pub const BCH_MEMBER_DATA_ALLOWED_OFFSET: ::std::os::raw::c_uint = 15;
pub const BCH_MEMBER_DATA_ALLOWED_BITS: ::std::os::raw::c_uint = 5;
pub const BCH_MEMBER_DATA_ALLOWED_MAX: __u64 = 31;
pub const BCH_MEMBER_GROUP_OFFSET: ::std::os::raw::c_uint = 20;
pub const BCH_MEMBER_GROUP_BITS: ::std::os::raw::c_uint = 8;
pub const BCH_MEMBER_GROUP_MAX: __u64 = 255;
pub const BCH_MEMBER_DURABILITY_OFFSET: ::std::os::raw::c_uint = 28;
pub const BCH_MEMBER_DURABILITY_BITS: ::std::os::raw::c_uint = 2;
pub const BCH_MEMBER_DURABILITY_MAX: __u64 = 3;
pub const BCH_MEMBER_FREESPACE_INITIALIZED_OFFSET: ::std::os::raw::c_uint = 30;
pub const BCH_MEMBER_FREESPACE_INITIALIZED_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_MEMBER_FREESPACE_INITIALIZED_MAX: __u64 = 1;
pub const BCH_MEMBER_RESIZE_ON_MOUNT_OFFSET: ::std::os::raw::c_uint = 31;
pub const BCH_MEMBER_RESIZE_ON_MOUNT_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_MEMBER_RESIZE_ON_MOUNT_MAX: __u64 = 1;
pub const BCH_MEMBER_ROTATIONAL_OFFSET: ::std::os::raw::c_uint = 32;
pub const BCH_MEMBER_ROTATIONAL_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_MEMBER_ROTATIONAL_MAX: __u64 = 1;
pub const BCH_MEMBER_ROTATIONAL_SET_OFFSET: ::std::os::raw::c_uint = 33;
pub const BCH_MEMBER_ROTATIONAL_SET_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_MEMBER_ROTATIONAL_SET_MAX: __u64 = 1;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_member_state {
    BCH_MEMBER_STATE_rw = 0,
    BCH_MEMBER_STATE_ro = 1,
    BCH_MEMBER_STATE_evacuating = 2,
    BCH_MEMBER_STATE_spare = 3,
    BCH_MEMBER_STATE_NR = 4,
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_sb_field_members_v1 {
    pub field: bch_sb_field,
    pub _members: __IncompleteArrayField<bch_member>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_members_v1() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_members_v1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_members_v1>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_members_v1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_members_v1>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_members_v1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_members_v1),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._members) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_members_v1),
            "::",
            stringify!(_members),
        ),
    );
}
impl Default for bch_sb_field_members_v1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_sb_field_members_v2 {
    pub field: bch_sb_field,
    pub member_bytes: __le16,
    pub pad: [u8_; 6usize],
    pub _members: __IncompleteArrayField<bch_member>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_members_v2() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_members_v2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_members_v2>(),
        16usize,
        concat!("Size of: ", stringify!(bch_sb_field_members_v2)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_members_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_members_v2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_members_v2),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).member_bytes) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_members_v2),
            "::",
            stringify!(member_bytes),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_members_v2),
            "::",
            stringify!(pad),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._members) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_members_v2),
            "::",
            stringify!(_members),
        ),
    );
}
impl Default for bch_sb_field_members_v2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_subvolume {
    pub v: bch_val,
    pub flags: __le32,
    pub snapshot: __le32,
    pub inode: __le64,
    pub creation_parent: __le32,
    pub fs_path_parent: __le32,
    pub otime: bch_le128,
}
#[test]
fn bindgen_test_layout_bch_subvolume() {
    const UNINIT: ::std::mem::MaybeUninit<bch_subvolume> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_subvolume>(),
        40usize,
        concat!("Size of: ", stringify!(bch_subvolume)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_subvolume>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_subvolume)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_subvolume), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_subvolume), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).snapshot) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_subvolume),
            "::",
            stringify!(snapshot),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inode) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_subvolume), "::", stringify!(inode)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).creation_parent) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_subvolume),
            "::",
            stringify!(creation_parent),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fs_path_parent) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_subvolume),
            "::",
            stringify!(fs_path_parent),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).otime) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bch_subvolume), "::", stringify!(otime)),
    );
}
pub const BCH_SUBVOLUME_RO_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SUBVOLUME_RO_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SUBVOLUME_RO_MAX: __u32 = 1;
pub const BCH_SUBVOLUME_SNAP_OFFSET: ::std::os::raw::c_uint = 1;
pub const BCH_SUBVOLUME_SNAP_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SUBVOLUME_SNAP_MAX: __u32 = 1;
pub const BCH_SUBVOLUME_UNLINKED_OFFSET: ::std::os::raw::c_uint = 2;
pub const BCH_SUBVOLUME_UNLINKED_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SUBVOLUME_UNLINKED_MAX: __u32 = 1;
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_snapshot {
    pub v: bch_val,
    pub flags: __le32,
    pub parent: __le32,
    pub children: [__le32; 2usize],
    pub subvol: __le32,
    pub tree: __le32,
    pub depth: __le32,
    pub skip: [__le32; 3usize],
    pub btime: bch_le128,
}
#[test]
fn bindgen_test_layout_bch_snapshot() {
    const UNINIT: ::std::mem::MaybeUninit<bch_snapshot> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_snapshot>(),
        56usize,
        concat!("Size of: ", stringify!(bch_snapshot)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_snapshot>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_snapshot)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_snapshot), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_snapshot), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bch_snapshot), "::", stringify!(parent)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).children) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_snapshot),
            "::",
            stringify!(children),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subvol) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bch_snapshot), "::", stringify!(subvol)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tree) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(bch_snapshot), "::", stringify!(tree)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).depth) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bch_snapshot), "::", stringify!(depth)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).skip) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(bch_snapshot), "::", stringify!(skip)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btime) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(bch_snapshot), "::", stringify!(btime)),
    );
}
pub const BCH_SNAPSHOT_WILL_DELETE_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SNAPSHOT_WILL_DELETE_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SNAPSHOT_WILL_DELETE_MAX: __u32 = 1;
pub const BCH_SNAPSHOT_SUBVOL_OFFSET: ::std::os::raw::c_uint = 1;
pub const BCH_SNAPSHOT_SUBVOL_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SNAPSHOT_SUBVOL_MAX: __u32 = 1;
pub const BCH_SNAPSHOT_DELETED_OFFSET: ::std::os::raw::c_uint = 2;
pub const BCH_SNAPSHOT_DELETED_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SNAPSHOT_DELETED_MAX: __u32 = 1;
pub const BCH_SNAPSHOT_NO_KEYS_OFFSET: ::std::os::raw::c_uint = 3;
pub const BCH_SNAPSHOT_NO_KEYS_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SNAPSHOT_NO_KEYS_MAX: __u32 = 1;
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_snapshot_tree {
    pub v: bch_val,
    pub master_subvol: __le32,
    pub root_snapshot: __le32,
}
#[test]
fn bindgen_test_layout_bch_snapshot_tree() {
    const UNINIT: ::std::mem::MaybeUninit<bch_snapshot_tree> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_snapshot_tree>(),
        8usize,
        concat!("Size of: ", stringify!(bch_snapshot_tree)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_snapshot_tree>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_snapshot_tree)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_snapshot_tree), "::", stringify!(v)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).master_subvol) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_snapshot_tree),
            "::",
            stringify!(master_subvol),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).root_snapshot) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_snapshot_tree),
            "::",
            stringify!(root_snapshot),
        ),
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_sb_field_type {
    BCH_SB_FIELD_journal = 0,
    BCH_SB_FIELD_members_v1 = 1,
    BCH_SB_FIELD_crypt = 2,
    BCH_SB_FIELD_replicas_v0 = 3,
    BCH_SB_FIELD_quota = 4,
    BCH_SB_FIELD_disk_groups = 5,
    BCH_SB_FIELD_clean = 6,
    BCH_SB_FIELD_replicas = 7,
    BCH_SB_FIELD_journal_seq_blacklist = 8,
    BCH_SB_FIELD_journal_v2 = 9,
    BCH_SB_FIELD_counters = 10,
    BCH_SB_FIELD_members_v2 = 11,
    BCH_SB_FIELD_errors = 12,
    BCH_SB_FIELD_ext = 13,
    BCH_SB_FIELD_downgrade = 14,
    BCH_SB_FIELD_recovery_passes = 15,
    BCH_SB_FIELD_extent_type_u64s = 16,
    BCH_SB_FIELD_NR = 17,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_journal {
    pub field: bch_sb_field,
    pub buckets: __IncompleteArrayField<__le64>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_journal() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_journal> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_journal>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_journal)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_journal>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_journal)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_journal),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buckets) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_journal),
            "::",
            stringify!(buckets),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_journal_v2 {
    pub field: bch_sb_field,
    pub d: __IncompleteArrayField<bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry {
    pub start: __le64,
    pub nr: __le64,
}
#[test]
fn bindgen_test_layout_bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry() {
    const UNINIT: ::std::mem::MaybeUninit<
        bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry,
    > = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry),
        ),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry),
            "::",
            stringify!(start),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_journal_v2_bch_sb_field_journal_v2_entry),
            "::",
            stringify!(nr),
        ),
    );
}
#[test]
fn bindgen_test_layout_bch_sb_field_journal_v2() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_journal_v2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_journal_v2>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_field_journal_v2)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_journal_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_journal_v2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_journal_v2),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_journal_v2),
            "::",
            stringify!(d),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct nonce {
    pub d: [__le32; 4usize],
}
#[test]
fn bindgen_test_layout_nonce() {
    const UNINIT: ::std::mem::MaybeUninit<nonce> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nonce>(),
        16usize,
        concat!("Size of: ", stringify!(nonce)),
    );
    assert_eq!(
        ::std::mem::align_of::<nonce>(),
        4usize,
        concat!("Alignment of ", stringify!(nonce)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(nonce), "::", stringify!(d)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_key {
    pub key: [__le64; 4usize],
}
#[test]
fn bindgen_test_layout_bch_key() {
    const UNINIT: ::std::mem::MaybeUninit<bch_key> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_key>(),
        32usize,
        concat!("Size of: ", stringify!(bch_key)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_key>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_key)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_key), "::", stringify!(key)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_encrypted_key {
    pub magic: __le64,
    pub key: bch_key,
}
#[test]
fn bindgen_test_layout_bch_encrypted_key() {
    const UNINIT: ::std::mem::MaybeUninit<bch_encrypted_key> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_encrypted_key>(),
        40usize,
        concat!("Size of: ", stringify!(bch_encrypted_key)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_encrypted_key>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_encrypted_key)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).magic) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_encrypted_key),
            "::",
            stringify!(magic),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_encrypted_key),
            "::",
            stringify!(key),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_crypt {
    pub field: bch_sb_field,
    pub flags: __le64,
    pub kdf_flags: __le64,
    pub key: bch_encrypted_key,
}
#[test]
fn bindgen_test_layout_bch_sb_field_crypt() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_crypt> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_crypt>(),
        64usize,
        concat!("Size of: ", stringify!(bch_sb_field_crypt)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_crypt>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_crypt)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_crypt),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_crypt),
            "::",
            stringify!(flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kdf_flags) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_crypt),
            "::",
            stringify!(kdf_flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_crypt),
            "::",
            stringify!(key),
        ),
    );
}
pub const BCH_CRYPT_KDF_TYPE_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_CRYPT_KDF_TYPE_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_CRYPT_KDF_TYPE_MAX: __u64 = 15;
impl bch_kdf_types {
    pub const BCH_KDF_SCRYPT: bch_kdf_types = bch_kdf_types(0);
}
impl bch_kdf_types {
    pub const BCH_KDF_NR: bch_kdf_types = bch_kdf_types(1);
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct bch_kdf_types(pub ::std::os::raw::c_uint);
pub const BCH_KDF_SCRYPT_N_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_KDF_SCRYPT_N_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_KDF_SCRYPT_N_MAX: __u64 = 65535;
pub const BCH_KDF_SCRYPT_R_OFFSET: ::std::os::raw::c_uint = 16;
pub const BCH_KDF_SCRYPT_R_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_KDF_SCRYPT_R_MAX: __u64 = 65535;
pub const BCH_KDF_SCRYPT_P_OFFSET: ::std::os::raw::c_uint = 32;
pub const BCH_KDF_SCRYPT_P_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_KDF_SCRYPT_P_MAX: __u64 = 65535;
#[repr(C)]
#[derive(Debug, Default)]
pub struct jset_entry {
    pub u64s: __le16,
    pub btree_id: __u8,
    pub level: __u8,
    pub type_: __u8,
    pub pad: [__u8; 3usize],
    pub start: __IncompleteArrayField<bkey_i>,
    pub _data: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_jset_entry() {
    const UNINIT: ::std::mem::MaybeUninit<jset_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<jset_entry>(),
        8usize,
        concat!("Size of: ", stringify!(jset_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<jset_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(jset_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(jset_entry), "::", stringify!(u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btree_id) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(jset_entry), "::", stringify!(btree_id)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        3usize,
        concat!("Offset of field: ", stringify!(jset_entry), "::", stringify!(level)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(jset_entry), "::", stringify!(type_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        5usize,
        concat!("Offset of field: ", stringify!(jset_entry), "::", stringify!(pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(jset_entry), "::", stringify!(start)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(jset_entry), "::", stringify!(_data)),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_clean {
    pub field: bch_sb_field,
    pub flags: __le32,
    pub _read_clock: __le16,
    pub _write_clock: __le16,
    pub journal_seq: __le64,
    pub start: __IncompleteArrayField<jset_entry>,
    pub _data: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_bch_sb_field_clean() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_clean> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_clean>(),
        24usize,
        concat!("Size of: ", stringify!(bch_sb_field_clean)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_clean>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_clean)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_clean),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_clean),
            "::",
            stringify!(flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._read_clock) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_clean),
            "::",
            stringify!(_read_clock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._write_clock) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_clean),
            "::",
            stringify!(_write_clock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_seq) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_clean),
            "::",
            stringify!(journal_seq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_clean),
            "::",
            stringify!(start),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_clean),
            "::",
            stringify!(_data),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct bch_sb_field_ext {
    pub field: bch_sb_field,
    pub recovery_passes_required: [__le64; 2usize],
    pub errors_silent: [__le64; 8usize],
    pub btrees_lost_data: __le64,
}
#[test]
fn bindgen_test_layout_bch_sb_field_ext() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_field_ext> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_field_ext>(),
        96usize,
        concat!("Size of: ", stringify!(bch_sb_field_ext)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_field_ext>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_field_ext)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_ext),
            "::",
            stringify!(field),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).recovery_passes_required) as usize - ptr as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_ext),
            "::",
            stringify!(recovery_passes_required),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).errors_silent) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_ext),
            "::",
            stringify!(errors_silent),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btrees_lost_data) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_field_ext),
            "::",
            stringify!(btrees_lost_data),
        ),
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bcachefs_metadata_version {
    bcachefs_metadata_version_min = 9,
    bcachefs_metadata_version_bkey_renumber = 10,
    bcachefs_metadata_version_inode_btree_change = 11,
    bcachefs_metadata_version_snapshot = 12,
    bcachefs_metadata_version_inode_backpointers = 13,
    bcachefs_metadata_version_btree_ptr_sectors_written = 14,
    bcachefs_metadata_version_snapshot_2 = 15,
    bcachefs_metadata_version_reflink_p_fix = 16,
    bcachefs_metadata_version_subvol_dirent = 17,
    bcachefs_metadata_version_inode_v2 = 18,
    bcachefs_metadata_version_freespace = 19,
    bcachefs_metadata_version_alloc_v4 = 20,
    bcachefs_metadata_version_new_data_types = 21,
    bcachefs_metadata_version_backpointers = 22,
    bcachefs_metadata_version_inode_v3 = 23,
    bcachefs_metadata_version_unwritten_extents = 24,
    bcachefs_metadata_version_bucket_gens = 25,
    bcachefs_metadata_version_lru_v2 = 26,
    bcachefs_metadata_version_fragmentation_lru = 27,
    bcachefs_metadata_version_no_bps_in_alloc_keys = 28,
    bcachefs_metadata_version_snapshot_trees = 29,
    bcachefs_metadata_version_major_minor = 1024,
    bcachefs_metadata_version_snapshot_skiplists = 1025,
    bcachefs_metadata_version_deleted_inodes = 1026,
    bcachefs_metadata_version_rebalance_work = 1027,
    bcachefs_metadata_version_member_seq = 1028,
    bcachefs_metadata_version_subvolume_fs_parent = 1029,
    bcachefs_metadata_version_btree_subvolume_children = 1030,
    bcachefs_metadata_version_mi_btree_bitmap = 1031,
    bcachefs_metadata_version_bucket_stripe_sectors = 1032,
    bcachefs_metadata_version_disk_accounting_v2 = 1033,
    bcachefs_metadata_version_disk_accounting_v3 = 1034,
    bcachefs_metadata_version_disk_accounting_inum = 1035,
    bcachefs_metadata_version_rebalance_work_acct_fix = 1036,
    bcachefs_metadata_version_inode_has_child_snapshots = 1037,
    bcachefs_metadata_version_backpointer_bucket_gen = 1038,
    bcachefs_metadata_version_disk_accounting_big_endian = 1039,
    bcachefs_metadata_version_reflink_p_may_update_opts = 1040,
    bcachefs_metadata_version_inode_depth = 1041,
    bcachefs_metadata_version_persistent_inode_cursors = 1042,
    bcachefs_metadata_version_autofix_errors = 1043,
    bcachefs_metadata_version_directory_size = 1044,
    bcachefs_metadata_version_cached_backpointers = 1045,
    bcachefs_metadata_version_stripe_backpointers = 1046,
    bcachefs_metadata_version_stripe_lru = 1047,
    bcachefs_metadata_version_casefolding = 1048,
    bcachefs_metadata_version_extent_flags = 1049,
    bcachefs_metadata_version_snapshot_deletion_v2 = 1050,
    bcachefs_metadata_version_fast_device_removal = 1051,
    bcachefs_metadata_version_inode_has_case_insensitive = 1052,
    bcachefs_metadata_version_extent_snapshot_whiteouts = 1053,
    bcachefs_metadata_version_31bit_dirent_offset = 1054,
    bcachefs_metadata_version_btree_node_accounting = 1055,
    bcachefs_metadata_version_sb_field_extent_type_u64s = 1056,
    bcachefs_metadata_version_reconcile = 1057,
    bcachefs_metadata_version_extented_key_type_error = 1058,
    bcachefs_metadata_version_bucket_stripe_index = 1059,
    bcachefs_metadata_version_max = 1060,
}
#[repr(C, packed(8))]
#[derive(Debug, Copy, Clone)]
pub struct bch_sb_layout {
    pub magic: __uuid_t,
    pub layout_type: __u8,
    pub sb_max_size_bits: __u8,
    pub nr_superblocks: __u8,
    pub pad: [__u8; 5usize],
    pub sb_offset: [__le64; 61usize],
}
#[test]
fn bindgen_test_layout_bch_sb_layout() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_layout> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_layout>(),
        512usize,
        concat!("Size of: ", stringify!(bch_sb_layout)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_layout>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_layout)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).magic) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_sb_layout), "::", stringify!(magic)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).layout_type) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_layout),
            "::",
            stringify!(layout_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sb_max_size_bits) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_layout),
            "::",
            stringify!(sb_max_size_bits),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_superblocks) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_layout),
            "::",
            stringify!(nr_superblocks),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        19usize,
        concat!("Offset of field: ", stringify!(bch_sb_layout), "::", stringify!(pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sb_offset) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_layout),
            "::",
            stringify!(sb_offset),
        ),
    );
}
impl Default for bch_sb_layout {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, align(8))]
pub struct bch_sb {
    pub csum: bch_csum,
    pub version: __le16,
    pub version_min: __le16,
    pub pad: [__le16; 2usize],
    pub magic: __uuid_t,
    pub uuid: __uuid_t,
    pub user_uuid: __uuid_t,
    pub label: [__u8; 32usize],
    pub offset: __le64,
    pub seq: __le64,
    pub block_size: __le16,
    pub dev_idx: __u8,
    pub nr_devices: __u8,
    pub u64s: __le32,
    pub time_base_lo: __le64,
    pub time_base_hi: __le32,
    pub time_precision: __le32,
    pub flags: [__le64; 7usize],
    pub write_time: __le64,
    pub features: [__le64; 2usize],
    pub compat: [__le64; 2usize],
    pub layout: bch_sb_layout,
    pub start: __IncompleteArrayField<bch_sb_field>,
    pub _data: __IncompleteArrayField<__le64>,
}
#[test]
fn bindgen_test_layout_bch_sb() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb>(),
        752usize,
        concat!("Size of: ", stringify!(bch_sb)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(csum)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(version)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version_min) as usize - ptr as usize },
        18usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(version_min)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).magic) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(magic)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uuid) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(uuid)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).user_uuid) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(user_uuid)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).label) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(label)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        104usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(offset)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        112usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block_size) as usize - ptr as usize },
        120usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(block_size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dev_idx) as usize - ptr as usize },
        122usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(dev_idx)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_devices) as usize - ptr as usize },
        123usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(nr_devices)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        124usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time_base_lo) as usize - ptr as usize },
        128usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(time_base_lo)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time_base_hi) as usize - ptr as usize },
        136usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(time_base_hi)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time_precision) as usize - ptr as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb),
            "::",
            stringify!(time_precision),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        144usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_time) as usize - ptr as usize },
        200usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(write_time)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).features) as usize - ptr as usize },
        208usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(features)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compat) as usize - ptr as usize },
        224usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(compat)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).layout) as usize - ptr as usize },
        240usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(layout)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        752usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(start)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        752usize,
        concat!("Offset of field: ", stringify!(bch_sb), "::", stringify!(_data)),
    );
}
impl Default for bch_sb {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BCH_SB_BLOCK_SIZE_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SB_BLOCK_SIZE_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_SB_BLOCK_SIZE_MAX: __u16 = 65535;
pub const BCH_SB_INITIALIZED_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SB_INITIALIZED_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_INITIALIZED_MAX: __u64 = 1;
pub const BCH_SB_CLEAN_OFFSET: ::std::os::raw::c_uint = 1;
pub const BCH_SB_CLEAN_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_CLEAN_MAX: __u64 = 1;
pub const BCH_SB_CSUM_TYPE_OFFSET: ::std::os::raw::c_uint = 2;
pub const BCH_SB_CSUM_TYPE_BITS: ::std::os::raw::c_uint = 6;
pub const BCH_SB_CSUM_TYPE_MAX: __u64 = 63;
pub const BCH_SB_ERROR_ACTION_OFFSET: ::std::os::raw::c_uint = 8;
pub const BCH_SB_ERROR_ACTION_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_ERROR_ACTION_MAX: __u64 = 15;
pub const BCH_SB_BTREE_NODE_SIZE_OFFSET: ::std::os::raw::c_uint = 12;
pub const BCH_SB_BTREE_NODE_SIZE_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_SB_BTREE_NODE_SIZE_MAX: __u64 = 65535;
pub const BCH_SB_GC_RESERVE_OFFSET: ::std::os::raw::c_uint = 28;
pub const BCH_SB_GC_RESERVE_BITS: ::std::os::raw::c_uint = 5;
pub const BCH_SB_GC_RESERVE_MAX: __u64 = 31;
pub const BCH_SB_ROOT_RESERVE_OFFSET: ::std::os::raw::c_uint = 33;
pub const BCH_SB_ROOT_RESERVE_BITS: ::std::os::raw::c_uint = 7;
pub const BCH_SB_ROOT_RESERVE_MAX: __u64 = 127;
pub const BCH_SB_META_CSUM_TYPE_OFFSET: ::std::os::raw::c_uint = 40;
pub const BCH_SB_META_CSUM_TYPE_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_META_CSUM_TYPE_MAX: __u64 = 15;
pub const BCH_SB_DATA_CSUM_TYPE_OFFSET: ::std::os::raw::c_uint = 44;
pub const BCH_SB_DATA_CSUM_TYPE_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_DATA_CSUM_TYPE_MAX: __u64 = 15;
pub const BCH_SB_META_REPLICAS_WANT_OFFSET: ::std::os::raw::c_uint = 48;
pub const BCH_SB_META_REPLICAS_WANT_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_META_REPLICAS_WANT_MAX: __u64 = 15;
pub const BCH_SB_DATA_REPLICAS_WANT_OFFSET: ::std::os::raw::c_uint = 52;
pub const BCH_SB_DATA_REPLICAS_WANT_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_DATA_REPLICAS_WANT_MAX: __u64 = 15;
pub const BCH_SB_POSIX_ACL_OFFSET: ::std::os::raw::c_uint = 56;
pub const BCH_SB_POSIX_ACL_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_POSIX_ACL_MAX: __u64 = 1;
pub const BCH_SB_USRQUOTA_OFFSET: ::std::os::raw::c_uint = 57;
pub const BCH_SB_USRQUOTA_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_USRQUOTA_MAX: __u64 = 1;
pub const BCH_SB_GRPQUOTA_OFFSET: ::std::os::raw::c_uint = 58;
pub const BCH_SB_GRPQUOTA_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_GRPQUOTA_MAX: __u64 = 1;
pub const BCH_SB_PRJQUOTA_OFFSET: ::std::os::raw::c_uint = 59;
pub const BCH_SB_PRJQUOTA_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_PRJQUOTA_MAX: __u64 = 1;
pub const BCH_SB_HAS_ERRORS_OFFSET: ::std::os::raw::c_uint = 60;
pub const BCH_SB_HAS_ERRORS_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_HAS_ERRORS_MAX: __u64 = 1;
pub const BCH_SB_HAS_TOPOLOGY_ERRORS_OFFSET: ::std::os::raw::c_uint = 61;
pub const BCH_SB_HAS_TOPOLOGY_ERRORS_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_HAS_TOPOLOGY_ERRORS_MAX: __u64 = 1;
pub const BCH_SB_BIG_ENDIAN_OFFSET: ::std::os::raw::c_uint = 62;
pub const BCH_SB_BIG_ENDIAN_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_BIG_ENDIAN_MAX: __u64 = 1;
pub const BCH_SB_PROMOTE_WHOLE_EXTENTS_OFFSET: ::std::os::raw::c_uint = 63;
pub const BCH_SB_PROMOTE_WHOLE_EXTENTS_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_PROMOTE_WHOLE_EXTENTS_MAX: __u64 = 1;
pub const BCH_SB_STR_HASH_TYPE_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SB_STR_HASH_TYPE_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_STR_HASH_TYPE_MAX: __u64 = 15;
pub const BCH_SB_COMPRESSION_TYPE_LO_OFFSET: ::std::os::raw::c_uint = 4;
pub const BCH_SB_COMPRESSION_TYPE_LO_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_COMPRESSION_TYPE_LO_MAX: __u64 = 15;
pub const BCH_SB_INODE_32BIT_OFFSET: ::std::os::raw::c_uint = 8;
pub const BCH_SB_INODE_32BIT_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_INODE_32BIT_MAX: __u64 = 1;
pub const BCH_SB_128_BIT_MACS_OFFSET: ::std::os::raw::c_uint = 9;
pub const BCH_SB_128_BIT_MACS_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_128_BIT_MACS_MAX: __u64 = 1;
pub const BCH_SB_ENCRYPTION_TYPE_OFFSET: ::std::os::raw::c_uint = 10;
pub const BCH_SB_ENCRYPTION_TYPE_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_ENCRYPTION_TYPE_MAX: __u64 = 15;
pub const BCH_SB_ENCODED_EXTENT_MAX_BITS_OFFSET: ::std::os::raw::c_uint = 14;
pub const BCH_SB_ENCODED_EXTENT_MAX_BITS_BITS: ::std::os::raw::c_uint = 6;
pub const BCH_SB_ENCODED_EXTENT_MAX_BITS_MAX: __u64 = 63;
pub const BCH_SB_META_REPLICAS_REQ_OFFSET: ::std::os::raw::c_uint = 20;
pub const BCH_SB_META_REPLICAS_REQ_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_META_REPLICAS_REQ_MAX: __u64 = 15;
pub const BCH_SB_DATA_REPLICAS_REQ_OFFSET: ::std::os::raw::c_uint = 24;
pub const BCH_SB_DATA_REPLICAS_REQ_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_DATA_REPLICAS_REQ_MAX: __u64 = 15;
pub const BCH_SB_PROMOTE_TARGET_OFFSET: ::std::os::raw::c_uint = 28;
pub const BCH_SB_PROMOTE_TARGET_BITS: ::std::os::raw::c_uint = 12;
pub const BCH_SB_PROMOTE_TARGET_MAX: __u64 = 4095;
pub const BCH_SB_FOREGROUND_TARGET_OFFSET: ::std::os::raw::c_uint = 40;
pub const BCH_SB_FOREGROUND_TARGET_BITS: ::std::os::raw::c_uint = 12;
pub const BCH_SB_FOREGROUND_TARGET_MAX: __u64 = 4095;
pub const BCH_SB_BACKGROUND_TARGET_OFFSET: ::std::os::raw::c_uint = 52;
pub const BCH_SB_BACKGROUND_TARGET_BITS: ::std::os::raw::c_uint = 12;
pub const BCH_SB_BACKGROUND_TARGET_MAX: __u64 = 4095;
pub const BCH_SB_BACKGROUND_COMPRESSION_TYPE_LO_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SB_BACKGROUND_COMPRESSION_TYPE_LO_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_BACKGROUND_COMPRESSION_TYPE_LO_MAX: __u64 = 15;
pub const BCH_SB_GC_RESERVE_BYTES_OFFSET: ::std::os::raw::c_uint = 4;
pub const BCH_SB_GC_RESERVE_BYTES_BITS: ::std::os::raw::c_uint = 60;
pub const BCH_SB_GC_RESERVE_BYTES_MAX: __u64 = 1152921504606846975;
pub const BCH_SB_ERASURE_CODE_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SB_ERASURE_CODE_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_SB_ERASURE_CODE_MAX: __u64 = 65535;
pub const BCH_SB_METADATA_TARGET_OFFSET: ::std::os::raw::c_uint = 16;
pub const BCH_SB_METADATA_TARGET_BITS: ::std::os::raw::c_uint = 12;
pub const BCH_SB_METADATA_TARGET_MAX: __u64 = 4095;
pub const BCH_SB_SHARD_INUMS_OFFSET: ::std::os::raw::c_uint = 28;
pub const BCH_SB_SHARD_INUMS_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_SHARD_INUMS_MAX: __u64 = 1;
pub const BCH_SB_JOURNAL_FLUSH_DELAY_OFFSET: ::std::os::raw::c_uint = 30;
pub const BCH_SB_JOURNAL_FLUSH_DELAY_BITS: ::std::os::raw::c_uint = 32;
pub const BCH_SB_JOURNAL_FLUSH_DELAY_MAX: __u64 = 4294967295;
pub const BCH_SB_JOURNAL_FLUSH_DISABLED_OFFSET: ::std::os::raw::c_uint = 62;
pub const BCH_SB_JOURNAL_FLUSH_DISABLED_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_JOURNAL_FLUSH_DISABLED_MAX: __u64 = 1;
pub const BCH_SB_MULTI_DEVICE_OFFSET: ::std::os::raw::c_uint = 63;
pub const BCH_SB_MULTI_DEVICE_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_MULTI_DEVICE_MAX: __u64 = 1;
pub const BCH_SB_JOURNAL_RECLAIM_DELAY_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SB_JOURNAL_RECLAIM_DELAY_BITS: ::std::os::raw::c_uint = 32;
pub const BCH_SB_JOURNAL_RECLAIM_DELAY_MAX: __u64 = 4294967295;
pub const BCH_SB_JOURNAL_TRANSACTION_NAMES_OFFSET: ::std::os::raw::c_uint = 32;
pub const BCH_SB_JOURNAL_TRANSACTION_NAMES_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_JOURNAL_TRANSACTION_NAMES_MAX: __u64 = 1;
pub const BCH_SB_NOCOW_OFFSET: ::std::os::raw::c_uint = 33;
pub const BCH_SB_NOCOW_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_NOCOW_MAX: __u64 = 1;
pub const BCH_SB_WRITE_BUFFER_SIZE_OFFSET: ::std::os::raw::c_uint = 34;
pub const BCH_SB_WRITE_BUFFER_SIZE_BITS: ::std::os::raw::c_uint = 20;
pub const BCH_SB_WRITE_BUFFER_SIZE_MAX: __u64 = 1048575;
pub const BCH_SB_VERSION_UPGRADE_OFFSET: ::std::os::raw::c_uint = 54;
pub const BCH_SB_VERSION_UPGRADE_BITS: ::std::os::raw::c_uint = 2;
pub const BCH_SB_VERSION_UPGRADE_MAX: __u64 = 3;
pub const BCH_SB_COMPRESSION_TYPE_HI_OFFSET: ::std::os::raw::c_uint = 56;
pub const BCH_SB_COMPRESSION_TYPE_HI_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_COMPRESSION_TYPE_HI_MAX: __u64 = 15;
pub const BCH_SB_BACKGROUND_COMPRESSION_TYPE_HI_OFFSET: ::std::os::raw::c_uint = 60;
pub const BCH_SB_BACKGROUND_COMPRESSION_TYPE_HI_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_BACKGROUND_COMPRESSION_TYPE_HI_MAX: __u64 = 15;
pub const BCH_SB_VERSION_UPGRADE_COMPLETE_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SB_VERSION_UPGRADE_COMPLETE_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_SB_VERSION_UPGRADE_COMPLETE_MAX: __u64 = 65535;
pub const BCH_SB_ALLOCATOR_STUCK_TIMEOUT_OFFSET: ::std::os::raw::c_uint = 16;
pub const BCH_SB_ALLOCATOR_STUCK_TIMEOUT_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_SB_ALLOCATOR_STUCK_TIMEOUT_MAX: __u64 = 65535;
pub const BCH_SB_VERSION_INCOMPAT_OFFSET: ::std::os::raw::c_uint = 32;
pub const BCH_SB_VERSION_INCOMPAT_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_SB_VERSION_INCOMPAT_MAX: __u64 = 65535;
pub const BCH_SB_VERSION_INCOMPAT_ALLOWED_OFFSET: ::std::os::raw::c_uint = 48;
pub const BCH_SB_VERSION_INCOMPAT_ALLOWED_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_SB_VERSION_INCOMPAT_ALLOWED_MAX: __u64 = 65535;
pub const BCH_SB_SHARD_INUMS_NBITS_OFFSET: ::std::os::raw::c_uint = 0;
pub const BCH_SB_SHARD_INUMS_NBITS_BITS: ::std::os::raw::c_uint = 4;
pub const BCH_SB_SHARD_INUMS_NBITS_MAX: __u64 = 15;
pub const BCH_SB_WRITE_ERROR_TIMEOUT_OFFSET: ::std::os::raw::c_uint = 4;
pub const BCH_SB_WRITE_ERROR_TIMEOUT_BITS: ::std::os::raw::c_uint = 10;
pub const BCH_SB_WRITE_ERROR_TIMEOUT_MAX: __u64 = 1023;
pub const BCH_SB_CSUM_ERR_RETRY_NR_OFFSET: ::std::os::raw::c_uint = 14;
pub const BCH_SB_CSUM_ERR_RETRY_NR_BITS: ::std::os::raw::c_uint = 6;
pub const BCH_SB_CSUM_ERR_RETRY_NR_MAX: __u64 = 63;
pub const BCH_SB_DEGRADED_ACTION_OFFSET: ::std::os::raw::c_uint = 20;
pub const BCH_SB_DEGRADED_ACTION_BITS: ::std::os::raw::c_uint = 2;
pub const BCH_SB_DEGRADED_ACTION_MAX: __u64 = 3;
pub const BCH_SB_CASEFOLD_OFFSET: ::std::os::raw::c_uint = 22;
pub const BCH_SB_CASEFOLD_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_CASEFOLD_MAX: __u64 = 1;
pub const BCH_SB_REBALANCE_AC_ONLY_OFFSET: ::std::os::raw::c_uint = 23;
pub const BCH_SB_REBALANCE_AC_ONLY_BITS: ::std::os::raw::c_uint = 1;
pub const BCH_SB_REBALANCE_AC_ONLY_MAX: __u64 = 1;
pub const BCH_SB_WRITEBACK_TIMEOUT_OFFSET: ::std::os::raw::c_uint = 24;
pub const BCH_SB_WRITEBACK_TIMEOUT_BITS: ::std::os::raw::c_uint = 16;
pub const BCH_SB_WRITEBACK_TIMEOUT_MAX: __u64 = 65535;
pub const BCH_SB_EXTENT_BP_SHIFT_OFFSET: ::std::os::raw::c_uint = 40;
pub const BCH_SB_EXTENT_BP_SHIFT_BITS: ::std::os::raw::c_uint = 8;
pub const BCH_SB_EXTENT_BP_SHIFT_MAX: __u64 = 255;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_sb_feature {
    BCH_FEATURE_lz4 = 0,
    BCH_FEATURE_gzip = 1,
    BCH_FEATURE_zstd = 2,
    BCH_FEATURE_atomic_nlink = 3,
    BCH_FEATURE_ec = 4,
    BCH_FEATURE_journal_seq_blacklist_v3 = 5,
    BCH_FEATURE_reflink = 6,
    BCH_FEATURE_new_siphash = 7,
    BCH_FEATURE_inline_data = 8,
    BCH_FEATURE_new_extent_overwrite = 9,
    BCH_FEATURE_incompressible = 10,
    BCH_FEATURE_btree_ptr_v2 = 11,
    BCH_FEATURE_extents_above_btree_updates = 12,
    BCH_FEATURE_btree_updates_journalled = 13,
    BCH_FEATURE_reflink_inline_data = 14,
    BCH_FEATURE_new_varint = 15,
    BCH_FEATURE_journal_no_flush = 16,
    BCH_FEATURE_alloc_v2 = 17,
    BCH_FEATURE_extents_across_btree_nodes = 18,
    BCH_FEATURE_incompat_version_field = 19,
    BCH_FEATURE_casefolding = 20,
    BCH_FEATURE_no_alloc_info = 21,
    BCH_FEATURE_small_image = 22,
    BCH_FEATURE_NR = 23,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_sb_compat {
    BCH_COMPAT_alloc_info = 0,
    BCH_COMPAT_alloc_metadata = 1,
    BCH_COMPAT_extents_above_btree_updates_done = 2,
    BCH_COMPAT_bformat_overflow_done = 3,
    BCH_COMPAT_no_stale_ptrs = 4,
    BCH_COMPAT_NR = 5,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_version_upgrade_opts {
    BCH_VERSION_UPGRADE_compatible = 0,
    BCH_VERSION_UPGRADE_incompatible = 1,
    BCH_VERSION_UPGRADE_none = 2,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_error_actions {
    BCH_ON_ERROR_continue = 0,
    BCH_ON_ERROR_fix_safe = 1,
    BCH_ON_ERROR_panic = 2,
    BCH_ON_ERROR_ro = 3,
    BCH_ON_ERROR_NR = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_degraded_actions {
    BCH_DEGRADED_ask = 0,
    BCH_DEGRADED_yes = 1,
    BCH_DEGRADED_very = 2,
    BCH_DEGRADED_no = 3,
    BCH_DEGRADED_ACTIONS_NR = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_str_hash_type {
    BCH_STR_HASH_crc32c = 0,
    BCH_STR_HASH_crc64 = 1,
    BCH_STR_HASH_siphash_old = 2,
    BCH_STR_HASH_siphash = 3,
    BCH_STR_HASH_NR = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_str_hash_opts {
    BCH_STR_HASH_OPT_crc32c = 0,
    BCH_STR_HASH_OPT_crc64 = 1,
    BCH_STR_HASH_OPT_siphash = 2,
    BCH_STR_HASH_OPT_NR = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_csum_type {
    BCH_CSUM_none = 0,
    BCH_CSUM_crc32c_nonzero = 1,
    BCH_CSUM_crc64_nonzero = 2,
    BCH_CSUM_chacha20_poly1305_80 = 3,
    BCH_CSUM_chacha20_poly1305_128 = 4,
    BCH_CSUM_crc32c = 5,
    BCH_CSUM_crc64 = 6,
    BCH_CSUM_xxhash = 7,
    BCH_CSUM_NR = 8,
}
extern "C" {
    pub static bch_crc_bytes: [::std::os::raw::c_uint; 8usize];
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_csum_opt {
    BCH_CSUM_OPT_none = 0,
    BCH_CSUM_OPT_crc32c = 1,
    BCH_CSUM_OPT_crc64 = 2,
    BCH_CSUM_OPT_xxhash = 3,
    BCH_CSUM_OPT_NR = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_compression_type {
    BCH_COMPRESSION_TYPE_none = 0,
    BCH_COMPRESSION_TYPE_lz4_old = 1,
    BCH_COMPRESSION_TYPE_gzip = 2,
    BCH_COMPRESSION_TYPE_lz4 = 3,
    BCH_COMPRESSION_TYPE_zstd = 4,
    BCH_COMPRESSION_TYPE_incompressible = 5,
    BCH_COMPRESSION_TYPE_NR = 6,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_compression_opts {
    BCH_COMPRESSION_OPT_none = 0,
    BCH_COMPRESSION_OPT_lz4 = 1,
    BCH_COMPRESSION_OPT_gzip = 2,
    BCH_COMPRESSION_OPT_zstd = 3,
    BCH_COMPRESSION_OPT_NR = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_jset_entry_type {
    BCH_JSET_ENTRY_btree_keys = 0,
    BCH_JSET_ENTRY_btree_root = 1,
    BCH_JSET_ENTRY_prio_ptrs = 2,
    BCH_JSET_ENTRY_blacklist = 3,
    BCH_JSET_ENTRY_blacklist_v2 = 4,
    BCH_JSET_ENTRY_usage = 5,
    BCH_JSET_ENTRY_data_usage = 6,
    BCH_JSET_ENTRY_clock = 7,
    BCH_JSET_ENTRY_dev_usage = 8,
    BCH_JSET_ENTRY_log = 9,
    BCH_JSET_ENTRY_overwrite = 10,
    BCH_JSET_ENTRY_write_buffer_keys = 11,
    BCH_JSET_ENTRY_datetime = 12,
    BCH_JSET_ENTRY_log_bkey = 13,
    BCH_JSET_ENTRY_NR = 14,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_fs_usage_type {
    BCH_FS_USAGE_reserved = 0,
    BCH_FS_USAGE_inodes = 1,
    BCH_FS_USAGE_key_version = 2,
    BCH_FS_USAGE_NR = 3,
}
#[repr(C, align(8))]
pub struct jset {
    pub csum: bch_csum,
    pub magic: __le64,
    pub seq: __le64,
    pub version: __le32,
    pub flags: __le32,
    pub u64s: __le32,
    pub encrypted_start: __IncompleteArrayField<__u8>,
    pub _read_clock: __le16,
    pub _write_clock: __le16,
    pub last_seq: __le64,
    pub start: __IncompleteArrayField<jset_entry>,
    pub _data: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_jset() {
    const UNINIT: ::std::mem::MaybeUninit<jset> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<jset>(),
        56usize,
        concat!("Size of: ", stringify!(jset)),
    );
    assert_eq!(
        ::std::mem::align_of::<jset>(),
        8usize,
        concat!("Alignment of ", stringify!(jset)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(csum)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).magic) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(magic)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(version)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        36usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).encrypted_start) as usize - ptr as usize },
        44usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(encrypted_start)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._read_clock) as usize - ptr as usize },
        44usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(_read_clock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._write_clock) as usize - ptr as usize },
        46usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(_write_clock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_seq) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(last_seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(start)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(jset), "::", stringify!(_data)),
    );
}
impl Default for jset {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, packed(8))]
pub struct bset {
    pub seq: __le64,
    pub journal_seq: __le64,
    pub flags: __le32,
    pub version: __le16,
    pub u64s: __le16,
    pub start: __IncompleteArrayField<bkey_packed>,
    pub _data: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_bset() {
    const UNINIT: ::std::mem::MaybeUninit<bset> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bset>(),
        24usize,
        concat!("Size of: ", stringify!(bset)),
    );
    assert_eq!(
        ::std::mem::align_of::<bset>(),
        8usize,
        concat!("Alignment of ", stringify!(bset)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bset), "::", stringify!(seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_seq) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bset), "::", stringify!(journal_seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bset), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(bset), "::", stringify!(version)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        22usize,
        concat!("Offset of field: ", stringify!(bset), "::", stringify!(u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bset), "::", stringify!(start)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bset), "::", stringify!(_data)),
    );
}
impl Default for bset {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, align(8))]
pub struct btree_node {
    pub csum: bch_csum,
    pub magic: __le64,
    pub flags: __le64,
    pub min_key: bpos,
    pub max_key: bpos,
    pub _ptr: bch_extent_ptr,
    pub format: bkey_format,
    pub __bindgen_anon_1: btree_node__bindgen_ty_1,
}
#[repr(C)]
pub struct btree_node__bindgen_ty_1 {
    pub keys: __BindgenUnionField<bset>,
    pub __bindgen_anon_1: __BindgenUnionField<btree_node__bindgen_ty_1__bindgen_ty_1>,
    pub bindgen_union_field: [u64; 3usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct btree_node__bindgen_ty_1__bindgen_ty_1 {
    pub pad: [__u8; 22usize],
    pub u64s: __le16,
    pub _data: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_btree_node__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<btree_node__bindgen_ty_1__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_node__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(btree_node__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_node__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_node__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(pad),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(u64s),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_data),
        ),
    );
}
#[test]
fn bindgen_test_layout_btree_node__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<btree_node__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_node__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(btree_node__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_node__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_node__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keys) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node__bindgen_ty_1),
            "::",
            stringify!(keys),
        ),
    );
}
impl Default for btree_node__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_btree_node() {
    const UNINIT: ::std::mem::MaybeUninit<btree_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_node>(),
        160usize,
        concat!("Size of: ", stringify!(btree_node)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_node>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_node)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(btree_node), "::", stringify!(csum)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).magic) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(btree_node), "::", stringify!(magic)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(btree_node), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_key) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(btree_node), "::", stringify!(min_key)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_key) as usize - ptr as usize },
        52usize,
        concat!("Offset of field: ", stringify!(btree_node), "::", stringify!(max_key)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._ptr) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(btree_node), "::", stringify!(_ptr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).format) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(btree_node), "::", stringify!(format)),
    );
}
impl Default for btree_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C, align(8))]
pub struct btree_node_entry {
    pub csum: bch_csum,
    pub __bindgen_anon_1: btree_node_entry__bindgen_ty_1,
}
#[repr(C)]
pub struct btree_node_entry__bindgen_ty_1 {
    pub keys: __BindgenUnionField<bset>,
    pub __bindgen_anon_1: __BindgenUnionField<
        btree_node_entry__bindgen_ty_1__bindgen_ty_1,
    >,
    pub bindgen_union_field: [u64; 3usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct btree_node_entry__bindgen_ty_1__bindgen_ty_1 {
    pub pad: [__u8; 22usize],
    pub u64s: __le16,
    pub _data: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_btree_node_entry__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<
        btree_node_entry__bindgen_ty_1__bindgen_ty_1,
    > = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_node_entry__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(btree_node_entry__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_node_entry__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(btree_node_entry__bindgen_ty_1__bindgen_ty_1),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node_entry__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(pad),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node_entry__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(u64s),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._data) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node_entry__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_data),
        ),
    );
}
#[test]
fn bindgen_test_layout_btree_node_entry__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<btree_node_entry__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_node_entry__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(btree_node_entry__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_node_entry__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_node_entry__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keys) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node_entry__bindgen_ty_1),
            "::",
            stringify!(keys),
        ),
    );
}
impl Default for btree_node_entry__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_btree_node_entry() {
    const UNINIT: ::std::mem::MaybeUninit<btree_node_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_node_entry>(),
        40usize,
        concat!("Size of: ", stringify!(btree_node_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_node_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_node_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node_entry),
            "::",
            stringify!(csum),
        ),
    );
}
impl Default for btree_node_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_errcode {
    BCH_ERR_START = 2048,
    BCH_ERR_blockdev_io_error = 2049,
    BCH_ERR_BLK_STS_NOTSUPP = 2050,
    BCH_ERR_BLK_STS_TIMEOUT = 2051,
    BCH_ERR_BLK_STS_NOSPC = 2052,
    BCH_ERR_BLK_STS_TRANSPORT = 2053,
    BCH_ERR_BLK_STS_TARGET = 2054,
    BCH_ERR_BLK_STS_RESV_CONFLICT = 2055,
    BCH_ERR_BLK_STS_MEDIUM = 2056,
    BCH_ERR_BLK_STS_PROTECTION = 2057,
    BCH_ERR_BLK_STS_RESOURCE = 2058,
    BCH_ERR_BLK_STS_IOERR = 2059,
    BCH_ERR_BLK_STS_DM_REQUEUE = 2060,
    BCH_ERR_BLK_STS_AGAIN = 2061,
    BCH_ERR_BLK_STS_DEV_RESOURCE = 2062,
    BCH_ERR_BLK_STS_ZONE_OPEN_RESOURCE = 2063,
    BCH_ERR_BLK_STS_ZONE_ACTIVE_RESOURCE = 2064,
    BCH_ERR_BLK_STS_OFFLINE = 2065,
    BCH_ERR_BLK_STS_DURATION_LIMIT = 2066,
    BCH_ERR_BLK_STS_INVAL = 2067,
    BCH_ERR_BLK_STS_REMOVED = 2068,
    BCH_ERR_BLK_STS_UNKNOWN = 2069,
    BCH_ERR_zstd_error = 2070,
    BCH_ERR_ZSTD_error_GENERIC = 2071,
    BCH_ERR_ZSTD_error_prefix_unknown = 2072,
    BCH_ERR_ZSTD_error_version_unsupported = 2073,
    BCH_ERR_ZSTD_error_frameParameter_unsupported = 2074,
    BCH_ERR_ZSTD_error_frameParameter_windowTooLarge = 2075,
    BCH_ERR_ZSTD_error_corruption_detected = 2076,
    BCH_ERR_ZSTD_error_checksum_wrong = 2077,
    BCH_ERR_ZSTD_error_dictionary_corrupted = 2078,
    BCH_ERR_ZSTD_error_dictionary_wrong = 2079,
    BCH_ERR_ZSTD_error_dictionaryCreation_failed = 2080,
    BCH_ERR_ZSTD_error_parameter_unsupported = 2081,
    BCH_ERR_ZSTD_error_parameter_outOfBound = 2082,
    BCH_ERR_ZSTD_error_tableLog_tooLarge = 2083,
    BCH_ERR_ZSTD_error_maxSymbolValue_tooLarge = 2084,
    BCH_ERR_ZSTD_error_maxSymbolValue_tooSmall = 2085,
    BCH_ERR_ZSTD_error_stage_wrong = 2086,
    BCH_ERR_ZSTD_error_init_missing = 2087,
    BCH_ERR_ZSTD_error_memory_allocation = 2088,
    BCH_ERR_ZSTD_error_workSpace_tooSmall = 2089,
    BCH_ERR_ZSTD_error_dstSize_tooSmall = 2090,
    BCH_ERR_ZSTD_error_srcSize_wrong = 2091,
    BCH_ERR_ZSTD_error_dstBuffer_null = 2092,
    BCH_ERR_ZSTD_error_frameIndex_tooLarge = 2093,
    BCH_ERR_ZSTD_error_seekableIO = 2094,
    BCH_ERR_ZSTD_error_dstBuffer_wrong = 2095,
    BCH_ERR_ZSTD_error_srcBuffer_wrong = 2096,
    BCH_ERR_ZSTD_error_unknown = 2097,
    BCH_ERR_ERANGE_option_too_small = 2098,
    BCH_ERR_ERANGE_option_too_big = 2099,
    BCH_ERR_projid_too_big = 2100,
    BCH_ERR_injected = 2101,
    BCH_ERR_injected_fs_start = 2102,
    BCH_ERR_mount_option = 2103,
    BCH_ERR_option_name = 2104,
    BCH_ERR_option_value = 2105,
    BCH_ERR_option_not_bool = 2106,
    BCH_ERR_ENOMEM_stripe_buf = 2107,
    BCH_ERR_ENOMEM_replicas_table = 2108,
    BCH_ERR_ENOMEM_cpu_replicas = 2109,
    BCH_ERR_ENOMEM_replicas_gc = 2110,
    BCH_ERR_ENOMEM_disk_groups_validate = 2111,
    BCH_ERR_ENOMEM_disk_groups_to_cpu = 2112,
    BCH_ERR_ENOMEM_mark_snapshot = 2113,
    BCH_ERR_ENOMEM_mark_stripe = 2114,
    BCH_ERR_ENOMEM_mark_stripe_ptr = 2115,
    BCH_ERR_ENOMEM_btree_key_cache_create = 2116,
    BCH_ERR_ENOMEM_btree_key_cache_fill = 2117,
    BCH_ERR_ENOMEM_btree_key_cache_insert = 2118,
    BCH_ERR_ENOMEM_trans_kmalloc = 2119,
    BCH_ERR_ENOMEM_trans_log_msg = 2120,
    BCH_ERR_ENOMEM_do_encrypt = 2121,
    BCH_ERR_ENOMEM_ec_read_extent = 2122,
    BCH_ERR_ENOMEM_ec_stripe_mem_alloc = 2123,
    BCH_ERR_ENOMEM_ec_new_stripe_alloc = 2124,
    BCH_ERR_ENOMEM_fs_btree_cache_init = 2125,
    BCH_ERR_ENOMEM_fs_btree_key_cache_init = 2126,
    BCH_ERR_ENOMEM_fs_counters_init = 2127,
    BCH_ERR_ENOMEM_fs_btree_write_buffer_init = 2128,
    BCH_ERR_ENOMEM_io_clock_init = 2129,
    BCH_ERR_ENOMEM_blacklist_table_init = 2130,
    BCH_ERR_ENOMEM_sb_realloc_injected = 2131,
    BCH_ERR_ENOMEM_sb_bio_realloc = 2132,
    BCH_ERR_ENOMEM_sb_buf_realloc = 2133,
    BCH_ERR_ENOMEM_sb_journal_validate = 2134,
    BCH_ERR_ENOMEM_sb_journal_v2_validate = 2135,
    BCH_ERR_ENOMEM_journal_entry_add = 2136,
    BCH_ERR_ENOMEM_journal_read_buf_realloc = 2137,
    BCH_ERR_ENOMEM_btree_interior_update_worker_init = 2138,
    BCH_ERR_ENOMEM_btree_interior_update_pool_init = 2139,
    BCH_ERR_ENOMEM_bio_read_init = 2140,
    BCH_ERR_ENOMEM_bio_read_split_init = 2141,
    BCH_ERR_ENOMEM_bio_write_init = 2142,
    BCH_ERR_ENOMEM_promote_limit_init = 2143,
    BCH_ERR_ENOMEM_bio_bounce_pages_init = 2144,
    BCH_ERR_ENOMEM_writepage_bioset_init = 2145,
    BCH_ERR_ENOMEM_dio_read_bioset_init = 2146,
    BCH_ERR_ENOMEM_dio_write_bioset_init = 2147,
    BCH_ERR_ENOMEM_nocow_flush_bioset_init = 2148,
    BCH_ERR_ENOMEM_promote_table_init = 2149,
    BCH_ERR_ENOMEM_async_obj_init = 2150,
    BCH_ERR_ENOMEM_compression_bounce_read_init = 2151,
    BCH_ERR_ENOMEM_compression_bounce_write_init = 2152,
    BCH_ERR_ENOMEM_compression_workspace_init = 2153,
    BCH_ERR_ENOMEM_backpointer_mismatches_bitmap = 2154,
    BCH_ERR_compression_workspace_not_initialized = 2155,
    BCH_ERR_ENOMEM_bucket_gens = 2156,
    BCH_ERR_ENOMEM_buckets_nouse = 2157,
    BCH_ERR_ENOMEM_usage_init = 2158,
    BCH_ERR_ENOMEM_btree_node_read_all_replicas = 2159,
    BCH_ERR_ENOMEM_btree_node_reclaim = 2160,
    BCH_ERR_ENOMEM_btree_node_mem_alloc = 2161,
    BCH_ERR_ENOMEM_btree_cache_cannibalize_lock = 2162,
    BCH_ERR_ENOMEM_buckets_waiting_for_journal_init = 2163,
    BCH_ERR_ENOMEM_buckets_waiting_for_journal_set = 2164,
    BCH_ERR_ENOMEM_set_nr_journal_buckets = 2165,
    BCH_ERR_ENOMEM_dev_journal_init = 2166,
    BCH_ERR_ENOMEM_journal_pin_fifo = 2167,
    BCH_ERR_ENOMEM_journal_buf = 2168,
    BCH_ERR_ENOMEM_gc_start = 2169,
    BCH_ERR_ENOMEM_gc_alloc_start = 2170,
    BCH_ERR_ENOMEM_gc_reflink_start = 2171,
    BCH_ERR_ENOMEM_gc_gens = 2172,
    BCH_ERR_ENOMEM_gc_repair_key = 2173,
    BCH_ERR_ENOMEM_fsck_extent_ends_at = 2174,
    BCH_ERR_ENOMEM_fsck_add_nlink = 2175,
    BCH_ERR_ENOMEM_journal_key_insert = 2176,
    BCH_ERR_ENOMEM_journal_keys_sort = 2177,
    BCH_ERR_ENOMEM_read_superblock_clean = 2178,
    BCH_ERR_ENOMEM_fs_alloc = 2179,
    BCH_ERR_ENOMEM_fs_name_alloc = 2180,
    BCH_ERR_ENOMEM_fs_other_alloc = 2181,
    BCH_ERR_ENOMEM_dev_alloc = 2182,
    BCH_ERR_ENOMEM_disk_accounting = 2183,
    BCH_ERR_ENOMEM_stripe_head_alloc = 2184,
    BCH_ERR_ENOMEM_journal_read_bucket = 2185,
    BCH_ERR_ENOMEM_acl = 2186,
    BCH_ERR_ENOMEM_move_extent = 2187,
    BCH_ERR_ENOSPC_disk_reservation = 2188,
    BCH_ERR_ENOSPC_bucket_alloc = 2189,
    BCH_ERR_ENOSPC_disk_label_add = 2190,
    BCH_ERR_ENOSPC_stripe_create = 2191,
    BCH_ERR_ENOSPC_inode_create = 2192,
    BCH_ERR_ENOSPC_str_hash_create = 2193,
    BCH_ERR_ENOSPC_snapshot_create = 2194,
    BCH_ERR_ENOSPC_subvolume_create = 2195,
    BCH_ERR_ENOSPC_sb = 2196,
    BCH_ERR_ENOSPC_sb_journal = 2197,
    BCH_ERR_ENOSPC_sb_journal_seq_blacklist = 2198,
    BCH_ERR_ENOSPC_sb_quota = 2199,
    BCH_ERR_ENOSPC_sb_replicas = 2200,
    BCH_ERR_ENOSPC_sb_members = 2201,
    BCH_ERR_ENOSPC_sb_members_v2 = 2202,
    BCH_ERR_ENOSPC_sb_extent_type_u64s = 2203,
    BCH_ERR_ENOSPC_sb_crypt = 2204,
    BCH_ERR_ENOSPC_sb_downgrade = 2205,
    BCH_ERR_ENOSPC_btree_slot = 2206,
    BCH_ERR_ENOSPC_snapshot_tree = 2207,
    BCH_ERR_ENOENT_bkey_type_mismatch = 2208,
    BCH_ERR_ENOENT_str_hash_lookup = 2209,
    BCH_ERR_ENOENT_str_hash_set_must_replace = 2210,
    BCH_ERR_ENOENT_inode = 2211,
    BCH_ERR_ENOENT_not_subvol = 2212,
    BCH_ERR_ENOENT_not_directory = 2213,
    BCH_ERR_ENOENT_directory_dead = 2214,
    BCH_ERR_ENOENT_subvolume = 2215,
    BCH_ERR_ENOENT_snapshot = 2216,
    BCH_ERR_ENOENT_snapshot_tree = 2217,
    BCH_ERR_ENOENT_dirent_doesnt_match_inode = 2218,
    BCH_ERR_ENOENT_dev_not_found = 2219,
    BCH_ERR_ENOENT_dev_bucket_not_found = 2220,
    BCH_ERR_ENOENT_dev_idx_not_found = 2221,
    BCH_ERR_ENOENT_inode_no_backpointer = 2222,
    BCH_ERR_ENOENT_no_snapshot_tree_subvol = 2223,
    BCH_ERR_btree_node_dying = 2224,
    BCH_ERR_ENOTEMPTY_dir_not_empty = 2225,
    BCH_ERR_ENOTEMPTY_subvol_not_empty = 2226,
    BCH_ERR_EEXIST_str_hash_set = 2227,
    BCH_ERR_EEXIST_discard_in_flight_add = 2228,
    BCH_ERR_EEXIST_subvolume_create = 2229,
    BCH_ERR_open_buckets_empty = 2230,
    BCH_ERR_freelist_empty = 2231,
    BCH_ERR_ec_alloc_failed = 2232,
    BCH_ERR_no_buckets_found = 2233,
    BCH_ERR_transaction_restart = 2234,
    BCH_ERR_transaction_restart_fault_inject = 2235,
    BCH_ERR_transaction_restart_relock = 2236,
    BCH_ERR_transaction_restart_relock_path = 2237,
    BCH_ERR_transaction_restart_relock_path_intent = 2238,
    BCH_ERR_transaction_restart_too_many_iters = 2239,
    BCH_ERR_transaction_restart_lock_node_reused = 2240,
    BCH_ERR_transaction_restart_fill_relock = 2241,
    BCH_ERR_transaction_restart_fill_mem_alloc_fail = 2242,
    BCH_ERR_transaction_restart_mem_realloced = 2243,
    BCH_ERR_transaction_restart_in_traverse_all = 2244,
    BCH_ERR_transaction_restart_would_deadlock = 2245,
    BCH_ERR_transaction_restart_would_deadlock_write = 2246,
    BCH_ERR_transaction_restart_deadlock_recursion_limit = 2247,
    BCH_ERR_transaction_restart_upgrade = 2248,
    BCH_ERR_transaction_restart_key_cache_fill = 2249,
    BCH_ERR_transaction_restart_key_cache_raced = 2250,
    BCH_ERR_transaction_restart_lock_root_race = 2251,
    BCH_ERR_transaction_restart_split_race = 2252,
    BCH_ERR_transaction_restart_split_with_interior_updates = 2253,
    BCH_ERR_transaction_restart_write_buffer_flush = 2254,
    BCH_ERR_transaction_restart_nested = 2255,
    BCH_ERR_transaction_restart_commit = 2256,
    BCH_ERR_no_btree_node = 2257,
    BCH_ERR_no_btree_node_relock = 2258,
    BCH_ERR_no_btree_node_upgrade = 2259,
    BCH_ERR_no_btree_node_drop = 2260,
    BCH_ERR_no_btree_node_lock_root = 2261,
    BCH_ERR_no_btree_node_up = 2262,
    BCH_ERR_no_btree_node_down = 2263,
    BCH_ERR_no_btree_node_init = 2264,
    BCH_ERR_no_btree_node_cached = 2265,
    BCH_ERR_no_btree_node_srcu_reset = 2266,
    BCH_ERR_btree_insert_fail = 2267,
    BCH_ERR_btree_insert_btree_node_full = 2268,
    BCH_ERR_btree_insert_need_mark_replicas = 2269,
    BCH_ERR_btree_insert_need_journal_res = 2270,
    BCH_ERR_btree_insert_need_journal_reclaim = 2271,
    BCH_ERR_backpointer_to_overwritten_btree_node = 2272,
    BCH_ERR_journal_reclaim_would_deadlock = 2273,
    BCH_ERR_fsck = 2274,
    BCH_ERR_fsck_ask = 2275,
    BCH_ERR_fsck_fix = 2276,
    BCH_ERR_fsck_delete_bkey = 2277,
    BCH_ERR_fsck_ignore = 2278,
    BCH_ERR_fsck_errors_not_fixed = 2279,
    BCH_ERR_fsck_repair_unimplemented = 2280,
    BCH_ERR_fsck_repair_impossible = 2281,
    BCH_ERR_recovery_will_run = 2282,
    BCH_ERR_restart_recovery = 2283,
    BCH_ERR_cannot_rewind_recovery = 2284,
    BCH_ERR_recovery_pass_will_run = 2285,
    BCH_ERR_bkey_was_deleted = 2286,
    BCH_ERR_bucket_not_moveable = 2287,
    BCH_ERR_bucket_not_moveable_dev_not_rw = 2288,
    BCH_ERR_bucket_not_moveable_bucket_open = 2289,
    BCH_ERR_bucket_not_moveable_bp_mismatch = 2290,
    BCH_ERR_bucket_not_moveable_lru_race = 2291,
    BCH_ERR_data_update_done = 2292,
    BCH_ERR_data_update_done_unwritten = 2293,
    BCH_ERR_data_update_done_no_writes_needed = 2294,
    BCH_ERR_data_update_fail = 2295,
    BCH_ERR_data_update_fail_would_block = 2296,
    BCH_ERR_data_update_fail_no_snapshot = 2297,
    BCH_ERR_data_update_fail_no_rw_devs = 2298,
    BCH_ERR_device_state_not_allowed = 2299,
    BCH_ERR_member_info_missing = 2300,
    BCH_ERR_mismatched_block_size = 2301,
    BCH_ERR_block_size_too_small = 2302,
    BCH_ERR_bucket_size_too_small = 2303,
    BCH_ERR_device_size_too_small = 2304,
    BCH_ERR_device_size_too_big = 2305,
    BCH_ERR_device_not_a_member_of_filesystem = 2306,
    BCH_ERR_device_has_been_removed = 2307,
    BCH_ERR_device_splitbrain = 2308,
    BCH_ERR_device_already_online = 2309,
    BCH_ERR_filesystem_uuid_already_open = 2310,
    BCH_ERR_insufficient_devices_to_start = 2311,
    BCH_ERR_chardev_init_error = 2312,
    BCH_ERR_sysfs_init_error = 2313,
    BCH_ERR_invalid = 2314,
    BCH_ERR_internal_fsck_err = 2315,
    BCH_ERR_opt_parse_error = 2316,
    BCH_ERR_remove_with_metadata_missing_unimplemented = 2317,
    BCH_ERR_remove_would_lose_data = 2318,
    BCH_ERR_no_resize_with_buckets_nouse = 2319,
    BCH_ERR_inode_unpack_error = 2320,
    BCH_ERR_inode_not_unlinked = 2321,
    BCH_ERR_inode_has_child_snapshot = 2322,
    BCH_ERR_varint_decode_error = 2323,
    BCH_ERR_erasure_coding_found_btree_node = 2324,
    BCH_ERR_option_negative = 2325,
    BCH_ERR_topology_repair = 2326,
    BCH_ERR_unaligned_io = 2327,
    BCH_ERR_topology_repair_drop_this_node = 2328,
    BCH_ERR_topology_repair_drop_prev_node = 2329,
    BCH_ERR_topology_repair_did_fill_from_scan = 2330,
    BCH_ERR_too_many_links = 2331,
    BCH_ERR_may_not_use_incompat_feature = 2332,
    BCH_ERR_no_casefolding_without_utf8 = 2333,
    BCH_ERR_casefolding_disabled = 2334,
    BCH_ERR_casefold_opt_is_dir_only = 2335,
    BCH_ERR_casefolding_in_use = 2336,
    BCH_ERR_casefold_dir_but_disabled = 2337,
    BCH_ERR_unsupported_fsx_flag = 2338,
    BCH_ERR_unsupported_fa_flag = 2339,
    BCH_ERR_unsupported_fallocate_mode = 2340,
    BCH_ERR_erofs_trans_commit = 2341,
    BCH_ERR_erofs_no_writes = 2342,
    BCH_ERR_erofs_journal_err = 2343,
    BCH_ERR_erofs_sb_err = 2344,
    BCH_ERR_erofs_unfixed_errors = 2345,
    BCH_ERR_erofs_norecovery = 2346,
    BCH_ERR_erofs_nochanges = 2347,
    BCH_ERR_erofs_no_alloc_info = 2348,
    BCH_ERR_erofs_filesystem_full = 2349,
    BCH_ERR_insufficient_devices = 2350,
    BCH_ERR_erofs_recovery_cancelled = 2351,
    BCH_ERR_btree_not_started = 2352,
    BCH_ERR_operation_blocked = 2353,
    BCH_ERR_btree_cache_cannibalize_lock_blocked = 2354,
    BCH_ERR_journal_res_blocked = 2355,
    BCH_ERR_journal_blocked = 2356,
    BCH_ERR_journal_max_in_flight = 2357,
    BCH_ERR_journal_max_open = 2358,
    BCH_ERR_journal_full = 2359,
    BCH_ERR_journal_pin_full = 2360,
    BCH_ERR_journal_buf_enomem = 2361,
    BCH_ERR_journal_stuck = 2362,
    BCH_ERR_journal_retry_open = 2363,
    BCH_ERR_bucket_alloc_blocked = 2364,
    BCH_ERR_stripe_alloc_blocked = 2365,
    BCH_ERR_invalid_sb = 2366,
    BCH_ERR_invalid_sb_magic = 2367,
    BCH_ERR_invalid_sb_version = 2368,
    BCH_ERR_invalid_sb_features = 2369,
    BCH_ERR_invalid_sb_too_big = 2370,
    BCH_ERR_invalid_sb_csum_type = 2371,
    BCH_ERR_invalid_sb_csum = 2372,
    BCH_ERR_invalid_sb_block_size = 2373,
    BCH_ERR_invalid_sb_uuid = 2374,
    BCH_ERR_invalid_sb_offset = 2375,
    BCH_ERR_invalid_sb_too_many_members = 2376,
    BCH_ERR_invalid_sb_dev_idx = 2377,
    BCH_ERR_invalid_sb_time_precision = 2378,
    BCH_ERR_invalid_sb_field_size = 2379,
    BCH_ERR_invalid_sb_layout = 2380,
    BCH_ERR_invalid_sb_layout_type = 2381,
    BCH_ERR_invalid_sb_layout_nr_superblocks = 2382,
    BCH_ERR_invalid_sb_layout_superblocks_overlap = 2383,
    BCH_ERR_invalid_sb_layout_sb_max_size_bits = 2384,
    BCH_ERR_invalid_sb_members_missing = 2385,
    BCH_ERR_invalid_sb_members = 2386,
    BCH_ERR_invalid_sb_disk_groups = 2387,
    BCH_ERR_invalid_sb_replicas = 2388,
    BCH_ERR_invalid_replicas_entry = 2389,
    BCH_ERR_invalid_sb_journal = 2390,
    BCH_ERR_invalid_sb_journal_seq_blacklist = 2391,
    BCH_ERR_invalid_sb_crypt = 2392,
    BCH_ERR_invalid_sb_clean = 2393,
    BCH_ERR_invalid_sb_quota = 2394,
    BCH_ERR_invalid_sb_errors = 2395,
    BCH_ERR_invalid_sb_opt_compression = 2396,
    BCH_ERR_invalid_sb_ext = 2397,
    BCH_ERR_invalid_sb_downgrade = 2398,
    BCH_ERR_invalid_sb_extent_type_u64s = 2399,
    BCH_ERR_invalid_bkey = 2400,
    BCH_ERR_nocow_lock_blocked = 2401,
    BCH_ERR_journal_shutdown = 2402,
    BCH_ERR_journal_flush_err = 2403,
    BCH_ERR_journal_write_err = 2404,
    BCH_ERR_btree_node_read_err = 2405,
    BCH_ERR_btree_node_validate_err = 2406,
    BCH_ERR_btree_node_read_err_cached = 2407,
    BCH_ERR_sb_not_downgraded = 2408,
    BCH_ERR_btree_node_write_all_failed = 2409,
    BCH_ERR_btree_node_read_error = 2410,
    BCH_ERR_btree_need_topology_repair = 2411,
    BCH_ERR_bucket_ref_update = 2412,
    BCH_ERR_trigger_alloc = 2413,
    BCH_ERR_trigger_pointer = 2414,
    BCH_ERR_trigger_stripe_pointer = 2415,
    BCH_ERR_metadata_bucket_inconsistency = 2416,
    BCH_ERR_mark_stripe = 2417,
    BCH_ERR_stripe_reconstruct = 2418,
    BCH_ERR_key_type_error = 2419,
    BCH_ERR_extent_poisoned = 2420,
    BCH_ERR_missing_indirect_extent = 2421,
    BCH_ERR_invalidate_stripe_to_dev = 2422,
    BCH_ERR_no_encryption_key = 2423,
    BCH_ERR_insufficient_journal_devices = 2424,
    BCH_ERR_device_offline = 2425,
    BCH_ERR_EIO_fault_injected = 2426,
    BCH_ERR_ec_block_read = 2427,
    BCH_ERR_ec_block_write = 2428,
    BCH_ERR_recompute_checksum = 2429,
    BCH_ERR_decompress = 2430,
    BCH_ERR_decompress_exceeded_max_encoded_extent = 2431,
    BCH_ERR_decompress_lz4 = 2432,
    BCH_ERR_decompress_gzip = 2433,
    BCH_ERR_decompress_zstd_src_len_bad = 2434,
    BCH_ERR_decompress_zstd_size_mismatch = 2435,
    BCH_ERR_data_write = 2436,
    BCH_ERR_data_write_io = 2437,
    BCH_ERR_data_write_csum = 2438,
    BCH_ERR_data_write_invalid_ptr = 2439,
    BCH_ERR_data_write_misaligned = 2440,
    BCH_ERR_data_read = 2441,
    BCH_ERR_no_device_to_read_from = 2442,
    BCH_ERR_no_devices_valid = 2443,
    BCH_ERR_data_read_io_err = 2444,
    BCH_ERR_data_read_csum_err = 2445,
    BCH_ERR_data_read_retry = 2446,
    BCH_ERR_data_read_retry_avoid = 2447,
    BCH_ERR_data_read_retry_device_offline = 2448,
    BCH_ERR_data_read_retry_io_err = 2449,
    BCH_ERR_data_read_retry_ec_reconstruct_err = 2450,
    BCH_ERR_data_read_retry_csum_err = 2451,
    BCH_ERR_data_read_retry_csum_err_maybe_userspace = 2452,
    BCH_ERR_data_read_decompress_err = 2453,
    BCH_ERR_data_read_decrypt_err = 2454,
    BCH_ERR_data_read_ptr_stale_race = 2455,
    BCH_ERR_data_read_ptr_stale_retry = 2456,
    BCH_ERR_data_read_ptr_stale_dirty = 2457,
    BCH_ERR_data_read_no_encryption_key = 2458,
    BCH_ERR_data_read_buffer_too_small = 2459,
    BCH_ERR_data_read_key_overwritten = 2460,
    BCH_ERR_rbio_narrow_crcs_fail = 2461,
    BCH_ERR_nopromote = 2462,
    BCH_ERR_nopromote_no_rewrites = 2463,
    BCH_ERR_nopromote_already_promoted = 2464,
    BCH_ERR_nopromote_unwritten = 2465,
    BCH_ERR_nopromote_congested = 2466,
    BCH_ERR_nopromote_ratelimited = 2467,
    BCH_ERR_nopromote_in_flight = 2468,
    BCH_ERR_nopromote_no_writes = 2469,
    BCH_ERR_nopromote_enomem = 2470,
    BCH_ERR_invalid_snapshot_node = 2471,
    BCH_ERR_option_needs_open_fs = 2472,
    BCH_ERR_remove_disk_accounting_entry = 2473,
    BCH_ERR_nocow_trylock_fail = 2474,
    BCH_ERR_nocow_trylock_contended = 2475,
    BCH_ERR_nocow_trylock_bucket_full = 2476,
    BCH_ERR_recovery_cancelled = 2477,
    BCH_ERR_shutdown_with_errors = 2478,
    BCH_ERR_shutdown_with_errors_fixed = 2479,
    BCH_ERR_shutdown_with_errors_unfixed = 2480,
    BCH_ERR_shutdown_with_emergency_ro = 2481,
    BCH_ERR_MAX = 2482,
}
extern "C" {
    pub fn bch2_err_str(arg1: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn __bch2_err_matches(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn __bch2_err_class(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_blk_status_to_str(arg1: blk_status_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub static bch2_error_actions: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static bch2_degraded_actions: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static bch2_fsck_fix_opts: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static bch2_version_upgrade_opts: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static bch2_sb_features: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static bch2_sb_compat: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static __bch2_btree_ids: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static __bch2_csum_types: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static __bch2_csum_opts: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static __bch2_compression_types: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static bch2_compression_opts: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static __bch2_str_hash_types: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static bch2_str_hash_opts: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static __bch2_data_types: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static bch2_member_states: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static __bch2_reconcile_accounting_types: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static bch2_d_types: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn bch2_prt_jset_entry_type(arg1: *mut printbuf, arg2: bch_jset_entry_type);
}
extern "C" {
    pub fn bch2_prt_fs_usage_type(arg1: *mut printbuf, arg2: bch_fs_usage_type);
}
extern "C" {
    pub fn bch2_prt_data_type(arg1: *mut printbuf, arg2: bch_data_type);
}
extern "C" {
    pub fn bch2_prt_csum_opt(arg1: *mut printbuf, arg2: bch_csum_opt);
}
extern "C" {
    pub fn bch2_prt_csum_type(arg1: *mut printbuf, arg2: bch_csum_type);
}
extern "C" {
    pub fn bch2_prt_compression_type(arg1: *mut printbuf, arg2: bch_compression_type);
}
extern "C" {
    pub fn bch2_prt_str_hash_type(arg1: *mut printbuf, arg2: bch_str_hash_type);
}
extern "C" {
    pub fn bch2_prt_reconcile_accounting_type(
        arg1: *mut printbuf,
        arg2: bch_reconcile_accounting_type,
    );
}
extern "C" {
    pub fn bch2_prt_key_type_error_reason(
        arg1: *mut printbuf,
        arg2: bch_key_type_errors,
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum opt_flags {
    OPT_FS = 1,
    OPT_DEVICE = 2,
    OPT_INODE = 4,
    OPT_FORMAT = 8,
    OPT_MOUNT = 16,
    OPT_RUNTIME = 32,
    OPT_HUMAN_READABLE = 64,
    OPT_MUST_BE_POW_2 = 128,
    OPT_SB_FIELD_SECTORS = 256,
    OPT_SB_FIELD_ILOG2 = 512,
    OPT_SB_FIELD_ONE_BIAS = 1024,
    OPT_HIDDEN = 2048,
    OPT_MOUNT_OLD = 4096,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum opt_type {
    BCH_OPT_BOOL = 0,
    BCH_OPT_UINT = 1,
    BCH_OPT_STR = 2,
    BCH_OPT_BITFIELD = 3,
    BCH_OPT_FN = 4,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_opt_fn {
    pub parse: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut bch_fs,
            arg2: *const ::std::os::raw::c_char,
            arg3: *mut u64_,
            arg4: *mut printbuf,
        ) -> ::std::os::raw::c_int,
    >,
    pub to_text: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut printbuf,
            arg2: *mut bch_fs,
            arg3: *mut bch_sb,
            arg4: u64_,
        ),
    >,
    pub validate: ::std::option::Option<
        unsafe extern "C" fn(arg1: u64_, arg2: *mut printbuf) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_bch_opt_fn() {
    const UNINIT: ::std::mem::MaybeUninit<bch_opt_fn> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_opt_fn>(),
        24usize,
        concat!("Size of: ", stringify!(bch_opt_fn)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_opt_fn>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_opt_fn)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parse) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_opt_fn), "::", stringify!(parse)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).to_text) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bch_opt_fn), "::", stringify!(to_text)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).validate) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bch_opt_fn), "::", stringify!(validate)),
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum fsck_err_opts {
    FSCK_FIX_exit = 0,
    FSCK_FIX_yes = 1,
    FSCK_FIX_no = 2,
    FSCK_FIX_ask = 3,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_opts {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 11usize]>,
    pub block_size: u16_,
    pub btree_node_size: u32_,
    pub errors: u8_,
    pub write_error_timeout: u16_,
    pub metadata_replicas: u8_,
    pub data_replicas: u8_,
    pub metadata_replicas_required: u8_,
    pub data_replicas_required: u8_,
    pub encoded_extent_max: u32_,
    pub metadata_checksum: u8_,
    pub data_checksum: u8_,
    pub checksum_err_retry_nr: u8_,
    pub compression: u8_,
    pub background_compression: u8_,
    pub str_hash: u8_,
    pub metadata_target: u16_,
    pub foreground_target: u16_,
    pub background_target: u16_,
    pub promote_target: u16_,
    pub erasure_code: u16_,
    pub casefold: u8_,
    pub casefold_disabled: u8_,
    pub inodes_32bit: u8_,
    pub shard_inode_numbers_bits: u8_,
    pub btree_node_mem_ptr_optimization: u8_,
    pub gc_reserve_percent: u8_,
    pub gc_reserve_bytes: u64_,
    pub root_reserve_percent: u8_,
    pub wide_macs: u8_,
    pub inline_data: u8_,
    pub promote_whole_extents: u8_,
    pub acl: u8_,
    pub usrquota: u8_,
    pub grpquota: u8_,
    pub prjquota: u8_,
    pub degraded: u8_,
    pub mount_trusts_udev: u8_,
    pub no_splitbrain_check: u8_,
    pub no_version_check: u8_,
    pub verbose: u8_,
    pub journal_flush_delay: u32_,
    pub journal_flush_disabled: u8_,
    pub journal_reclaim_delay: u32_,
    pub writeback_timeout: u16_,
    pub move_bytes_in_flight: u32_,
    pub move_ios_in_flight: u32_,
    pub fsck: u8_,
    pub fsck_memory_usage_percent: u8_,
    pub fix_errors: u8_,
    pub ratelimit_errors: u8_,
    pub nochanges: u8_,
    pub norecovery: u8_,
    pub journal_rewind: u64_,
    pub recovery_passes: u64_,
    pub recovery_passes_exclude: u64_,
    pub recovery_pass_last: u8_,
    pub retain_recovery_info: u8_,
    pub read_entire_journal: u8_,
    pub read_journal_only: u8_,
    pub journal_transaction_names: u8_,
    pub allocator_stuck_timeout: u16_,
    pub noexcl: u8_,
    pub direct_io: u8_,
    pub sb: u64_,
    pub read_only: u8_,
    pub nostart: u8_,
    pub reconstruct_alloc: u8_,
    pub version_upgrade: u8_,
    pub stdio: u64_,
    pub project: u8_,
    pub nocow: u8_,
    pub nocow_enabled: u8_,
    pub copygc_enabled: u8_,
    pub reconcile_enabled: u8_,
    pub reconcile_on_ac_only: u8_,
    pub auto_snapshot_deletion: u8_,
    pub no_data_io: u8_,
    pub state: u64_,
    pub bucket_size: u32_,
    pub durability: u8_,
    pub data_allowed: u8_,
    pub discard: u8_,
    pub rotational: u8_,
    pub btree_node_prefetch: u8_,
}
#[test]
fn bindgen_test_layout_bch_opts() {
    const UNINIT: ::std::mem::MaybeUninit<bch_opts> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_opts>(),
        208usize,
        concat!("Size of: ", stringify!(bch_opts)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_opts)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block_size) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(block_size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btree_node_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(btree_node_size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).errors) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(errors)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).write_error_timeout) as usize - ptr as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(write_error_timeout),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).metadata_replicas) as usize - ptr as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(metadata_replicas),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_replicas) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(data_replicas),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).metadata_replicas_required) as usize
                - ptr as usize
        },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(metadata_replicas_required),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).data_replicas_required) as usize - ptr as usize
        },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(data_replicas_required),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).encoded_extent_max) as usize - ptr as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(encoded_extent_max),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).metadata_checksum) as usize - ptr as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(metadata_checksum),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_checksum) as usize - ptr as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(data_checksum),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).checksum_err_retry_nr) as usize - ptr as usize
        },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(checksum_err_retry_nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compression) as usize - ptr as usize },
        35usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(compression)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).background_compression) as usize - ptr as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(background_compression),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).str_hash) as usize - ptr as usize },
        37usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(str_hash)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).metadata_target) as usize - ptr as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(metadata_target),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).foreground_target) as usize - ptr as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(foreground_target),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).background_target) as usize - ptr as usize
        },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(background_target),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).promote_target) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(promote_target),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).erasure_code) as usize - ptr as usize },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(erasure_code),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).casefold) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(casefold)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).casefold_disabled) as usize - ptr as usize
        },
        49usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(casefold_disabled),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inodes_32bit) as usize - ptr as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(inodes_32bit),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).shard_inode_numbers_bits) as usize - ptr as usize
        },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(shard_inode_numbers_bits),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).btree_node_mem_ptr_optimization) as usize
                - ptr as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(btree_node_mem_ptr_optimization),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).gc_reserve_percent) as usize - ptr as usize
        },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(gc_reserve_percent),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gc_reserve_bytes) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(gc_reserve_bytes),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).root_reserve_percent) as usize - ptr as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(root_reserve_percent),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wide_macs) as usize - ptr as usize },
        65usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(wide_macs)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inline_data) as usize - ptr as usize },
        66usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(inline_data)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).promote_whole_extents) as usize - ptr as usize
        },
        67usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(promote_whole_extents),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).acl) as usize - ptr as usize },
        68usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(acl)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).usrquota) as usize - ptr as usize },
        69usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(usrquota)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).grpquota) as usize - ptr as usize },
        70usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(grpquota)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prjquota) as usize - ptr as usize },
        71usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(prjquota)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).degraded) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(degraded)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).mount_trusts_udev) as usize - ptr as usize
        },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(mount_trusts_udev),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).no_splitbrain_check) as usize - ptr as usize
        },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(no_splitbrain_check),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).no_version_check) as usize - ptr as usize },
        75usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(no_version_check),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).verbose) as usize - ptr as usize },
        76usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(verbose)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).journal_flush_delay) as usize - ptr as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(journal_flush_delay),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).journal_flush_disabled) as usize - ptr as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(journal_flush_disabled),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).journal_reclaim_delay) as usize - ptr as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(journal_reclaim_delay),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).writeback_timeout) as usize - ptr as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(writeback_timeout),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).move_bytes_in_flight) as usize - ptr as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(move_bytes_in_flight),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).move_ios_in_flight) as usize - ptr as usize
        },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(move_ios_in_flight),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fsck) as usize - ptr as usize },
        104usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(fsck)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).fsck_memory_usage_percent) as usize
                - ptr as usize
        },
        105usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(fsck_memory_usage_percent),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fix_errors) as usize - ptr as usize },
        106usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(fix_errors)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ratelimit_errors) as usize - ptr as usize },
        107usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(ratelimit_errors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nochanges) as usize - ptr as usize },
        108usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(nochanges)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).norecovery) as usize - ptr as usize },
        109usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(norecovery)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_rewind) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(journal_rewind),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).recovery_passes) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(recovery_passes),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).recovery_passes_exclude) as usize - ptr as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(recovery_passes_exclude),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).recovery_pass_last) as usize - ptr as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(recovery_pass_last),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).retain_recovery_info) as usize - ptr as usize
        },
        137usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(retain_recovery_info),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).read_entire_journal) as usize - ptr as usize
        },
        138usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(read_entire_journal),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).read_journal_only) as usize - ptr as usize
        },
        139usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(read_journal_only),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).journal_transaction_names) as usize
                - ptr as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(journal_transaction_names),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).allocator_stuck_timeout) as usize - ptr as usize
        },
        142usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(allocator_stuck_timeout),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).noexcl) as usize - ptr as usize },
        144usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(noexcl)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).direct_io) as usize - ptr as usize },
        145usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(direct_io)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sb) as usize - ptr as usize },
        152usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(sb)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_only) as usize - ptr as usize },
        160usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(read_only)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nostart) as usize - ptr as usize },
        161usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(nostart)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).reconstruct_alloc) as usize - ptr as usize
        },
        162usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(reconstruct_alloc),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version_upgrade) as usize - ptr as usize },
        163usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(version_upgrade),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stdio) as usize - ptr as usize },
        168usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(stdio)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).project) as usize - ptr as usize },
        176usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(project)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nocow) as usize - ptr as usize },
        177usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(nocow)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nocow_enabled) as usize - ptr as usize },
        178usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(nocow_enabled),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).copygc_enabled) as usize - ptr as usize },
        179usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(copygc_enabled),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).reconcile_enabled) as usize - ptr as usize
        },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(reconcile_enabled),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).reconcile_on_ac_only) as usize - ptr as usize
        },
        181usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(reconcile_on_ac_only),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).auto_snapshot_deletion) as usize - ptr as usize
        },
        182usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(auto_snapshot_deletion),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).no_data_io) as usize - ptr as usize },
        183usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(no_data_io)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        184usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(state)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bucket_size) as usize - ptr as usize },
        192usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(bucket_size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).durability) as usize - ptr as usize },
        196usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(durability)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_allowed) as usize - ptr as usize },
        197usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(data_allowed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).discard) as usize - ptr as usize },
        198usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(discard)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rotational) as usize - ptr as usize },
        199usize,
        concat!("Offset of field: ", stringify!(bch_opts), "::", stringify!(rotational)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).btree_node_prefetch) as usize - ptr as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_opts),
            "::",
            stringify!(btree_node_prefetch),
        ),
    );
}
impl bch_opts {
    #[inline]
    pub fn block_size_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_block_size_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn btree_node_size_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_btree_node_size_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn errors_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_errors_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn write_error_timeout_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_write_error_timeout_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn metadata_replicas_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_metadata_replicas_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_replicas_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_data_replicas_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn metadata_replicas_required_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_metadata_replicas_required_defined(
        &mut self,
        val: ::std::os::raw::c_uint,
    ) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_replicas_required_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_data_replicas_required_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn encoded_extent_max_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_encoded_extent_max_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn metadata_checksum_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_metadata_checksum_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_checksum_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_data_checksum_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn checksum_err_retry_nr_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_checksum_err_retry_nr_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn compression_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_compression_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn background_compression_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_background_compression_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn str_hash_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_str_hash_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn metadata_target_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_metadata_target_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn foreground_target_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_foreground_target_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn background_target_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_background_target_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn promote_target_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_promote_target_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn erasure_code_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_erasure_code_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn casefold_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_casefold_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn casefold_disabled_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_casefold_disabled_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn inodes_32bit_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_inodes_32bit_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn shard_inode_numbers_bits_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_shard_inode_numbers_bits_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn btree_node_mem_ptr_optimization_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_btree_node_mem_ptr_optimization_defined(
        &mut self,
        val: ::std::os::raw::c_uint,
    ) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn gc_reserve_percent_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gc_reserve_percent_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn gc_reserve_bytes_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gc_reserve_bytes_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn root_reserve_percent_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_root_reserve_percent_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn wide_macs_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_wide_macs_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn inline_data_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_inline_data_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn promote_whole_extents_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_promote_whole_extents_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn acl_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_acl_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn usrquota_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_usrquota_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn grpquota_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(33usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_grpquota_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(33usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn prjquota_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(34usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_prjquota_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(34usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn degraded_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(35usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_degraded_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(35usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mount_trusts_udev_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(36usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mount_trusts_udev_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(36usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_splitbrain_check_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(37usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_splitbrain_check_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(37usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_version_check_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(38usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_version_check_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(38usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn verbose_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(39usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_verbose_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(39usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn journal_flush_delay_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_journal_flush_delay_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn journal_flush_disabled_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(41usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_journal_flush_disabled_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(41usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn journal_reclaim_delay_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(42usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_journal_reclaim_delay_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(42usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn writeback_timeout_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(43usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_writeback_timeout_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(43usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn move_bytes_in_flight_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(44usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_move_bytes_in_flight_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(44usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn move_ios_in_flight_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(45usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_move_ios_in_flight_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(45usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fsck_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(46usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fsck_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(46usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fsck_memory_usage_percent_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(47usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fsck_memory_usage_percent_defined(
        &mut self,
        val: ::std::os::raw::c_uint,
    ) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(47usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fix_errors_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(48usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fix_errors_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(48usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ratelimit_errors_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(49usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ratelimit_errors_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(49usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nochanges_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(50usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nochanges_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(50usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn norecovery_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(51usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_norecovery_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(51usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn journal_rewind_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(52usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_journal_rewind_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(52usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn recovery_passes_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(53usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_recovery_passes_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(53usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn recovery_passes_exclude_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(54usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_recovery_passes_exclude_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(54usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn recovery_pass_last_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(55usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_recovery_pass_last_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(55usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn retain_recovery_info_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(56usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_retain_recovery_info_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(56usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn read_entire_journal_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(57usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_entire_journal_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(57usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn read_journal_only_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(58usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_journal_only_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(58usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn journal_transaction_names_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(59usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_journal_transaction_names_defined(
        &mut self,
        val: ::std::os::raw::c_uint,
    ) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(59usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn allocator_stuck_timeout_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(60usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_allocator_stuck_timeout_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(60usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn noexcl_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(61usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_noexcl_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(61usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn direct_io_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(62usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_direct_io_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(62usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sb_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(63usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sb_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(63usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn read_only_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(64usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_only_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(64usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nostart_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(65usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nostart_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(65usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reconstruct_alloc_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(66usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reconstruct_alloc_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(66usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn version_upgrade_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(67usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_version_upgrade_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(67usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn stdio_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(68usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_stdio_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(68usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn project_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(69usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_project_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(69usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nocow_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(70usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nocow_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(70usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nocow_enabled_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(71usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nocow_enabled_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(71usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn copygc_enabled_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(72usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_copygc_enabled_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(72usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reconcile_enabled_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(73usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reconcile_enabled_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(73usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reconcile_on_ac_only_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(74usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_reconcile_on_ac_only_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(74usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn auto_snapshot_deletion_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(75usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_auto_snapshot_deletion_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(75usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_data_io_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(76usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_data_io_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(76usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn state_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(77usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_state_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(77usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bucket_size_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(78usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bucket_size_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(78usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn durability_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(79usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_durability_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(79usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_allowed_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(80usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_data_allowed_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(80usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn discard_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(81usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_discard_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(81usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rotational_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(82usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_rotational_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(82usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn btree_node_prefetch_defined(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(83usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_btree_node_prefetch_defined(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(83usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        block_size_defined: ::std::os::raw::c_uint,
        btree_node_size_defined: ::std::os::raw::c_uint,
        errors_defined: ::std::os::raw::c_uint,
        write_error_timeout_defined: ::std::os::raw::c_uint,
        metadata_replicas_defined: ::std::os::raw::c_uint,
        data_replicas_defined: ::std::os::raw::c_uint,
        metadata_replicas_required_defined: ::std::os::raw::c_uint,
        data_replicas_required_defined: ::std::os::raw::c_uint,
        encoded_extent_max_defined: ::std::os::raw::c_uint,
        metadata_checksum_defined: ::std::os::raw::c_uint,
        data_checksum_defined: ::std::os::raw::c_uint,
        checksum_err_retry_nr_defined: ::std::os::raw::c_uint,
        compression_defined: ::std::os::raw::c_uint,
        background_compression_defined: ::std::os::raw::c_uint,
        str_hash_defined: ::std::os::raw::c_uint,
        metadata_target_defined: ::std::os::raw::c_uint,
        foreground_target_defined: ::std::os::raw::c_uint,
        background_target_defined: ::std::os::raw::c_uint,
        promote_target_defined: ::std::os::raw::c_uint,
        erasure_code_defined: ::std::os::raw::c_uint,
        casefold_defined: ::std::os::raw::c_uint,
        casefold_disabled_defined: ::std::os::raw::c_uint,
        inodes_32bit_defined: ::std::os::raw::c_uint,
        shard_inode_numbers_bits_defined: ::std::os::raw::c_uint,
        btree_node_mem_ptr_optimization_defined: ::std::os::raw::c_uint,
        gc_reserve_percent_defined: ::std::os::raw::c_uint,
        gc_reserve_bytes_defined: ::std::os::raw::c_uint,
        root_reserve_percent_defined: ::std::os::raw::c_uint,
        wide_macs_defined: ::std::os::raw::c_uint,
        inline_data_defined: ::std::os::raw::c_uint,
        promote_whole_extents_defined: ::std::os::raw::c_uint,
        acl_defined: ::std::os::raw::c_uint,
        usrquota_defined: ::std::os::raw::c_uint,
        grpquota_defined: ::std::os::raw::c_uint,
        prjquota_defined: ::std::os::raw::c_uint,
        degraded_defined: ::std::os::raw::c_uint,
        mount_trusts_udev_defined: ::std::os::raw::c_uint,
        no_splitbrain_check_defined: ::std::os::raw::c_uint,
        no_version_check_defined: ::std::os::raw::c_uint,
        verbose_defined: ::std::os::raw::c_uint,
        journal_flush_delay_defined: ::std::os::raw::c_uint,
        journal_flush_disabled_defined: ::std::os::raw::c_uint,
        journal_reclaim_delay_defined: ::std::os::raw::c_uint,
        writeback_timeout_defined: ::std::os::raw::c_uint,
        move_bytes_in_flight_defined: ::std::os::raw::c_uint,
        move_ios_in_flight_defined: ::std::os::raw::c_uint,
        fsck_defined: ::std::os::raw::c_uint,
        fsck_memory_usage_percent_defined: ::std::os::raw::c_uint,
        fix_errors_defined: ::std::os::raw::c_uint,
        ratelimit_errors_defined: ::std::os::raw::c_uint,
        nochanges_defined: ::std::os::raw::c_uint,
        norecovery_defined: ::std::os::raw::c_uint,
        journal_rewind_defined: ::std::os::raw::c_uint,
        recovery_passes_defined: ::std::os::raw::c_uint,
        recovery_passes_exclude_defined: ::std::os::raw::c_uint,
        recovery_pass_last_defined: ::std::os::raw::c_uint,
        retain_recovery_info_defined: ::std::os::raw::c_uint,
        read_entire_journal_defined: ::std::os::raw::c_uint,
        read_journal_only_defined: ::std::os::raw::c_uint,
        journal_transaction_names_defined: ::std::os::raw::c_uint,
        allocator_stuck_timeout_defined: ::std::os::raw::c_uint,
        noexcl_defined: ::std::os::raw::c_uint,
        direct_io_defined: ::std::os::raw::c_uint,
        sb_defined: ::std::os::raw::c_uint,
        read_only_defined: ::std::os::raw::c_uint,
        nostart_defined: ::std::os::raw::c_uint,
        reconstruct_alloc_defined: ::std::os::raw::c_uint,
        version_upgrade_defined: ::std::os::raw::c_uint,
        stdio_defined: ::std::os::raw::c_uint,
        project_defined: ::std::os::raw::c_uint,
        nocow_defined: ::std::os::raw::c_uint,
        nocow_enabled_defined: ::std::os::raw::c_uint,
        copygc_enabled_defined: ::std::os::raw::c_uint,
        reconcile_enabled_defined: ::std::os::raw::c_uint,
        reconcile_on_ac_only_defined: ::std::os::raw::c_uint,
        auto_snapshot_deletion_defined: ::std::os::raw::c_uint,
        no_data_io_defined: ::std::os::raw::c_uint,
        state_defined: ::std::os::raw::c_uint,
        bucket_size_defined: ::std::os::raw::c_uint,
        durability_defined: ::std::os::raw::c_uint,
        data_allowed_defined: ::std::os::raw::c_uint,
        discard_defined: ::std::os::raw::c_uint,
        rotational_defined: ::std::os::raw::c_uint,
        btree_node_prefetch_defined: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 11usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 11usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let block_size_defined: u32 = unsafe {
                        ::std::mem::transmute(block_size_defined)
                    };
                    block_size_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                1usize,
                1u8,
                {
                    let btree_node_size_defined: u32 = unsafe {
                        ::std::mem::transmute(btree_node_size_defined)
                    };
                    btree_node_size_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                2usize,
                1u8,
                {
                    let errors_defined: u32 = unsafe {
                        ::std::mem::transmute(errors_defined)
                    };
                    errors_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                3usize,
                1u8,
                {
                    let write_error_timeout_defined: u32 = unsafe {
                        ::std::mem::transmute(write_error_timeout_defined)
                    };
                    write_error_timeout_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                4usize,
                1u8,
                {
                    let metadata_replicas_defined: u32 = unsafe {
                        ::std::mem::transmute(metadata_replicas_defined)
                    };
                    metadata_replicas_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                5usize,
                1u8,
                {
                    let data_replicas_defined: u32 = unsafe {
                        ::std::mem::transmute(data_replicas_defined)
                    };
                    data_replicas_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                6usize,
                1u8,
                {
                    let metadata_replicas_required_defined: u32 = unsafe {
                        ::std::mem::transmute(metadata_replicas_required_defined)
                    };
                    metadata_replicas_required_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                1u8,
                {
                    let data_replicas_required_defined: u32 = unsafe {
                        ::std::mem::transmute(data_replicas_required_defined)
                    };
                    data_replicas_required_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                8usize,
                1u8,
                {
                    let encoded_extent_max_defined: u32 = unsafe {
                        ::std::mem::transmute(encoded_extent_max_defined)
                    };
                    encoded_extent_max_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                9usize,
                1u8,
                {
                    let metadata_checksum_defined: u32 = unsafe {
                        ::std::mem::transmute(metadata_checksum_defined)
                    };
                    metadata_checksum_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                10usize,
                1u8,
                {
                    let data_checksum_defined: u32 = unsafe {
                        ::std::mem::transmute(data_checksum_defined)
                    };
                    data_checksum_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                11usize,
                1u8,
                {
                    let checksum_err_retry_nr_defined: u32 = unsafe {
                        ::std::mem::transmute(checksum_err_retry_nr_defined)
                    };
                    checksum_err_retry_nr_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                12usize,
                1u8,
                {
                    let compression_defined: u32 = unsafe {
                        ::std::mem::transmute(compression_defined)
                    };
                    compression_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                13usize,
                1u8,
                {
                    let background_compression_defined: u32 = unsafe {
                        ::std::mem::transmute(background_compression_defined)
                    };
                    background_compression_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                14usize,
                1u8,
                {
                    let str_hash_defined: u32 = unsafe {
                        ::std::mem::transmute(str_hash_defined)
                    };
                    str_hash_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                15usize,
                1u8,
                {
                    let metadata_target_defined: u32 = unsafe {
                        ::std::mem::transmute(metadata_target_defined)
                    };
                    metadata_target_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                16usize,
                1u8,
                {
                    let foreground_target_defined: u32 = unsafe {
                        ::std::mem::transmute(foreground_target_defined)
                    };
                    foreground_target_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                17usize,
                1u8,
                {
                    let background_target_defined: u32 = unsafe {
                        ::std::mem::transmute(background_target_defined)
                    };
                    background_target_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                18usize,
                1u8,
                {
                    let promote_target_defined: u32 = unsafe {
                        ::std::mem::transmute(promote_target_defined)
                    };
                    promote_target_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                19usize,
                1u8,
                {
                    let erasure_code_defined: u32 = unsafe {
                        ::std::mem::transmute(erasure_code_defined)
                    };
                    erasure_code_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                20usize,
                1u8,
                {
                    let casefold_defined: u32 = unsafe {
                        ::std::mem::transmute(casefold_defined)
                    };
                    casefold_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                21usize,
                1u8,
                {
                    let casefold_disabled_defined: u32 = unsafe {
                        ::std::mem::transmute(casefold_disabled_defined)
                    };
                    casefold_disabled_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                22usize,
                1u8,
                {
                    let inodes_32bit_defined: u32 = unsafe {
                        ::std::mem::transmute(inodes_32bit_defined)
                    };
                    inodes_32bit_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                23usize,
                1u8,
                {
                    let shard_inode_numbers_bits_defined: u32 = unsafe {
                        ::std::mem::transmute(shard_inode_numbers_bits_defined)
                    };
                    shard_inode_numbers_bits_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                24usize,
                1u8,
                {
                    let btree_node_mem_ptr_optimization_defined: u32 = unsafe {
                        ::std::mem::transmute(btree_node_mem_ptr_optimization_defined)
                    };
                    btree_node_mem_ptr_optimization_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                25usize,
                1u8,
                {
                    let gc_reserve_percent_defined: u32 = unsafe {
                        ::std::mem::transmute(gc_reserve_percent_defined)
                    };
                    gc_reserve_percent_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                26usize,
                1u8,
                {
                    let gc_reserve_bytes_defined: u32 = unsafe {
                        ::std::mem::transmute(gc_reserve_bytes_defined)
                    };
                    gc_reserve_bytes_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                27usize,
                1u8,
                {
                    let root_reserve_percent_defined: u32 = unsafe {
                        ::std::mem::transmute(root_reserve_percent_defined)
                    };
                    root_reserve_percent_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                28usize,
                1u8,
                {
                    let wide_macs_defined: u32 = unsafe {
                        ::std::mem::transmute(wide_macs_defined)
                    };
                    wide_macs_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                29usize,
                1u8,
                {
                    let inline_data_defined: u32 = unsafe {
                        ::std::mem::transmute(inline_data_defined)
                    };
                    inline_data_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                30usize,
                1u8,
                {
                    let promote_whole_extents_defined: u32 = unsafe {
                        ::std::mem::transmute(promote_whole_extents_defined)
                    };
                    promote_whole_extents_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                31usize,
                1u8,
                {
                    let acl_defined: u32 = unsafe { ::std::mem::transmute(acl_defined) };
                    acl_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                32usize,
                1u8,
                {
                    let usrquota_defined: u32 = unsafe {
                        ::std::mem::transmute(usrquota_defined)
                    };
                    usrquota_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                33usize,
                1u8,
                {
                    let grpquota_defined: u32 = unsafe {
                        ::std::mem::transmute(grpquota_defined)
                    };
                    grpquota_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                34usize,
                1u8,
                {
                    let prjquota_defined: u32 = unsafe {
                        ::std::mem::transmute(prjquota_defined)
                    };
                    prjquota_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                35usize,
                1u8,
                {
                    let degraded_defined: u32 = unsafe {
                        ::std::mem::transmute(degraded_defined)
                    };
                    degraded_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                36usize,
                1u8,
                {
                    let mount_trusts_udev_defined: u32 = unsafe {
                        ::std::mem::transmute(mount_trusts_udev_defined)
                    };
                    mount_trusts_udev_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                37usize,
                1u8,
                {
                    let no_splitbrain_check_defined: u32 = unsafe {
                        ::std::mem::transmute(no_splitbrain_check_defined)
                    };
                    no_splitbrain_check_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                38usize,
                1u8,
                {
                    let no_version_check_defined: u32 = unsafe {
                        ::std::mem::transmute(no_version_check_defined)
                    };
                    no_version_check_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                39usize,
                1u8,
                {
                    let verbose_defined: u32 = unsafe {
                        ::std::mem::transmute(verbose_defined)
                    };
                    verbose_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                40usize,
                1u8,
                {
                    let journal_flush_delay_defined: u32 = unsafe {
                        ::std::mem::transmute(journal_flush_delay_defined)
                    };
                    journal_flush_delay_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                41usize,
                1u8,
                {
                    let journal_flush_disabled_defined: u32 = unsafe {
                        ::std::mem::transmute(journal_flush_disabled_defined)
                    };
                    journal_flush_disabled_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                42usize,
                1u8,
                {
                    let journal_reclaim_delay_defined: u32 = unsafe {
                        ::std::mem::transmute(journal_reclaim_delay_defined)
                    };
                    journal_reclaim_delay_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                43usize,
                1u8,
                {
                    let writeback_timeout_defined: u32 = unsafe {
                        ::std::mem::transmute(writeback_timeout_defined)
                    };
                    writeback_timeout_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                44usize,
                1u8,
                {
                    let move_bytes_in_flight_defined: u32 = unsafe {
                        ::std::mem::transmute(move_bytes_in_flight_defined)
                    };
                    move_bytes_in_flight_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                45usize,
                1u8,
                {
                    let move_ios_in_flight_defined: u32 = unsafe {
                        ::std::mem::transmute(move_ios_in_flight_defined)
                    };
                    move_ios_in_flight_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                46usize,
                1u8,
                {
                    let fsck_defined: u32 = unsafe {
                        ::std::mem::transmute(fsck_defined)
                    };
                    fsck_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                47usize,
                1u8,
                {
                    let fsck_memory_usage_percent_defined: u32 = unsafe {
                        ::std::mem::transmute(fsck_memory_usage_percent_defined)
                    };
                    fsck_memory_usage_percent_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                48usize,
                1u8,
                {
                    let fix_errors_defined: u32 = unsafe {
                        ::std::mem::transmute(fix_errors_defined)
                    };
                    fix_errors_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                49usize,
                1u8,
                {
                    let ratelimit_errors_defined: u32 = unsafe {
                        ::std::mem::transmute(ratelimit_errors_defined)
                    };
                    ratelimit_errors_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                50usize,
                1u8,
                {
                    let nochanges_defined: u32 = unsafe {
                        ::std::mem::transmute(nochanges_defined)
                    };
                    nochanges_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                51usize,
                1u8,
                {
                    let norecovery_defined: u32 = unsafe {
                        ::std::mem::transmute(norecovery_defined)
                    };
                    norecovery_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                52usize,
                1u8,
                {
                    let journal_rewind_defined: u32 = unsafe {
                        ::std::mem::transmute(journal_rewind_defined)
                    };
                    journal_rewind_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                53usize,
                1u8,
                {
                    let recovery_passes_defined: u32 = unsafe {
                        ::std::mem::transmute(recovery_passes_defined)
                    };
                    recovery_passes_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                54usize,
                1u8,
                {
                    let recovery_passes_exclude_defined: u32 = unsafe {
                        ::std::mem::transmute(recovery_passes_exclude_defined)
                    };
                    recovery_passes_exclude_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                55usize,
                1u8,
                {
                    let recovery_pass_last_defined: u32 = unsafe {
                        ::std::mem::transmute(recovery_pass_last_defined)
                    };
                    recovery_pass_last_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                56usize,
                1u8,
                {
                    let retain_recovery_info_defined: u32 = unsafe {
                        ::std::mem::transmute(retain_recovery_info_defined)
                    };
                    retain_recovery_info_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                57usize,
                1u8,
                {
                    let read_entire_journal_defined: u32 = unsafe {
                        ::std::mem::transmute(read_entire_journal_defined)
                    };
                    read_entire_journal_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                58usize,
                1u8,
                {
                    let read_journal_only_defined: u32 = unsafe {
                        ::std::mem::transmute(read_journal_only_defined)
                    };
                    read_journal_only_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                59usize,
                1u8,
                {
                    let journal_transaction_names_defined: u32 = unsafe {
                        ::std::mem::transmute(journal_transaction_names_defined)
                    };
                    journal_transaction_names_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                60usize,
                1u8,
                {
                    let allocator_stuck_timeout_defined: u32 = unsafe {
                        ::std::mem::transmute(allocator_stuck_timeout_defined)
                    };
                    allocator_stuck_timeout_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                61usize,
                1u8,
                {
                    let noexcl_defined: u32 = unsafe {
                        ::std::mem::transmute(noexcl_defined)
                    };
                    noexcl_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                62usize,
                1u8,
                {
                    let direct_io_defined: u32 = unsafe {
                        ::std::mem::transmute(direct_io_defined)
                    };
                    direct_io_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                63usize,
                1u8,
                {
                    let sb_defined: u32 = unsafe { ::std::mem::transmute(sb_defined) };
                    sb_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                64usize,
                1u8,
                {
                    let read_only_defined: u32 = unsafe {
                        ::std::mem::transmute(read_only_defined)
                    };
                    read_only_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                65usize,
                1u8,
                {
                    let nostart_defined: u32 = unsafe {
                        ::std::mem::transmute(nostart_defined)
                    };
                    nostart_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                66usize,
                1u8,
                {
                    let reconstruct_alloc_defined: u32 = unsafe {
                        ::std::mem::transmute(reconstruct_alloc_defined)
                    };
                    reconstruct_alloc_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                67usize,
                1u8,
                {
                    let version_upgrade_defined: u32 = unsafe {
                        ::std::mem::transmute(version_upgrade_defined)
                    };
                    version_upgrade_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                68usize,
                1u8,
                {
                    let stdio_defined: u32 = unsafe {
                        ::std::mem::transmute(stdio_defined)
                    };
                    stdio_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                69usize,
                1u8,
                {
                    let project_defined: u32 = unsafe {
                        ::std::mem::transmute(project_defined)
                    };
                    project_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                70usize,
                1u8,
                {
                    let nocow_defined: u32 = unsafe {
                        ::std::mem::transmute(nocow_defined)
                    };
                    nocow_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                71usize,
                1u8,
                {
                    let nocow_enabled_defined: u32 = unsafe {
                        ::std::mem::transmute(nocow_enabled_defined)
                    };
                    nocow_enabled_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                72usize,
                1u8,
                {
                    let copygc_enabled_defined: u32 = unsafe {
                        ::std::mem::transmute(copygc_enabled_defined)
                    };
                    copygc_enabled_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                73usize,
                1u8,
                {
                    let reconcile_enabled_defined: u32 = unsafe {
                        ::std::mem::transmute(reconcile_enabled_defined)
                    };
                    reconcile_enabled_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                74usize,
                1u8,
                {
                    let reconcile_on_ac_only_defined: u32 = unsafe {
                        ::std::mem::transmute(reconcile_on_ac_only_defined)
                    };
                    reconcile_on_ac_only_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                75usize,
                1u8,
                {
                    let auto_snapshot_deletion_defined: u32 = unsafe {
                        ::std::mem::transmute(auto_snapshot_deletion_defined)
                    };
                    auto_snapshot_deletion_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                76usize,
                1u8,
                {
                    let no_data_io_defined: u32 = unsafe {
                        ::std::mem::transmute(no_data_io_defined)
                    };
                    no_data_io_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                77usize,
                1u8,
                {
                    let state_defined: u32 = unsafe {
                        ::std::mem::transmute(state_defined)
                    };
                    state_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                78usize,
                1u8,
                {
                    let bucket_size_defined: u32 = unsafe {
                        ::std::mem::transmute(bucket_size_defined)
                    };
                    bucket_size_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                79usize,
                1u8,
                {
                    let durability_defined: u32 = unsafe {
                        ::std::mem::transmute(durability_defined)
                    };
                    durability_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                80usize,
                1u8,
                {
                    let data_allowed_defined: u32 = unsafe {
                        ::std::mem::transmute(data_allowed_defined)
                    };
                    data_allowed_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                81usize,
                1u8,
                {
                    let discard_defined: u32 = unsafe {
                        ::std::mem::transmute(discard_defined)
                    };
                    discard_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                82usize,
                1u8,
                {
                    let rotational_defined: u32 = unsafe {
                        ::std::mem::transmute(rotational_defined)
                    };
                    rotational_defined as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                83usize,
                1u8,
                {
                    let btree_node_prefetch_defined: u32 = unsafe {
                        ::std::mem::transmute(btree_node_prefetch_defined)
                    };
                    btree_node_prefetch_defined as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub static bch2_opts_default: bch_opts;
}
extern "C" {
    pub fn bch2_opts_apply(arg1: *mut bch_opts, arg2: bch_opts);
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_opt_id {
    Opt_block_size = 0,
    Opt_btree_node_size = 1,
    Opt_errors = 2,
    Opt_write_error_timeout = 3,
    Opt_metadata_replicas = 4,
    Opt_data_replicas = 5,
    Opt_metadata_replicas_required = 6,
    Opt_data_replicas_required = 7,
    Opt_encoded_extent_max = 8,
    Opt_metadata_checksum = 9,
    Opt_data_checksum = 10,
    Opt_checksum_err_retry_nr = 11,
    Opt_compression = 12,
    Opt_background_compression = 13,
    Opt_str_hash = 14,
    Opt_metadata_target = 15,
    Opt_foreground_target = 16,
    Opt_background_target = 17,
    Opt_promote_target = 18,
    Opt_erasure_code = 19,
    Opt_casefold = 20,
    Opt_casefold_disabled = 21,
    Opt_inodes_32bit = 22,
    Opt_shard_inode_numbers_bits = 23,
    Opt_btree_node_mem_ptr_optimization = 24,
    Opt_gc_reserve_percent = 25,
    Opt_gc_reserve_bytes = 26,
    Opt_root_reserve_percent = 27,
    Opt_wide_macs = 28,
    Opt_inline_data = 29,
    Opt_promote_whole_extents = 30,
    Opt_acl = 31,
    Opt_usrquota = 32,
    Opt_grpquota = 33,
    Opt_prjquota = 34,
    Opt_degraded = 35,
    Opt_mount_trusts_udev = 36,
    Opt_no_splitbrain_check = 37,
    Opt_no_version_check = 38,
    Opt_verbose = 39,
    Opt_journal_flush_delay = 40,
    Opt_journal_flush_disabled = 41,
    Opt_journal_reclaim_delay = 42,
    Opt_writeback_timeout = 43,
    Opt_move_bytes_in_flight = 44,
    Opt_move_ios_in_flight = 45,
    Opt_fsck = 46,
    Opt_fsck_memory_usage_percent = 47,
    Opt_fix_errors = 48,
    Opt_ratelimit_errors = 49,
    Opt_nochanges = 50,
    Opt_norecovery = 51,
    Opt_journal_rewind = 52,
    Opt_recovery_passes = 53,
    Opt_recovery_passes_exclude = 54,
    Opt_recovery_pass_last = 55,
    Opt_retain_recovery_info = 56,
    Opt_read_entire_journal = 57,
    Opt_read_journal_only = 58,
    Opt_journal_transaction_names = 59,
    Opt_allocator_stuck_timeout = 60,
    Opt_noexcl = 61,
    Opt_direct_io = 62,
    Opt_sb = 63,
    Opt_read_only = 64,
    Opt_nostart = 65,
    Opt_reconstruct_alloc = 66,
    Opt_version_upgrade = 67,
    Opt_stdio = 68,
    Opt_project = 69,
    Opt_nocow = 70,
    Opt_nocow_enabled = 71,
    Opt_copygc_enabled = 72,
    Opt_reconcile_enabled = 73,
    Opt_reconcile_on_ac_only = 74,
    Opt_auto_snapshot_deletion = 75,
    Opt_no_data_io = 76,
    Opt_state = 77,
    Opt_bucket_size = 78,
    Opt_durability = 79,
    Opt_data_allowed = 80,
    Opt_discard = 81,
    Opt_rotational = 82,
    Opt_btree_node_prefetch = 83,
    bch2_opts_nr = 84,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bch_option {
    pub attr: attribute,
    pub type_: opt_type,
    pub flags: opt_flags,
    pub min: u64_,
    pub max: u64_,
    pub choices: *const *const ::std::os::raw::c_char,
    pub fn_: bch_opt_fn,
    pub hint: *const ::std::os::raw::c_char,
    pub help: *const ::std::os::raw::c_char,
    pub get_sb: ::std::option::Option<unsafe extern "C" fn(arg1: *const bch_sb) -> u64_>,
    pub set_sb: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut bch_sb, arg2: u64_),
    >,
    pub get_member: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const bch_member) -> u64_,
    >,
    pub set_member: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut bch_member, arg2: u64_),
    >,
}
#[test]
fn bindgen_test_layout_bch_option() {
    const UNINIT: ::std::mem::MaybeUninit<bch_option> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_option>(),
        120usize,
        concat!("Size of: ", stringify!(bch_option)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_option>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_option)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).attr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(attr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(type_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(min)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(max)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).choices) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(choices)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fn_) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(fn_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hint) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(hint)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).help) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(help)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_sb) as usize - ptr as usize },
        88usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(get_sb)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_sb) as usize - ptr as usize },
        96usize,
        concat!("Offset of field: ", stringify!(bch_option), "::", stringify!(set_sb)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_member) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_option),
            "::",
            stringify!(get_member),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set_member) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_option),
            "::",
            stringify!(set_member),
        ),
    );
}
impl Default for bch_option {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static bch2_opt_table: [bch_option; 0usize];
}
extern "C" {
    pub fn bch2_opt_defined_by_id(arg1: *const bch_opts, arg2: bch_opt_id) -> bool;
}
extern "C" {
    pub fn bch2_opt_get_by_id(arg1: *const bch_opts, arg2: bch_opt_id) -> u64_;
}
extern "C" {
    pub fn bch2_opt_set_by_id(arg1: *mut bch_opts, arg2: bch_opt_id, arg3: u64_);
}
extern "C" {
    pub fn bch2_opt_from_sb(
        arg1: *mut bch_sb,
        arg2: bch_opt_id,
        arg3: ::std::os::raw::c_int,
    ) -> u64_;
}
extern "C" {
    pub fn bch2_opts_from_sb(
        arg1: *mut bch_opts,
        arg2: *mut bch_sb,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __bch2_opt_set_sb(
        arg1: *mut bch_sb,
        arg2: ::std::os::raw::c_int,
        arg3: *const bch_option,
        arg4: u64_,
    ) -> bool;
}
extern "C" {
    pub fn bch2_opt_set_sb(
        arg1: *mut bch_fs,
        arg2: *mut bch_dev,
        arg3: *const bch_option,
        arg4: u64_,
    ) -> bool;
}
extern "C" {
    pub fn bch2_opt_lookup(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_opt_validate(
        arg1: *const bch_option,
        arg2: u64_,
        arg3: *mut printbuf,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_opt_parse(
        arg1: *mut bch_fs,
        arg2: *const bch_option,
        arg3: *const ::std::os::raw::c_char,
        arg4: *mut u64_,
        arg5: *mut printbuf,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_opt_to_text(
        arg1: *mut printbuf,
        arg2: *mut bch_fs,
        arg3: *mut bch_sb,
        arg4: *const bch_option,
        arg5: u64_,
        arg6: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bch2_opts_to_text(
        arg1: *mut printbuf,
        arg2: bch_opts,
        arg3: *mut bch_fs,
        arg4: *mut bch_sb,
        arg5: ::std::os::raw::c_uint,
        arg6: ::std::os::raw::c_uint,
        arg7: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn bch2_opt_hook_pre_set(
        arg1: *mut bch_fs,
        arg2: *mut bch_dev,
        arg3: u64_,
        arg4: bch_opt_id,
        arg5: u64_,
        arg6: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_opts_hooks_pre_set(arg1: *mut bch_fs) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_opt_hook_post_set(
        arg1: *mut bch_fs,
        arg2: *mut bch_dev,
        arg3: u64_,
        arg4: bch_opt_id,
        arg5: u64_,
    );
}
extern "C" {
    pub fn bch2_parse_one_mount_opt(
        arg1: *mut bch_fs,
        arg2: *mut bch_opts,
        arg3: *mut printbuf,
        arg4: *const ::std::os::raw::c_char,
        arg5: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bch2_parse_mount_opts(
        arg1: *mut bch_fs,
        arg2: *mut bch_opts,
        arg3: *mut printbuf,
        arg4: *mut ::std::os::raw::c_char,
        arg5: bool,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_inode_opts {
    pub data_checksum: u8_,
    pub compression: u8_,
    pub project: u32_,
    pub background_compression: u8_,
    pub data_replicas: u8_,
    pub promote_target: u16_,
    pub foreground_target: u16_,
    pub background_target: u16_,
    pub erasure_code: u16_,
    pub nocow: u8_,
    pub inodes_32bit: u8_,
    pub casefold: u8_,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub change_cookie: u32_,
}
#[test]
fn bindgen_test_layout_bch_inode_opts() {
    const UNINIT: ::std::mem::MaybeUninit<bch_inode_opts> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_inode_opts>(),
        32usize,
        concat!("Size of: ", stringify!(bch_inode_opts)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_inode_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_inode_opts)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_checksum) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(data_checksum),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compression) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(compression),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).project) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(project),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).background_compression) as usize - ptr as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(background_compression),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_replicas) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(data_replicas),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).promote_target) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(promote_target),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).foreground_target) as usize - ptr as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(foreground_target),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).background_target) as usize - ptr as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(background_target),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).erasure_code) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(erasure_code),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nocow) as usize - ptr as usize },
        18usize,
        concat!("Offset of field: ", stringify!(bch_inode_opts), "::", stringify!(nocow)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inodes_32bit) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(inodes_32bit),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).casefold) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(casefold),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).change_cookie) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_inode_opts),
            "::",
            stringify!(change_cookie),
        ),
    );
}
impl bch_inode_opts {
    #[inline]
    pub fn data_checksum_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_data_checksum_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn compression_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_compression_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn project_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_project_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn background_compression_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_background_compression_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_replicas_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_data_replicas_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn promote_target_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_promote_target_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn foreground_target_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_foreground_target_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn background_target_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_background_target_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn erasure_code_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_erasure_code_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nocow_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_nocow_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn inodes_32bit_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_inodes_32bit_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn casefold_from_inode(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_casefold_from_inode(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        data_checksum_from_inode: u64_,
        compression_from_inode: u64_,
        project_from_inode: u64_,
        background_compression_from_inode: u64_,
        data_replicas_from_inode: u64_,
        promote_target_from_inode: u64_,
        foreground_target_from_inode: u64_,
        background_target_from_inode: u64_,
        erasure_code_from_inode: u64_,
        nocow_from_inode: u64_,
        inodes_32bit_from_inode: u64_,
        casefold_from_inode: u64_,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let data_checksum_from_inode: u64 = unsafe {
                        ::std::mem::transmute(data_checksum_from_inode)
                    };
                    data_checksum_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                1usize,
                1u8,
                {
                    let compression_from_inode: u64 = unsafe {
                        ::std::mem::transmute(compression_from_inode)
                    };
                    compression_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                2usize,
                1u8,
                {
                    let project_from_inode: u64 = unsafe {
                        ::std::mem::transmute(project_from_inode)
                    };
                    project_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                3usize,
                1u8,
                {
                    let background_compression_from_inode: u64 = unsafe {
                        ::std::mem::transmute(background_compression_from_inode)
                    };
                    background_compression_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                4usize,
                1u8,
                {
                    let data_replicas_from_inode: u64 = unsafe {
                        ::std::mem::transmute(data_replicas_from_inode)
                    };
                    data_replicas_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                5usize,
                1u8,
                {
                    let promote_target_from_inode: u64 = unsafe {
                        ::std::mem::transmute(promote_target_from_inode)
                    };
                    promote_target_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                6usize,
                1u8,
                {
                    let foreground_target_from_inode: u64 = unsafe {
                        ::std::mem::transmute(foreground_target_from_inode)
                    };
                    foreground_target_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                1u8,
                {
                    let background_target_from_inode: u64 = unsafe {
                        ::std::mem::transmute(background_target_from_inode)
                    };
                    background_target_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                8usize,
                1u8,
                {
                    let erasure_code_from_inode: u64 = unsafe {
                        ::std::mem::transmute(erasure_code_from_inode)
                    };
                    erasure_code_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                9usize,
                1u8,
                {
                    let nocow_from_inode: u64 = unsafe {
                        ::std::mem::transmute(nocow_from_inode)
                    };
                    nocow_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                10usize,
                1u8,
                {
                    let inodes_32bit_from_inode: u64 = unsafe {
                        ::std::mem::transmute(inodes_32bit_from_inode)
                    };
                    inodes_32bit_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                11usize,
                1u8,
                {
                    let casefold_from_inode: u64 = unsafe {
                        ::std::mem::transmute(casefold_from_inode)
                    };
                    casefold_from_inode as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn bch2_inode_opts_get(arg1: *mut bch_fs, arg2: *mut bch_inode_opts, arg3: bool);
}
extern "C" {
    pub fn bch2_opt_is_inode_opt(arg1: bch_opt_id) -> bool;
}
extern "C" {
    pub fn bch2_inode_opts_to_text(
        arg1: *mut printbuf,
        arg2: *mut bch_fs,
        arg3: bch_inode_opts,
    );
}
pub type percpu_ref_func_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut percpu_ref),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct percpu_ref {
    pub count: atomic_long_t,
    pub release: percpu_ref_func_t,
    pub confirm_switch: percpu_ref_func_t,
}
#[test]
fn bindgen_test_layout_percpu_ref() {
    const UNINIT: ::std::mem::MaybeUninit<percpu_ref> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<percpu_ref>(),
        24usize,
        concat!("Size of: ", stringify!(percpu_ref)),
    );
    assert_eq!(
        ::std::mem::align_of::<percpu_ref>(),
        8usize,
        concat!("Alignment of ", stringify!(percpu_ref)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(percpu_ref), "::", stringify!(count)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).release) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(percpu_ref), "::", stringify!(release)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).confirm_switch) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(percpu_ref),
            "::",
            stringify!(confirm_switch),
        ),
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct percpu_rw_semaphore {
    pub lock: pthread_mutex_t,
}
#[test]
fn bindgen_test_layout_percpu_rw_semaphore() {
    const UNINIT: ::std::mem::MaybeUninit<percpu_rw_semaphore> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<percpu_rw_semaphore>(),
        40usize,
        concat!("Size of: ", stringify!(percpu_rw_semaphore)),
    );
    assert_eq!(
        ::std::mem::align_of::<percpu_rw_semaphore>(),
        8usize,
        concat!("Alignment of ", stringify!(percpu_rw_semaphore)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(percpu_rw_semaphore),
            "::",
            stringify!(lock),
        ),
    );
}
impl Default for percpu_rw_semaphore {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
/** typedef refcount_t - variant of atomic_t specialized for reference counts
 @refs: atomic_t counter field

 The counter saturates at REFCOUNT_SATURATED and will not move once
 there. This avoids wrapping the counter and causing 'spurious'
 use-after-free bugs.*/
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct refcount_struct {
    pub refs: atomic_t,
}
#[test]
fn bindgen_test_layout_refcount_struct() {
    const UNINIT: ::std::mem::MaybeUninit<refcount_struct> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<refcount_struct>(),
        4usize,
        concat!("Size of: ", stringify!(refcount_struct)),
    );
    assert_eq!(
        ::std::mem::align_of::<refcount_struct>(),
        4usize,
        concat!("Alignment of ", stringify!(refcount_struct)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).refs) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(refcount_struct), "::", stringify!(refs)),
    );
}
/** typedef refcount_t - variant of atomic_t specialized for reference counts
 @refs: atomic_t counter field

 The counter saturates at REFCOUNT_SATURATED and will not move once
 there. This avoids wrapping the counter and causing 'spurious'
 use-after-free bugs.*/
pub type refcount_t = refcount_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cds_wfcq_node {
    pub next: *mut cds_wfcq_node,
}
#[test]
fn bindgen_test_layout_cds_wfcq_node() {
    const UNINIT: ::std::mem::MaybeUninit<cds_wfcq_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cds_wfcq_node>(),
        8usize,
        concat!("Size of: ", stringify!(cds_wfcq_node)),
    );
    assert_eq!(
        ::std::mem::align_of::<cds_wfcq_node>(),
        8usize,
        concat!("Alignment of ", stringify!(cds_wfcq_node)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cds_wfcq_node), "::", stringify!(next)),
    );
}
impl Default for cds_wfcq_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rcu_head {
    pub next: cds_wfcq_node,
    pub func: ::std::option::Option<unsafe extern "C" fn(head: *mut rcu_head)>,
}
#[test]
fn bindgen_test_layout_rcu_head() {
    const UNINIT: ::std::mem::MaybeUninit<rcu_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rcu_head>(),
        16usize,
        concat!("Size of: ", stringify!(rcu_head)),
    );
    assert_eq!(
        ::std::mem::align_of::<rcu_head>(),
        8usize,
        concat!("Alignment of ", stringify!(rcu_head)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(rcu_head), "::", stringify!(next)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).func) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(rcu_head), "::", stringify!(func)),
    );
}
impl Default for rcu_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rhash_head {
    pub next: *mut rhash_head,
}
#[test]
fn bindgen_test_layout_rhash_head() {
    const UNINIT: ::std::mem::MaybeUninit<rhash_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rhash_head>(),
        8usize,
        concat!("Size of: ", stringify!(rhash_head)),
    );
    assert_eq!(
        ::std::mem::align_of::<rhash_head>(),
        8usize,
        concat!("Alignment of ", stringify!(rhash_head)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(rhash_head), "::", stringify!(next)),
    );
}
impl Default for rhash_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
/** struct rhashtable_compare_arg - Key for the function rhashtable_compare
 @ht: Hash table
 @key: Key to compare against*/
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rhashtable_compare_arg {
    pub ht: *mut rhashtable,
    pub key: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_rhashtable_compare_arg() {
    const UNINIT: ::std::mem::MaybeUninit<rhashtable_compare_arg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rhashtable_compare_arg>(),
        16usize,
        concat!("Size of: ", stringify!(rhashtable_compare_arg)),
    );
    assert_eq!(
        ::std::mem::align_of::<rhashtable_compare_arg>(),
        8usize,
        concat!("Alignment of ", stringify!(rhashtable_compare_arg)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ht) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_compare_arg),
            "::",
            stringify!(ht),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_compare_arg),
            "::",
            stringify!(key),
        ),
    );
}
impl Default for rhashtable_compare_arg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type rht_hashfn_t = ::std::option::Option<
    unsafe extern "C" fn(
        data: *const ::std::os::raw::c_void,
        len: u32_,
        seed: u32_,
    ) -> u32_,
>;
pub type rht_obj_hashfn_t = ::std::option::Option<
    unsafe extern "C" fn(
        data: *const ::std::os::raw::c_void,
        len: u32_,
        seed: u32_,
    ) -> u32_,
>;
pub type rht_obj_cmpfn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg: *mut rhashtable_compare_arg,
        obj: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
/** struct rhashtable_params - Hash table construction parameters
 @nelem_hint: Hint on number of elements, should be 75% of desired size
 @key_len: Length of key
 @key_offset: Offset of key in struct to be hashed
 @head_offset: Offset of rhash_head in struct to be hashed
 @max_size: Maximum size while expanding
 @min_size: Minimum size while shrinking
 @automatic_shrinking: Enable automatic shrinking of tables
 @hashfn: Hash function (default: jhash2 if !(key_len % 4), or jhash)
 @obj_hashfn: Function to hash object
 @obj_cmpfn: Function to compare key with object*/
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rhashtable_params {
    pub nelem_hint: u16_,
    pub key_len: u16_,
    pub key_offset: u16_,
    pub head_offset: u16_,
    pub max_size: ::std::os::raw::c_uint,
    pub min_size: u16_,
    pub automatic_shrinking: bool,
    pub hashfn: rht_hashfn_t,
    pub obj_hashfn: rht_obj_hashfn_t,
    pub obj_cmpfn: rht_obj_cmpfn_t,
}
#[test]
fn bindgen_test_layout_rhashtable_params() {
    const UNINIT: ::std::mem::MaybeUninit<rhashtable_params> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rhashtable_params>(),
        40usize,
        concat!("Size of: ", stringify!(rhashtable_params)),
    );
    assert_eq!(
        ::std::mem::align_of::<rhashtable_params>(),
        8usize,
        concat!("Alignment of ", stringify!(rhashtable_params)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nelem_hint) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(nelem_hint),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_len) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(key_len),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_offset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(key_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).head_offset) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(head_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(max_size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(min_size),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).automatic_shrinking) as usize - ptr as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(automatic_shrinking),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hashfn) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(hashfn),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).obj_hashfn) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(obj_hashfn),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).obj_cmpfn) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rhashtable_params),
            "::",
            stringify!(obj_cmpfn),
        ),
    );
}
/** struct rhashtable - Hash table handle
 @tbl: Bucket table
 @key_len: Key length for hashfn
 @max_elems: Maximum number of elements in table
 @p: Configuration parameters
 @rhlist: True if this is an rhltable
 @run_work: Deferred worker to expand/shrink asynchronously
 @mutex: Mutex to protect current/future table swapping
 @lock: Spin lock to protect walker list
 @nelems: Number of elements in table*/
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rhashtable {
    pub tbl: *mut bucket_table,
    pub key_len: ::std::os::raw::c_uint,
    pub max_elems: ::std::os::raw::c_uint,
    pub p: rhashtable_params,
    pub rhlist: bool,
    pub run_work: work_struct,
    pub mutex: mutex,
    pub lock: spinlock_t,
    pub nelems: atomic_t,
}
#[test]
fn bindgen_test_layout_rhashtable() {
    const UNINIT: ::std::mem::MaybeUninit<rhashtable> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rhashtable>(),
        184usize,
        concat!("Size of: ", stringify!(rhashtable)),
    );
    assert_eq!(
        ::std::mem::align_of::<rhashtable>(),
        8usize,
        concat!("Alignment of ", stringify!(rhashtable)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tbl) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(rhashtable), "::", stringify!(tbl)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_len) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(rhashtable), "::", stringify!(key_len)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_elems) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(rhashtable), "::", stringify!(max_elems)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).p) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(rhashtable), "::", stringify!(p)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rhlist) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(rhashtable), "::", stringify!(rhlist)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).run_work) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(rhashtable), "::", stringify!(run_work)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mutex) as usize - ptr as usize },
        96usize,
        concat!("Offset of field: ", stringify!(rhashtable), "::", stringify!(mutex)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        136usize,
        concat!("Offset of field: ", stringify!(rhashtable), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nelems) as usize - ptr as usize },
        176usize,
        concat!("Offset of field: ", stringify!(rhashtable), "::", stringify!(nelems)),
    );
}
impl Default for rhashtable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
/** struct rhltable - Hash table with duplicate objects in a list
 @ht: Underlying rhtable*/
#[repr(C)]
#[derive(Copy, Clone)]
pub struct rhltable {
    pub ht: rhashtable,
}
#[test]
fn bindgen_test_layout_rhltable() {
    const UNINIT: ::std::mem::MaybeUninit<rhltable> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rhltable>(),
        184usize,
        concat!("Size of: ", stringify!(rhltable)),
    );
    assert_eq!(
        ::std::mem::align_of::<rhltable>(),
        8usize,
        concat!("Alignment of ", stringify!(rhltable)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ht) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(rhltable), "::", stringify!(ht)),
    );
}
impl Default for rhltable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
/** struct bucket_table - Table of hash buckets
 @size: Number of hash buckets
 @nest: Number of bits of first-level nested table.
 @rehash: Current bucket being rehashed
 @hash_rnd: Random seed to fold into hash
 @walkers: List of active walkers
 @rcu: RCU structure for freeing the table
 @future_tbl: Table under construction during rehashing
 @ntbl: Nested table used when out of memory.
 @buckets: size * hash buckets*/
#[repr(C)]
#[repr(align(64))]
#[derive(Debug)]
pub struct bucket_table {
    pub size: ::std::os::raw::c_uint,
    pub nest: ::std::os::raw::c_uint,
    pub hash_rnd: u32_,
    pub walkers: cds_list_head,
    pub rcu: rcu_head,
    pub future_tbl: *mut bucket_table,
    pub __bindgen_padding_0: u64,
    pub buckets: __IncompleteArrayField<*mut rhash_lock_head>,
}
#[test]
fn bindgen_test_layout_bucket_table() {
    const UNINIT: ::std::mem::MaybeUninit<bucket_table> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bucket_table>(),
        64usize,
        concat!("Size of: ", stringify!(bucket_table)),
    );
    assert_eq!(
        ::std::mem::align_of::<bucket_table>(),
        64usize,
        concat!("Alignment of ", stringify!(bucket_table)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bucket_table), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nest) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bucket_table), "::", stringify!(nest)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hash_rnd) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bucket_table),
            "::",
            stringify!(hash_rnd),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).walkers) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bucket_table), "::", stringify!(walkers)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rcu) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(bucket_table), "::", stringify!(rcu)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).future_tbl) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bucket_table),
            "::",
            stringify!(future_tbl),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buckets) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(bucket_table), "::", stringify!(buckets)),
    );
}
impl Default for bucket_table {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct semaphore {
    pub lock: raw_spinlock_t,
    pub count: ::std::os::raw::c_uint,
    pub wait_list: cds_list_head,
}
#[test]
fn bindgen_test_layout_semaphore() {
    const UNINIT: ::std::mem::MaybeUninit<semaphore> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<semaphore>(),
        64usize,
        concat!("Size of: ", stringify!(semaphore)),
    );
    assert_eq!(
        ::std::mem::align_of::<semaphore>(),
        8usize,
        concat!("Alignment of ", stringify!(semaphore)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(semaphore), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(semaphore), "::", stringify!(count)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait_list) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(semaphore), "::", stringify!(wait_list)),
    );
}
impl Default for semaphore {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct seqcount {
    pub sequence: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_seqcount() {
    const UNINIT: ::std::mem::MaybeUninit<seqcount> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<seqcount>(),
        4usize,
        concat!("Size of: ", stringify!(seqcount)),
    );
    assert_eq!(
        ::std::mem::align_of::<seqcount>(),
        4usize,
        concat!("Alignment of ", stringify!(seqcount)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sequence) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(seqcount), "::", stringify!(sequence)),
    );
}
pub type seqcount_t = seqcount;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct utf8data {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct utf8data_table {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct unicode_map {
    pub version: ::std::os::raw::c_uint,
    pub ntab: [*const utf8data; 2usize],
    pub tables: *const utf8data_table,
}
#[test]
fn bindgen_test_layout_unicode_map() {
    const UNINIT: ::std::mem::MaybeUninit<unicode_map> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<unicode_map>(),
        32usize,
        concat!("Size of: ", stringify!(unicode_map)),
    );
    assert_eq!(
        ::std::mem::align_of::<unicode_map>(),
        8usize,
        concat!("Alignment of ", stringify!(unicode_map)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(unicode_map), "::", stringify!(version)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ntab) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(unicode_map), "::", stringify!(ntab)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tables) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(unicode_map), "::", stringify!(tables)),
    );
}
impl Default for unicode_map {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct min_heap_char {
    pub nr: usize,
    pub size: usize,
    pub data: *mut ::std::os::raw::c_char,
    pub preallocated: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[test]
fn bindgen_test_layout_min_heap_char() {
    const UNINIT: ::std::mem::MaybeUninit<min_heap_char> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<min_heap_char>(),
        24usize,
        concat!("Size of: ", stringify!(min_heap_char)),
    );
    assert_eq!(
        ::std::mem::align_of::<min_heap_char>(),
        8usize,
        concat!("Alignment of ", stringify!(min_heap_char)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(min_heap_char), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(min_heap_char), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(min_heap_char), "::", stringify!(data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(min_heap_char),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for min_heap_char {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
/** struct min_heap_callbacks - Data/functions to customise the min_heap.
 @less: Partial order function for this heap.
 @swp: Swap elements function.*/
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct min_heap_callbacks {
    pub less: ::std::option::Option<
        unsafe extern "C" fn(
            lhs: *const ::std::os::raw::c_void,
            rhs: *const ::std::os::raw::c_void,
            args: *mut ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub swp: ::std::option::Option<
        unsafe extern "C" fn(
            lhs: *mut ::std::os::raw::c_void,
            rhs: *mut ::std::os::raw::c_void,
            args: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout_min_heap_callbacks() {
    const UNINIT: ::std::mem::MaybeUninit<min_heap_callbacks> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<min_heap_callbacks>(),
        16usize,
        concat!("Size of: ", stringify!(min_heap_callbacks)),
    );
    assert_eq!(
        ::std::mem::align_of::<min_heap_callbacks>(),
        8usize,
        concat!("Alignment of ", stringify!(min_heap_callbacks)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).less) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(min_heap_callbacks),
            "::",
            stringify!(less),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).swp) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(min_heap_callbacks),
            "::",
            stringify!(swp),
        ),
    );
}
extern "C" {
    pub fn __bch2_min_heap_init(
        heap: *mut min_heap_char,
        data: *mut ::std::os::raw::c_void,
        size: usize,
    );
}
extern "C" {
    pub fn __bch2_min_heap_peek(heap: *mut min_heap_char) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn __bch2_min_heap_full(heap: *mut min_heap_char) -> bool;
}
extern "C" {
    pub fn __bch2_min_heap_sift_down(
        heap: *mut min_heap_char,
        pos: usize,
        elem_size: usize,
        func: *const min_heap_callbacks,
        args: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn __bch2_min_heap_sift_up(
        heap: *mut min_heap_char,
        elem_size: usize,
        idx: usize,
        func: *const min_heap_callbacks,
        args: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn __bch2_min_heapify_all(
        heap: *mut min_heap_char,
        elem_size: usize,
        func: *const min_heap_callbacks,
        args: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn __bch2_min_heap_pop(
        heap: *mut min_heap_char,
        elem_size: usize,
        func: *const min_heap_callbacks,
        args: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn __bch2_min_heap_pop_push(
        heap: *mut min_heap_char,
        element: *const ::std::os::raw::c_void,
        elem_size: usize,
        func: *const min_heap_callbacks,
        args: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn __bch2_min_heap_push(
        heap: *mut min_heap_char,
        element: *const ::std::os::raw::c_void,
        elem_size: usize,
        func: *const min_heap_callbacks,
        args: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn __bch2_min_heap_del(
        heap: *mut min_heap_char,
        elem_size: usize,
        idx: usize,
        func: *const min_heap_callbacks,
        args: *mut ::std::os::raw::c_void,
    ) -> bool;
}
pub type io_timer_fn = ::std::option::Option<unsafe extern "C" fn(arg1: *mut io_timer)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct io_timer {
    pub fn_: io_timer_fn,
    pub fn2: *mut ::std::os::raw::c_void,
    pub expire: u64_,
}
#[test]
fn bindgen_test_layout_io_timer() {
    const UNINIT: ::std::mem::MaybeUninit<io_timer> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<io_timer>(),
        24usize,
        concat!("Size of: ", stringify!(io_timer)),
    );
    assert_eq!(
        ::std::mem::align_of::<io_timer>(),
        8usize,
        concat!("Alignment of ", stringify!(io_timer)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fn_) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(io_timer), "::", stringify!(fn_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fn2) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(io_timer), "::", stringify!(fn2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).expire) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(io_timer), "::", stringify!(expire)),
    );
}
impl Default for io_timer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct io_timer_heap {
    pub nr: usize,
    pub size: usize,
    pub data: *mut *mut io_timer,
    pub preallocated: __IncompleteArrayField<*mut io_timer>,
}
#[test]
fn bindgen_test_layout_io_timer_heap() {
    const UNINIT: ::std::mem::MaybeUninit<io_timer_heap> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<io_timer_heap>(),
        24usize,
        concat!("Size of: ", stringify!(io_timer_heap)),
    );
    assert_eq!(
        ::std::mem::align_of::<io_timer_heap>(),
        8usize,
        concat!("Alignment of ", stringify!(io_timer_heap)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(io_timer_heap), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(io_timer_heap), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(io_timer_heap), "::", stringify!(data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(io_timer_heap),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for io_timer_heap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct io_clock {
    pub now: atomic64_t,
    pub pcpu_buf: *mut u16_,
    pub max_slop: ::std::os::raw::c_uint,
    pub timer_lock: spinlock_t,
    pub timers: io_timer_heap,
}
#[test]
fn bindgen_test_layout_io_clock() {
    const UNINIT: ::std::mem::MaybeUninit<io_clock> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<io_clock>(),
        88usize,
        concat!("Size of: ", stringify!(io_clock)),
    );
    assert_eq!(
        ::std::mem::align_of::<io_clock>(),
        8usize,
        concat!("Alignment of ", stringify!(io_clock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).now) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(io_clock), "::", stringify!(now)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pcpu_buf) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(io_clock), "::", stringify!(pcpu_buf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_slop) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(io_clock), "::", stringify!(max_slop)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timer_lock) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(io_clock), "::", stringify!(timer_lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timers) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(io_clock), "::", stringify!(timers)),
    );
}
impl Default for io_clock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct enumerated_ref {
    pub ref_: percpu_ref,
    pub stop_fn: ::std::option::Option<unsafe extern "C" fn(arg1: *mut enumerated_ref)>,
    pub stop_complete: completion,
}
#[test]
fn bindgen_test_layout_enumerated_ref() {
    const UNINIT: ::std::mem::MaybeUninit<enumerated_ref> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<enumerated_ref>(),
        96usize,
        concat!("Size of: ", stringify!(enumerated_ref)),
    );
    assert_eq!(
        ::std::mem::align_of::<enumerated_ref>(),
        8usize,
        concat!("Alignment of ", stringify!(enumerated_ref)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ref_) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(enumerated_ref), "::", stringify!(ref_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stop_fn) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(enumerated_ref),
            "::",
            stringify!(stop_fn),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stop_complete) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(enumerated_ref),
            "::",
            stringify!(stop_complete),
        ),
    );
}
impl Default for enumerated_ref {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct genradix_root {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __genradix {
    pub root: *mut genradix_root,
}
#[test]
fn bindgen_test_layout___genradix() {
    const UNINIT: ::std::mem::MaybeUninit<__genradix> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__genradix>(),
        8usize,
        concat!("Size of: ", stringify!(__genradix)),
    );
    assert_eq!(
        ::std::mem::align_of::<__genradix>(),
        8usize,
        concat!("Alignment of ", stringify!(__genradix)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).root) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(__genradix), "::", stringify!(root)),
    );
}
impl Default for __genradix {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct seqmutex {
    pub lock: mutex,
    pub seq: u32_,
}
#[test]
fn bindgen_test_layout_seqmutex() {
    const UNINIT: ::std::mem::MaybeUninit<seqmutex> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<seqmutex>(),
        48usize,
        concat!("Size of: ", stringify!(seqmutex)),
    );
    assert_eq!(
        ::std::mem::align_of::<seqmutex>(),
        8usize,
        concat!("Alignment of ", stringify!(seqmutex)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(seqmutex), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(seqmutex), "::", stringify!(seq)),
    );
}
impl Default for seqmutex {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct stdio_buf {
    pub lock: spinlock_t,
    pub wait: wait_queue_head_t,
    pub buf: darray_char,
    pub waiting_for_line: bool,
}
#[test]
fn bindgen_test_layout_stdio_buf() {
    const UNINIT: ::std::mem::MaybeUninit<stdio_buf> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<stdio_buf>(),
        128usize,
        concat!("Size of: ", stringify!(stdio_buf)),
    );
    assert_eq!(
        ::std::mem::align_of::<stdio_buf>(),
        8usize,
        concat!("Alignment of ", stringify!(stdio_buf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(stdio_buf), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(stdio_buf), "::", stringify!(wait)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf) as usize - ptr as usize },
        96usize,
        concat!("Offset of field: ", stringify!(stdio_buf), "::", stringify!(buf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).waiting_for_line) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(stdio_buf),
            "::",
            stringify!(waiting_for_line),
        ),
    );
}
impl Default for stdio_buf {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct stdio_redirect {
    pub input: stdio_buf,
    pub output: stdio_buf,
    pub done: bool,
}
#[test]
fn bindgen_test_layout_stdio_redirect() {
    const UNINIT: ::std::mem::MaybeUninit<stdio_redirect> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<stdio_redirect>(),
        264usize,
        concat!("Size of: ", stringify!(stdio_redirect)),
    );
    assert_eq!(
        ::std::mem::align_of::<stdio_redirect>(),
        8usize,
        concat!("Alignment of ", stringify!(stdio_redirect)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).input) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(stdio_redirect), "::", stringify!(input)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).output) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(stdio_redirect),
            "::",
            stringify!(output),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).done) as usize - ptr as usize },
        256usize,
        concat!("Offset of field: ", stringify!(stdio_redirect), "::", stringify!(done)),
    );
}
impl Default for stdio_redirect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct accounting_mem_entry {
    pub pos: bpos,
    pub bversion: bversion,
    pub nr_counters: ::std::os::raw::c_uint,
    pub v: [*mut u64_; 2usize],
}
#[test]
fn bindgen_test_layout_accounting_mem_entry() {
    const UNINIT: ::std::mem::MaybeUninit<accounting_mem_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<accounting_mem_entry>(),
        56usize,
        concat!("Size of: ", stringify!(accounting_mem_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<accounting_mem_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(accounting_mem_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(accounting_mem_entry),
            "::",
            stringify!(pos),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bversion) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(accounting_mem_entry),
            "::",
            stringify!(bversion),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_counters) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(accounting_mem_entry),
            "::",
            stringify!(nr_counters),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(accounting_mem_entry),
            "::",
            stringify!(v),
        ),
    );
}
impl Default for accounting_mem_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_accounting_mem {
    pub k: bch_accounting_mem__bindgen_ty_1,
    pub gc_running: bool,
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_accounting_mem__bindgen_ty_1 {
    pub nr: usize,
    pub size: usize,
    pub data: *mut accounting_mem_entry,
    pub preallocated: __IncompleteArrayField<accounting_mem_entry>,
}
#[test]
fn bindgen_test_layout_bch_accounting_mem__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bch_accounting_mem__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_accounting_mem__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(bch_accounting_mem__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_accounting_mem__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_accounting_mem__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_accounting_mem__bindgen_ty_1),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_accounting_mem__bindgen_ty_1),
            "::",
            stringify!(size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_accounting_mem__bindgen_ty_1),
            "::",
            stringify!(data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_accounting_mem__bindgen_ty_1),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for bch_accounting_mem__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bch_accounting_mem() {
    const UNINIT: ::std::mem::MaybeUninit<bch_accounting_mem> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_accounting_mem>(),
        32usize,
        concat!("Size of: ", stringify!(bch_accounting_mem)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_accounting_mem>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_accounting_mem)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_accounting_mem), "::", stringify!(k)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gc_running) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_accounting_mem),
            "::",
            stringify!(gc_running),
        ),
    );
}
impl Default for bch_accounting_mem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bucket {
    pub lock: u8_,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub gen: u8_,
    pub dirty_sectors: u32_,
    pub cached_sectors: u32_,
    pub stripe_sectors: u32_,
}
#[test]
fn bindgen_test_layout_bucket() {
    const UNINIT: ::std::mem::MaybeUninit<bucket> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bucket>(),
        16usize,
        concat!("Size of: ", stringify!(bucket)),
    );
    assert_eq!(
        ::std::mem::align_of::<bucket>(),
        8usize,
        concat!("Alignment of ", stringify!(bucket)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bucket), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gen) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(bucket), "::", stringify!(gen)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dirty_sectors) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bucket), "::", stringify!(dirty_sectors)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cached_sectors) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bucket),
            "::",
            stringify!(cached_sectors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_sectors) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bucket),
            "::",
            stringify!(stripe_sectors),
        ),
    );
}
impl bucket {
    #[inline]
    pub fn gen_valid(&self) -> u8_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_gen_valid(&mut self, val: u8_) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn data_type(&self) -> u8_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 7u8) as u8) }
    }
    #[inline]
    pub fn set_data_type(&mut self, val: u8_) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gen_valid: u8_,
        data_type: u8_,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let gen_valid: u8 = unsafe { ::std::mem::transmute(gen_valid) };
                    gen_valid as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                1usize,
                7u8,
                {
                    let data_type: u8 = unsafe { ::std::mem::transmute(data_type) };
                    data_type as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct bucket_gens {
    pub rcu: rcu_head,
    pub first_bucket: u16_,
    pub nbuckets: usize,
    pub nbuckets_minus_first: usize,
    pub b: __IncompleteArrayField<u8_>,
}
#[test]
fn bindgen_test_layout_bucket_gens() {
    const UNINIT: ::std::mem::MaybeUninit<bucket_gens> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bucket_gens>(),
        40usize,
        concat!("Size of: ", stringify!(bucket_gens)),
    );
    assert_eq!(
        ::std::mem::align_of::<bucket_gens>(),
        8usize,
        concat!("Alignment of ", stringify!(bucket_gens)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rcu) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bucket_gens), "::", stringify!(rcu)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).first_bucket) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bucket_gens),
            "::",
            stringify!(first_bucket),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nbuckets) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bucket_gens), "::", stringify!(nbuckets)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).nbuckets_minus_first) as usize - ptr as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bucket_gens),
            "::",
            stringify!(nbuckets_minus_first),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).b) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(bucket_gens), "::", stringify!(b)),
    );
}
impl Default for bucket_gens {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_dev_usage {
    pub buckets: [u64_; 11usize],
}
#[test]
fn bindgen_test_layout_bch_dev_usage() {
    const UNINIT: ::std::mem::MaybeUninit<bch_dev_usage> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_dev_usage>(),
        88usize,
        concat!("Size of: ", stringify!(bch_dev_usage)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dev_usage>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_dev_usage)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buckets) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dev_usage),
            "::",
            stringify!(buckets),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_dev_usage_full {
    pub d: [bch_dev_usage_full_bch_dev_usage_type; 11usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_dev_usage_full_bch_dev_usage_type {
    pub buckets: u64_,
    pub sectors: u64_,
    pub fragmented: u64_,
}
#[test]
fn bindgen_test_layout_bch_dev_usage_full_bch_dev_usage_type() {
    const UNINIT: ::std::mem::MaybeUninit<bch_dev_usage_full_bch_dev_usage_type> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_dev_usage_full_bch_dev_usage_type>(),
        24usize,
        concat!("Size of: ", stringify!(bch_dev_usage_full_bch_dev_usage_type)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dev_usage_full_bch_dev_usage_type>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_dev_usage_full_bch_dev_usage_type)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buckets) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dev_usage_full_bch_dev_usage_type),
            "::",
            stringify!(buckets),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sectors) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dev_usage_full_bch_dev_usage_type),
            "::",
            stringify!(sectors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fragmented) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_dev_usage_full_bch_dev_usage_type),
            "::",
            stringify!(fragmented),
        ),
    );
}
#[test]
fn bindgen_test_layout_bch_dev_usage_full() {
    const UNINIT: ::std::mem::MaybeUninit<bch_dev_usage_full> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_dev_usage_full>(),
        264usize,
        concat!("Size of: ", stringify!(bch_dev_usage_full)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_dev_usage_full>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_dev_usage_full)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_dev_usage_full), "::", stringify!(d)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_fs_usage_base {
    pub hidden: u64_,
    pub btree: u64_,
    pub data: u64_,
    pub cached: u64_,
    pub reserved: u64_,
}
#[test]
fn bindgen_test_layout_bch_fs_usage_base() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_usage_base> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_usage_base>(),
        40usize,
        concat!("Size of: ", stringify!(bch_fs_usage_base)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_usage_base>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_usage_base)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hidden) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_usage_base),
            "::",
            stringify!(hidden),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btree) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_usage_base),
            "::",
            stringify!(btree),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_usage_base),
            "::",
            stringify!(data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cached) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_usage_base),
            "::",
            stringify!(cached),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_usage_base),
            "::",
            stringify!(reserved),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_fs_usage_short {
    pub capacity: u64_,
    pub used: u64_,
    pub free: u64_,
}
#[test]
fn bindgen_test_layout_bch_fs_usage_short() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_usage_short> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_usage_short>(),
        24usize,
        concat!("Size of: ", stringify!(bch_fs_usage_short)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_usage_short>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_usage_short)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).capacity) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_usage_short),
            "::",
            stringify!(capacity),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).used) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_usage_short),
            "::",
            stringify!(used),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).free) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_usage_short),
            "::",
            stringify!(free),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct disk_reservation {
    pub sectors: u64_,
    pub gen: u32_,
    pub nr_replicas: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_disk_reservation() {
    const UNINIT: ::std::mem::MaybeUninit<disk_reservation> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<disk_reservation>(),
        16usize,
        concat!("Size of: ", stringify!(disk_reservation)),
    );
    assert_eq!(
        ::std::mem::align_of::<disk_reservation>(),
        8usize,
        concat!("Alignment of ", stringify!(disk_reservation)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sectors) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(disk_reservation),
            "::",
            stringify!(sectors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gen) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(disk_reservation), "::", stringify!(gen)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_replicas) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(disk_reservation),
            "::",
            stringify!(nr_replicas),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bucket_hashed {
    pub dev_bucket: u64_,
    pub journal_seq: u64_,
}
#[test]
fn bindgen_test_layout_bucket_hashed() {
    const UNINIT: ::std::mem::MaybeUninit<bucket_hashed> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bucket_hashed>(),
        16usize,
        concat!("Size of: ", stringify!(bucket_hashed)),
    );
    assert_eq!(
        ::std::mem::align_of::<bucket_hashed>(),
        8usize,
        concat!("Alignment of ", stringify!(bucket_hashed)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dev_bucket) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bucket_hashed),
            "::",
            stringify!(dev_bucket),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_seq) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bucket_hashed),
            "::",
            stringify!(journal_seq),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct buckets_waiting_for_journal_table {
    pub bits: ::std::os::raw::c_uint,
    pub hash_seeds: [u64_; 3usize],
    pub d: __IncompleteArrayField<bucket_hashed>,
}
#[test]
fn bindgen_test_layout_buckets_waiting_for_journal_table() {
    const UNINIT: ::std::mem::MaybeUninit<buckets_waiting_for_journal_table> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<buckets_waiting_for_journal_table>(),
        32usize,
        concat!("Size of: ", stringify!(buckets_waiting_for_journal_table)),
    );
    assert_eq!(
        ::std::mem::align_of::<buckets_waiting_for_journal_table>(),
        8usize,
        concat!("Alignment of ", stringify!(buckets_waiting_for_journal_table)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bits) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(buckets_waiting_for_journal_table),
            "::",
            stringify!(bits),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hash_seeds) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(buckets_waiting_for_journal_table),
            "::",
            stringify!(hash_seeds),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(buckets_waiting_for_journal_table),
            "::",
            stringify!(d),
        ),
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct buckets_waiting_for_journal {
    pub lock: mutex,
    pub t: *mut buckets_waiting_for_journal_table,
}
#[test]
fn bindgen_test_layout_buckets_waiting_for_journal() {
    const UNINIT: ::std::mem::MaybeUninit<buckets_waiting_for_journal> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<buckets_waiting_for_journal>(),
        48usize,
        concat!("Size of: ", stringify!(buckets_waiting_for_journal)),
    );
    assert_eq!(
        ::std::mem::align_of::<buckets_waiting_for_journal>(),
        8usize,
        concat!("Alignment of ", stringify!(buckets_waiting_for_journal)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(buckets_waiting_for_journal),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).t) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(buckets_waiting_for_journal),
            "::",
            stringify!(t),
        ),
    );
}
impl Default for buckets_waiting_for_journal {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bch_sb_handle_holder {
    pub c: *mut bch_fs,
}
#[test]
fn bindgen_test_layout_bch_sb_handle_holder() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_handle_holder> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_handle_holder>(),
        8usize,
        concat!("Size of: ", stringify!(bch_sb_handle_holder)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_handle_holder>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_handle_holder)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).c) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_handle_holder),
            "::",
            stringify!(c),
        ),
    );
}
impl Default for bch_sb_handle_holder {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_sb_handle {
    pub sb: *mut bch_sb,
    pub s_bdev_file: *mut file,
    pub bdev: *mut block_device,
    pub sb_name: *mut ::std::os::raw::c_char,
    pub bio: *mut bio,
    pub holder: *mut bch_sb_handle_holder,
    pub buffer_size: usize,
    pub mode: blk_mode_t,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub seq: u64_,
}
#[test]
fn bindgen_test_layout_bch_sb_handle() {
    const UNINIT: ::std::mem::MaybeUninit<bch_sb_handle> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_sb_handle>(),
        72usize,
        concat!("Size of: ", stringify!(bch_sb_handle)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_sb_handle>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_sb_handle)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sb) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_sb_handle), "::", stringify!(sb)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s_bdev_file) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_handle),
            "::",
            stringify!(s_bdev_file),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bdev) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(bch_sb_handle), "::", stringify!(bdev)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sb_name) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_handle),
            "::",
            stringify!(sb_name),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bio) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(bch_sb_handle), "::", stringify!(bio)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).holder) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(bch_sb_handle), "::", stringify!(holder)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer_size) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_sb_handle),
            "::",
            stringify!(buffer_size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mode) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(bch_sb_handle), "::", stringify!(mode)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(bch_sb_handle), "::", stringify!(seq)),
    );
}
impl Default for bch_sb_handle {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bch_sb_handle {
    #[inline]
    pub fn have_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_have_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn have_bio(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_have_bio(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fs_sb(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fs_sb(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        have_layout: ::std::os::raw::c_uint,
        have_bio: ::std::os::raw::c_uint,
        fs_sb: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let have_layout: u32 = unsafe { ::std::mem::transmute(have_layout) };
                    have_layout as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                1usize,
                1u8,
                {
                    let have_bio: u32 = unsafe { ::std::mem::transmute(have_bio) };
                    have_bio as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                2usize,
                1u8,
                {
                    let fs_sb: u32 = unsafe { ::std::mem::transmute(fs_sb) };
                    fs_sb as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_devs_mask {
    pub d: [::std::os::raw::c_ulong; 1usize],
}
#[test]
fn bindgen_test_layout_bch_devs_mask() {
    const UNINIT: ::std::mem::MaybeUninit<bch_devs_mask> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_devs_mask>(),
        8usize,
        concat!("Size of: ", stringify!(bch_devs_mask)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_devs_mask>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_devs_mask)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_devs_mask), "::", stringify!(d)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_devs_list {
    pub nr: u8_,
    pub data: [u8_; 16usize],
}
#[test]
fn bindgen_test_layout_bch_devs_list() {
    const UNINIT: ::std::mem::MaybeUninit<bch_devs_list> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_devs_list>(),
        17usize,
        concat!("Size of: ", stringify!(bch_devs_list)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_devs_list>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_devs_list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_devs_list), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        1usize,
        concat!("Offset of field: ", stringify!(bch_devs_list), "::", stringify!(data)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_disk_group_cpu {
    pub deleted: bool,
    pub parent: u16_,
    pub label: [u8_; 32usize],
    pub devs: bch_devs_mask,
}
#[test]
fn bindgen_test_layout_bch_disk_group_cpu() {
    const UNINIT: ::std::mem::MaybeUninit<bch_disk_group_cpu> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_disk_group_cpu>(),
        48usize,
        concat!("Size of: ", stringify!(bch_disk_group_cpu)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_disk_group_cpu>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_disk_group_cpu)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deleted) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_disk_group_cpu),
            "::",
            stringify!(deleted),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_disk_group_cpu),
            "::",
            stringify!(parent),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).label) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_disk_group_cpu),
            "::",
            stringify!(label),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).devs) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_disk_group_cpu),
            "::",
            stringify!(devs),
        ),
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_disk_groups_cpu {
    pub rcu: rcu_head,
    pub nr: ::std::os::raw::c_uint,
    pub entries: __IncompleteArrayField<bch_disk_group_cpu>,
}
#[test]
fn bindgen_test_layout_bch_disk_groups_cpu() {
    const UNINIT: ::std::mem::MaybeUninit<bch_disk_groups_cpu> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_disk_groups_cpu>(),
        24usize,
        concat!("Size of: ", stringify!(bch_disk_groups_cpu)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_disk_groups_cpu>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_disk_groups_cpu)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rcu) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_disk_groups_cpu),
            "::",
            stringify!(rcu),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_disk_groups_cpu),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_disk_groups_cpu),
            "::",
            stringify!(entries),
        ),
    );
}
impl Default for bch_disk_groups_cpu {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct bch_replicas_entry_cpu {
    pub ref_: atomic_t,
    pub e: bch_replicas_entry_v1,
}
#[test]
fn bindgen_test_layout_bch_replicas_entry_cpu() {
    const UNINIT: ::std::mem::MaybeUninit<bch_replicas_entry_cpu> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_replicas_entry_cpu>(),
        8usize,
        concat!("Size of: ", stringify!(bch_replicas_entry_cpu)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_replicas_entry_cpu>(),
        4usize,
        concat!("Alignment of ", stringify!(bch_replicas_entry_cpu)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ref_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_entry_cpu),
            "::",
            stringify!(ref_),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).e) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_entry_cpu),
            "::",
            stringify!(e),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bch_replicas_cpu {
    pub nr: ::std::os::raw::c_uint,
    pub entry_size: ::std::os::raw::c_uint,
    pub entries: *mut bch_replicas_entry_cpu,
}
#[test]
fn bindgen_test_layout_bch_replicas_cpu() {
    const UNINIT: ::std::mem::MaybeUninit<bch_replicas_cpu> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_replicas_cpu>(),
        16usize,
        concat!("Size of: ", stringify!(bch_replicas_cpu)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_replicas_cpu>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_replicas_cpu)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_replicas_cpu), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entry_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_cpu),
            "::",
            stringify!(entry_size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_cpu),
            "::",
            stringify!(entries),
        ),
    );
}
impl Default for bch_replicas_cpu {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct bch_replicas_padded {
    pub __bindgen_anon_1: __BindgenUnionField<bch_replicas_padded__bindgen_ty_1>,
    pub __bindgen_anon_2: __BindgenUnionField<bch_replicas_padded__bindgen_ty_2>,
    pub __bindgen_anon_3: __BindgenUnionField<bch_replicas_padded__bindgen_ty_3>,
    pub __bindgen_anon_4: __BindgenUnionField<bch_replicas_padded__bindgen_ty_4>,
    pub bytes: __BindgenUnionField<[u8_; 19usize]>,
    pub e: __BindgenUnionField<bch_replicas_entry_v1>,
    pub bindgen_union_field: [u8; 19usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_replicas_padded__bindgen_ty_1 {}
#[test]
fn bindgen_test_layout_bch_replicas_padded__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<bch_replicas_padded__bindgen_ty_1>(),
        0usize,
        concat!("Size of: ", stringify!(bch_replicas_padded__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_replicas_padded__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_replicas_padded__bindgen_ty_1)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_replicas_padded__bindgen_ty_2 {}
#[test]
fn bindgen_test_layout_bch_replicas_padded__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<bch_replicas_padded__bindgen_ty_2>(),
        0usize,
        concat!("Size of: ", stringify!(bch_replicas_padded__bindgen_ty_2)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_replicas_padded__bindgen_ty_2>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_replicas_padded__bindgen_ty_2)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_replicas_padded__bindgen_ty_3 {}
#[test]
fn bindgen_test_layout_bch_replicas_padded__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<bch_replicas_padded__bindgen_ty_3>(),
        0usize,
        concat!("Size of: ", stringify!(bch_replicas_padded__bindgen_ty_3)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_replicas_padded__bindgen_ty_3>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_replicas_padded__bindgen_ty_3)),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_replicas_padded__bindgen_ty_4 {}
#[test]
fn bindgen_test_layout_bch_replicas_padded__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<bch_replicas_padded__bindgen_ty_4>(),
        0usize,
        concat!("Size of: ", stringify!(bch_replicas_padded__bindgen_ty_4)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_replicas_padded__bindgen_ty_4>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_replicas_padded__bindgen_ty_4)),
    );
}
#[test]
fn bindgen_test_layout_bch_replicas_padded() {
    const UNINIT: ::std::mem::MaybeUninit<bch_replicas_padded> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_replicas_padded>(),
        19usize,
        concat!("Size of: ", stringify!(bch_replicas_padded)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_replicas_padded>(),
        1usize,
        concat!("Alignment of ", stringify!(bch_replicas_padded)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_padded),
            "::",
            stringify!(bytes),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).e) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_replicas_padded),
            "::",
            stringify!(e),
        ),
    );
}
impl Default for bch_replicas_padded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_watermark {
    BCH_WATERMARK_stripe = 0,
    BCH_WATERMARK_normal = 1,
    BCH_WATERMARK_copygc = 2,
    BCH_WATERMARK_btree = 3,
    BCH_WATERMARK_btree_copygc = 4,
    BCH_WATERMARK_reclaim = 5,
    BCH_WATERMARK_interior_updates = 6,
    BCH_WATERMARK_NR = 7,
}
pub type open_bucket_idx_t = u16;
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct open_bucket {
    pub _bindgen_opaque_blob: [u64; 9usize],
}
#[test]
fn bindgen_test_layout_open_bucket() {
    assert_eq!(
        ::std::mem::size_of::<open_bucket>(),
        72usize,
        concat!("Size of: ", stringify!(open_bucket)),
    );
    assert_eq!(
        ::std::mem::align_of::<open_bucket>(),
        8usize,
        concat!("Alignment of ", stringify!(open_bucket)),
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct open_buckets {
    pub _bindgen_opaque_blob: [u16; 17usize],
}
#[test]
fn bindgen_test_layout_open_buckets() {
    assert_eq!(
        ::std::mem::size_of::<open_buckets>(),
        34usize,
        concat!("Size of: ", stringify!(open_buckets)),
    );
    assert_eq!(
        ::std::mem::align_of::<open_buckets>(),
        2usize,
        concat!("Alignment of ", stringify!(open_buckets)),
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dev_stripe_state {
    pub next_alloc: [u64_; 64usize],
}
#[test]
fn bindgen_test_layout_dev_stripe_state() {
    const UNINIT: ::std::mem::MaybeUninit<dev_stripe_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<dev_stripe_state>(),
        512usize,
        concat!("Size of: ", stringify!(dev_stripe_state)),
    );
    assert_eq!(
        ::std::mem::align_of::<dev_stripe_state>(),
        8usize,
        concat!("Alignment of ", stringify!(dev_stripe_state)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next_alloc) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dev_stripe_state),
            "::",
            stringify!(next_alloc),
        ),
    );
}
impl Default for dev_stripe_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum write_point_state {
    WRITE_POINT_stopped = 0,
    WRITE_POINT_waiting_io = 1,
    WRITE_POINT_waiting_work = 2,
    WRITE_POINT_runnable = 3,
    WRITE_POINT_running = 4,
    WRITE_POINT_STATE_NR = 5,
}
#[repr(C)]
#[repr(align(64))]
#[derive(Copy, Clone)]
pub struct write_point {
    pub __bindgen_anon_1: write_point__bindgen_ty_1,
    pub __bindgen_anon_2: write_point__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(64))]
#[derive(Copy, Clone)]
pub struct write_point__bindgen_ty_1 {
    pub node: cds_hlist_node,
    pub lock: mutex,
    pub last_used: u64_,
    pub write_point: ::std::os::raw::c_ulong,
    pub data_type: bch_data_type,
    pub sectors_free: ::std::os::raw::c_uint,
    pub ptrs: open_buckets,
    pub stripe: dev_stripe_state,
    pub sectors_allocated: u64_,
}
#[test]
fn bindgen_test_layout_write_point__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<write_point__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<write_point__bindgen_ty_1>(),
        640usize,
        concat!("Size of: ", stringify!(write_point__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<write_point__bindgen_ty_1>(),
        64usize,
        concat!("Alignment of ", stringify!(write_point__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_1),
            "::",
            stringify!(node),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_1),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_used) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_1),
            "::",
            stringify!(last_used),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_point) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_1),
            "::",
            stringify!(write_point),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_type) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_1),
            "::",
            stringify!(data_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sectors_free) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_1),
            "::",
            stringify!(sectors_free),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptrs) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_1),
            "::",
            stringify!(ptrs),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_1),
            "::",
            stringify!(stripe),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).sectors_allocated) as usize - ptr as usize
        },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_1),
            "::",
            stringify!(sectors_allocated),
        ),
    );
}
impl Default for write_point__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(64))]
#[derive(Copy, Clone)]
pub struct write_point__bindgen_ty_2 {
    pub index_update_work: work_struct,
    pub writes: cds_list_head,
    pub writes_lock: spinlock_t,
    pub state: write_point_state,
    pub last_state_change: u64_,
    pub time: [u64_; 5usize],
    pub last_runtime: u64_,
}
#[test]
fn bindgen_test_layout_write_point__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<write_point__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<write_point__bindgen_ty_2>(),
        192usize,
        concat!("Size of: ", stringify!(write_point__bindgen_ty_2)),
    );
    assert_eq!(
        ::std::mem::align_of::<write_point__bindgen_ty_2>(),
        64usize,
        concat!("Alignment of ", stringify!(write_point__bindgen_ty_2)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).index_update_work) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_2),
            "::",
            stringify!(index_update_work),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).writes) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_2),
            "::",
            stringify!(writes),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).writes_lock) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_2),
            "::",
            stringify!(writes_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_2),
            "::",
            stringify!(state),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).last_state_change) as usize - ptr as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_2),
            "::",
            stringify!(last_state_change),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_2),
            "::",
            stringify!(time),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_runtime) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(write_point__bindgen_ty_2),
            "::",
            stringify!(last_runtime),
        ),
    );
}
impl Default for write_point__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_write_point() {
    assert_eq!(
        ::std::mem::size_of::<write_point>(),
        832usize,
        concat!("Size of: ", stringify!(write_point)),
    );
    assert_eq!(
        ::std::mem::align_of::<write_point>(),
        64usize,
        concat!("Alignment of ", stringify!(write_point)),
    );
}
impl Default for write_point {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_fs_capacity_pcpu {
    pub sectors_available: u64_,
    pub online_reserved: u64_,
}
#[test]
fn bindgen_test_layout_bch_fs_capacity_pcpu() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_capacity_pcpu> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_capacity_pcpu>(),
        16usize,
        concat!("Size of: ", stringify!(bch_fs_capacity_pcpu)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_capacity_pcpu>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_capacity_pcpu)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).sectors_available) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity_pcpu),
            "::",
            stringify!(sectors_available),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).online_reserved) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity_pcpu),
            "::",
            stringify!(online_reserved),
        ),
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bch_fs_capacity {
    pub capacity: u64_,
    pub reserved: u64_,
    pub capacity_gen: u32_,
    pub bucket_size_max: ::std::os::raw::c_uint,
    pub sectors_available: atomic64_t,
    pub sectors_available_lock: mutex,
    pub pcpu: *mut bch_fs_capacity_pcpu,
    pub mark_lock: percpu_rw_semaphore,
    pub usage_lock: seqcount_t,
    pub usage: *mut bch_fs_usage_base,
}
#[test]
fn bindgen_test_layout_bch_fs_capacity() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_capacity> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_capacity>(),
        136usize,
        concat!("Size of: ", stringify!(bch_fs_capacity)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_capacity>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_capacity)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).capacity) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity),
            "::",
            stringify!(capacity),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity),
            "::",
            stringify!(reserved),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).capacity_gen) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity),
            "::",
            stringify!(capacity_gen),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bucket_size_max) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity),
            "::",
            stringify!(bucket_size_max),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).sectors_available) as usize - ptr as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity),
            "::",
            stringify!(sectors_available),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).sectors_available_lock) as usize - ptr as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity),
            "::",
            stringify!(sectors_available_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pcpu) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(bch_fs_capacity), "::", stringify!(pcpu)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mark_lock) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity),
            "::",
            stringify!(mark_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).usage_lock) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity),
            "::",
            stringify!(usage_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).usage) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_capacity),
            "::",
            stringify!(usage),
        ),
    );
}
impl Default for bch_fs_capacity {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(64))]
#[derive(Copy, Clone)]
pub struct bch_fs_allocator {
    pub rw_devs: [bch_devs_mask; 11usize],
    pub rw_devs_change_count: ::std::os::raw::c_ulong,
    pub freelist_lock: spinlock_t,
    pub freelist_wait: closure_waitlist,
    pub last_stuck: ::std::os::raw::c_ulong,
    pub open_buckets_freelist: open_bucket_idx_t,
    pub open_buckets_nr_free: open_bucket_idx_t,
    pub open_buckets_wait: closure_waitlist,
    pub open_buckets: [open_bucket; 1024usize],
    pub open_buckets_hash: [open_bucket_idx_t; 1024usize],
    pub open_buckets_partial: [open_bucket_idx_t; 1024usize],
    pub open_buckets_partial_nr: open_bucket_idx_t,
    pub __bindgen_padding_0: [u64; 2usize],
    pub write_points: [write_point; 32usize],
    pub write_points_hash: [cds_hlist_head; 32usize],
    pub write_points_hash_lock: mutex,
    pub write_points_nr: ::std::os::raw::c_uint,
    pub __bindgen_padding_1: [u64; 2usize],
    pub btree_write_point: write_point,
    pub reconcile_write_point: write_point,
}
#[test]
fn bindgen_test_layout_bch_fs_allocator() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_allocator> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_allocator>(),
        106624usize,
        concat!("Size of: ", stringify!(bch_fs_allocator)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_allocator>(),
        64usize,
        concat!("Alignment of ", stringify!(bch_fs_allocator)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rw_devs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(rw_devs),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).rw_devs_change_count) as usize - ptr as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(rw_devs_change_count),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).freelist_lock) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(freelist_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).freelist_wait) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(freelist_wait),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_stuck) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(last_stuck),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).open_buckets_freelist) as usize - ptr as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(open_buckets_freelist),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).open_buckets_nr_free) as usize - ptr as usize
        },
        154usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(open_buckets_nr_free),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).open_buckets_wait) as usize - ptr as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(open_buckets_wait),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).open_buckets) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(open_buckets),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).open_buckets_hash) as usize - ptr as usize
        },
        73896usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(open_buckets_hash),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).open_buckets_partial) as usize - ptr as usize
        },
        75944usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(open_buckets_partial),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).open_buckets_partial_nr) as usize - ptr as usize
        },
        77992usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(open_buckets_partial_nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_points) as usize - ptr as usize },
        78016usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(write_points),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).write_points_hash) as usize - ptr as usize
        },
        104640usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(write_points_hash),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).write_points_hash_lock) as usize - ptr as usize
        },
        104896usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(write_points_hash_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_points_nr) as usize - ptr as usize },
        104936usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(write_points_nr),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).btree_write_point) as usize - ptr as usize
        },
        104960usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(btree_write_point),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).reconcile_write_point) as usize - ptr as usize
        },
        105792usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_allocator),
            "::",
            stringify!(reconcile_write_point),
        ),
    );
}
impl Default for bch_fs_allocator {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bbpos {
    pub btree: btree_id,
    pub pos: bpos,
}
#[test]
fn bindgen_test_layout_bbpos() {
    const UNINIT: ::std::mem::MaybeUninit<bbpos> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bbpos>(),
        24usize,
        concat!("Size of: ", stringify!(bbpos)),
    );
    assert_eq!(
        ::std::mem::align_of::<bbpos>(),
        4usize,
        concat!("Alignment of ", stringify!(bbpos)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btree) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bbpos), "::", stringify!(btree)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bbpos), "::", stringify!(pos)),
    );
}
impl Default for bbpos {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum gc_phase {
    GC_PHASE_not_running = 0,
    GC_PHASE_start = 1,
    GC_PHASE_sb = 2,
    GC_PHASE_btree = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gc_pos {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub level: u16_,
    pub pos: bpos,
}
#[test]
fn bindgen_test_layout_gc_pos() {
    const UNINIT: ::std::mem::MaybeUninit<gc_pos> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<gc_pos>(),
        24usize,
        concat!("Size of: ", stringify!(gc_pos)),
    );
    assert_eq!(
        ::std::mem::align_of::<gc_pos>(),
        4usize,
        concat!("Alignment of ", stringify!(gc_pos)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(gc_pos), "::", stringify!(level)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(gc_pos), "::", stringify!(pos)),
    );
}
impl Default for gc_pos {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl gc_pos {
    #[inline]
    pub fn phase(&self) -> gc_phase {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_phase(&mut self, val: gc_phase) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn btree(&self) -> btree_id {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_btree(&mut self, val: btree_id) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        phase: gc_phase,
        btree: btree_id,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                8u8,
                {
                    let phase: u32 = unsafe { ::std::mem::transmute(phase) };
                    phase as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                8usize,
                8u8,
                {
                    let btree: u32 = unsafe { ::std::mem::transmute(btree) };
                    btree as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct reflink_gc {
    pub offset: u64_,
    pub size: u32_,
    pub refcount: u32_,
}
#[test]
fn bindgen_test_layout_reflink_gc() {
    const UNINIT: ::std::mem::MaybeUninit<reflink_gc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<reflink_gc>(),
        16usize,
        concat!("Size of: ", stringify!(reflink_gc)),
    );
    assert_eq!(
        ::std::mem::align_of::<reflink_gc>(),
        8usize,
        concat!("Alignment of ", stringify!(reflink_gc)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(reflink_gc), "::", stringify!(offset)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(reflink_gc), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).refcount) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(reflink_gc), "::", stringify!(refcount)),
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct reflink_gc_table {
    pub tree: __genradix,
    pub type_: __IncompleteArrayField<reflink_gc>,
}
#[test]
fn bindgen_test_layout_reflink_gc_table() {
    const UNINIT: ::std::mem::MaybeUninit<reflink_gc_table> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<reflink_gc_table>(),
        8usize,
        concat!("Size of: ", stringify!(reflink_gc_table)),
    );
    assert_eq!(
        ::std::mem::align_of::<reflink_gc_table>(),
        8usize,
        concat!("Alignment of ", stringify!(reflink_gc_table)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tree) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(reflink_gc_table),
            "::",
            stringify!(tree),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(reflink_gc_table),
            "::",
            stringify!(type_),
        ),
    );
}
impl Default for reflink_gc_table {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bch_fs_gc {
    pub pos_lock: seqcount_t,
    pub pos: gc_pos,
    pub lock: rw_semaphore,
}
#[test]
fn bindgen_test_layout_bch_fs_gc() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_gc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_gc>(),
        88usize,
        concat!("Size of: ", stringify!(bch_fs_gc)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_gc>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_gc)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos_lock) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_fs_gc), "::", stringify!(pos_lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bch_fs_gc), "::", stringify!(pos)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(bch_fs_gc), "::", stringify!(lock)),
    );
}
impl Default for bch_fs_gc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bch_fs_gc_gens {
    pub pos: bbpos,
    pub work: work_struct,
    pub lock: mutex,
}
#[test]
fn bindgen_test_layout_bch_fs_gc_gens() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_gc_gens> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_gc_gens>(),
        96usize,
        concat!("Size of: ", stringify!(bch_fs_gc_gens)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_gc_gens>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_gc_gens)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_fs_gc_gens), "::", stringify!(pos)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).work) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(bch_fs_gc_gens), "::", stringify!(work)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(bch_fs_gc_gens), "::", stringify!(lock)),
    );
}
impl Default for bch_fs_gc_gens {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_ptr {
    pub csum_good: bool,
    pub csum: bch_csum,
    pub dev: u8_,
    pub bucket: u32_,
    pub bucket_offset: u32_,
    pub sector: u64_,
}
#[test]
fn bindgen_test_layout_journal_ptr() {
    const UNINIT: ::std::mem::MaybeUninit<journal_ptr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_ptr>(),
        48usize,
        concat!("Size of: ", stringify!(journal_ptr)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_ptr>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_ptr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum_good) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_ptr),
            "::",
            stringify!(csum_good),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(journal_ptr), "::", stringify!(csum)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dev) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(journal_ptr), "::", stringify!(dev)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bucket) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(journal_ptr), "::", stringify!(bucket)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bucket_offset) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_ptr),
            "::",
            stringify!(bucket_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sector) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(journal_ptr), "::", stringify!(sector)),
    );
}
#[repr(C)]
pub struct journal_replay {
    pub ptrs: journal_replay__bindgen_ty_1,
    pub csum_good: bool,
    pub ignore_blacklisted: bool,
    pub ignore_not_dirty: bool,
    pub j: jset,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct journal_replay__bindgen_ty_1 {
    pub nr: usize,
    pub size: usize,
    pub data: *mut journal_ptr,
    pub preallocated: [journal_ptr; 8usize],
}
#[test]
fn bindgen_test_layout_journal_replay__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<journal_replay__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_replay__bindgen_ty_1>(),
        408usize,
        concat!("Size of: ", stringify!(journal_replay__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_replay__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_replay__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_replay__bindgen_ty_1),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_replay__bindgen_ty_1),
            "::",
            stringify!(size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_replay__bindgen_ty_1),
            "::",
            stringify!(data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_replay__bindgen_ty_1),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for journal_replay__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_journal_replay() {
    const UNINIT: ::std::mem::MaybeUninit<journal_replay> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_replay>(),
        472usize,
        concat!("Size of: ", stringify!(journal_replay)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_replay>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_replay)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptrs) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(journal_replay), "::", stringify!(ptrs)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum_good) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_replay),
            "::",
            stringify!(csum_good),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).ignore_blacklisted) as usize - ptr as usize
        },
        409usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_replay),
            "::",
            stringify!(ignore_blacklisted),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ignore_not_dirty) as usize - ptr as usize },
        410usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_replay),
            "::",
            stringify!(ignore_not_dirty),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).j) as usize - ptr as usize },
        416usize,
        concat!("Offset of field: ", stringify!(journal_replay), "::", stringify!(j)),
    );
}
impl Default for journal_replay {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_key_range_overwritten {
    pub start: usize,
    pub end: usize,
}
#[test]
fn bindgen_test_layout_journal_key_range_overwritten() {
    const UNINIT: ::std::mem::MaybeUninit<journal_key_range_overwritten> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_key_range_overwritten>(),
        16usize,
        concat!("Size of: ", stringify!(journal_key_range_overwritten)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_key_range_overwritten>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_key_range_overwritten)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_key_range_overwritten),
            "::",
            stringify!(start),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_key_range_overwritten),
            "::",
            stringify!(end),
        ),
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct journal_key {
    pub __bindgen_anon_1: journal_key__bindgen_ty_1,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub overwritten_range: u32_,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union journal_key__bindgen_ty_1 {
    pub __bindgen_anon_1: journal_key__bindgen_ty_1__bindgen_ty_1,
    pub allocated_k: *mut bkey_i,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_key__bindgen_ty_1__bindgen_ty_1 {
    pub journal_seq_offset: u32_,
    pub journal_offset: u32_,
}
#[test]
fn bindgen_test_layout_journal_key__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<journal_key__bindgen_ty_1__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_key__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(journal_key__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_key__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(journal_key__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).journal_seq_offset) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_key__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(journal_seq_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_offset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_key__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(journal_offset),
        ),
    );
}
#[test]
fn bindgen_test_layout_journal_key__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<journal_key__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_key__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(journal_key__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_key__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_key__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).allocated_k) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_key__bindgen_ty_1),
            "::",
            stringify!(allocated_k),
        ),
    );
}
impl Default for journal_key__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_journal_key() {
    const UNINIT: ::std::mem::MaybeUninit<journal_key> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_key>(),
        16usize,
        concat!("Size of: ", stringify!(journal_key)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_key>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_key)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).overwritten_range) as usize - ptr as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_key),
            "::",
            stringify!(overwritten_range),
        ),
    );
}
impl Default for journal_key {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl journal_key {
    #[inline]
    pub fn btree_id(&self) -> btree_id {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_btree_id(&mut self, val: btree_id) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn level(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_level(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn allocated(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_allocated(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overwritten(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_overwritten(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rewind(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_rewind(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        btree_id: btree_id,
        level: ::std::os::raw::c_uint,
        allocated: bool,
        overwritten: bool,
        rewind: bool,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                8u8,
                {
                    let btree_id: u32 = unsafe { ::std::mem::transmute(btree_id) };
                    btree_id as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                8usize,
                8u8,
                {
                    let level: u32 = unsafe { ::std::mem::transmute(level) };
                    level as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                16usize,
                1u8,
                {
                    let allocated: u8 = unsafe { ::std::mem::transmute(allocated) };
                    allocated as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                17usize,
                1u8,
                {
                    let overwritten: u8 = unsafe { ::std::mem::transmute(overwritten) };
                    overwritten as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                18usize,
                1u8,
                {
                    let rewind: u8 = unsafe { ::std::mem::transmute(rewind) };
                    rewind as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
pub struct journal_keys {
    pub nr: usize,
    pub size: usize,
    pub data: *mut journal_key,
    pub gap: usize,
    pub ref_: atomic_t,
    pub initial_ref_held: bool,
    pub overwrite_lock: mutex,
    pub overwrites: journal_keys__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug)]
pub struct journal_keys__bindgen_ty_1 {
    pub nr: usize,
    pub size: usize,
    pub data: *mut journal_key_range_overwritten,
    pub preallocated: __IncompleteArrayField<journal_key_range_overwritten>,
}
#[test]
fn bindgen_test_layout_journal_keys__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<journal_keys__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_keys__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(journal_keys__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_keys__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_keys__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_keys__bindgen_ty_1),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_keys__bindgen_ty_1),
            "::",
            stringify!(size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_keys__bindgen_ty_1),
            "::",
            stringify!(data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_keys__bindgen_ty_1),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for journal_keys__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_journal_keys() {
    const UNINIT: ::std::mem::MaybeUninit<journal_keys> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_keys>(),
        104usize,
        concat!("Size of: ", stringify!(journal_keys)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_keys>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_keys)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(journal_keys), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(journal_keys), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(journal_keys), "::", stringify!(data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gap) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(journal_keys), "::", stringify!(gap)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ref_) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(journal_keys), "::", stringify!(ref_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).initial_ref_held) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_keys),
            "::",
            stringify!(initial_ref_held),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).overwrite_lock) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_keys),
            "::",
            stringify!(overwrite_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).overwrites) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_keys),
            "::",
            stringify!(overwrites),
        ),
    );
}
impl Default for journal_keys {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct btree_alloc {
    pub ob: open_buckets,
    pub k: bkey_i,
    pub k_pad: [__u64; 11usize],
}
#[test]
fn bindgen_test_layout_btree_alloc() {
    const UNINIT: ::std::mem::MaybeUninit<btree_alloc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_alloc>(),
        168usize,
        concat!("Size of: ", stringify!(btree_alloc)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_alloc>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_alloc)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ob) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(btree_alloc), "::", stringify!(ob)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(btree_alloc), "::", stringify!(k)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k_pad) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(btree_alloc), "::", stringify!(k_pad)),
    );
}
#[repr(C)]
pub struct bch_fs_btree_reserve_cache {
    pub lock: mutex,
    pub nr: ::std::os::raw::c_uint,
    pub data: [btree_alloc; 56usize],
}
#[test]
fn bindgen_test_layout_bch_fs_btree_reserve_cache() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_reserve_cache> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_reserve_cache>(),
        9456usize,
        concat!("Size of: ", stringify!(bch_fs_btree_reserve_cache)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_reserve_cache>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_reserve_cache)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_reserve_cache),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_reserve_cache),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_reserve_cache),
            "::",
            stringify!(data),
        ),
    );
}
impl Default for bch_fs_btree_reserve_cache {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bch_fs_btree_interior_updates {
    pub pool: mempool_t,
    pub list: cds_list_head,
    pub unwritten: cds_list_head,
    pub lock: mutex,
    pub commit_lock: mutex,
    pub wait: closure_waitlist,
    pub worker: *mut workqueue_struct,
    pub work: work_struct,
}
#[test]
fn bindgen_test_layout_bch_fs_btree_interior_updates() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_interior_updates> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_interior_updates>(),
        296usize,
        concat!("Size of: ", stringify!(bch_fs_btree_interior_updates)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_interior_updates>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_interior_updates)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pool) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_interior_updates),
            "::",
            stringify!(pool),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_interior_updates),
            "::",
            stringify!(list),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unwritten) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_interior_updates),
            "::",
            stringify!(unwritten),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_interior_updates),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).commit_lock) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_interior_updates),
            "::",
            stringify!(commit_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_interior_updates),
            "::",
            stringify!(wait),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).worker) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_interior_updates),
            "::",
            stringify!(worker),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).work) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_interior_updates),
            "::",
            stringify!(work),
        ),
    );
}
impl Default for bch_fs_btree_interior_updates {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bch_fs_btree_node_rewrites {
    pub list: cds_list_head,
    pub pending: cds_list_head,
    pub lock: spinlock_t,
    pub wait: closure_waitlist,
    pub worker: *mut workqueue_struct,
}
#[test]
fn bindgen_test_layout_bch_fs_btree_node_rewrites() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_node_rewrites> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_node_rewrites>(),
        88usize,
        concat!("Size of: ", stringify!(bch_fs_btree_node_rewrites)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_node_rewrites>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_node_rewrites)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_node_rewrites),
            "::",
            stringify!(list),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_node_rewrites),
            "::",
            stringify!(pending),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_node_rewrites),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_node_rewrites),
            "::",
            stringify!(wait),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).worker) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_node_rewrites),
            "::",
            stringify!(worker),
        ),
    );
}
impl Default for bch_fs_btree_node_rewrites {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type rcu_pending_process_fn = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut rcu_pending, arg2: *mut rcu_head),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rcu_pending_pcpu {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rcu_pending {
    pub p: *mut rcu_pending_pcpu,
    pub srcu: *mut srcu_struct,
    pub process: rcu_pending_process_fn,
}
#[test]
fn bindgen_test_layout_rcu_pending() {
    const UNINIT: ::std::mem::MaybeUninit<rcu_pending> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rcu_pending>(),
        24usize,
        concat!("Size of: ", stringify!(rcu_pending)),
    );
    assert_eq!(
        ::std::mem::align_of::<rcu_pending>(),
        8usize,
        concat!("Alignment of ", stringify!(rcu_pending)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).p) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(rcu_pending), "::", stringify!(p)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).srcu) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(rcu_pending), "::", stringify!(srcu)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).process) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(rcu_pending), "::", stringify!(process)),
    );
}
impl Default for rcu_pending {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bch_fs_btree_key_cache {
    pub table: rhashtable,
    pub table_init_done: bool,
    pub shrink: *mut shrinker,
    pub shrink_iter: ::std::os::raw::c_uint,
    pub pending: [rcu_pending; 2usize],
    pub nr_pending: *mut usize,
    pub nr_keys: atomic_long_t,
    pub nr_dirty: atomic_long_t,
    pub requested_to_free: ::std::os::raw::c_ulong,
    pub freed: ::std::os::raw::c_ulong,
    pub skipped_dirty: ::std::os::raw::c_ulong,
    pub skipped_accessed: ::std::os::raw::c_ulong,
    pub skipped_lock_fail: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_bch_fs_btree_key_cache() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_key_cache> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_key_cache>(),
        320usize,
        concat!("Size of: ", stringify!(bch_fs_btree_key_cache)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_key_cache>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_key_cache)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).table) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(table),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).table_init_done) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(table_init_done),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shrink) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(shrink),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shrink_iter) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(shrink_iter),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(pending),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_pending) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(nr_pending),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_keys) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(nr_keys),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_dirty) as usize - ptr as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(nr_dirty),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).requested_to_free) as usize - ptr as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(requested_to_free),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).freed) as usize - ptr as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(freed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).skipped_dirty) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(skipped_dirty),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).skipped_accessed) as usize - ptr as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(skipped_accessed),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).skipped_lock_fail) as usize - ptr as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_key_cache),
            "::",
            stringify!(skipped_lock_fail),
        ),
    );
}
impl Default for bch_fs_btree_key_cache {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct found_btree_node {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub btree_id: u8_,
    pub level: u8_,
    pub sectors_written: ::std::os::raw::c_uint,
    pub seq: u32_,
    pub journal_seq: u64_,
    pub cookie: u64_,
    pub min_key: bpos,
    pub max_key: bpos,
    pub nr_ptrs: ::std::os::raw::c_uint,
    pub ptrs: [bch_extent_ptr; 4usize],
}
#[test]
fn bindgen_test_layout_found_btree_node() {
    const UNINIT: ::std::mem::MaybeUninit<found_btree_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<found_btree_node>(),
        112usize,
        concat!("Size of: ", stringify!(found_btree_node)),
    );
    assert_eq!(
        ::std::mem::align_of::<found_btree_node>(),
        8usize,
        concat!("Alignment of ", stringify!(found_btree_node)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btree_id) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(found_btree_node),
            "::",
            stringify!(btree_id),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(found_btree_node),
            "::",
            stringify!(level),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sectors_written) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(found_btree_node),
            "::",
            stringify!(sectors_written),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(found_btree_node), "::", stringify!(seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_seq) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(found_btree_node),
            "::",
            stringify!(journal_seq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cookie) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(found_btree_node),
            "::",
            stringify!(cookie),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_key) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(found_btree_node),
            "::",
            stringify!(min_key),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_key) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(found_btree_node),
            "::",
            stringify!(max_key),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_ptrs) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(found_btree_node),
            "::",
            stringify!(nr_ptrs),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptrs) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(found_btree_node),
            "::",
            stringify!(ptrs),
        ),
    );
}
impl found_btree_node {
    #[inline]
    pub fn range_updated(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_range_updated(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(range_updated: bool) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let range_updated: u8 = unsafe {
                        ::std::mem::transmute(range_updated)
                    };
                    range_updated as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct darray_found_btree_node {
    pub nr: usize,
    pub size: usize,
    pub data: *mut found_btree_node,
    pub preallocated: __IncompleteArrayField<found_btree_node>,
}
#[test]
fn bindgen_test_layout_darray_found_btree_node() {
    const UNINIT: ::std::mem::MaybeUninit<darray_found_btree_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<darray_found_btree_node>(),
        24usize,
        concat!("Size of: ", stringify!(darray_found_btree_node)),
    );
    assert_eq!(
        ::std::mem::align_of::<darray_found_btree_node>(),
        8usize,
        concat!("Alignment of ", stringify!(darray_found_btree_node)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(darray_found_btree_node),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(darray_found_btree_node),
            "::",
            stringify!(size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(darray_found_btree_node),
            "::",
            stringify!(data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(darray_found_btree_node),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for darray_found_btree_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct find_btree_nodes {
    pub ret: ::std::os::raw::c_int,
    pub lock: mutex,
    pub nodes: darray_found_btree_node,
}
#[test]
fn bindgen_test_layout_find_btree_nodes() {
    const UNINIT: ::std::mem::MaybeUninit<find_btree_nodes> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<find_btree_nodes>(),
        72usize,
        concat!("Size of: ", stringify!(find_btree_nodes)),
    );
    assert_eq!(
        ::std::mem::align_of::<find_btree_nodes>(),
        8usize,
        concat!("Alignment of ", stringify!(find_btree_nodes)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ret) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(find_btree_nodes), "::", stringify!(ret)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(find_btree_nodes),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nodes) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(find_btree_nodes),
            "::",
            stringify!(nodes),
        ),
    );
}
impl Default for find_btree_nodes {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_extent_crc_unpacked {
    pub compressed_size: u32_,
    pub uncompressed_size: u32_,
    pub live_size: u32_,
    pub csum_type: u8_,
    pub compression_type: u8_,
    pub offset: u16_,
    pub nonce: u16_,
    pub csum: bch_csum,
}
#[test]
fn bindgen_test_layout_bch_extent_crc_unpacked() {
    const UNINIT: ::std::mem::MaybeUninit<bch_extent_crc_unpacked> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_extent_crc_unpacked>(),
        40usize,
        concat!("Size of: ", stringify!(bch_extent_crc_unpacked)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_extent_crc_unpacked>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_extent_crc_unpacked)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compressed_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc_unpacked),
            "::",
            stringify!(compressed_size),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).uncompressed_size) as usize - ptr as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc_unpacked),
            "::",
            stringify!(uncompressed_size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).live_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc_unpacked),
            "::",
            stringify!(live_size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum_type) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc_unpacked),
            "::",
            stringify!(csum_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compression_type) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc_unpacked),
            "::",
            stringify!(compression_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc_unpacked),
            "::",
            stringify!(offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nonce) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc_unpacked),
            "::",
            stringify!(nonce),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csum) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_extent_crc_unpacked),
            "::",
            stringify!(csum),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct extent_ptr_decoded {
    pub has_ec: bool,
    pub do_ec_reconstruct: bool,
    pub crc_retry_nr: u8_,
    pub crc: bch_extent_crc_unpacked,
    pub ptr: bch_extent_ptr,
    pub ec: bch_extent_stripe_ptr,
}
#[test]
fn bindgen_test_layout_extent_ptr_decoded() {
    const UNINIT: ::std::mem::MaybeUninit<extent_ptr_decoded> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<extent_ptr_decoded>(),
        64usize,
        concat!("Size of: ", stringify!(extent_ptr_decoded)),
    );
    assert_eq!(
        ::std::mem::align_of::<extent_ptr_decoded>(),
        8usize,
        concat!("Alignment of ", stringify!(extent_ptr_decoded)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_ec) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(extent_ptr_decoded),
            "::",
            stringify!(has_ec),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).do_ec_reconstruct) as usize - ptr as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(extent_ptr_decoded),
            "::",
            stringify!(do_ec_reconstruct),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crc_retry_nr) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(extent_ptr_decoded),
            "::",
            stringify!(crc_retry_nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(extent_ptr_decoded),
            "::",
            stringify!(crc),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(extent_ptr_decoded),
            "::",
            stringify!(ptr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ec) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(extent_ptr_decoded),
            "::",
            stringify!(ec),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_io_failures {
    pub nr: u8_,
    pub data: [bch_io_failures_bch_dev_io_failures; 5usize],
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_io_failures_bch_dev_io_failures {
    pub dev: u8_,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub errcode: s16,
}
#[test]
fn bindgen_test_layout_bch_io_failures_bch_dev_io_failures() {
    const UNINIT: ::std::mem::MaybeUninit<bch_io_failures_bch_dev_io_failures> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_io_failures_bch_dev_io_failures>(),
        4usize,
        concat!("Size of: ", stringify!(bch_io_failures_bch_dev_io_failures)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_io_failures_bch_dev_io_failures>(),
        4usize,
        concat!("Alignment of ", stringify!(bch_io_failures_bch_dev_io_failures)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dev) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_io_failures_bch_dev_io_failures),
            "::",
            stringify!(dev),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).errcode) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_io_failures_bch_dev_io_failures),
            "::",
            stringify!(errcode),
        ),
    );
}
impl bch_io_failures_bch_dev_io_failures {
    #[inline]
    pub fn csum_nr(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_csum_nr(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn ec(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_ec(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        csum_nr: ::std::os::raw::c_uint,
        ec: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                7u8,
                {
                    let csum_nr: u32 = unsafe { ::std::mem::transmute(csum_nr) };
                    csum_nr as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                1u8,
                {
                    let ec: u8 = unsafe { ::std::mem::transmute(ec) };
                    ec as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_bch_io_failures() {
    const UNINIT: ::std::mem::MaybeUninit<bch_io_failures> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_io_failures>(),
        24usize,
        concat!("Size of: ", stringify!(bch_io_failures)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_io_failures>(),
        4usize,
        concat!("Alignment of ", stringify!(bch_io_failures)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_io_failures), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(bch_io_failures), "::", stringify!(data)),
    );
}
#[repr(C)]
pub struct journal_buf {
    pub io: closure,
    pub data: *mut jset,
    pub key: bkey_i,
    pub key_pad: [__u64; 4usize],
    pub devs_written: bch_devs_list,
    pub failed: bch_io_failures,
    pub wait: closure_waitlist,
    pub last_seq: u64_,
    pub expires: ::std::os::raw::c_long,
    pub flush_time: u64_,
    pub buf_size: ::std::os::raw::c_uint,
    pub sectors: ::std::os::raw::c_uint,
    pub disk_sectors: ::std::os::raw::c_uint,
    pub u64s_reserved: ::std::os::raw::c_uint,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub idx: u8_,
}
#[test]
fn bindgen_test_layout_journal_buf() {
    const UNINIT: ::std::mem::MaybeUninit<journal_buf> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_buf>(),
        232usize,
        concat!("Size of: ", stringify!(journal_buf)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_buf>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_buf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).io) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(io)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(key)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_pad) as usize - ptr as usize },
        96usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(key_pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).devs_written) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_buf),
            "::",
            stringify!(devs_written),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).failed) as usize - ptr as usize },
        148usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(failed)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait) as usize - ptr as usize },
        176usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(wait)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_seq) as usize - ptr as usize },
        184usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(last_seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).expires) as usize - ptr as usize },
        192usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(expires)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush_time) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_buf),
            "::",
            stringify!(flush_time),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf_size) as usize - ptr as usize },
        208usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(buf_size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sectors) as usize - ptr as usize },
        212usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(sectors)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).disk_sectors) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_buf),
            "::",
            stringify!(disk_sectors),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s_reserved) as usize - ptr as usize },
        220usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_buf),
            "::",
            stringify!(u64s_reserved),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).idx) as usize - ptr as usize },
        225usize,
        concat!("Offset of field: ", stringify!(journal_buf), "::", stringify!(idx)),
    );
}
impl Default for journal_buf {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl journal_buf {
    #[inline]
    pub fn noflush(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_noflush(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn must_flush(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_must_flush(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_flush(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_separate_flush(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn need_flush_to_write_buffer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_need_flush_to_write_buffer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn write_started(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_write_started(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn write_allocated(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_write_allocated(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn write_done(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_write_done(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn empty(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_empty(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        noflush: bool,
        must_flush: bool,
        separate_flush: bool,
        need_flush_to_write_buffer: bool,
        write_started: bool,
        write_allocated: bool,
        write_done: bool,
        empty: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let noflush: u8 = unsafe { ::std::mem::transmute(noflush) };
                    noflush as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                1usize,
                1u8,
                {
                    let must_flush: u8 = unsafe { ::std::mem::transmute(must_flush) };
                    must_flush as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                2usize,
                1u8,
                {
                    let separate_flush: u8 = unsafe {
                        ::std::mem::transmute(separate_flush)
                    };
                    separate_flush as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                3usize,
                1u8,
                {
                    let need_flush_to_write_buffer: u8 = unsafe {
                        ::std::mem::transmute(need_flush_to_write_buffer)
                    };
                    need_flush_to_write_buffer as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                4usize,
                1u8,
                {
                    let write_started: u8 = unsafe {
                        ::std::mem::transmute(write_started)
                    };
                    write_started as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                5usize,
                1u8,
                {
                    let write_allocated: u8 = unsafe {
                        ::std::mem::transmute(write_allocated)
                    };
                    write_allocated as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                6usize,
                1u8,
                {
                    let write_done: u8 = unsafe { ::std::mem::transmute(write_done) };
                    write_done as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                1u8,
                {
                    let empty: u8 = unsafe { ::std::mem::transmute(empty) };
                    empty as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
pub struct journal_entry_pin_list {
    pub unflushed: [cds_list_head; 6usize],
    pub flushed: [cds_list_head; 6usize],
    pub count: atomic_t,
    pub devs: bch_replicas_padded,
    pub bytes: usize,
}
#[test]
fn bindgen_test_layout_journal_entry_pin_list() {
    const UNINIT: ::std::mem::MaybeUninit<journal_entry_pin_list> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_entry_pin_list>(),
        224usize,
        concat!("Size of: ", stringify!(journal_entry_pin_list)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_entry_pin_list>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_entry_pin_list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unflushed) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_entry_pin_list),
            "::",
            stringify!(unflushed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flushed) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_entry_pin_list),
            "::",
            stringify!(flushed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_entry_pin_list),
            "::",
            stringify!(count),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).devs) as usize - ptr as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_entry_pin_list),
            "::",
            stringify!(devs),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_entry_pin_list),
            "::",
            stringify!(bytes),
        ),
    );
}
impl Default for journal_entry_pin_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type journal_pin_flush_fn = ::std::option::Option<
    unsafe extern "C" fn(
        j: *mut journal,
        arg1: *mut journal_entry_pin,
        arg2: u64_,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct journal_entry_pin {
    pub list: cds_list_head,
    pub flush: journal_pin_flush_fn,
    pub seq: u64_,
}
#[test]
fn bindgen_test_layout_journal_entry_pin() {
    const UNINIT: ::std::mem::MaybeUninit<journal_entry_pin> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_entry_pin>(),
        32usize,
        concat!("Size of: ", stringify!(journal_entry_pin)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_entry_pin>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_entry_pin)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_entry_pin),
            "::",
            stringify!(list),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_entry_pin),
            "::",
            stringify!(flush),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_entry_pin),
            "::",
            stringify!(seq),
        ),
    );
}
impl Default for journal_entry_pin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_res {
    pub ref_: bool,
    pub u64s: u16_,
    pub offset: u32_,
    pub seq: u64_,
}
#[test]
fn bindgen_test_layout_journal_res() {
    const UNINIT: ::std::mem::MaybeUninit<journal_res> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_res>(),
        16usize,
        concat!("Size of: ", stringify!(journal_res)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_res>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_res)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ref_) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(journal_res), "::", stringify!(ref_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(journal_res), "::", stringify!(u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(journal_res), "::", stringify!(offset)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(journal_res), "::", stringify!(seq)),
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union journal_res_state {
    pub __bindgen_anon_1: journal_res_state__bindgen_ty_1,
    pub __bindgen_anon_2: journal_res_state__bindgen_ty_2,
    pub __bindgen_anon_3: journal_res_state__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_res_state__bindgen_ty_1 {
    pub counter: atomic64_t,
}
#[test]
fn bindgen_test_layout_journal_res_state__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<journal_res_state__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_res_state__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(journal_res_state__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_res_state__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_res_state__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).counter) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_res_state__bindgen_ty_1),
            "::",
            stringify!(counter),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_res_state__bindgen_ty_2 {
    pub v: u64_,
}
#[test]
fn bindgen_test_layout_journal_res_state__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<journal_res_state__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_res_state__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(journal_res_state__bindgen_ty_2)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_res_state__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_res_state__bindgen_ty_2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_res_state__bindgen_ty_2),
            "::",
            stringify!(v),
        ),
    );
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_res_state__bindgen_ty_3 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_journal_res_state__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<journal_res_state__bindgen_ty_3>(),
        8usize,
        concat!("Size of: ", stringify!(journal_res_state__bindgen_ty_3)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_res_state__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_res_state__bindgen_ty_3)),
    );
}
impl journal_res_state__bindgen_ty_3 {
    #[inline]
    pub fn cur_entry_offset(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 22u8) as u64) }
    }
    #[inline]
    pub fn set_cur_entry_offset(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 22u8, val as u64)
        }
    }
    #[inline]
    pub fn idx(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 2u8) as u64) }
    }
    #[inline]
    pub fn set_idx(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn buf0_count(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 10u8) as u64) }
    }
    #[inline]
    pub fn set_buf0_count(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn buf1_count(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(34usize, 10u8) as u64) }
    }
    #[inline]
    pub fn set_buf1_count(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(34usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn buf2_count(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(44usize, 10u8) as u64) }
    }
    #[inline]
    pub fn set_buf2_count(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(44usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn buf3_count(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(54usize, 10u8) as u64) }
    }
    #[inline]
    pub fn set_buf3_count(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(54usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        cur_entry_offset: u64_,
        idx: u64_,
        buf0_count: u64_,
        buf1_count: u64_,
        buf2_count: u64_,
        buf3_count: u64_,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                22u8,
                {
                    let cur_entry_offset: u64 = unsafe {
                        ::std::mem::transmute(cur_entry_offset)
                    };
                    cur_entry_offset as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                22usize,
                2u8,
                {
                    let idx: u64 = unsafe { ::std::mem::transmute(idx) };
                    idx as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                24usize,
                10u8,
                {
                    let buf0_count: u64 = unsafe { ::std::mem::transmute(buf0_count) };
                    buf0_count as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                34usize,
                10u8,
                {
                    let buf1_count: u64 = unsafe { ::std::mem::transmute(buf1_count) };
                    buf1_count as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                44usize,
                10u8,
                {
                    let buf2_count: u64 = unsafe { ::std::mem::transmute(buf2_count) };
                    buf2_count as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                54usize,
                10u8,
                {
                    let buf3_count: u64 = unsafe { ::std::mem::transmute(buf3_count) };
                    buf3_count as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_journal_res_state() {
    assert_eq!(
        ::std::mem::size_of::<journal_res_state>(),
        8usize,
        concat!("Size of: ", stringify!(journal_res_state)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_res_state>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_res_state)),
    );
}
impl Default for journal_res_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_space {
    pub next_entry: ::std::os::raw::c_uint,
    pub total: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_journal_space() {
    const UNINIT: ::std::mem::MaybeUninit<journal_space> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_space>(),
        8usize,
        concat!("Size of: ", stringify!(journal_space)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_space>(),
        4usize,
        concat!("Alignment of ", stringify!(journal_space)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next_entry) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_space),
            "::",
            stringify!(next_entry),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(journal_space), "::", stringify!(total)),
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct journal_bio {
    pub ca: *mut bch_dev,
    pub buf_idx: ::std::os::raw::c_uint,
    pub submit_time: u64_,
    pub bio: bio,
}
#[test]
fn bindgen_test_layout_journal_bio() {
    const UNINIT: ::std::mem::MaybeUninit<journal_bio> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_bio>(),
        128usize,
        concat!("Size of: ", stringify!(journal_bio)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_bio>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_bio)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ca) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(journal_bio), "::", stringify!(ca)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf_idx) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(journal_bio), "::", stringify!(buf_idx)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).submit_time) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_bio),
            "::",
            stringify!(submit_time),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bio) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(journal_bio), "::", stringify!(bio)),
    );
}
impl Default for journal_bio {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(64))]
pub struct journal {
    pub __bindgen_anon_1: journal__bindgen_ty_1,
    pub flags: ::std::os::raw::c_ulong,
    pub cur_entry_u64s: ::std::os::raw::c_uint,
    pub cur_entry_sectors: ::std::os::raw::c_uint,
    pub entry_u64s_reserved: ::std::os::raw::c_uint,
    pub cur_entry_error: ::std::os::raw::c_int,
    pub cur_entry_offset_if_blocked: ::std::os::raw::c_uint,
    pub buf_size_want: ::std::os::raw::c_uint,
    pub early_journal_entries: darray_u64,
    pub buf_lock: mutex,
    pub buf: [journal_buf; 16usize],
    pub free_buf: *mut ::std::os::raw::c_void,
    pub free_buf_size: ::std::os::raw::c_uint,
    pub lock: spinlock_t,
    pub blocked: ::std::os::raw::c_uint,
    pub wait: wait_queue_head_t,
    pub async_wait: closure_waitlist,
    pub reclaim_flush_wait: closure_waitlist,
    pub write_work: delayed_work,
    pub wq: *mut workqueue_struct,
    pub seq: atomic64_t,
    pub seq_write_started: u64_,
    pub seq_ondisk: u64_,
    pub flushed_seq_ondisk: u64_,
    pub flushing_seq: u64_,
    pub last_seq_ondisk: u64_,
    pub err_seq: u64_,
    pub last_empty_seq: u64_,
    pub oldest_seq_found_ondisk: u64_,
    pub pin: journal__bindgen_ty_2,
    pub last_seq: u64_,
    pub dirty_entry_bytes: usize,
    pub space: [journal_space; 4usize],
    pub replay_journal_seq: u64_,
    pub replay_journal_seq_end: u64_,
    pub __bindgen_padding_0: [u64; 4usize],
    pub wp: write_point,
    pub err_lock: spinlock_t,
    pub reclaim_lock: mutex,
    pub reclaim_wait: wait_queue_head_t,
    pub reclaim_thread: *mut task_struct,
    pub reclaim_kicked: bool,
    pub next_reclaim: ::std::os::raw::c_ulong,
    pub nr_direct_reclaim: u64_,
    pub nr_background_reclaim: u64_,
    pub last_flushed: ::std::os::raw::c_ulong,
    pub flush_in_progress: *mut journal_entry_pin,
    pub flush_in_progress_dropped: bool,
    pub pin_flush_wait: wait_queue_head_t,
    pub discard_lock: mutex,
    pub can_discard: bool,
    pub last_flush_write: ::std::os::raw::c_ulong,
    pub write_start_time: u64_,
    pub nr_flush_writes: u64_,
    pub nr_noflush_writes: u64_,
    pub entry_bytes_written: u64_,
    pub flush_write_time: *mut bch2_time_stats,
    pub noflush_write_time: *mut bch2_time_stats,
    pub flush_seq_time: *mut bch2_time_stats,
}
#[repr(C)]
#[repr(align(64))]
#[derive(Copy, Clone)]
pub struct journal__bindgen_ty_1 {
    pub reservations: journal_res_state,
    pub watermark: bch_watermark,
}
#[test]
fn bindgen_test_layout_journal__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<journal__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(journal__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal__bindgen_ty_1>(),
        64usize,
        concat!("Alignment of ", stringify!(journal__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reservations) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal__bindgen_ty_1),
            "::",
            stringify!(reservations),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).watermark) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(journal__bindgen_ty_1),
            "::",
            stringify!(watermark),
        ),
    );
}
impl Default for journal__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct journal__bindgen_ty_2 {
    pub front: u64_,
    pub back: u64_,
    pub size: u64_,
    pub mask: u64_,
    pub data: *mut journal_entry_pin_list,
}
#[test]
fn bindgen_test_layout_journal__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<journal__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal__bindgen_ty_2>(),
        40usize,
        concat!("Size of: ", stringify!(journal__bindgen_ty_2)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(journal__bindgen_ty_2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).front) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal__bindgen_ty_2),
            "::",
            stringify!(front),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).back) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(journal__bindgen_ty_2),
            "::",
            stringify!(back),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(journal__bindgen_ty_2),
            "::",
            stringify!(size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mask) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(journal__bindgen_ty_2),
            "::",
            stringify!(mask),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(journal__bindgen_ty_2),
            "::",
            stringify!(data),
        ),
    );
}
impl Default for journal__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_journal() {
    const UNINIT: ::std::mem::MaybeUninit<journal> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal>(),
        5504usize,
        concat!("Size of: ", stringify!(journal)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal>(),
        64usize,
        concat!("Alignment of ", stringify!(journal)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cur_entry_u64s) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(cur_entry_u64s),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).cur_entry_sectors) as usize - ptr as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(cur_entry_sectors),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).entry_u64s_reserved) as usize - ptr as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(entry_u64s_reserved),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cur_entry_error) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(cur_entry_error),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).cur_entry_offset_if_blocked) as usize
                - ptr as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(cur_entry_offset_if_blocked),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf_size_want) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(buf_size_want),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).early_journal_entries) as usize - ptr as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(early_journal_entries),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf_lock) as usize - ptr as usize },
        120usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(buf_lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf) as usize - ptr as usize },
        160usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(buf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).free_buf) as usize - ptr as usize },
        3872usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(free_buf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).free_buf_size) as usize - ptr as usize },
        3880usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(free_buf_size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        3888usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blocked) as usize - ptr as usize },
        3928usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(blocked)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait) as usize - ptr as usize },
        3936usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(wait)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).async_wait) as usize - ptr as usize },
        3992usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(async_wait)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).reclaim_flush_wait) as usize - ptr as usize
        },
        4000usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(reclaim_flush_wait),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_work) as usize - ptr as usize },
        4008usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(write_work)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wq) as usize - ptr as usize },
        4072usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(wq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        4080usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(seq)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).seq_write_started) as usize - ptr as usize
        },
        4088usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(seq_write_started),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq_ondisk) as usize - ptr as usize },
        4096usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(seq_ondisk)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).flushed_seq_ondisk) as usize - ptr as usize
        },
        4104usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(flushed_seq_ondisk),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flushing_seq) as usize - ptr as usize },
        4112usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(flushing_seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_seq_ondisk) as usize - ptr as usize },
        4120usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(last_seq_ondisk),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).err_seq) as usize - ptr as usize },
        4128usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(err_seq)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_empty_seq) as usize - ptr as usize },
        4136usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(last_empty_seq),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).oldest_seq_found_ondisk) as usize - ptr as usize
        },
        4144usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(oldest_seq_found_ondisk),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pin) as usize - ptr as usize },
        4152usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(pin)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_seq) as usize - ptr as usize },
        4192usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(last_seq)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).dirty_entry_bytes) as usize - ptr as usize
        },
        4200usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(dirty_entry_bytes),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).space) as usize - ptr as usize },
        4208usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(space)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).replay_journal_seq) as usize - ptr as usize
        },
        4240usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(replay_journal_seq),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).replay_journal_seq_end) as usize - ptr as usize
        },
        4248usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(replay_journal_seq_end),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wp) as usize - ptr as usize },
        4288usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(wp)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).err_lock) as usize - ptr as usize },
        5120usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(err_lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reclaim_lock) as usize - ptr as usize },
        5160usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(reclaim_lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reclaim_wait) as usize - ptr as usize },
        5200usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(reclaim_wait)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reclaim_thread) as usize - ptr as usize },
        5256usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(reclaim_thread),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reclaim_kicked) as usize - ptr as usize },
        5264usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(reclaim_kicked),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next_reclaim) as usize - ptr as usize },
        5272usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(next_reclaim)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).nr_direct_reclaim) as usize - ptr as usize
        },
        5280usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(nr_direct_reclaim),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).nr_background_reclaim) as usize - ptr as usize
        },
        5288usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(nr_background_reclaim),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_flushed) as usize - ptr as usize },
        5296usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(last_flushed)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).flush_in_progress) as usize - ptr as usize
        },
        5304usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(flush_in_progress),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).flush_in_progress_dropped) as usize
                - ptr as usize
        },
        5312usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(flush_in_progress_dropped),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pin_flush_wait) as usize - ptr as usize },
        5320usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(pin_flush_wait),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).discard_lock) as usize - ptr as usize },
        5376usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(discard_lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).can_discard) as usize - ptr as usize },
        5416usize,
        concat!("Offset of field: ", stringify!(journal), "::", stringify!(can_discard)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_flush_write) as usize - ptr as usize },
        5424usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(last_flush_write),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_start_time) as usize - ptr as usize },
        5432usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(write_start_time),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_flush_writes) as usize - ptr as usize },
        5440usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(nr_flush_writes),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).nr_noflush_writes) as usize - ptr as usize
        },
        5448usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(nr_noflush_writes),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).entry_bytes_written) as usize - ptr as usize
        },
        5456usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(entry_bytes_written),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush_write_time) as usize - ptr as usize },
        5464usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(flush_write_time),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).noflush_write_time) as usize - ptr as usize
        },
        5472usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(noflush_write_time),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush_seq_time) as usize - ptr as usize },
        5480usize,
        concat!(
            "Offset of field: ",
            stringify!(journal),
            "::",
            stringify!(flush_seq_time),
        ),
    );
}
impl Default for journal {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct journal_device {
    pub bucket_seq: *mut u64_,
    pub sectors_free: ::std::os::raw::c_uint,
    pub discard_idx: ::std::os::raw::c_uint,
    pub dirty_idx_ondisk: ::std::os::raw::c_uint,
    pub dirty_idx: ::std::os::raw::c_uint,
    pub cur_idx: ::std::os::raw::c_uint,
    pub nr: ::std::os::raw::c_uint,
    pub buckets: *mut u64_,
    pub bio: [*mut journal_bio; 16usize],
    pub read: closure,
    pub highest_seq_found: u64_,
}
#[test]
fn bindgen_test_layout_journal_device() {
    const UNINIT: ::std::mem::MaybeUninit<journal_device> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_device>(),
        224usize,
        concat!("Size of: ", stringify!(journal_device)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_device>(),
        8usize,
        concat!("Alignment of ", stringify!(journal_device)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bucket_seq) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_device),
            "::",
            stringify!(bucket_seq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sectors_free) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_device),
            "::",
            stringify!(sectors_free),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).discard_idx) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_device),
            "::",
            stringify!(discard_idx),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dirty_idx_ondisk) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_device),
            "::",
            stringify!(dirty_idx_ondisk),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dirty_idx) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_device),
            "::",
            stringify!(dirty_idx),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cur_idx) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_device),
            "::",
            stringify!(cur_idx),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(journal_device), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buckets) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_device),
            "::",
            stringify!(buckets),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bio) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(journal_device), "::", stringify!(bio)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read) as usize - ptr as usize },
        168usize,
        concat!("Offset of field: ", stringify!(journal_device), "::", stringify!(read)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).highest_seq_found) as usize - ptr as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_device),
            "::",
            stringify!(highest_seq_found),
        ),
    );
}
impl Default for journal_device {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct journal_entry_res {
    pub u64s: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_journal_entry_res() {
    const UNINIT: ::std::mem::MaybeUninit<journal_entry_res> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<journal_entry_res>(),
        4usize,
        concat!("Size of: ", stringify!(journal_entry_res)),
    );
    assert_eq!(
        ::std::mem::align_of::<journal_entry_res>(),
        4usize,
        concat!("Alignment of ", stringify!(journal_entry_res)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(journal_entry_res),
            "::",
            stringify!(u64s),
        ),
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct wb_key_ref {
    pub __bindgen_anon_1: wb_key_ref__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wb_key_ref__bindgen_ty_1 {
    pub __bindgen_anon_1: wb_key_ref__bindgen_ty_1__bindgen_ty_1,
    pub __bindgen_anon_2: wb_key_ref__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct wb_key_ref__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub pos: [u8_; 20usize],
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[test]
fn bindgen_test_layout_wb_key_ref__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<wb_key_ref__bindgen_ty_1__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<wb_key_ref__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(wb_key_ref__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<wb_key_ref__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(wb_key_ref__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(wb_key_ref__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(pos),
        ),
    );
}
impl Default for wb_key_ref__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl wb_key_ref__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn idx(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_idx(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        idx: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                24u8,
                {
                    let idx: u32 = unsafe { ::std::mem::transmute(idx) };
                    idx as u64
                },
            );
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn btree(&self) -> btree_id {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_btree(&mut self, val: btree_id) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_2(btree: btree_id) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                8u8,
                {
                    let btree: u32 = unsafe { ::std::mem::transmute(btree) };
                    btree as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct wb_key_ref__bindgen_ty_1__bindgen_ty_2 {
    pub lo: u64_,
    pub mi: u64_,
    pub hi: u64_,
}
#[test]
fn bindgen_test_layout_wb_key_ref__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<wb_key_ref__bindgen_ty_1__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<wb_key_ref__bindgen_ty_1__bindgen_ty_2>(),
        24usize,
        concat!("Size of: ", stringify!(wb_key_ref__bindgen_ty_1__bindgen_ty_2)),
    );
    assert_eq!(
        ::std::mem::align_of::<wb_key_ref__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(wb_key_ref__bindgen_ty_1__bindgen_ty_2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lo) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wb_key_ref__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(lo),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mi) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(wb_key_ref__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(mi),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hi) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(wb_key_ref__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(hi),
        ),
    );
}
#[test]
fn bindgen_test_layout_wb_key_ref__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wb_key_ref__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(wb_key_ref__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<wb_key_ref__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(wb_key_ref__bindgen_ty_1)),
    );
}
impl Default for wb_key_ref__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_wb_key_ref() {
    assert_eq!(
        ::std::mem::size_of::<wb_key_ref>(),
        24usize,
        concat!("Size of: ", stringify!(wb_key_ref)),
    );
    assert_eq!(
        ::std::mem::align_of::<wb_key_ref>(),
        8usize,
        concat!("Alignment of ", stringify!(wb_key_ref)),
    );
}
impl Default for wb_key_ref {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct btree_write_buffered_key {
    pub _bitfield_align_1: [u64; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub k: bkey_i,
    pub k_pad: [__u64; 4usize],
}
#[test]
fn bindgen_test_layout_btree_write_buffered_key() {
    const UNINIT: ::std::mem::MaybeUninit<btree_write_buffered_key> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_write_buffered_key>(),
        80usize,
        concat!("Size of: ", stringify!(btree_write_buffered_key)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_write_buffered_key>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_write_buffered_key)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_write_buffered_key),
            "::",
            stringify!(k),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k_pad) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_write_buffered_key),
            "::",
            stringify!(k_pad),
        ),
    );
}
impl Default for btree_write_buffered_key {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl btree_write_buffered_key {
    #[inline]
    pub fn btree(&self) -> btree_id {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_btree(&mut self, val: btree_id) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn journal_seq(&self) -> u64_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 56u8) as u64) }
    }
    #[inline]
    pub fn set_journal_seq(&mut self, val: u64_) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 56u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        btree: btree_id,
        journal_seq: u64_,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                8u8,
                {
                    let btree: u32 = unsafe { ::std::mem::transmute(btree) };
                    btree as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                8usize,
                56u8,
                {
                    let journal_seq: u64 = unsafe { ::std::mem::transmute(journal_seq) };
                    journal_seq as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
pub struct btree_write_buffer_keys {
    pub keys: darray_u64,
    pub pin: journal_entry_pin,
    pub lock: mutex,
}
#[test]
fn bindgen_test_layout_btree_write_buffer_keys() {
    const UNINIT: ::std::mem::MaybeUninit<btree_write_buffer_keys> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_write_buffer_keys>(),
        96usize,
        concat!("Size of: ", stringify!(btree_write_buffer_keys)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_write_buffer_keys>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_write_buffer_keys)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keys) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_write_buffer_keys),
            "::",
            stringify!(keys),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pin) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_write_buffer_keys),
            "::",
            stringify!(pin),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_write_buffer_keys),
            "::",
            stringify!(lock),
        ),
    );
}
impl Default for btree_write_buffer_keys {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct bch_fs_btree_write_buffer {
    pub sorted: bch_fs_btree_write_buffer__bindgen_ty_1,
    pub inc: btree_write_buffer_keys,
    pub flushing: btree_write_buffer_keys,
    pub flush_work: work_struct,
    pub accounting: bch_fs_btree_write_buffer__bindgen_ty_2,
}
#[repr(C)]
pub struct bch_fs_btree_write_buffer__bindgen_ty_1 {
    pub nr: usize,
    pub size: usize,
    pub data: *mut wb_key_ref,
    pub preallocated: __IncompleteArrayField<wb_key_ref>,
}
#[test]
fn bindgen_test_layout_bch_fs_btree_write_buffer__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_write_buffer__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_write_buffer__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(bch_fs_btree_write_buffer__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_write_buffer__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_write_buffer__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer__bindgen_ty_1),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer__bindgen_ty_1),
            "::",
            stringify!(size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer__bindgen_ty_1),
            "::",
            stringify!(data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer__bindgen_ty_1),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for bch_fs_btree_write_buffer__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_fs_btree_write_buffer__bindgen_ty_2 {
    pub nr: usize,
    pub size: usize,
    pub data: *mut btree_write_buffered_key,
    pub preallocated: __IncompleteArrayField<btree_write_buffered_key>,
}
#[test]
fn bindgen_test_layout_bch_fs_btree_write_buffer__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_write_buffer__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_write_buffer__bindgen_ty_2>(),
        24usize,
        concat!("Size of: ", stringify!(bch_fs_btree_write_buffer__bindgen_ty_2)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_write_buffer__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_write_buffer__bindgen_ty_2)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer__bindgen_ty_2),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer__bindgen_ty_2),
            "::",
            stringify!(size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer__bindgen_ty_2),
            "::",
            stringify!(data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer__bindgen_ty_2),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for bch_fs_btree_write_buffer__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bch_fs_btree_write_buffer() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_write_buffer> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_write_buffer>(),
        272usize,
        concat!("Size of: ", stringify!(bch_fs_btree_write_buffer)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_write_buffer>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_write_buffer)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sorted) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer),
            "::",
            stringify!(sorted),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inc) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer),
            "::",
            stringify!(inc),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flushing) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer),
            "::",
            stringify!(flushing),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush_work) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer),
            "::",
            stringify!(flush_work),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).accounting) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_write_buffer),
            "::",
            stringify!(accounting),
        ),
    );
}
impl Default for bch_fs_btree_write_buffer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum six_lock_type {
    SIX_LOCK_read = 0,
    SIX_LOCK_intent = 1,
    SIX_LOCK_write = 2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct six_lock {
    pub state: atomic_t,
    pub seq: u32_,
    pub intent_lock_recurse: ::std::os::raw::c_uint,
    pub write_lock_recurse: ::std::os::raw::c_uint,
    pub owner: *mut task_struct,
    pub readers: *mut ::std::os::raw::c_uint,
    pub wait_lock: raw_spinlock_t,
    pub wait_list: cds_list_head,
}
#[test]
fn bindgen_test_layout_six_lock() {
    const UNINIT: ::std::mem::MaybeUninit<six_lock> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<six_lock>(),
        88usize,
        concat!("Size of: ", stringify!(six_lock)),
    );
    assert_eq!(
        ::std::mem::align_of::<six_lock>(),
        8usize,
        concat!("Alignment of ", stringify!(six_lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(six_lock), "::", stringify!(state)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(six_lock), "::", stringify!(seq)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).intent_lock_recurse) as usize - ptr as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(six_lock),
            "::",
            stringify!(intent_lock_recurse),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).write_lock_recurse) as usize - ptr as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(six_lock),
            "::",
            stringify!(write_lock_recurse),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).owner) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(six_lock), "::", stringify!(owner)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).readers) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(six_lock), "::", stringify!(readers)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait_lock) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(six_lock), "::", stringify!(wait_lock)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait_list) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(six_lock), "::", stringify!(wait_list)),
    );
}
impl Default for six_lock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct six_lock_waiter {
    pub list: cds_list_head,
    pub task: *mut task_struct,
    pub lock_want: six_lock_type,
    pub lock_acquired: bool,
    pub start_time: u64_,
}
#[test]
fn bindgen_test_layout_six_lock_waiter() {
    const UNINIT: ::std::mem::MaybeUninit<six_lock_waiter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<six_lock_waiter>(),
        40usize,
        concat!("Size of: ", stringify!(six_lock_waiter)),
    );
    assert_eq!(
        ::std::mem::align_of::<six_lock_waiter>(),
        8usize,
        concat!("Alignment of ", stringify!(six_lock_waiter)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(six_lock_waiter), "::", stringify!(list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).task) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(six_lock_waiter), "::", stringify!(task)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock_want) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(six_lock_waiter),
            "::",
            stringify!(lock_want),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock_acquired) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(six_lock_waiter),
            "::",
            stringify!(lock_acquired),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_time) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(six_lock_waiter),
            "::",
            stringify!(start_time),
        ),
    );
}
impl Default for six_lock_waiter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct btree_nr_keys {
    pub live_u64s: u16_,
    pub bset_u64s: [u16_; 3usize],
    pub packed_keys: u16_,
    pub unpacked_keys: u16_,
}
#[test]
fn bindgen_test_layout_btree_nr_keys() {
    const UNINIT: ::std::mem::MaybeUninit<btree_nr_keys> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_nr_keys>(),
        12usize,
        concat!("Size of: ", stringify!(btree_nr_keys)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_nr_keys>(),
        2usize,
        concat!("Alignment of ", stringify!(btree_nr_keys)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).live_u64s) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_nr_keys),
            "::",
            stringify!(live_u64s),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bset_u64s) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_nr_keys),
            "::",
            stringify!(bset_u64s),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).packed_keys) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_nr_keys),
            "::",
            stringify!(packed_keys),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpacked_keys) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_nr_keys),
            "::",
            stringify!(unpacked_keys),
        ),
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bset_tree {
    pub size: u16_,
    pub extra: u16_,
    pub data_offset: u16_,
    pub aux_data_offset: u16_,
    pub end_offset: u16_,
}
#[test]
fn bindgen_test_layout_bset_tree() {
    const UNINIT: ::std::mem::MaybeUninit<bset_tree> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bset_tree>(),
        10usize,
        concat!("Size of: ", stringify!(bset_tree)),
    );
    assert_eq!(
        ::std::mem::align_of::<bset_tree>(),
        2usize,
        concat!("Alignment of ", stringify!(bset_tree)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bset_tree), "::", stringify!(size)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extra) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(bset_tree), "::", stringify!(extra)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_offset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bset_tree),
            "::",
            stringify!(data_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).aux_data_offset) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(bset_tree),
            "::",
            stringify!(aux_data_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end_offset) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bset_tree), "::", stringify!(end_offset)),
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btree_write {
    pub journal: journal_entry_pin,
}
#[test]
fn bindgen_test_layout_btree_write() {
    const UNINIT: ::std::mem::MaybeUninit<btree_write> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_write>(),
        32usize,
        concat!("Size of: ", stringify!(btree_write)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_write>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_write)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(btree_write), "::", stringify!(journal)),
    );
}
impl Default for btree_write {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct btree_bkey_cached_common {
    pub lock: six_lock,
    pub level: u8_,
    pub btree_id: u8_,
    pub cached: bool,
}
#[test]
fn bindgen_test_layout_btree_bkey_cached_common() {
    const UNINIT: ::std::mem::MaybeUninit<btree_bkey_cached_common> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_bkey_cached_common>(),
        96usize,
        concat!("Size of: ", stringify!(btree_bkey_cached_common)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_bkey_cached_common>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_bkey_cached_common)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_bkey_cached_common),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_bkey_cached_common),
            "::",
            stringify!(level),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btree_id) as usize - ptr as usize },
        89usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_bkey_cached_common),
            "::",
            stringify!(btree_id),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cached) as usize - ptr as usize },
        90usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_bkey_cached_common),
            "::",
            stringify!(cached),
        ),
    );
}
impl Default for btree_bkey_cached_common {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct btree {
    pub c: btree_bkey_cached_common,
    pub hash: rhash_head,
    pub hash_val: u64_,
    pub flags: ::std::os::raw::c_ulong,
    pub written: u16_,
    pub nsets: u8_,
    pub nr_key_bits: u8_,
    pub version_ondisk: u16_,
    pub format: bkey_format,
    pub data: *mut btree_node,
    pub aux_data: *mut ::std::os::raw::c_void,
    pub set: [bset_tree; 3usize],
    pub nr: btree_nr_keys,
    pub sib_u64s: [u16_; 2usize],
    pub whiteout_u64s: u16_,
    pub byte_order: u8_,
    pub unpack_fn_len: u8_,
    pub writes: [btree_write; 2usize],
    pub key: bkey_i,
    pub key_pad: [__u64; 11usize],
    pub write_blocked: cds_list_head,
    pub will_make_reachable: ::std::os::raw::c_ulong,
    pub ob: open_buckets,
    pub list: cds_list_head,
}
#[test]
fn bindgen_test_layout_btree() {
    const UNINIT: ::std::mem::MaybeUninit<btree> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree>(),
        528usize,
        concat!("Size of: ", stringify!(btree)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree>(),
        8usize,
        concat!("Alignment of ", stringify!(btree)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).c) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(c)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hash) as usize - ptr as usize },
        96usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(hash)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hash_val) as usize - ptr as usize },
        104usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(hash_val)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        112usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).written) as usize - ptr as usize },
        120usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(written)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nsets) as usize - ptr as usize },
        122usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(nsets)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_key_bits) as usize - ptr as usize },
        123usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(nr_key_bits)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version_ondisk) as usize - ptr as usize },
        124usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(version_ondisk)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).format) as usize - ptr as usize },
        128usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(format)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        184usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).aux_data) as usize - ptr as usize },
        192usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(aux_data)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set) as usize - ptr as usize },
        200usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(set)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        230usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(nr)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sib_u64s) as usize - ptr as usize },
        242usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(sib_u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).whiteout_u64s) as usize - ptr as usize },
        246usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(whiteout_u64s)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).byte_order) as usize - ptr as usize },
        248usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(byte_order)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unpack_fn_len) as usize - ptr as usize },
        249usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(unpack_fn_len)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).writes) as usize - ptr as usize },
        256usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(writes)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        320usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(key)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_pad) as usize - ptr as usize },
        360usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(key_pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_blocked) as usize - ptr as usize },
        448usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(write_blocked)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).will_make_reachable) as usize - ptr as usize
        },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(btree),
            "::",
            stringify!(will_make_reachable),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ob) as usize - ptr as usize },
        472usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(ob)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        512usize,
        concat!("Offset of field: ", stringify!(btree), "::", stringify!(list)),
    );
}
impl Default for btree {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_btree_cache_not_freed_reasons {
    BCH_BTREE_CACHE_NOT_FREED_cache_reserve = 0,
    BCH_BTREE_CACHE_NOT_FREED_lock_intent = 1,
    BCH_BTREE_CACHE_NOT_FREED_lock_write = 2,
    BCH_BTREE_CACHE_NOT_FREED_dirty = 3,
    BCH_BTREE_CACHE_NOT_FREED_read_in_flight = 4,
    BCH_BTREE_CACHE_NOT_FREED_write_in_flight = 5,
    BCH_BTREE_CACHE_NOT_FREED_noevict = 6,
    BCH_BTREE_CACHE_NOT_FREED_write_blocked = 7,
    BCH_BTREE_CACHE_NOT_FREED_will_make_reachable = 8,
    BCH_BTREE_CACHE_NOT_FREED_access_bit = 9,
    BCH_BTREE_CACHE_NOT_FREED_REASONS_NR = 10,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btree_cache_list {
    pub idx: ::std::os::raw::c_uint,
    pub shrink: *mut shrinker,
    pub list: cds_list_head,
    pub nr: usize,
}
#[test]
fn bindgen_test_layout_btree_cache_list() {
    const UNINIT: ::std::mem::MaybeUninit<btree_cache_list> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_cache_list>(),
        40usize,
        concat!("Size of: ", stringify!(btree_cache_list)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_cache_list>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_cache_list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).idx) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(btree_cache_list), "::", stringify!(idx)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shrink) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_cache_list),
            "::",
            stringify!(shrink),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_cache_list),
            "::",
            stringify!(list),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(btree_cache_list), "::", stringify!(nr)),
    );
}
impl Default for btree_cache_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct btree_root {
    pub b: *mut btree,
    pub key: bkey_i,
    pub key_pad: [__u64; 11usize],
    pub level: u8_,
    pub alive: u8_,
    pub error: s16,
}
#[test]
fn bindgen_test_layout_btree_root() {
    const UNINIT: ::std::mem::MaybeUninit<btree_root> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_root>(),
        144usize,
        concat!("Size of: ", stringify!(btree_root)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_root>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_root)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).b) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(btree_root), "::", stringify!(b)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(btree_root), "::", stringify!(key)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_pad) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(btree_root), "::", stringify!(key_pad)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        136usize,
        concat!("Offset of field: ", stringify!(btree_root), "::", stringify!(level)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alive) as usize - ptr as usize },
        137usize,
        concat!("Offset of field: ", stringify!(btree_root), "::", stringify!(alive)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error) as usize - ptr as usize },
        138usize,
        concat!("Offset of field: ", stringify!(btree_root), "::", stringify!(error)),
    );
}
impl Default for btree_root {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct bch_fs_btree_cache {
    pub roots_known: [btree_root; 27usize],
    pub roots_extra: bch_fs_btree_cache__bindgen_ty_1,
    pub root_lock: mutex,
    pub table: rhashtable,
    pub table_init_done: bool,
    pub lock: mutex,
    pub freeable: cds_list_head,
    pub freed_pcpu: cds_list_head,
    pub freed_nonpcpu: cds_list_head,
    pub live: [btree_cache_list; 2usize],
    pub nr_vmalloc: usize,
    pub nr_freeable: usize,
    pub nr_reserve: usize,
    pub nr_by_btree: [usize; 27usize],
    pub nr_dirty: atomic_long_t,
    pub nr_freed: usize,
    pub not_freed: [u64_; 10usize],
    pub alloc_lock: *mut task_struct,
    pub alloc_wait: closure_waitlist,
    pub pinned_nodes_start: bbpos,
    pub pinned_nodes_end: bbpos,
    pub pinned_nodes_mask: [u64_; 2usize],
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_fs_btree_cache__bindgen_ty_1 {
    pub nr: usize,
    pub size: usize,
    pub data: *mut btree_root,
    pub preallocated: __IncompleteArrayField<btree_root>,
}
#[test]
fn bindgen_test_layout_bch_fs_btree_cache__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_cache__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_cache__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(bch_fs_btree_cache__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_cache__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_cache__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache__bindgen_ty_1),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache__bindgen_ty_1),
            "::",
            stringify!(size),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache__bindgen_ty_1),
            "::",
            stringify!(data),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preallocated) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache__bindgen_ty_1),
            "::",
            stringify!(preallocated),
        ),
    );
}
impl Default for bch_fs_btree_cache__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bch_fs_btree_cache() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_cache> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_cache>(),
        4728usize,
        concat!("Size of: ", stringify!(bch_fs_btree_cache)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_cache>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_cache)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).roots_known) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(roots_known),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).roots_extra) as usize - ptr as usize },
        3888usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(roots_extra),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).root_lock) as usize - ptr as usize },
        3912usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(root_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).table) as usize - ptr as usize },
        3952usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(table),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).table_init_done) as usize - ptr as usize },
        4136usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(table_init_done),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        4144usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).freeable) as usize - ptr as usize },
        4184usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(freeable),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).freed_pcpu) as usize - ptr as usize },
        4200usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(freed_pcpu),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).freed_nonpcpu) as usize - ptr as usize },
        4216usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(freed_nonpcpu),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).live) as usize - ptr as usize },
        4232usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(live),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_vmalloc) as usize - ptr as usize },
        4312usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(nr_vmalloc),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_freeable) as usize - ptr as usize },
        4320usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(nr_freeable),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_reserve) as usize - ptr as usize },
        4328usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(nr_reserve),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_by_btree) as usize - ptr as usize },
        4336usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(nr_by_btree),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_dirty) as usize - ptr as usize },
        4552usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(nr_dirty),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_freed) as usize - ptr as usize },
        4560usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(nr_freed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).not_freed) as usize - ptr as usize },
        4568usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(not_freed),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alloc_lock) as usize - ptr as usize },
        4648usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(alloc_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alloc_wait) as usize - ptr as usize },
        4656usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(alloc_wait),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).pinned_nodes_start) as usize - ptr as usize
        },
        4664usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(pinned_nodes_start),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pinned_nodes_end) as usize - ptr as usize },
        4688usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(pinned_nodes_end),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).pinned_nodes_mask) as usize - ptr as usize
        },
        4712usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_cache),
            "::",
            stringify!(pinned_nodes_mask),
        ),
    );
}
impl Default for bch_fs_btree_cache {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct btree_node_iter {
    pub data: [btree_node_iter_btree_node_iter_set; 3usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct btree_node_iter_btree_node_iter_set {
    pub k: u16_,
    pub end: u16_,
}
#[test]
fn bindgen_test_layout_btree_node_iter_btree_node_iter_set() {
    const UNINIT: ::std::mem::MaybeUninit<btree_node_iter_btree_node_iter_set> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_node_iter_btree_node_iter_set>(),
        4usize,
        concat!("Size of: ", stringify!(btree_node_iter_btree_node_iter_set)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_node_iter_btree_node_iter_set>(),
        2usize,
        concat!("Alignment of ", stringify!(btree_node_iter_btree_node_iter_set)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node_iter_btree_node_iter_set),
            "::",
            stringify!(k),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_node_iter_btree_node_iter_set),
            "::",
            stringify!(end),
        ),
    );
}
#[test]
fn bindgen_test_layout_btree_node_iter() {
    const UNINIT: ::std::mem::MaybeUninit<btree_node_iter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_node_iter>(),
        12usize,
        concat!("Size of: ", stringify!(btree_node_iter)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_node_iter>(),
        2usize,
        concat!("Alignment of ", stringify!(btree_node_iter)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(btree_node_iter), "::", stringify!(data)),
    );
}
pub const BTREE_ITER_FLAG_BIT_slots: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_slots;
pub const BTREE_ITER_FLAG_BIT_intent: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_intent;
pub const BTREE_ITER_FLAG_BIT_prefetch: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_prefetch;
pub const BTREE_ITER_FLAG_BIT_is_extents: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_is_extents;
pub const BTREE_ITER_FLAG_BIT_not_extents: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_not_extents;
pub const BTREE_ITER_FLAG_BIT_cached: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_cached;
pub const BTREE_ITER_FLAG_BIT_with_key_cache: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_with_key_cache;
pub const BTREE_ITER_FLAG_BIT_with_updates: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_with_updates;
pub const BTREE_ITER_FLAG_BIT_with_journal: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_with_journal;
pub const BTREE_ITER_FLAG_BIT_snapshot_field: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_snapshot_field;
pub const BTREE_ITER_FLAG_BIT_all_snapshots: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_all_snapshots;
pub const BTREE_ITER_FLAG_BIT_filter_snapshots: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_filter_snapshots;
pub const BTREE_ITER_FLAG_BIT_nofilter_whiteouts: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_nofilter_whiteouts;
pub const BTREE_ITER_FLAG_BIT_nopreserve: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_nopreserve;
pub const BTREE_ITER_FLAG_BIT_cached_nofill: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_cached_nofill;
pub const BTREE_ITER_FLAG_BIT_key_cache_fill: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_key_cache_fill;
pub const BTREE_ITER_FLAG_BIT_must_create: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_must_create;
pub const BTREE_ITER_FLAG_BIT_must_replace: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_must_replace;
pub const BTREE_ITER_FLAG_BIT_internal_snapshot_node: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_internal_snapshot_node;
pub const BTREE_ITER_FLAG_BIT_nojournal: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_nojournal;
pub const BTREE_ITER_FLAG_BIT_key_cache_reclaim: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_key_cache_reclaim;
pub const BTREE_ITER_FLAG_BIT_norun: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_norun;
pub const BTREE_ITER_FLAG_BIT_transactional: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_transactional;
pub const BTREE_ITER_FLAG_BIT_atomic: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_atomic;
pub const BTREE_ITER_FLAG_BIT_check_repair: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_check_repair;
pub const BTREE_ITER_FLAG_BIT_gc: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_gc;
pub const BTREE_ITER_FLAG_BIT_insert: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_insert;
pub const BTREE_ITER_FLAG_BIT_overwrite: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_overwrite;
pub const BTREE_ITER_FLAG_BIT_is_root: _bindgen_ty_20 = _bindgen_ty_20::BTREE_ITER_FLAG_BIT_is_root;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_20 {
    BTREE_ITER_FLAG_BIT_slots = 0,
    BTREE_ITER_FLAG_BIT_intent = 1,
    BTREE_ITER_FLAG_BIT_prefetch = 2,
    BTREE_ITER_FLAG_BIT_is_extents = 3,
    BTREE_ITER_FLAG_BIT_not_extents = 4,
    BTREE_ITER_FLAG_BIT_cached = 5,
    BTREE_ITER_FLAG_BIT_with_key_cache = 6,
    BTREE_ITER_FLAG_BIT_with_updates = 7,
    BTREE_ITER_FLAG_BIT_with_journal = 8,
    BTREE_ITER_FLAG_BIT_snapshot_field = 9,
    BTREE_ITER_FLAG_BIT_all_snapshots = 10,
    BTREE_ITER_FLAG_BIT_filter_snapshots = 11,
    BTREE_ITER_FLAG_BIT_nofilter_whiteouts = 12,
    BTREE_ITER_FLAG_BIT_nopreserve = 13,
    BTREE_ITER_FLAG_BIT_cached_nofill = 14,
    BTREE_ITER_FLAG_BIT_key_cache_fill = 15,
    BTREE_ITER_FLAG_BIT_must_create = 16,
    BTREE_ITER_FLAG_BIT_must_replace = 17,
    BTREE_ITER_FLAG_BIT_internal_snapshot_node = 18,
    BTREE_ITER_FLAG_BIT_nojournal = 19,
    BTREE_ITER_FLAG_BIT_key_cache_reclaim = 20,
    BTREE_ITER_FLAG_BIT_norun = 21,
    BTREE_ITER_FLAG_BIT_transactional = 22,
    BTREE_ITER_FLAG_BIT_atomic = 23,
    BTREE_ITER_FLAG_BIT_check_repair = 24,
    BTREE_ITER_FLAG_BIT_gc = 25,
    BTREE_ITER_FLAG_BIT_insert = 26,
    BTREE_ITER_FLAG_BIT_overwrite = 27,
    BTREE_ITER_FLAG_BIT_is_root = 28,
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_slots: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        1,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_intent: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        2,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_prefetch: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        4,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_is_extents: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        8,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_not_extents: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        16,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_cached: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        32,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_with_key_cache: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        64,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_with_updates: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        128,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_with_journal: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        256,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_snapshot_field: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        512,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_all_snapshots: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        1024,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_filter_snapshots: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        2048,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_nofilter_whiteouts: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        4096,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_nopreserve: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        8192,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_cached_nofill: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        16384,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_ITER_key_cache_fill: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        32768,
    );
}
impl btree_iter_update_trigger_flags {
    pub const STR_HASH_must_create: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        65536,
    );
}
impl btree_iter_update_trigger_flags {
    pub const STR_HASH_must_replace: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        131072,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_UPDATE_internal_snapshot_node: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        262144,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_UPDATE_nojournal: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        524288,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_UPDATE_key_cache_reclaim: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        1048576,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_TRIGGER_norun: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        2097152,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_TRIGGER_transactional: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        4194304,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_TRIGGER_atomic: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        8388608,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_TRIGGER_check_repair: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        16777216,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_TRIGGER_gc: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        33554432,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_TRIGGER_insert: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        67108864,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_TRIGGER_overwrite: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        134217728,
    );
}
impl btree_iter_update_trigger_flags {
    pub const BTREE_TRIGGER_is_root: btree_iter_update_trigger_flags = btree_iter_update_trigger_flags(
        268435456,
    );
}
impl ::std::ops::BitOr<btree_iter_update_trigger_flags>
for btree_iter_update_trigger_flags {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        btree_iter_update_trigger_flags(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for btree_iter_update_trigger_flags {
    #[inline]
    fn bitor_assign(&mut self, rhs: btree_iter_update_trigger_flags) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<btree_iter_update_trigger_flags>
for btree_iter_update_trigger_flags {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        btree_iter_update_trigger_flags(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for btree_iter_update_trigger_flags {
    #[inline]
    fn bitand_assign(&mut self, rhs: btree_iter_update_trigger_flags) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct btree_iter_update_trigger_flags(pub ::std::os::raw::c_uint);
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum btree_path_uptodate {
    BTREE_ITER_UPTODATE = 0,
    BTREE_ITER_NEED_RELOCK = 1,
    BTREE_ITER_NEED_TRAVERSE = 2,
}
pub type btree_path_idx_t = u16_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btree_path {
    pub sorted_idx: btree_path_idx_t,
    pub ref_: u8_,
    pub intent_ref: u8_,
    pub pos: bpos,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub nodes_locked: u8_,
    pub l: [btree_path_btree_path_level; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btree_path_btree_path_level {
    pub b: *mut btree,
    pub iter: btree_node_iter,
    pub lock_seq: u32_,
}
#[test]
fn bindgen_test_layout_btree_path_btree_path_level() {
    const UNINIT: ::std::mem::MaybeUninit<btree_path_btree_path_level> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_path_btree_path_level>(),
        24usize,
        concat!("Size of: ", stringify!(btree_path_btree_path_level)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_path_btree_path_level>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_path_btree_path_level)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).b) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_path_btree_path_level),
            "::",
            stringify!(b),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iter) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_path_btree_path_level),
            "::",
            stringify!(iter),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock_seq) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_path_btree_path_level),
            "::",
            stringify!(lock_seq),
        ),
    );
}
impl Default for btree_path_btree_path_level {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_btree_path() {
    const UNINIT: ::std::mem::MaybeUninit<btree_path> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_path>(),
        128usize,
        concat!("Size of: ", stringify!(btree_path)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_path>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_path)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sorted_idx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_path),
            "::",
            stringify!(sorted_idx),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ref_) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(btree_path), "::", stringify!(ref_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).intent_ref) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_path),
            "::",
            stringify!(intent_ref),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(btree_path), "::", stringify!(pos)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nodes_locked) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_path),
            "::",
            stringify!(nodes_locked),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(btree_path), "::", stringify!(l)),
    );
}
impl Default for btree_path {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl btree_path {
    #[inline]
    pub fn btree_id(&self) -> btree_id {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_btree_id(&mut self, val: btree_id) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn cached(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_cached(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn preserve(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_preserve(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uptodate(&self) -> btree_path_uptodate {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_uptodate(&mut self, val: btree_path_uptodate) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn should_be_locked(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_should_be_locked(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn level(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_level(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn locks_want(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_locks_want(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        btree_id: btree_id,
        cached: bool,
        preserve: bool,
        uptodate: btree_path_uptodate,
        should_be_locked: bool,
        level: ::std::os::raw::c_uint,
        locks_want: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                5u8,
                {
                    let btree_id: u32 = unsafe { ::std::mem::transmute(btree_id) };
                    btree_id as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                5usize,
                1u8,
                {
                    let cached: u8 = unsafe { ::std::mem::transmute(cached) };
                    cached as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                6usize,
                1u8,
                {
                    let preserve: u8 = unsafe { ::std::mem::transmute(preserve) };
                    preserve as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                2u8,
                {
                    let uptodate: u32 = unsafe { ::std::mem::transmute(uptodate) };
                    uptodate as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                9usize,
                1u8,
                {
                    let should_be_locked: u8 = unsafe {
                        ::std::mem::transmute(should_be_locked)
                    };
                    should_be_locked as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                10usize,
                3u8,
                {
                    let level: u32 = unsafe { ::std::mem::transmute(level) };
                    level as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                13usize,
                3u8,
                {
                    let locks_want: u32 = unsafe { ::std::mem::transmute(locks_want) };
                    locks_want as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btree_iter {
    pub trans: *mut btree_trans,
    pub path: btree_path_idx_t,
    pub update_path: btree_path_idx_t,
    pub key_cache_path: btree_path_idx_t,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub min_depth: u8_,
    pub flags: u16_,
    pub snapshot: ::std::os::raw::c_uint,
    pub pos: bpos,
    pub k: bkey,
    pub journal_idx: usize,
}
#[test]
fn bindgen_test_layout_btree_iter() {
    const UNINIT: ::std::mem::MaybeUninit<btree_iter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_iter>(),
        96usize,
        concat!("Size of: ", stringify!(btree_iter)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_iter>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_iter)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(btree_iter), "::", stringify!(trans)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).path) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(btree_iter), "::", stringify!(path)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).update_path) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_iter),
            "::",
            stringify!(update_path),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_cache_path) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_iter),
            "::",
            stringify!(key_cache_path),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_depth) as usize - ptr as usize },
        15usize,
        concat!("Offset of field: ", stringify!(btree_iter), "::", stringify!(min_depth)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(btree_iter), "::", stringify!(flags)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).snapshot) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(btree_iter), "::", stringify!(snapshot)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pos) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(btree_iter), "::", stringify!(pos)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(btree_iter), "::", stringify!(k)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_idx) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_iter),
            "::",
            stringify!(journal_idx),
        ),
    );
}
impl Default for btree_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl btree_iter {
    #[inline]
    pub fn btree_id(&self) -> btree_id {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_btree_id(&mut self, val: btree_id) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(btree_id: btree_id) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                8u8,
                {
                    let btree_id: u32 = unsafe { ::std::mem::transmute(btree_id) };
                    btree_id as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btree_insert_entry {
    pub flags: ::std::os::raw::c_uint,
    pub sort_order: u8_,
    pub bkey_type: u8_,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub old_btree_u64s: u8_,
    pub path: btree_path_idx_t,
    pub k: *mut bkey_i,
    pub old_k: bkey,
    pub old_v: *const bch_val,
    pub ip_allocated: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_btree_insert_entry() {
    const UNINIT: ::std::mem::MaybeUninit<btree_insert_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_insert_entry>(),
        80usize,
        concat!("Size of: ", stringify!(btree_insert_entry)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_insert_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_insert_entry)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_insert_entry),
            "::",
            stringify!(flags),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sort_order) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_insert_entry),
            "::",
            stringify!(sort_order),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bkey_type) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_insert_entry),
            "::",
            stringify!(bkey_type),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).old_btree_u64s) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_insert_entry),
            "::",
            stringify!(old_btree_u64s),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).path) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_insert_entry),
            "::",
            stringify!(path),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(btree_insert_entry), "::", stringify!(k)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).old_k) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_insert_entry),
            "::",
            stringify!(old_k),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).old_v) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_insert_entry),
            "::",
            stringify!(old_v),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ip_allocated) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_insert_entry),
            "::",
            stringify!(ip_allocated),
        ),
    );
}
impl Default for btree_insert_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl btree_insert_entry {
    #[inline]
    pub fn btree_id(&self) -> btree_id {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_btree_id(&mut self, val: btree_id) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn level(&self) -> u8_ {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_level(&mut self, val: u8_) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn cached(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_cached(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn insert_trigger_run(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_insert_trigger_run(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overwrite_trigger_run(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_overwrite_trigger_run(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn key_cache_already_flushed(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_key_cache_already_flushed(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn key_cache_flushing(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_key_cache_flushing(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        btree_id: btree_id,
        level: u8_,
        cached: bool,
        insert_trigger_run: bool,
        overwrite_trigger_run: bool,
        key_cache_already_flushed: bool,
        key_cache_flushing: bool,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                8u8,
                {
                    let btree_id: u32 = unsafe { ::std::mem::transmute(btree_id) };
                    btree_id as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                8usize,
                3u8,
                {
                    let level: u8 = unsafe { ::std::mem::transmute(level) };
                    level as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                11usize,
                1u8,
                {
                    let cached: u8 = unsafe { ::std::mem::transmute(cached) };
                    cached as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                12usize,
                1u8,
                {
                    let insert_trigger_run: u8 = unsafe {
                        ::std::mem::transmute(insert_trigger_run)
                    };
                    insert_trigger_run as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                13usize,
                1u8,
                {
                    let overwrite_trigger_run: u8 = unsafe {
                        ::std::mem::transmute(overwrite_trigger_run)
                    };
                    overwrite_trigger_run as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                14usize,
                1u8,
                {
                    let key_cache_already_flushed: u8 = unsafe {
                        ::std::mem::transmute(key_cache_already_flushed)
                    };
                    key_cache_already_flushed as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                15usize,
                1u8,
                {
                    let key_cache_flushing: u8 = unsafe {
                        ::std::mem::transmute(key_cache_flushing)
                    };
                    key_cache_flushing as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
pub type btree_trans_commit_hook_fn = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut btree_trans,
        arg2: *mut btree_trans_commit_hook,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btree_trans_commit_hook {
    pub fn_: btree_trans_commit_hook_fn,
    pub next: *mut btree_trans_commit_hook,
}
#[test]
fn bindgen_test_layout_btree_trans_commit_hook() {
    const UNINIT: ::std::mem::MaybeUninit<btree_trans_commit_hook> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_trans_commit_hook>(),
        16usize,
        concat!("Size of: ", stringify!(btree_trans_commit_hook)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_trans_commit_hook>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_trans_commit_hook)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fn_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans_commit_hook),
            "::",
            stringify!(fn_),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans_commit_hook),
            "::",
            stringify!(next),
        ),
    );
}
impl Default for btree_trans_commit_hook {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct btree_trans_paths {
    pub nr_paths: ::std::os::raw::c_ulong,
    pub paths: __IncompleteArrayField<btree_path>,
}
#[test]
fn bindgen_test_layout_btree_trans_paths() {
    const UNINIT: ::std::mem::MaybeUninit<btree_trans_paths> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_trans_paths>(),
        8usize,
        concat!("Size of: ", stringify!(btree_trans_paths)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_trans_paths>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_trans_paths)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_paths) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans_paths),
            "::",
            stringify!(nr_paths),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).paths) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans_paths),
            "::",
            stringify!(paths),
        ),
    );
}
impl Default for btree_trans_paths {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct btree_trans_subbuf {
    pub base: u16_,
    pub u64s: u16_,
    pub size: u16_,
}
#[test]
fn bindgen_test_layout_btree_trans_subbuf() {
    const UNINIT: ::std::mem::MaybeUninit<btree_trans_subbuf> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_trans_subbuf>(),
        6usize,
        concat!("Size of: ", stringify!(btree_trans_subbuf)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_trans_subbuf>(),
        2usize,
        concat!("Alignment of ", stringify!(btree_trans_subbuf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans_subbuf),
            "::",
            stringify!(base),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u64s) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans_subbuf),
            "::",
            stringify!(u64s),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans_subbuf),
            "::",
            stringify!(size),
        ),
    );
}
#[repr(C)]
pub struct btree_trans {
    pub c: *mut bch_fs,
    pub paths_allocated: *mut ::std::os::raw::c_ulong,
    pub paths: *mut btree_path,
    pub sorted: *mut btree_path_idx_t,
    pub updates: *mut btree_insert_entry,
    pub mem: *mut ::std::os::raw::c_void,
    pub mem_top: ::std::os::raw::c_uint,
    pub mem_bytes: ::std::os::raw::c_uint,
    pub realloc_bytes_required: ::std::os::raw::c_uint,
    pub nr_sorted: btree_path_idx_t,
    pub nr_paths: btree_path_idx_t,
    pub nr_paths_max: btree_path_idx_t,
    pub nr_updates: btree_path_idx_t,
    pub fn_idx: u8_,
    pub lock_must_abort: u8_,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub restart_count: u32_,
    pub last_begin_time: u64_,
    pub last_begin_ip: ::std::os::raw::c_ulong,
    pub last_restarted_ip: ::std::os::raw::c_ulong,
    pub last_unlock_ip: ::std::os::raw::c_ulong,
    pub srcu_lock_time: ::std::os::raw::c_ulong,
    pub fn_: *const ::std::os::raw::c_char,
    pub locking: *mut btree_bkey_cached_common,
    pub locking_wait: six_lock_waiter,
    pub srcu_idx: ::std::os::raw::c_int,
    pub journal_entries: btree_trans_subbuf,
    pub accounting: btree_trans_subbuf,
    pub hooks: *mut btree_trans_commit_hook,
    pub journal_pin: *mut journal_entry_pin,
    pub journal_res: journal_res,
    pub journal_seq: *mut u64_,
    pub disk_res: *mut disk_reservation,
    pub fs_usage_delta: bch_fs_usage_base,
    pub journal_u64s: ::std::os::raw::c_uint,
    pub extra_disk_res: u64_,
    pub btree_path_down: bkey_i,
    pub btree_path_down_pad: [__u64; 11usize],
    pub list: cds_list_head,
    pub ref_: closure,
    pub _paths_allocated: [::std::os::raw::c_ulong; 1usize],
    pub trans_paths: btree_trans_paths,
    pub _paths: [btree_path; 64usize],
    pub _sorted: [btree_path_idx_t; 68usize],
    pub _updates: [btree_insert_entry; 64usize],
}
#[test]
fn bindgen_test_layout_btree_trans() {
    const UNINIT: ::std::mem::MaybeUninit<btree_trans> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_trans>(),
        13952usize,
        concat!("Size of: ", stringify!(btree_trans)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_trans>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_trans)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).c) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(c)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).paths_allocated) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(paths_allocated),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).paths) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(paths)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sorted) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(sorted)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).updates) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(updates)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mem) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(mem)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mem_top) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(mem_top)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mem_bytes) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(mem_bytes),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).realloc_bytes_required) as usize - ptr as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(realloc_bytes_required),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_sorted) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(nr_sorted),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_paths) as usize - ptr as usize },
        62usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(nr_paths)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_paths_max) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(nr_paths_max),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_updates) as usize - ptr as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(nr_updates),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fn_idx) as usize - ptr as usize },
        68usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(fn_idx)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock_must_abort) as usize - ptr as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(lock_must_abort),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).restart_count) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(restart_count),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_begin_time) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(last_begin_time),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_begin_ip) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(last_begin_ip),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).last_restarted_ip) as usize - ptr as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(last_restarted_ip),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_unlock_ip) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(last_unlock_ip),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).srcu_lock_time) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(srcu_lock_time),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fn_) as usize - ptr as usize },
        120usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(fn_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).locking) as usize - ptr as usize },
        128usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(locking)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).locking_wait) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(locking_wait),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).srcu_idx) as usize - ptr as usize },
        176usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(srcu_idx)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_entries) as usize - ptr as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(journal_entries),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).accounting) as usize - ptr as usize },
        186usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(accounting),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hooks) as usize - ptr as usize },
        192usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(hooks)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_pin) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(journal_pin),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_res) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(journal_res),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_seq) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(journal_seq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).disk_res) as usize - ptr as usize },
        232usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(disk_res)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fs_usage_delta) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(fs_usage_delta),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_u64s) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(journal_u64s),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extra_disk_res) as usize - ptr as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(extra_disk_res),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btree_path_down) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(btree_path_down),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).btree_path_down_pad) as usize - ptr as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(btree_path_down_pad),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        424usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(list)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ref_) as usize - ptr as usize },
        440usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(ref_)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._paths_allocated) as usize - ptr as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(_paths_allocated),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans_paths) as usize - ptr as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans),
            "::",
            stringify!(trans_paths),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._paths) as usize - ptr as usize },
        504usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(_paths)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._sorted) as usize - ptr as usize },
        8696usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(_sorted)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._updates) as usize - ptr as usize },
        8832usize,
        concat!("Offset of field: ", stringify!(btree_trans), "::", stringify!(_updates)),
    );
}
impl Default for btree_trans {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl btree_trans {
    #[inline]
    pub fn lock_may_not_fail(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lock_may_not_fail(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn srcu_held(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_srcu_held(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn locked(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_locked(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pf_memalloc_nofs(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pf_memalloc_nofs(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn write_locked(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_write_locked(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn used_mempool(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_used_mempool(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn in_traverse_all(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_in_traverse_all(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn paths_sorted(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_paths_sorted(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn memory_allocation_failure(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_memory_allocation_failure(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn journal_transaction_names(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_journal_transaction_names(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn journal_replay_not_finished(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_journal_replay_not_finished(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn notrace_relock_fail(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_notrace_relock_fail(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn has_interior_updates(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_interior_updates(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn restarted(&self) -> bch_errcode {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_restarted(&mut self, val: bch_errcode) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lock_may_not_fail: bool,
        srcu_held: bool,
        locked: bool,
        pf_memalloc_nofs: bool,
        write_locked: bool,
        used_mempool: bool,
        in_traverse_all: bool,
        paths_sorted: bool,
        memory_allocation_failure: bool,
        journal_transaction_names: bool,
        journal_replay_not_finished: bool,
        notrace_relock_fail: bool,
        has_interior_updates: bool,
        restarted: bch_errcode,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let lock_may_not_fail: u8 = unsafe {
                        ::std::mem::transmute(lock_may_not_fail)
                    };
                    lock_may_not_fail as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                1usize,
                1u8,
                {
                    let srcu_held: u8 = unsafe { ::std::mem::transmute(srcu_held) };
                    srcu_held as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                2usize,
                1u8,
                {
                    let locked: u8 = unsafe { ::std::mem::transmute(locked) };
                    locked as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                3usize,
                1u8,
                {
                    let pf_memalloc_nofs: u8 = unsafe {
                        ::std::mem::transmute(pf_memalloc_nofs)
                    };
                    pf_memalloc_nofs as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                4usize,
                1u8,
                {
                    let write_locked: u8 = unsafe {
                        ::std::mem::transmute(write_locked)
                    };
                    write_locked as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                5usize,
                1u8,
                {
                    let used_mempool: u8 = unsafe {
                        ::std::mem::transmute(used_mempool)
                    };
                    used_mempool as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                6usize,
                1u8,
                {
                    let in_traverse_all: u8 = unsafe {
                        ::std::mem::transmute(in_traverse_all)
                    };
                    in_traverse_all as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                7usize,
                1u8,
                {
                    let paths_sorted: u8 = unsafe {
                        ::std::mem::transmute(paths_sorted)
                    };
                    paths_sorted as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                8usize,
                1u8,
                {
                    let memory_allocation_failure: u8 = unsafe {
                        ::std::mem::transmute(memory_allocation_failure)
                    };
                    memory_allocation_failure as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                9usize,
                1u8,
                {
                    let journal_transaction_names: u8 = unsafe {
                        ::std::mem::transmute(journal_transaction_names)
                    };
                    journal_transaction_names as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                10usize,
                1u8,
                {
                    let journal_replay_not_finished: u8 = unsafe {
                        ::std::mem::transmute(journal_replay_not_finished)
                    };
                    journal_replay_not_finished as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                11usize,
                1u8,
                {
                    let notrace_relock_fail: u8 = unsafe {
                        ::std::mem::transmute(notrace_relock_fail)
                    };
                    notrace_relock_fail as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                12usize,
                1u8,
                {
                    let has_interior_updates: u8 = unsafe {
                        ::std::mem::transmute(has_interior_updates)
                    };
                    has_interior_updates as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                13usize,
                16u8,
                {
                    let restarted: u32 = unsafe { ::std::mem::transmute(restarted) };
                    restarted as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct btree_trans_buf {
    pub trans: *mut btree_trans,
}
#[test]
fn bindgen_test_layout_btree_trans_buf() {
    const UNINIT: ::std::mem::MaybeUninit<btree_trans_buf> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_trans_buf>(),
        8usize,
        concat!("Size of: ", stringify!(btree_trans_buf)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_trans_buf>(),
        8usize,
        concat!("Alignment of ", stringify!(btree_trans_buf)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_trans_buf),
            "::",
            stringify!(trans),
        ),
    );
}
impl Default for btree_trans_buf {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub struct btree_transaction_stats {
    pub duration: bch2_time_stats,
    pub lock_hold_times: bch2_time_stats,
    pub lock: mutex,
    pub nr_max_paths: ::std::os::raw::c_uint,
    pub max_mem: ::std::os::raw::c_uint,
    pub max_paths_text: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_btree_transaction_stats() {
    const UNINIT: ::std::mem::MaybeUninit<btree_transaction_stats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<btree_transaction_stats>(),
        512usize,
        concat!("Size of: ", stringify!(btree_transaction_stats)),
    );
    assert_eq!(
        ::std::mem::align_of::<btree_transaction_stats>(),
        16usize,
        concat!("Alignment of ", stringify!(btree_transaction_stats)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).duration) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_transaction_stats),
            "::",
            stringify!(duration),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock_hold_times) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_transaction_stats),
            "::",
            stringify!(lock_hold_times),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_transaction_stats),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr_max_paths) as usize - ptr as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_transaction_stats),
            "::",
            stringify!(nr_max_paths),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_mem) as usize - ptr as usize },
        492usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_transaction_stats),
            "::",
            stringify!(max_mem),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_paths_text) as usize - ptr as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(btree_transaction_stats),
            "::",
            stringify!(max_paths_text),
        ),
    );
}
impl Default for btree_transaction_stats {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(16))]
pub struct bch_fs_btree_trans {
    pub lock: seqmutex,
    pub list: cds_list_head,
    pub pool: mempool_t,
    pub malloc_pool: mempool_t,
    pub bufs: *mut btree_trans_buf,
    pub barrier: srcu_struct,
    pub barrier_initialized: bool,
    pub stats: [btree_transaction_stats; 128usize],
}
#[test]
fn bindgen_test_layout_bch_fs_btree_trans() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_trans> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_trans>(),
        65888usize,
        concat!("Size of: ", stringify!(bch_fs_btree_trans)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_trans>(),
        16usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_trans)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_trans),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_trans),
            "::",
            stringify!(list),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pool) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_trans),
            "::",
            stringify!(pool),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).malloc_pool) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_trans),
            "::",
            stringify!(malloc_pool),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bufs) as usize - ptr as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_trans),
            "::",
            stringify!(bufs),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).barrier) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_trans),
            "::",
            stringify!(barrier),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).barrier_initialized) as usize - ptr as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_trans),
            "::",
            stringify!(barrier_initialized),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stats) as usize - ptr as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_trans),
            "::",
            stringify!(stats),
        ),
    );
}
impl Default for bch_fs_btree_trans {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(16))]
pub struct bch_fs_btree {
    pub foreground_merge_threshold: u16_,
    pub bounce_pool: mempool_t,
    pub write_stats: [bch_fs_btree_btree_write_stats; 5usize],
    pub bio: bio_set,
    pub fill_iter: mempool_t,
    pub read_complete_wq: *mut workqueue_struct,
    pub read_errors_soft: ratelimit_state,
    pub read_errors_hard: ratelimit_state,
    pub write_submit_wq: *mut workqueue_struct,
    pub write_complete_wq: *mut workqueue_struct,
    pub root_journal_res: journal_entry_res,
    pub cache: bch_fs_btree_cache,
    pub key_cache: bch_fs_btree_key_cache,
    pub write_buffer: bch_fs_btree_write_buffer,
    pub __bindgen_padding_0: u64,
    pub trans: bch_fs_btree_trans,
    pub reserve_cache: bch_fs_btree_reserve_cache,
    pub interior_updates: bch_fs_btree_interior_updates,
    pub node_rewrites: bch_fs_btree_node_rewrites,
    pub node_scan: find_btree_nodes,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_fs_btree_btree_write_stats {
    pub nr: atomic64_t,
    pub bytes: atomic64_t,
}
#[test]
fn bindgen_test_layout_bch_fs_btree_btree_write_stats() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree_btree_write_stats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree_btree_write_stats>(),
        16usize,
        concat!("Size of: ", stringify!(bch_fs_btree_btree_write_stats)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree_btree_write_stats>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_btree_btree_write_stats)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_btree_write_stats),
            "::",
            stringify!(nr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree_btree_write_stats),
            "::",
            stringify!(bytes),
        ),
    );
}
#[test]
fn bindgen_test_layout_bch_fs_btree() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_btree> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_btree>(),
        81952usize,
        concat!("Size of: ", stringify!(bch_fs_btree)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_btree>(),
        16usize,
        concat!("Alignment of ", stringify!(bch_fs_btree)),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).foreground_merge_threshold) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(foreground_merge_threshold),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bounce_pool) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(bounce_pool),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_stats) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(write_stats),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bio) as usize - ptr as usize },
        224usize,
        concat!("Offset of field: ", stringify!(bch_fs_btree), "::", stringify!(bio)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fill_iter) as usize - ptr as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(fill_iter),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_complete_wq) as usize - ptr as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(read_complete_wq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_errors_soft) as usize - ptr as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(read_errors_soft),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_errors_hard) as usize - ptr as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(read_errors_hard),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_submit_wq) as usize - ptr as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(write_submit_wq),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).write_complete_wq) as usize - ptr as usize
        },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(write_complete_wq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).root_journal_res) as usize - ptr as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(root_journal_res),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cache) as usize - ptr as usize },
        816usize,
        concat!("Offset of field: ", stringify!(bch_fs_btree), "::", stringify!(cache)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_cache) as usize - ptr as usize },
        5544usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(key_cache),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_buffer) as usize - ptr as usize },
        5864usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(write_buffer),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trans) as usize - ptr as usize },
        6144usize,
        concat!("Offset of field: ", stringify!(bch_fs_btree), "::", stringify!(trans)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserve_cache) as usize - ptr as usize },
        72032usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(reserve_cache),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interior_updates) as usize - ptr as usize },
        81488usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(interior_updates),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node_rewrites) as usize - ptr as usize },
        81784usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(node_rewrites),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).node_scan) as usize - ptr as usize },
        81872usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_btree),
            "::",
            stringify!(node_scan),
        ),
    );
}
impl Default for bch_fs_btree {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum btree_node_type {
    BKEY_TYPE_btree = 0,
    BKEY_TYPE_extents = 1,
    BKEY_TYPE_inodes = 2,
    BKEY_TYPE_dirents = 3,
    BKEY_TYPE_xattrs = 4,
    BKEY_TYPE_alloc = 5,
    BKEY_TYPE_quotas = 6,
    BKEY_TYPE_stripes = 7,
    BKEY_TYPE_reflink = 8,
    BKEY_TYPE_subvolumes = 9,
    BKEY_TYPE_snapshots = 10,
    BKEY_TYPE_lru = 11,
    BKEY_TYPE_freespace = 12,
    BKEY_TYPE_need_discard = 13,
    BKEY_TYPE_backpointers = 14,
    BKEY_TYPE_bucket_gens = 15,
    BKEY_TYPE_snapshot_trees = 16,
    BKEY_TYPE_deleted_inodes = 17,
    BKEY_TYPE_logged_ops = 18,
    BKEY_TYPE_reconcile_work = 19,
    BKEY_TYPE_subvolume_children = 20,
    BKEY_TYPE_accounting = 21,
    BKEY_TYPE_reconcile_hipri = 22,
    BKEY_TYPE_reconcile_pending = 23,
    BKEY_TYPE_reconcile_scan = 24,
    BKEY_TYPE_reconcile_work_phys = 25,
    BKEY_TYPE_reconcile_hipri_phys = 26,
    BKEY_TYPE_bucket_to_stripe = 27,
    BKEY_TYPE_NR = 28,
}
extern "C" {
    pub fn bch2_btree_node_type_str(
        arg1: btree_node_type,
    ) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bch_fs_compress {
    pub bounce: [mempool_t; 2usize],
    pub workspace: [mempool_t; 4usize],
    pub zstd_workspace_size: usize,
}
#[test]
fn bindgen_test_layout_bch_fs_compress() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_compress> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_compress>(),
        824usize,
        concat!("Size of: ", stringify!(bch_fs_compress)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_compress>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_compress)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bounce) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_compress),
            "::",
            stringify!(bounce),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).workspace) as usize - ptr as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_compress),
            "::",
            stringify!(workspace),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).zstd_workspace_size) as usize - ptr as usize
        },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_compress),
            "::",
            stringify!(zstd_workspace_size),
        ),
    );
}
impl Default for bch_fs_compress {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(64))]
#[derive(Copy, Clone)]
pub struct bch_fs_copygc {
    pub thread: *mut task_struct,
    pub __bindgen_padding_0: [u64; 7usize],
    pub write_point: write_point,
    pub wait_at: s64,
    pub wait: s64,
    pub running: bool,
    pub running_wq: wait_queue_head_t,
    pub wq: *mut workqueue_struct,
}
#[test]
fn bindgen_test_layout_bch_fs_copygc() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_copygc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_copygc>(),
        1024usize,
        concat!("Size of: ", stringify!(bch_fs_copygc)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_copygc>(),
        64usize,
        concat!("Alignment of ", stringify!(bch_fs_copygc)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bch_fs_copygc), "::", stringify!(thread)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_point) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_copygc),
            "::",
            stringify!(write_point),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait_at) as usize - ptr as usize },
        896usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_copygc),
            "::",
            stringify!(wait_at),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait) as usize - ptr as usize },
        904usize,
        concat!("Offset of field: ", stringify!(bch_fs_copygc), "::", stringify!(wait)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).running) as usize - ptr as usize },
        912usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_copygc),
            "::",
            stringify!(running),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).running_wq) as usize - ptr as usize },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_copygc),
            "::",
            stringify!(running_wq),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wq) as usize - ptr as usize },
        976usize,
        concat!("Offset of field: ", stringify!(bch_fs_copygc), "::", stringify!(wq)),
    );
}
impl Default for bch_fs_copygc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Default, Copy, Clone)]
pub struct gc_stripe {
    pub _bindgen_opaque_blob: [u64; 24usize],
}
#[test]
fn bindgen_test_layout_gc_stripe() {
    assert_eq!(
        ::std::mem::size_of::<gc_stripe>(),
        192usize,
        concat!("Size of: ", stringify!(gc_stripe)),
    );
    assert_eq!(
        ::std::mem::align_of::<gc_stripe>(),
        8usize,
        concat!("Alignment of ", stringify!(gc_stripe)),
    );
}
#[repr(C)]
pub struct bch_fs_ec {
    pub stripes_new: [cds_hlist_head; 32usize],
    pub stripes_new_buckets: [cds_hlist_head; 64usize],
    pub stripes_new_lock: spinlock_t,
    pub stripe_head_list: cds_list_head,
    pub stripe_head_lock: mutex,
    pub stripe_new_list: cds_list_head,
    pub stripe_new_lock: mutex,
    pub stripe_new_wait: wait_queue_head_t,
    pub stripe_create_work: work_struct,
    pub stripe_hint: u64_,
    pub stripe_delete_work: work_struct,
    pub block_bioset: bio_set,
    pub gc_stripes: bch_fs_ec__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug)]
pub struct bch_fs_ec__bindgen_ty_1 {
    pub tree: __genradix,
    pub type_: __IncompleteArrayField<gc_stripe>,
}
#[test]
fn bindgen_test_layout_bch_fs_ec__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_ec__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_ec__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(bch_fs_ec__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_ec__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_ec__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tree) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec__bindgen_ty_1),
            "::",
            stringify!(tree),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec__bindgen_ty_1),
            "::",
            stringify!(type_),
        ),
    );
}
impl Default for bch_fs_ec__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bch_fs_ec() {
    const UNINIT: ::std::mem::MaybeUninit<bch_fs_ec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_fs_ec>(),
        1336usize,
        concat!("Size of: ", stringify!(bch_fs_ec)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_fs_ec>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_fs_ec)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripes_new) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripes_new),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).stripes_new_buckets) as usize - ptr as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripes_new_buckets),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripes_new_lock) as usize - ptr as usize },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripes_new_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_head_list) as usize - ptr as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripe_head_list),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_head_lock) as usize - ptr as usize },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripe_head_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_new_list) as usize - ptr as usize },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripe_new_list),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_new_lock) as usize - ptr as usize },
        880usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripe_new_lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_new_wait) as usize - ptr as usize },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripe_new_wait),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).stripe_create_work) as usize - ptr as usize
        },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripe_create_work),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stripe_hint) as usize - ptr as usize },
        1008usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripe_hint),
        ),
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).stripe_delete_work) as usize - ptr as usize
        },
        1016usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(stripe_delete_work),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block_bioset) as usize - ptr as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_fs_ec),
            "::",
            stringify!(block_bioset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gc_stripes) as usize - ptr as usize },
        1328usize,
        concat!("Offset of field: ", stringify!(bch_fs_ec), "::", stringify!(gc_stripes)),
    );
}
impl Default for bch_fs_ec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(64))]
#[derive(Copy, Clone)]
pub struct nocow_lock_bucket {
    pub wait: closure_waitlist,
    pub lock: spinlock_t,
    pub b: [u64_; 6usize],
    pub l: [atomic_t; 6usize],
}
#[test]
fn bindgen_test_layout_nocow_lock_bucket() {
    const UNINIT: ::std::mem::MaybeUninit<nocow_lock_bucket> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<nocow_lock_bucket>(),
        128usize,
        concat!("Size of: ", stringify!(nocow_lock_bucket)),
    );
    assert_eq!(
        ::std::mem::align_of::<nocow_lock_bucket>(),
        64usize,
        concat!("Alignment of ", stringify!(nocow_lock_bucket)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wait) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(nocow_lock_bucket),
            "::",
            stringify!(wait),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lock) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(nocow_lock_bucket),
            "::",
            stringify!(lock),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).b) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(nocow_lock_bucket), "::", stringify!(b)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l) as usize - ptr as usize },
        96usize,
        concat!("Offset of field: ", stringify!(nocow_lock_bucket), "::", stringify!(l)),
    );
}
impl Default for nocow_lock_bucket {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(64))]
#[derive(Copy, Clone)]
pub struct bucket_nocow_lock_table {
    pub l: [nocow_lock_bucket; 1024usize],
}
#[test]
fn bindgen_test_layout_bucket_nocow_lock_table() {
    const UNINIT: ::std::mem::MaybeUninit<bucket_nocow_lock_table> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bucket_nocow_lock_table>(),
        131072usize,
        concat!("Size of: ", stringify!(bucket_nocow_lock_table)),
    );
    assert_eq!(
        ::std::mem::align_of::<bucket_nocow_lock_table>(),
        64usize,
        concat!("Alignment of ", stringify!(bucket_nocow_lock_table)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bucket_nocow_lock_table),
            "::",
            stringify!(l),
        ),
    );
}
impl Default for bucket_nocow_lock_table {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bkey_s_c {
    pub k: *const bkey,
    pub v: *const bch_val,
}
#[test]
fn bindgen_test_layout_bkey_s_c() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_s_c> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_s_c>(),
        16usize,
        concat!("Size of: ", stringify!(bkey_s_c)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_s_c>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_s_c)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(bkey_s_c), "::", stringify!(k)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(bkey_s_c), "::", stringify!(v)),
    );
}
impl Default for bkey_s_c {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bkey_s {
    pub __bindgen_anon_1: bkey_s__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bkey_s__bindgen_ty_1 {
    pub __bindgen_anon_1: bkey_s__bindgen_ty_1__bindgen_ty_1,
    pub s_c: bkey_s_c,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bkey_s__bindgen_ty_1__bindgen_ty_1 {
    pub k: *mut bkey,
    pub v: *mut bch_val,
}
#[test]
fn bindgen_test_layout_bkey_s__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_s__bindgen_ty_1__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_s__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(bkey_s__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_s__bindgen_ty_1__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(k),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(v),
        ),
    );
}
impl Default for bkey_s__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bkey_s__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_s__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_s__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(bkey_s__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_s__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s_c) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_s__bindgen_ty_1),
            "::",
            stringify!(s_c),
        ),
    );
}
impl Default for bkey_s__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bkey_s() {
    assert_eq!(
        ::std::mem::size_of::<bkey_s>(),
        16usize,
        concat!("Size of: ", stringify!(bkey_s)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_s>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_s)),
    );
}
impl Default for bkey_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct bkey_i_inode_v3 {
    pub __bindgen_anon_1: bkey_i_inode_v3__bindgen_ty_1,
    pub v: bch_inode_v3,
}
#[repr(C)]
pub struct bkey_i_inode_v3__bindgen_ty_1 {
    pub k: __BindgenUnionField<bkey>,
    pub k_i: __BindgenUnionField<bkey_i>,
    pub bindgen_union_field: [u64; 5usize],
}
#[test]
fn bindgen_test_layout_bkey_i_inode_v3__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_i_inode_v3__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_i_inode_v3__bindgen_ty_1>(),
        40usize,
        concat!("Size of: ", stringify!(bkey_i_inode_v3__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_i_inode_v3__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_i_inode_v3__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_i_inode_v3__bindgen_ty_1),
            "::",
            stringify!(k),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k_i) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_i_inode_v3__bindgen_ty_1),
            "::",
            stringify!(k_i),
        ),
    );
}
impl Default for bkey_i_inode_v3__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bkey_i_inode_v3() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_i_inode_v3> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_i_inode_v3>(),
        88usize,
        concat!("Size of: ", stringify!(bkey_i_inode_v3)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_i_inode_v3>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_i_inode_v3)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(bkey_i_inode_v3), "::", stringify!(v)),
    );
}
impl Default for bkey_i_inode_v3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct bkey_i_snapshot_tree {
    pub __bindgen_anon_1: bkey_i_snapshot_tree__bindgen_ty_1,
    pub v: bch_snapshot_tree,
}
#[repr(C)]
pub struct bkey_i_snapshot_tree__bindgen_ty_1 {
    pub k: __BindgenUnionField<bkey>,
    pub k_i: __BindgenUnionField<bkey_i>,
    pub bindgen_union_field: [u64; 5usize],
}
#[test]
fn bindgen_test_layout_bkey_i_snapshot_tree__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_i_snapshot_tree__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_i_snapshot_tree__bindgen_ty_1>(),
        40usize,
        concat!("Size of: ", stringify!(bkey_i_snapshot_tree__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_i_snapshot_tree__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_i_snapshot_tree__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_i_snapshot_tree__bindgen_ty_1),
            "::",
            stringify!(k),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k_i) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_i_snapshot_tree__bindgen_ty_1),
            "::",
            stringify!(k_i),
        ),
    );
}
impl Default for bkey_i_snapshot_tree__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bkey_i_snapshot_tree() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_i_snapshot_tree> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_i_snapshot_tree>(),
        48usize,
        concat!("Size of: ", stringify!(bkey_i_snapshot_tree)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_i_snapshot_tree>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_i_snapshot_tree)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_i_snapshot_tree),
            "::",
            stringify!(v),
        ),
    );
}
impl Default for bkey_i_snapshot_tree {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct bkey_i_accounting {
    pub __bindgen_anon_1: bkey_i_accounting__bindgen_ty_1,
    pub v: bch_accounting,
}
#[repr(C)]
pub struct bkey_i_accounting__bindgen_ty_1 {
    pub k: __BindgenUnionField<bkey>,
    pub k_i: __BindgenUnionField<bkey_i>,
    pub bindgen_union_field: [u64; 5usize],
}
#[test]
fn bindgen_test_layout_bkey_i_accounting__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_i_accounting__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_i_accounting__bindgen_ty_1>(),
        40usize,
        concat!("Size of: ", stringify!(bkey_i_accounting__bindgen_ty_1)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_i_accounting__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_i_accounting__bindgen_ty_1)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_i_accounting__bindgen_ty_1),
            "::",
            stringify!(k),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k_i) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_i_accounting__bindgen_ty_1),
            "::",
            stringify!(k_i),
        ),
    );
}
impl Default for bkey_i_accounting__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bkey_i_accounting() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_i_accounting> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_i_accounting>(),
        40usize,
        concat!("Size of: ", stringify!(bkey_i_accounting)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_i_accounting>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_i_accounting)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(bkey_i_accounting), "::", stringify!(v)),
    );
}
impl Default for bkey_i_accounting {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bch_validate_flags {
    BCH_VALIDATE_write = 1,
    BCH_VALIDATE_commit = 2,
    BCH_VALIDATE_silent = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bkey_validate_context {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub level: u8_,
    pub btree: btree_id,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub journal_offset: ::std::os::raw::c_uint,
    pub journal_seq: u64_,
}
pub const bkey_validate_context_BKEY_VALIDATE_unknown: bkey_validate_context__bindgen_ty_1 = bkey_validate_context__bindgen_ty_1::BKEY_VALIDATE_unknown;
pub const bkey_validate_context_BKEY_VALIDATE_superblock: bkey_validate_context__bindgen_ty_1 = bkey_validate_context__bindgen_ty_1::BKEY_VALIDATE_superblock;
pub const bkey_validate_context_BKEY_VALIDATE_journal: bkey_validate_context__bindgen_ty_1 = bkey_validate_context__bindgen_ty_1::BKEY_VALIDATE_journal;
pub const bkey_validate_context_BKEY_VALIDATE_btree_root: bkey_validate_context__bindgen_ty_1 = bkey_validate_context__bindgen_ty_1::BKEY_VALIDATE_btree_root;
pub const bkey_validate_context_BKEY_VALIDATE_btree_node: bkey_validate_context__bindgen_ty_1 = bkey_validate_context__bindgen_ty_1::BKEY_VALIDATE_btree_node;
pub const bkey_validate_context_BKEY_VALIDATE_commit: bkey_validate_context__bindgen_ty_1 = bkey_validate_context__bindgen_ty_1::BKEY_VALIDATE_commit;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bkey_validate_context__bindgen_ty_1 {
    BKEY_VALIDATE_unknown = 0,
    BKEY_VALIDATE_superblock = 1,
    BKEY_VALIDATE_journal = 2,
    BKEY_VALIDATE_btree_root = 3,
    BKEY_VALIDATE_btree_node = 4,
    BKEY_VALIDATE_commit = 5,
}
#[test]
fn bindgen_test_layout_bkey_validate_context() {
    const UNINIT: ::std::mem::MaybeUninit<bkey_validate_context> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bkey_validate_context>(),
        24usize,
        concat!("Size of: ", stringify!(bkey_validate_context)),
    );
    assert_eq!(
        ::std::mem::align_of::<bkey_validate_context>(),
        8usize,
        concat!("Alignment of ", stringify!(bkey_validate_context)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_validate_context),
            "::",
            stringify!(level),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).btree) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_validate_context),
            "::",
            stringify!(btree),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_offset) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_validate_context),
            "::",
            stringify!(journal_offset),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).journal_seq) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(bkey_validate_context),
            "::",
            stringify!(journal_seq),
        ),
    );
}
impl Default for bkey_validate_context {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl bkey_validate_context {
    #[inline]
    pub fn from(&self) -> bkey_validate_context__bindgen_ty_1 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_from(&mut self, val: bkey_validate_context__bindgen_ty_1) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn flags(&self) -> bch_validate_flags {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: bch_validate_flags) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        from: bkey_validate_context__bindgen_ty_1,
        flags: bch_validate_flags,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                8u8,
                {
                    let from: u32 = unsafe { ::std::mem::transmute(from) };
                    from as u64
                },
            );
        __bindgen_bitfield_unit
            .set(
                8usize,
                8u8,
                {
                    let flags: u32 = unsafe { ::std::mem::transmute(flags) };
                    flags as u64
                },
            );
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn root(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_root(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_2(root: bool) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit
            .set(
                0usize,
                1u8,
                {
                    let root: u8 = unsafe { ::std::mem::transmute(root) };
                    root as u64
                },
            );
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct bch_ioctl_err_msg {
    pub msg_ptr: __u64,
    pub msg_len: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_bch_ioctl_err_msg() {
    const UNINIT: ::std::mem::MaybeUninit<bch_ioctl_err_msg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bch_ioctl_err_msg>(),
        16usize,
        concat!("Size of: ", stringify!(bch_ioctl_err_msg)),
    );
    assert_eq!(
        ::std::mem::align_of::<bch_ioctl_err_msg>(),
        8usize,
        concat!("Alignment of ", stringify!(bch_ioctl_err_msg)),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_ptr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_ioctl_err_msg),
            "::",
            stringify!(msg_ptr),
        ),
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_len) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(bch_io