---
allowed-tools: Read, Write, Edit, WebSearch
argument-hint: [constraint-domain] | --business | --technical | --regulatory | --resource
description: Model system constraints with validation, dependency mapping, and optimization strategies
---

# Constraint Modeler

Model comprehensive system constraints with systematic validation and optimization: **$ARGUMENTS**

## Current System Context

- Domain scope: Based on $ARGUMENTS (business, technical, operational, financial)
- Existing constraints: @documentation or configuration files
- System boundaries: Current limitations and dependencies
- Change dynamics: Historical constraint evolution patterns

## Task

Create comprehensive constraint models for accurate simulation and decision-making:

**Constraint Domain**: Use $ARGUMENTS to focus on business, technical, regulatory, or resource constraints

**Constraint Framework**:
1. **Hard Constraints** - Absolute limits that cannot be violated (legal, physical, technical)
2. **Soft Constraints** - Preferences and trade-offs that can be managed (budget, quality, timing)
3. **Dynamic Constraints** - Limitations that evolve over time (market, technology, capacity)
4. **Constraint Dependencies** - Relationships and interactions between different limitations
5. **Validation Framework** - Methods to verify constraint accuracy and relevance
6. **Optimization Strategies** - Approaches to relax, substitute, or circumvent constraints

**Advanced Analysis**: Constraint sensitivity analysis, bottleneck identification, scenario boundary definition, and optimization algorithms.

**Strategic Application**: Link constraint models to decision scenarios, resource allocation, and strategic planning.

**Output**: Complete constraint model with interaction matrices, validation reports, optimization recommendations, and scenario boundary definitions.