---
allowed-tools: Read, Write, Edit, WebSearch
argument-hint: [twin-subject] | --manufacturing | --business-process | --customer-journey | --system-performance
description: Create calibrated digital twins with real-world validation, scenario testing, and decision optimization
---

# Digital Twin Creator

Create comprehensive digital twins with systematic calibration and validation: **$ARGUMENTS**

## Current System State

- Twin subject: Based on $ARGUMENTS (manufacturing, business process, customer journey, system performance)
- Available data: Existing datasets, sensors, monitoring systems, and historical records
- System boundaries: Components, interfaces, and environmental factors to model
- Decision requirements: Specific use cases and accuracy needs for the digital twin

## Task

Build production-ready digital twin with comprehensive modeling and calibration:

**Twin Subject**: Use $ARGUMENTS to model manufacturing systems, business processes, customer journeys, or system performance

**Digital Twin Architecture**:
1. **System Mapping** - Component identification, relationship modeling, and boundary definition
2. **Data Foundation** - Quality assessment, gap analysis, and validation framework
3. **Model Construction** - Behavior modeling, interaction dynamics, and environmental factors
4. **Calibration Engine** - Historical validation, real-time adjustment, and accuracy monitoring
5. **Scenario Simulation** - What-if testing, optimization scenarios, and stress testing
6. **Decision Integration** - Recommendation engine, optimization algorithms, and risk assessment

**Advanced Features**: Real-time synchronization, predictive analytics, automated parameter tuning, and continuous learning.

**Quality Assurance**: Validation metrics, confidence intervals, model drift detection, and performance monitoring.

**Output**: Production-ready digital twin with calibration reports, scenario testing capabilities, decision support features, and comprehensive documentation.