---
allowed-tools: Read, Write, Edit, WebSearch
argument-hint: [time-horizon] | --near-term | --medium-term | --long-term | --disruption-focus
description: Generate comprehensive future scenarios with plausibility scoring, trend integration, and strategic implications
---

# Future Scenario Generator

Generate comprehensive future scenarios with systematic analysis and strategic integration: **$ARGUMENTS**

## Current Trend Context

- Time horizon: Based on $ARGUMENTS (1-2 years, 3-5 years, 5-10+ years)
- Domain focus: Industry, technology, society, or economic scenario generation
- Existing trends: Current patterns, trajectories, and emerging developments
- Key variables: Major factors that could shape future outcomes

## Task

Create systematic future scenarios with comprehensive analysis and strategic implications:

**Time Horizon**: Use $ARGUMENTS to focus on near-term, medium-term, long-term, or disruption-focused scenarios

**Scenario Framework**:
1. **Trend Analysis** - Multi-dimensional trend identification across technology, social, economic, and regulatory domains
2. **Scenario Architecture** - Baseline, optimistic, pessimistic, and transformation scenarios with cross-impact analysis
3. **Plausibility Assessment** - Multi-criteria scoring based on historical precedent, logical consistency, and expert validation
4. **Wild Card Integration** - Low-probability, high-impact events and disruption modeling
5. **Strategic Implications** - Decision-relevant insights and robust strategy identification
6. **Monitoring Framework** - Early warning indicators and scenario tracking systems

**Advanced Features**: Monte Carlo simulations, scenario interaction modeling, confidence intervals, and adaptive scenario management.

**Decision Integration**: Connect scenarios to strategic planning, risk management, and option generation with actionable recommendations.

**Output**: Comprehensive scenario portfolio with plausibility scores, strategic implications, monitoring indicators, and decision frameworks for multiple future possibilities.