---
allowed-tools: Read, Write, Edit, WebSearch
argument-hint: [simulation-target] | --financial-projections | --project-timelines | --market-scenarios | --risk-assessment
description: Run Monte Carlo simulations with probability distributions, confidence intervals, and statistical analysis
---

# Monte Carlo Simulator

Run comprehensive Monte Carlo simulations with advanced statistical analysis: **$ARGUMENTS**

## Current Analysis Context

- Simulation target: Based on $ARGUMENTS (financial projections, project timelines, market scenarios, risk assessment)
- Key variables: Uncertain parameters that drive outcome variability
- Available data: Historical data, expert estimates, and probability distributions
- Decision requirements: Confidence levels and risk tolerance for decision-making

## Task

Execute sophisticated Monte Carlo simulations with comprehensive uncertainty quantification:

**Simulation Target**: Use $ARGUMENTS to simulate financial projections, project timelines, market scenarios, or risk assessments

**Monte Carlo Framework**:
1. **Variable Definition** - Uncertain parameter identification, probability distribution selection, and correlation modeling
2. **Simulation Engine** - Random sampling, scenario generation, and statistical convergence analysis
3. **Output Analysis** - Probability distributions, confidence intervals, and sensitivity analysis
4. **Risk Quantification** - Value at Risk (VaR), extreme scenario analysis, and tail risk assessment
5. **Scenario Clustering** - Pattern recognition, outcome categorization, and decision-relevant grouping
6. **Decision Integration** - Risk-adjusted recommendations, optimization strategies, and contingency planning

**Advanced Features**: Latin hypercube sampling, copula modeling, importance sampling, and variance reduction techniques.

**Statistical Rigor**: Convergence testing, goodness-of-fit validation, and robust statistical inference with comprehensive uncertainty bounds.

**Output**: Complete Monte Carlo analysis with probability distributions, risk metrics, scenario analysis, and statistically-grounded decision recommendations with quantified confidence levels.