import { SendRequestReason } from "../JavaScriptSDK.Enums/SendRequestReason";
import { IAppInsightsCore } from "../JavaScriptSDK.Interfaces/IAppInsightsCore";
import { IChannelControls } from "../JavaScriptSDK.Interfaces/IChannelControls";
import { IPlugin } from "../JavaScriptSDK.Interfaces/ITelemetryPlugin";
import { ITelemetryPluginChain } from "../JavaScriptSDK.Interfaces/ITelemetryPluginChain";
export declare const ChannelControllerPriority = 500;
export interface IChannelController extends IChannelControls {
    flush(isAsync: boolean, callBack: (flushComplete?: boolean) => void, sendReason: SendRequestReason, cbTimeout?: number): void;
    getChannel<T extends IPlugin = IPlugin>(pluginIdentifier: string): T;
}
export interface IInternalChannelController extends IChannelController {
    _setQueue: (channels: _IInternalChannels[]) => void;
}
export interface _IInternalChannels {
    queue: IChannelControls[];
    chain: ITelemetryPluginChain;
}
export declare function createChannelControllerPlugin(channelQueue: _IInternalChannels[], core: IAppInsightsCore): IChannelController;
export declare function createChannelQueues(channels: IChannelControls[][], extensions: IPlugin[], core: IAppInsightsCore): _IInternalChannels[];
