"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraupnirRulesMatchingMembersCommand = exports.DraupnirRulesMatchingCommand = exports.DraupnirListRulesCommand = void 0;
exports.renderRuleHashes = renderRuleHashes;
exports.renderRuleClearText = renderRuleClearText;
exports.renderRuleSummary = renderRuleSummary;
exports.renderListRules = renderListRules;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const DraupnirCommandPrerequisites_1 = require("./DraupnirCommandPrerequisites");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
function renderListMatches(result) {
    if ((0, matrix_protection_suite_1.isError)(result)) {
        return (0, matrix_protection_suite_1.Ok)(undefined);
    }
    const lists = result.ok;
    if (lists.length === 0) {
        return (0, matrix_protection_suite_1.Ok)(interface_manager_1.DeadDocumentJSX.JSXFactory("root", null, "No policy lists configured"));
    }
    return (0, matrix_protection_suite_1.Ok)(interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("b", null, "Rules currently in use:"),
        interface_manager_1.DeadDocumentJSX.JSXFactory("br", null),
        lists.map((list) => renderListRules(list))));
}
function renderRuleHashes(rule) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, Object.entries(rule.hashes).map(([algorithm, hash]) => (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, algorithm),
        ": ",
        interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, hash))))));
}
function renderRuleClearText(rule) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, rule.entity),
        " (",
        rule.reason ?? "<no reason supplied>",
        ")"));
}
function renderRuleSummary(rule) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
        rule.kind,
        " (",
        interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, rule.recommendation),
        "):",
        " ",
        rule.matchType === matrix_protection_suite_1.PolicyRuleMatchType.HashedLiteral
            ? renderRuleHashes(rule)
            : renderRuleClearText(rule)));
}
function renderListRules(list) {
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("a", { href: list.room.toPermalink() }, list.roomID),
        " propagation:",
        " ",
        interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, list.profile.propagation),
        interface_manager_1.DeadDocumentJSX.JSXFactory("br", null),
        interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, list.matches.length === 0 ? (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("i", null, "No rules"))) : (list.matches.map((rule) => renderRuleSummary(rule))))));
}
exports.DraupnirListRulesCommand = (0, interface_manager_1.describeCommand)({
    summary: "Lists the rules currently in use by Draupnir.",
    parameters: [],
    async executor(draupnir) {
        return (0, matrix_protection_suite_1.Ok)(draupnir.protectedRoomsSet.watchedPolicyRooms.allRooms.map((profile) => ({
            room: profile.revision.room,
            roomID: profile.revision.room.toRoomIDOrAlias(),
            profile: profile,
            matches: profile.revision.allRules(),
        })));
    },
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.DraupnirListRulesCommand, {
    JSXRenderer: renderListMatches,
});
exports.DraupnirRulesMatchingCommand = (0, interface_manager_1.describeCommand)({
    summary: "Lists the rules in use that will match this entity e.g. `!rules matching @foo:example.com` will show all the user and server rules, including globs, that match this user",
    parameters: (0, interface_manager_1.tuple)({
        name: "entity",
        acceptor: (0, interface_manager_1.union)(interface_manager_1.MatrixUserIDPresentationType, interface_manager_1.MatrixRoomReferencePresentationSchema, interface_manager_1.StringPresentationType),
    }),
    async executor(draupnir, _info, _keywords, _rest, entity) {
        return (0, matrix_protection_suite_1.Ok)(draupnir.protectedRoomsSet.watchedPolicyRooms.allRooms.map((profile) => {
            return {
                room: profile.revision.room,
                roomID: profile.revision.room.toRoomIDOrAlias(),
                matches: profile.revision.allRulesMatchingEntity(entity.toString(), {}),
                profile: profile,
            };
        }));
    },
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.DraupnirRulesMatchingCommand, {
    JSXRenderer: renderListMatches,
});
exports.DraupnirRulesMatchingMembersCommand = (0, interface_manager_1.describeCommand)({
    summary: "Lists the rule that are matching matching members of protected rooms",
    parameters: (0, interface_manager_1.tuple)(),
    async executor(draupnir) {
        const revision = draupnir.protectedRoomsSet.setPoliciesMatchingMembership.currentRevision;
        return (0, matrix_protection_suite_1.Ok)(revision.allMembersWithRules());
    },
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.DraupnirRulesMatchingMembersCommand, {
    JSXRenderer(result) {
        if ((0, matrix_protection_suite_1.isError)(result)) {
            return (0, matrix_protection_suite_1.Ok)(undefined);
        }
        return (0, matrix_protection_suite_1.Ok)(interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("h4", null, "Rules matching members of protected rooms:"),
            interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, result.ok.map((memberPolicies) => (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
                (0, mps_interface_adaptor_1.renderMentionPill)(memberPolicies.userID, memberPolicies.userID),
                ":",
                interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, memberPolicies.policies.map((policy) => renderRuleSummary(policy)))))))));
    },
});
//# sourceMappingURL=Rules.js.map