"use strict";
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandExecutorHelper = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
const ParsedKeywords_1 = require("./ParsedKeywords");
const Adaptor_1 = require("../Adaptor");
const PresentationStream_1 = require("./PresentationStream");
const TextReader_1 = require("../TextReader");
const Keyword_1 = require("./Keyword");
exports.CommandExecutorHelper = Object.freeze({
    async execute(command, context, options, ...args) {
        var _a, _b, _c;
        const parsedKeywords = new ParsedKeywords_1.DirectParsedKeywords(command.parametersDescription.keywords, (_a = options.keywords) !== null && _a !== void 0 ? _a : {});
        return await command.executor(context, (_b = options.info) !== null && _b !== void 0 ? _b : {}, parsedKeywords, (_c = options.rest) !== null && _c !== void 0 ? _c : [], ...args);
    },
    async parseAndInvoke(commandTable, command, context, options, ...args) {
        var _a, _b;
        const commandInvoker = new Adaptor_1.StandardCommandInvoker({});
        const flatKeywords = [];
        for (const [key, value] of Object.entries((_a = options.keywords) !== null && _a !== void 0 ? _a : {})) {
            flatKeywords.push(TextReader_1.KeywordPresentationType.wrap(new Keyword_1.Keyword(key)));
            flatKeywords.push(value);
        }
        const partialcommand = {
            description: command,
            designator: ["CommandExecutorHelper"],
            isPartial: true,
            stream: new PresentationStream_1.StandardPresentationArgumentStream([
                ...args.reduce((acc, arg) => (arg ? [...acc, arg] : acc), []),
                ...flatKeywords,
                ...((_b = options.rest) !== null && _b !== void 0 ? _b : []),
            ]),
            commandTable,
        };
        const parseResult = commandInvoker.parseCommand(options.info, partialcommand);
        if ((0, typescript_result_1.isError)(parseResult)) {
            return parseResult;
        }
        else {
            return (await commandInvoker.invoke(context, options.info, parseResult.ok));
        }
    },
});
//# sourceMappingURL=CommandExecutorHelper.js.map