import { KeywordsMeta } from "./CommandMeta";
import { KeywordParametersDescription } from "./KeywordParameterDescription";
import { Presentation } from "./Presentation";
export interface ParsedKeywords {
    getKeywordValue<ObjectType = unknown>(keyword: string, defaultValue?: ObjectType): ObjectType | undefined;
}
/**
 * A read only map of keywords to their associated properties.
 */
export declare class StandardParsedKeywords<TKeywordsMeta extends KeywordsMeta = KeywordsMeta> implements ParsedKeywords {
    private readonly description;
    private readonly keywords;
    constructor(description: KeywordParametersDescription<TKeywordsMeta>, keywords: ReadonlyMap<keyof TKeywordsMeta, Presentation | true>);
    getKeywordValue<ObjectType = unknown>(keyword: string, defaultValue?: ObjectType | undefined): ObjectType | undefined;
}
export declare class DirectParsedKeywords<TKeywordsMeta extends KeywordsMeta = KeywordsMeta> implements ParsedKeywords {
    private readonly description;
    readonly keywords: TKeywordsMeta;
    constructor(description: KeywordParametersDescription<TKeywordsMeta>, keywords: TKeywordsMeta);
    getKeywordValue<ObjectType = unknown>(keyword: string, defaultValue?: ObjectType): ObjectType | undefined;
}
//# sourceMappingURL=ParsedKeywords.d.ts.map