"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardJSInterfaceCommandDispatcher = void 0;
const Adaptor_1 = require("../Adaptor");
const typescript_result_1 = require("@gnuxie/typescript-result");
const StandardCommandDispatcher_1 = require("./StandardCommandDispatcher");
class StandardJSInterfaceCommandDispatcher {
    constructor(commandTable, helpCommand, adaptorContext, callbacks, contextTranslator) {
        this.commandTable = commandTable;
        this.helpCommand = helpCommand;
        this.adaptorContext = adaptorContext;
        this.callbacks = callbacks;
        this.contextTranslator = contextTranslator;
        this.commandInvoker =
            new Adaptor_1.StandardCommandInvoker(this.callbacks);
        this.commandDispatcher =
            new StandardCommandDispatcher_1.StandardCommandDispatcher(this.commandTable, this.helpCommand, this.callbacks);
    }
    async invokeAndParsePartialCommand(invocationInformation, partialCommand) {
        var _a, _b;
        const completeCommand = this.commandInvoker.parseCommand(invocationInformation, partialCommand);
        if ((0, typescript_result_1.isError)(completeCommand)) {
            return completeCommand;
        }
        const commandContext = (_b = (_a = this.contextTranslator) === null || _a === void 0 ? void 0 : _a.translateContext(completeCommand.ok.description, this.adaptorContext)) !== null && _b !== void 0 ? _b : this.adaptorContext;
        return (await this.commandInvoker.invoke(commandContext, invocationInformation, completeCommand.ok));
    }
    async invokeCommandFromPresentationStream(invocationInformation, stream) {
        const partialCommand = this.commandDispatcher.parsePartialCommandFromStream(invocationInformation, stream);
        if ((0, typescript_result_1.isError)(partialCommand)) {
            return partialCommand;
        }
        return await this.invokeAndParsePartialCommand(invocationInformation, partialCommand.ok);
    }
    async invokeCommandFromBody(invocationInformation, body) {
        const partialCommand = this.commandDispatcher.parsePartialCommandFromBody(invocationInformation, body);
        if ((0, typescript_result_1.isError)(partialCommand)) {
            return partialCommand;
        }
        return await this.invokeAndParsePartialCommand(invocationInformation, partialCommand.ok);
    }
}
exports.StandardJSInterfaceCommandDispatcher = StandardJSInterfaceCommandDispatcher;
//# sourceMappingURL=JSInterfaceCommandDispatcher.js.map