"use strict";
// SPDX-FileCopyrightText: 2023 - 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-basic-types
// https://github.com/the-draupnir-project/matrix-basic-types
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.isStringRoomID = isStringRoomID;
exports.StringRoomID = StringRoomID;
const StringRoomIDRegex = /^!([^:]*:\S*|[a-zA-Z0-9-_]{43})/;
function isStringRoomID(string) {
    return StringRoomIDRegex.test(string);
}
function StringRoomID(value) {
    if (typeof value === "string" && isStringRoomID(value)) {
        return value;
    }
    throw new TypeError("Not a valid StringRoomID");
}
//# sourceMappingURL=StringRoomID.js.map