"use strict";
// SPDX-FileCopyrightText: 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from neightrix-basic-types
// https://github.com/the-draupnir-project/neightrix-basic-types
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringUserIDRegex = exports.HistoricalStringUserIDLocalpartRegex = void 0;
exports.isStringUserID = isStringUserID;
exports.StringUserID = StringUserID;
exports.userServerName = userServerName;
exports.userLocalpart = userLocalpart;
/**
 * Do not use this, Synapse does not validate user ids and it isn't an auth check....
 */
exports.HistoricalStringUserIDLocalpartRegex = /(?<localpart>[!-9;-~]+)/;
exports.StringUserIDRegex = /^@(?<localpart>[^:]*):(?<serverName>\S*)$/;
function isStringUserID(string) {
    return exports.StringUserIDRegex.test(string);
}
function StringUserID(string) {
    if (typeof string === "string" && isStringUserID(string)) {
        return string;
    }
    throw new TypeError("Not a valid StringUserID");
}
function userServerName(userID) {
    var _a, _b;
    const match = (_b = (_a = exports.StringUserIDRegex.exec(userID)) === null || _a === void 0 ? void 0 : _a.groups) === null || _b === void 0 ? void 0 : _b.serverName;
    if (match === undefined) {
        throw new TypeError("Somehow a StringUserID was created that is invalid.");
    }
    return match;
}
function userLocalpart(userID) {
    var _a, _b;
    const match = (_b = (_a = exports.StringUserIDRegex.exec(userID)) === null || _a === void 0 ? void 0 : _a.groups) === null || _b === void 0 ? void 0 : _b.localpart;
    if (match === undefined) {
        throw new TypeError("Somehow a StringUserID was created that is invalid.");
    }
    return match;
}
//# sourceMappingURL=StringUserID.js.map