"use strict";
/**
 * Copyright (C) 2023, 2025 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveRoomReferenceSafe = resolveRoomReferenceSafe;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const typebox_1 = require("@sinclair/typebox");
const BotSDKBaseClient_1 = require("./Client/BotSDKBaseClient");
const RoomResolveResponse = typebox_1.Type.Object({
    room_id: matrix_protection_suite_1.StringRoomIDSchema,
    servers: typebox_1.Type.Array(typebox_1.Type.String()),
});
async function resolveRoomReferenceSafe(client, roomRef) {
    if (roomRef instanceof matrix_basic_types_1.MatrixRoomID) {
        return (0, matrix_protection_suite_1.Ok)(roomRef);
    }
    return await client
        .doRequest('GET', `/_matrix/client/v3/directory/room/${encodeURIComponent(roomRef.toRoomIDOrAlias())}`)
        .then((value) => {
        const response = matrix_protection_suite_1.Value.Decode(RoomResolveResponse, value);
        if ((0, matrix_protection_suite_1.isError)(response)) {
            return response;
        }
        return (0, matrix_protection_suite_1.Ok)(new matrix_basic_types_1.MatrixRoomID(response.ok.room_id, response.ok.servers));
    }, BotSDKBaseClient_1.resultifyBotSDKRequestError);
}
//# sourceMappingURL=SafeMatrixClient.js.map