"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynapseRoomShutdownV2RequestBody = void 0;
const typebox_1 = require("@sinclair/typebox");
exports.SynapseRoomShutdownV2RequestBody = typebox_1.Type.Object({
    new_room_user_id: typebox_1.Type.Optional(typebox_1.Type.String({
        description: 'User ID of the creator/admin for the new room. Must be local but not necessarily registered.',
    })),
    room_name: typebox_1.Type.Optional(typebox_1.Type.String({
        description: "Name of the new room. Defaults to 'Content Violation Notification'.",
    })),
    message: typebox_1.Type.Optional(typebox_1.Type.String({
        description: "First message in the new room. Defaults to 'Sharing illegal content on this server is not permitted and rooms in violation will be blocked.'",
    })),
    block: typebox_1.Type.Optional(typebox_1.Type.Boolean({
        description: 'If true, prevents future attempts to join the room. Defaults to false.',
    })),
    purge: typebox_1.Type.Optional(typebox_1.Type.Boolean({
        description: 'If true, removes all traces of the room from the database. Defaults to true.',
    })),
    force_purge: typebox_1.Type.Optional(typebox_1.Type.Boolean({
        description: "If true, forces purge even if local users are still in the room. Only applies if 'purge' is true.",
    })),
}, { minProperties: 1, description: 'Request body must not be empty.' });
//# sourceMappingURL=ShutdownV2Endpoint.js.map