"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const DeclareRoomState_1 = require("../StateTracking/DeclareRoomState");
const EventGeneration_1 = require("../TestUtilities/EventGeneration");
const MembershipChange_1 = require("./MembershipChange");
const StandardRoomMembershipRevision_1 = require("./StandardRoomMembershipRevision");
test('Membership events are unintenrned', function () {
    const joinLeaveUser = (0, EventGeneration_1.randomUserID)();
    const room = (0, EventGeneration_1.randomRoomID)([]);
    const joinEvent = (0, DeclareRoomState_1.describeRoomMember)({
        sender: joinLeaveUser,
        room_id: room.toRoomIDOrAlias(),
    });
    const leaveEvent = (0, DeclareRoomState_1.describeRoomMember)({
        sender: joinLeaveUser,
        room_id: room.toRoomIDOrAlias(),
        membership: MembershipChange_1.Membership.Leave,
    });
    const revision = StandardRoomMembershipRevision_1.StandardRoomMembershipRevision.blankRevision(room)
        .reviseFromMembership([joinEvent])
        .reviseFromMembership([leaveEvent]);
    expect([...revision.members()].length).toBe(1);
});
//# sourceMappingURL=StandardRoomMembershipRevision.test.js.map