"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.policyStateKeyFromContent = policyStateKeyFromContent;
exports.buildPolicyEvent = buildPolicyEvent;
// Copyright (C) 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const PolicyEvents_1 = require("../MatrixTypes/PolicyEvents");
const crypto_js_1 = require("crypto-js");
const enc_base64_1 = __importDefault(require("crypto-js/enc-base64"));
function policyStateKeyFromContent(content) {
    if ('entity' in content) {
        return enc_base64_1.default.stringify((0, crypto_js_1.SHA256)(content.entity + content.recommendation));
    }
    else {
        const hashes = 
        // we need the expressions mare:
        // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
        ('hashes' in content && content.hashes) ||
            ('org.matrix.msc4205.hashes' in content &&
                content['org.matrix.msc4205.hashes']);
        const words = [content.recommendation];
        for (const [hash] of Object.entries(hashes)) {
            words.push(hash);
        }
        return enc_base64_1.default.stringify((0, crypto_js_1.SHA256)(words.join('')));
    }
}
function buildPolicyEvent({ state_key, type, content, copyFrom, remove, }) {
    if (remove !== undefined) {
        return {
            state_key: remove.state_key,
            type: remove.type,
            content: {},
            policyRuleType: (0, PolicyEvents_1.normalisePolicyRuleType)(remove.type),
        };
    }
    else if (copyFrom !== undefined) {
        return {
            state_key: state_key !== null && state_key !== void 0 ? state_key : copyFrom.state_key,
            type: type !== null && type !== void 0 ? type : copyFrom.type,
            content: content !== null && content !== void 0 ? content : copyFrom.content,
            policyRuleType: (0, PolicyEvents_1.normalisePolicyRuleType)(copyFrom.type),
        };
    }
    else if (content !== undefined) {
        if (type === undefined) {
            throw new TypeError(`type cannot be undefined while creating empty policy rule content`);
        }
        return {
            state_key: state_key !== null && state_key !== void 0 ? state_key : policyStateKeyFromContent(content),
            type,
            content,
            policyRuleType: (0, PolicyEvents_1.normalisePolicyRuleType)(type),
        };
    }
    else {
        if (state_key === undefined || type === undefined) {
            throw new TypeError(`Can't create a policy event with empty content without the state_key and type`);
        }
        return {
            state_key,
            type,
            content: {},
            policyRuleType: (0, PolicyEvents_1.normalisePolicyRuleType)(type),
        };
    }
}
//# sourceMappingURL=PolicyRuleEventBuilder.js.map