"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomStatePolicyRoomRevisionIssuer = void 0;
// Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const events_1 = __importDefault(require("events"));
const PolicyListRevision_1 = require("./PolicyListRevision");
const PolicyEvents_1 = require("../MatrixTypes/PolicyEvents");
/**
 * An implementation of the {@link RoomMembershipRevisionIssuer} that
 * uses the {@link RoomStateRevisionIssuer}.
 */
class RoomStatePolicyRoomRevisionIssuer extends events_1.default {
    constructor(room, currentRevision, roomStateRevisionIssuer) {
        super();
        this.room = room;
        this.currentRevision = currentRevision;
        this.roomStateRevisionIssuer = roomStateRevisionIssuer;
        const stateRevision = roomStateRevisionIssuer.currentRevision;
        const powerLevels = stateRevision.getStateEvent('m.room.power_levels', '');
        if (powerLevels !== undefined) {
            this.currentRevision =
                this.currentRevision.reviseFromPowerLevels(powerLevels);
        }
        const shortcodeEvent = stateRevision.getStateEvent(PolicyListRevision_1.MJOLNIR_SHORTCODE_EVENT_TYPE, '');
        if (shortcodeEvent !== undefined) {
            this.currentRevision =
                this.currentRevision.reviseFromShortcode(shortcodeEvent);
        }
        this.currentRevision = this.currentRevision.reviseFromState(stateRevision.getStateEventsOfTypes(PolicyEvents_1.ALL_RULE_TYPES));
        this.stateRevisionListener = this.listener.bind(this);
        this.roomStateRevisionIssuer.on('revision', this.stateRevisionListener);
    }
    updateForStateEvent(event) {
        if (this.currentRevision.hasEvent(event.event_id)) {
            return;
        }
        this.roomStateRevisionIssuer.updateForEvent(event);
    }
    updateForRedactionEvent(event) {
        this.roomStateRevisionIssuer.updateForRedaction(event);
    }
    listener(_stateRevision, stateChanges) {
        const previousRevision = this.currentRevision;
        const policyEvents = stateChanges
            .filter((change) => PolicyEvents_1.ALL_RULE_TYPES.includes(change.eventType))
            .map((change) => change.state);
        const policyChanges = this.currentRevision.changesFromState(policyEvents);
        const powerLevelsChange = stateChanges.find((change) => change.eventType === 'm.room.power_levels');
        if (policyChanges.length > 0) {
            this.currentRevision = previousRevision.reviseFromChanges(policyChanges);
        }
        if (powerLevelsChange !== undefined) {
            this.currentRevision = this.currentRevision.reviseFromPowerLevels(powerLevelsChange.state);
        }
        const shortcodeChange = stateChanges.find((change) => change.eventType === PolicyListRevision_1.MJOLNIR_SHORTCODE_EVENT_TYPE);
        if (shortcodeChange !== undefined) {
            this.currentRevision = this.currentRevision.reviseFromShortcode(shortcodeChange.state);
        }
        if (this.currentRevision.revisionID !== previousRevision.revisionID) {
            this.emit('revision', this.currentRevision, policyChanges, previousRevision);
        }
    }
    updateForRevealedPolicies(policies) {
        const changes = this.currentRevision.changesFromRevealedPolicies(policies);
        if (changes.length === 0) {
            return;
        }
        const previousRevision = this.currentRevision;
        this.currentRevision = previousRevision.reviseFromChanges(changes);
        this.emit('revision', this.currentRevision, changes, previousRevision);
    }
    unregisterListeners() {
        this.roomStateRevisionIssuer.off('revision', this.stateRevisionListener);
    }
}
exports.RoomStatePolicyRoomRevisionIssuer = RoomStatePolicyRoomRevisionIssuer;
//# sourceMappingURL=RoomStatePolicyListRevisionIssuer.js.map