import { DescriptionMeta } from '../DescriptionMeta';
import { CapabilityInterfaceDescription } from './CapabilityInterface';
import { CapabilityProviderSet, CapabilitySet, GenericCapabilityDescription } from './CapabilitySet';
import { PowerLevelPermission } from '../../Client/PowerLevelsMirror';
/**
 * We don't want to give protections access to the capability provider
 * description, just in case they do something silly.
 */
export interface CapabilityProviderDescription<Context = unknown> {
    /** Used by the user to identify the description */
    name: string;
    description: string;
    interface: CapabilityInterfaceDescription;
    isSimulated?: true;
    /**
     * Returns an instance of the provider.
     * @param protectionDescription A description of the protection that we are making the provider for.
     * Mostly so that the capability provider can audit the protection.
     * @param context Anything used to create the capability, usually the ProtectedRoomsSet context,
     * like Draupnir.
     */
    factory(protectionDescription: DescriptionMeta, context: Context): Capability;
}
export interface Capability {
    readonly requiredPermissions: PowerLevelPermission[];
    readonly requiredStatePermissions: string[];
    readonly requiredEventPermissions: string[];
    readonly isSimulated?: boolean;
}
export declare const Capability: import("@sinclair/typebox").TObject<{
    requiredPermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
    requiredEventPermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
    requiredStatePermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
}>;
export declare function registerCapabilityProvider(description: CapabilityProviderDescription): void;
export declare function findCapabilityProvider<Context = unknown>(name: string): CapabilityProviderDescription<Context> | undefined;
export declare function describeCapabilityProvider<Context = unknown>({ name, description, interface: interfaceName, isSimulated, factory, }: {
    name: string;
    description: string;
    interface: string;
    isSimulated?: boolean;
    factory(description: DescriptionMeta, context: Context): Capability;
}): void;
export declare function findCapabilityProviderSet<TCapabilitySet extends CapabilitySet = CapabilitySet>(names: GenericCapabilityDescription<TCapabilitySet>): CapabilityProviderSet<TCapabilitySet>;
export declare function findCompatibleCapabilityProviders(interfaceName: string): CapabilityProviderDescription[];
export declare function findSimulatedCapabilityProvider(interfaceName: string): CapabilityProviderDescription | undefined;
//# sourceMappingURL=CapabilityProvider.d.ts.map