"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerCapabilityRenderer = registerCapabilityRenderer;
exports.findCapabilityRenderer = findCapabilityRenderer;
exports.describeCapabilityRenderer = describeCapabilityRenderer;
exports.wrapCapabilityProviderInRenderer = wrapCapabilityProviderInRenderer;
const CapabilityContextGlue_1 = require("./CapabilityContextGlue");
const CapabilityInterface_1 = require("./CapabilityInterface");
const RENDERER_DESCRIPTIONS = new Map();
const DEFAULT_RENDERER_FOR_INTERFACE = new Map();
function registerCapabilityRenderer(description) {
    if (RENDERER_DESCRIPTIONS.has(description.name)) {
        throw new TypeError(`There is already a capability renderer named ${description.name}`);
    }
    if (description.isDefaultForInterface) {
        if (DEFAULT_RENDERER_FOR_INTERFACE.has(description.interface.name)) {
            throw new TypeError(`There is already a renderer for the capability interface ${description.interface.name}`);
        }
        DEFAULT_RENDERER_FOR_INTERFACE.set(description.interface.name, description);
    }
    RENDERER_DESCRIPTIONS.set(description.name, description);
}
function findCapabilityRenderer(name) {
    return RENDERER_DESCRIPTIONS.get(name);
}
function describeCapabilityRenderer({ name, description, interface: interfaceName, factory, isDefaultForInterface, }) {
    const entry = (0, CapabilityInterface_1.findCapabilityInterface)(interfaceName);
    if (entry === undefined) {
        throw new TypeError(`Cannot find a CapabilityInterface named ${interfaceName}`);
    }
    registerCapabilityRenderer({
        ...(isDefaultForInterface ? { isDefaultForInterface } : {}),
        name,
        description,
        interface: entry,
        factory,
    });
}
function findRendererForInterface(interfaceName) {
    return DEFAULT_RENDERER_FOR_INTERFACE.get(interfaceName);
}
function wrapCapabilityProviderInRenderer(protectionDescription, context, capabilityProviderDescription) {
    var _a;
    const rendererDescription = (_a = findCapabilityRenderer(capabilityProviderDescription.name)) !== null && _a !== void 0 ? _a : findRendererForInterface(capabilityProviderDescription.interface.name);
    if (rendererDescription === undefined) {
        throw new TypeError(`Cannot find a renderer for the capability provider named ${capabilityProviderDescription.name}`);
    }
    const glue = (0, CapabilityContextGlue_1.findCapabilityContextGlue)(capabilityProviderDescription.name);
    const capabilityProvider = glue === undefined
        ? capabilityProviderDescription.factory(protectionDescription, context)
        : glue.glueMethod(protectionDescription, context, capabilityProviderDescription);
    return rendererDescription.factory(protectionDescription, context, capabilityProvider);
}
//# sourceMappingURL=CapabilityRenderer.js.map