"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomMessageMediaURLMixinDescription = void 0;
const StandardMixinExtractor_1 = require("../EventMixinExtraction/StandardMixinExtractor");
const hasOwn_1 = require("../hasOwn");
exports.RoomMessageMediaURLMixinDescription = Object.freeze({
    name: 'm.room.message media URL mixin',
    description: 'Extracts the media URL mixin from content that looks like m.room.message',
    properties: ['url'],
    parser(content) {
        if (!(0, hasOwn_1.hasOwn)(content, 'url')) {
            return undefined;
        }
        if (typeof content.url !== 'string') {
            return (0, StandardMixinExtractor_1.ErroneousMixin)(this, "The mediaURL mixin doesn't match the schema");
        }
        return {
            description: this,
            isErroneous: false,
            url: content.url,
        };
    },
});
//# sourceMappingURL=RoomMessageMediaURLMixin.js.map