"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomsSetBehaviour = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const typescript_result_1 = require("@gnuxie/typescript-result");
const ProtectJoinedRooms_1 = require("./ProtectJoinedRooms");
const UnprotectPartedRooms_1 = require("./UnprotectPartedRooms");
const ProtectReplacementRooms_1 = require("./ProtectReplacementRooms");
const WatchReplacementPolicyRooms_1 = require("./WatchReplacementPolicyRooms");
class RoomsSetBehaviour extends matrix_protection_suite_1.AbstractProtection {
    constructor(description, capabilities, protectedRoomsSet, draupnir) {
        super(description, capabilities, protectedRoomsSet, {});
        this.draupnir = draupnir;
        this.protectJoinedRooms = new ProtectJoinedRooms_1.ProtectedJoinedRooms(this.draupnir.clientUserID, this.draupnir.managementRoomID, this.protectedRoomsSet, this.draupnir.clientRooms, this.draupnir.clientPlatform.toRoomMessageSender());
        this.unprotectedPartedRooms = new UnprotectPartedRooms_1.UnprotectPartedRooms(this.draupnir.clientUserID, this.draupnir.managementRoomID, this.protectedRoomsSet.protectedRoomsManager, this.draupnir.clientPlatform.toRoomMessageSender());
        this.protectReplacementRooms = new ProtectReplacementRooms_1.ProtectReplacementRooms(this.draupnir.managementRoomID, this.draupnir.clientPlatform.toRoomJoiner(), this.draupnir.clientPlatform.toRoomMessageSender(), this.protectedRoomsSet.protectedRoomsManager);
        this.watchReplacementPolicyRooms = new WatchReplacementPolicyRooms_1.WatchReplacementPolicyRooms(this.draupnir.managementRoomID, this.draupnir.clientPlatform.toRoomJoiner(), this.draupnir.clientPlatform.toRoomMessageSender(), this.draupnir.clientPlatform.toRoomReactionSender(), this.draupnir.protectedRoomsSet.watchedPolicyRooms, this.draupnir.roomStateManager, this.draupnir.policyRoomManager, this.draupnir.reactionHandler);
        if (this.draupnir.config.protectAllJoinedRooms) {
            void this.protectJoinedRooms.syncProtectedRooms();
        }
        void this.watchReplacementPolicyRooms.syncTombstonedPolicyRooms();
    }
    handleMembershipChange(_revision, changes) {
        if (this.draupnir.config.protectAllJoinedRooms) {
            this.protectJoinedRooms.handleMembershipChange(changes);
        }
        for (const change of changes) {
            this.unprotectedPartedRooms.handleMembershipChange(change);
        }
        return Promise.resolve((0, typescript_result_1.Ok)(undefined));
    }
    handleExternalMembership(roomID, event) {
        if (this.draupnir.config.protectAllJoinedRooms) {
            this.protectJoinedRooms.handleExternalMembership(roomID, event);
        }
    }
    handleStateChange(_revision, changes) {
        this.protectReplacementRooms.handleRoomStateChange(changes);
        this.watchReplacementPolicyRooms.handleRoomStateChange(changes);
        return Promise.resolve((0, typescript_result_1.Ok)(undefined));
    }
    handleProtectionDisable() {
        this.watchReplacementPolicyRooms.unregisterListeners();
    }
}
exports.RoomsSetBehaviour = RoomsSetBehaviour;
(0, matrix_protection_suite_1.describeProtection)({
    name: RoomsSetBehaviour.name,
    description: "Unprotects parted rooms and update the list of protected rooms.",
    capabilityInterfaces: {},
    defaultCapabilities: {},
    async factory(description, protectedRoomsSet, draupnir, capabilities, _settings) {
        return (0, typescript_result_1.Ok)(new RoomsSetBehaviour(description, capabilities, protectedRoomsSet, draupnir));
    },
});
//# sourceMappingURL=RoomsSetBehaviourProtection.js.map