"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnprotectPartedRooms = void 0;
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
class UnprotectPartedRooms {
    constructor(clientUserID, managementRoomID, protectedRoomsManager, messageSender) {
        this.clientUserID = clientUserID;
        this.managementRoomID = managementRoomID;
        this.protectedRoomsManager = protectedRoomsManager;
        this.messageSender = messageSender;
        // nothing to do.
    }
    async handlePartedRoom(change) {
        const room = matrix_basic_types_1.MatrixRoomReference.fromRoomID(change.roomID);
        const unprotectResult = await this.protectedRoomsManager.removeRoom(room);
        const removalDescription = (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
            "Draupnir has been removed from ",
            (0, mps_interface_adaptor_1.renderRoomPill)(room),
            " by",
            " ",
            (0, mps_interface_adaptor_1.renderMentionPill)(change.sender, change.sender),
            change.content.reason ? (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
                " ",
                "for reason: ",
                interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, change.content.reason))) : (""),
            "."));
        if ((0, matrix_protection_suite_1.isOk)(unprotectResult)) {
            void (0, matrix_protection_suite_1.Task)((0, mps_interface_adaptor_1.sendMatrixEventsFromDeadDocument)(this.messageSender, this.managementRoomID, interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
                removalDescription,
                " The room is now unprotected."), {}), {
                description: "Report recently unprotected rooms to the management room.",
            });
        }
        else {
            void (0, matrix_protection_suite_1.Task)((0, mps_interface_adaptor_1.sendMatrixEventsFromDeadDocument)(this.messageSender, this.managementRoomID, interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
                removalDescription,
                " Draupnir could not unprotect the room. Please use ",
                interface_manager_1.DeadDocumentJSX.JSXFactory("code", null,
                    "!draupnir rooms remove ",
                    room.toRoomIDOrAlias()),
                " if the room is still marked as protected."), {}), {
                description: "Report recently unprotected rooms to the management room.",
            });
        }
    }
    handleMembershipChange(change) {
        if (change.userID === this.clientUserID) {
            if (!this.protectedRoomsManager.isProtectedRoom(change.roomID)) {
                return;
            }
            switch (change.membershipChangeType) {
                case matrix_protection_suite_1.MembershipChangeType.Banned:
                case matrix_protection_suite_1.MembershipChangeType.Kicked:
                case matrix_protection_suite_1.MembershipChangeType.Left:
                    void this.handlePartedRoom(change);
            }
        }
    }
}
exports.UnprotectPartedRooms = UnprotectPartedRooms;
//# sourceMappingURL=UnprotectPartedRooms.js.map