"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderRecoveryOptions = renderRecoveryOptions;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const SafeModeCause_1 = require("./SafeModeCause");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
function renderRecoveryOptions(cause) {
    const recoveryOptions = cause.reason === SafeModeCause_1.SafeModeReason.ByRequest
        ? []
        : cause.error instanceof matrix_protection_suite_1.ConfigRecoverableError
            ? cause.error.recoveryOptions
            : [];
    if (recoveryOptions.length === 0) {
        return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null, "No recovery options are available for this failure mode."));
    }
    return (interface_manager_1.DeadDocumentJSX.JSXFactory("fragment", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("p", null,
            "Recovery options are available for this failure mode:",
            interface_manager_1.DeadDocumentJSX.JSXFactory("ol", null, recoveryOptions.map((option) => (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null, option.description))))),
        interface_manager_1.DeadDocumentJSX.JSXFactory("hr", null),
        interface_manager_1.DeadDocumentJSX.JSXFactory("p", null,
            "To use a ",
            interface_manager_1.DeadDocumentJSX.JSXFactory("b", null, "recovery option"),
            ", click on one of the reactions (",
            recoveryOptions
                .map((_, index) => mps_interface_adaptor_1.MatrixReactionHandler.numberToEmoji(index + 1))
                .join(", "),
            "), or use the recover command: ",
            interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, "!draupnir recover 1"),
            ".")));
}
//# sourceMappingURL=RecoveryOptions.js.map