"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserMayInviteEndpoint = exports.UserMayInviteRequestBody = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const typebox_1 = require("@sinclair/typebox");
// for check_event_for_spam we will leave the event as unparsed
const log = new matrix_protection_suite_1.Logger("UserMayInviteEndpoint");
exports.UserMayInviteRequestBody = typebox_1.Type.Object({
    inviter: matrix_protection_suite_1.StringUserIDSchema,
    invitee: matrix_protection_suite_1.StringUserIDSchema,
    room_id: matrix_protection_suite_1.StringRoomIDSchema,
});
class UserMayInviteEndpoint {
    constructor(pluginManager) {
        this.pluginManager = pluginManager;
        // nothing to do.
    }
    async handleUserMayInviteAsync(request, response, isResponded) {
        const decodedBody = matrix_protection_suite_1.Value.Decode(exports.UserMayInviteRequestBody, request.body);
        if ((0, matrix_protection_suite_1.isError)(decodedBody)) {
            log.error("Error decoding request body:", decodedBody.error);
            if (!isResponded && this.pluginManager.isBlocking()) {
                response.status(400).send({
                    errcode: "M_INVALID_PARAM",
                    error: "Error handling inviter, invitee, and room_id",
                });
            }
            return;
        }
        if (!isResponded && this.pluginManager.isBlocking()) {
            const blockingResult = await this.pluginManager.callBlockingHandles(decodedBody.ok);
            if (blockingResult === "NOT_SPAM") {
                response.status(200);
                response.send({});
            }
            else {
                response.status(400);
                response.send(blockingResult);
            }
        }
        else if (!isResponded) {
            response.status(200);
            response.send({});
        }
        this.pluginManager.callNonBlockingHandlesInTask(decodedBody.ok);
    }
    handleUserMayInvite(request, response) {
        if (!this.pluginManager.isBlocking()) {
            response.status(200);
            response.send({});
        }
        void (0, matrix_protection_suite_1.Task)(this.handleUserMayInviteAsync(request, response, !this.pluginManager.isBlocking()));
    }
}
exports.UserMayInviteEndpoint = UserMayInviteEndpoint;
//# sourceMappingURL=UserMayInviteEndpoint.js.map