"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppserviceRestartDraupnirCommand = exports.AppserviceListUnstartedCommand = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const AppserviceBotInterfaceAdaptor_1 = require("./AppserviceBotInterfaceAdaptor");
exports.AppserviceListUnstartedCommand = (0, interface_manager_1.describeCommand)({
    summary: "List any Draupnir that failed to start.",
    async executor(context) {
        return (0, matrix_protection_suite_1.Ok)(context.appservice.draupnirManager.getUnstartedDraupnirs());
    },
    parameters: [],
});
AppserviceBotInterfaceAdaptor_1.AppserviceBotInterfaceAdaptor.describeRenderer(exports.AppserviceListUnstartedCommand, {
    JSXRenderer: function (result) {
        if ((0, matrix_protection_suite_1.isError)(result)) {
            return (0, matrix_protection_suite_1.Ok)(undefined);
        }
        const draupnirs = result.ok;
        return (0, matrix_protection_suite_1.Ok)(interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
            interface_manager_1.DeadDocumentJSX.JSXFactory("b", null,
                "Unstarted Draupnir: ",
                draupnirs.length),
            interface_manager_1.DeadDocumentJSX.JSXFactory("ul", null, draupnirs.map((draupnir) => {
                return (interface_manager_1.DeadDocumentJSX.JSXFactory("li", null,
                    interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, draupnir.clientUserID),
                    interface_manager_1.DeadDocumentJSX.JSXFactory("code", null, draupnir.failType),
                    ":",
                    interface_manager_1.DeadDocumentJSX.JSXFactory("br", null),
                    String(draupnir.cause)));
            }))));
    },
});
exports.AppserviceRestartDraupnirCommand = (0, interface_manager_1.describeCommand)({
    summary: "Restart a Draupnir.",
    parameters: (0, interface_manager_1.tuple)({
        name: "draupnir",
        acceptor: interface_manager_1.MatrixUserIDPresentationType,
        description: "The userid of the draupnir to restart",
    }),
    async executor(context, _info, _keywords, _rest, draupnirUser) {
        const draupnirManager = context.appservice.draupnirManager;
        const draupnir = draupnirManager.findUnstartedDraupnir(draupnirUser.toString());
        if (draupnir !== undefined) {
            return matrix_protection_suite_1.ActionError.Result(`We can't find the unstarted draupnir ${draupnirUser.toString()}, is it already running?`);
        }
        return await draupnirManager.startDraupnirFromMXID(draupnirUser.toString());
    },
});
AppserviceBotInterfaceAdaptor_1.AppserviceBotInterfaceAdaptor.describeRenderer(exports.AppserviceRestartDraupnirCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
//# sourceMappingURL=ListCommand.js.map