"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2022 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
const matrix_appservice_bridge_1 = require("matrix-appservice-bridge");
const AppService_1 = require("./AppService");
const config_1 = require("./config/config");
const value_1 = require("@sinclair/typebox/value");
/**
 * This file provides the entrypoint for the appservice mode for draupnir.
 * A registration file can be generated `ts-node src/appservice/cli.ts -r -u "http://host.docker.internal:9000"`
 * and the appservice can be started with `ts-node src/appservice/cli -p 9000 -c your-confg.yaml`.
 */
const cli = new matrix_appservice_bridge_1.Cli({
    registrationPath: "draupnir-registration.yaml",
    bridgeConfig: {
        schema: {},
        affectsRegistration: false,
        defaults: {},
    },
    generateRegistration: AppService_1.MjolnirAppService.generateRegistration,
    run: function (port) {
        const config = cli.getConfig();
        if (config === null) {
            throw new Error("Couldn't load config");
        }
        void AppService_1.MjolnirAppService.run(port, 
        // we use the matrix-appservice-bridge library to handle cli arguments for loading the config
        // but we have to still validate it ourselves.
        value_1.Value.Decode(config_1.AppserviceConfig, config), cli.getRegistrationFilePath());
    },
});
cli.run();
//# sourceMappingURL=cli.js.map