"use strict";
// Copyright 2022 - 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 - 2022 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraupnirHelpCommand = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const DraupnirCommandTable_1 = require("./DraupnirCommandTable");
const PresentationSchema_1 = require("@the-draupnir-project/interface-manager/dist/Command/PresentationSchema");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const DraupnirCommandPrerequisites_1 = require("./DraupnirCommandPrerequisites");
const config_1 = require("../config");
function renderDraupnirHelp(mjolnirTable) {
    return interface_manager_1.DeadDocumentJSX.JSXFactory("root", null, (0, mps_interface_adaptor_1.renderTableHelp)(mjolnirTable, config_1.DOCUMENTATION_URL));
}
exports.DraupnirHelpCommand = (0, interface_manager_1.describeCommand)({
    async executor() {
        return (0, matrix_protection_suite_1.Ok)(DraupnirCommandTable_1.DraupnirTopLevelCommands);
    },
    parameters: [],
    rest: (0, interface_manager_1.describeRestParameters)({
        name: "command parts",
        acceptor: PresentationSchema_1.TopPresentationSchema,
    }),
    summary: "Display this message",
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.DraupnirHelpCommand, {
    JSXRenderer() {
        return (0, matrix_protection_suite_1.Ok)(renderDraupnirHelp(DraupnirCommandTable_1.DraupnirTopLevelCommands));
    },
});
//# sourceMappingURL=Help.js.map