"use strict";
// Copyright 2022 - 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 - 2021 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeProtectedRoomsSet = makeProtectedRoomsSet;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const matrix_protection_suite_for_matrix_bot_sdk_1 = require("matrix-protection-suite-for-matrix-bot-sdk");
const DefaultEnabledProtectionsMigration_1 = require("../protections/ConfigMigration/DefaultEnabledProtectionsMigration");
require("../protections/DraupnirProtectionsIndex");
const ConfigHooks_1 = require("../protections/ConfigHooks");
const MissingProtectionPermissions_1 = require("../protections/MissingProtectionPermissions");
const CapabilitySetProviderMigration_1 = require("../protections/ConfigMigration/CapabilitySetProviderMigration");
const log = new matrix_protection_suite_1.Logger("DraupnirProtectedRoomsSet");
async function makePolicyListConfig(client, roomJoiner) {
    const result = await matrix_protection_suite_1.MjolnirPolicyRoomsConfig.createFromStore(new matrix_protection_suite_for_matrix_bot_sdk_1.BotSDKAccountDataConfigBackend(client, matrix_protection_suite_1.MJOLNIR_WATCHED_POLICY_ROOMS_EVENT_TYPE), roomJoiner);
    return result;
}
async function makeProtectedRoomsConfig(client, roomResolver, loggableConfigTracker) {
    return await matrix_protection_suite_1.MjolnirProtectedRoomsConfig.createFromStore(new matrix_protection_suite_for_matrix_bot_sdk_1.BotSDKAccountDataConfigBackend(client, matrix_protection_suite_1.MJOLNIR_PROTECTED_ROOMS_EVENT_TYPE), roomResolver, loggableConfigTracker);
}
function missingProtectionCB(protectionName) {
    log.warn(`Unable to find a protection description for the protection named`, protectionName);
}
// FIXME: https://github.com/the-draupnir-project/Draupnir/issues/338
function makeMissingProtectionCB() {
    return missingProtectionCB;
}
async function makeProtectionsManager(client, roomStateManager, managementRoom, config, loggableConfigTracker) {
    const result = await roomStateManager.getRoomStateRevisionIssuer(managementRoom);
    if ((0, matrix_protection_suite_1.isError)(result)) {
        return result;
    }
    const protectionsConfigResult = await matrix_protection_suite_1.MjolnirProtectionsConfig.create(new matrix_protection_suite_for_matrix_bot_sdk_1.BotSDKAccountDataConfigBackend(client, matrix_protection_suite_1.MjolnirEnabledProtectionsEventType), loggableConfigTracker, {
        migrationHandler: DefaultEnabledProtectionsMigration_1.DefaultEnabledProtectionsMigration,
        missingProtectionCB: makeMissingProtectionCB(),
    });
    if ((0, matrix_protection_suite_1.isError)(protectionsConfigResult)) {
        return protectionsConfigResult;
    }
    const hookResult = await (0, ConfigHooks_1.runProtectionConfigHooks)(config, protectionsConfigResult.ok);
    if ((0, matrix_protection_suite_1.isError)(hookResult)) {
        return hookResult;
    }
    return (0, matrix_protection_suite_1.Ok)(new matrix_protection_suite_1.StandardProtectionsManager(protectionsConfigResult.ok, new matrix_protection_suite_1.StandardProtectionCapabilityProviderSetConfig((description) => (0, matrix_protection_suite_1.Ok)(new matrix_protection_suite_for_matrix_bot_sdk_1.BotSDKRoomStateConfigBackend(client, managementRoom.toRoomIDOrAlias(), "me.marewolf.draupnir.set_capability_provider", description.name)), CapabilitySetProviderMigration_1.CapabilitySetProviderMigration), new matrix_protection_suite_1.MjolnirProtectionSettingsConfig((description) => (0, matrix_protection_suite_1.Ok)(new matrix_protection_suite_for_matrix_bot_sdk_1.BotSDKRoomStateConfigBackend(client, managementRoom.toRoomIDOrAlias(), matrix_protection_suite_1.MjolnirProtectionSettingsEventType, description.name))), matrix_protection_suite_1.ProtectionHandleRegistryDescription));
}
async function makeProtectedRoomsSet(managementRoom, roomStateManager, policyRoomManager, roomMembershipManager, client, clientPlatform, userID, config, loggableConfigTracker) {
    const protectedRoomsConfig = await makeProtectedRoomsConfig(client, clientPlatform.toRoomResolver(), loggableConfigTracker);
    if ((0, matrix_protection_suite_1.isError)(protectedRoomsConfig)) {
        return protectedRoomsConfig;
    }
    const protectedRoomsManager = await matrix_protection_suite_1.StandardProtectedRoomsManager.create(protectedRoomsConfig.ok, roomStateManager, roomMembershipManager, clientPlatform.toRoomJoiner(), matrix_protection_suite_1.StandardSetRoomMembership.blankSet(), matrix_protection_suite_1.StandardSetRoomState.blankSet());
    if ((0, matrix_protection_suite_1.isError)(protectedRoomsManager)) {
        return protectedRoomsManager;
    }
    const policyListConfig = await makePolicyListConfig(client, clientPlatform.toRoomJoiner());
    if ((0, matrix_protection_suite_1.isError)(policyListConfig)) {
        return policyListConfig;
    }
    const watchedPolicyRooms = await matrix_protection_suite_1.StandardWatchedPolicyRooms.create(policyListConfig.ok, policyRoomManager, clientPlatform.toRoomJoiner());
    if ((0, matrix_protection_suite_1.isError)(watchedPolicyRooms)) {
        return watchedPolicyRooms;
    }
    const protectionsConfig = await makeProtectionsManager(client, roomStateManager, managementRoom, config, loggableConfigTracker);
    if ((0, matrix_protection_suite_1.isError)(protectionsConfig)) {
        return protectionsConfig;
    }
    const protectedRoomsSet = new matrix_protection_suite_1.StandardProtectedRoomsSet(watchedPolicyRooms.ok, protectedRoomsManager.ok, protectionsConfig.ok, userID, matrix_protection_suite_1.DefaultMixinExtractor, (0, MissingProtectionPermissions_1.makeHandleMissingProtectionPermissions)(clientPlatform.toRoomMessageSender(), managementRoom.toRoomIDOrAlias()));
    return (0, matrix_protection_suite_1.Ok)(protectedRoomsSet);
}
//# sourceMappingURL=DraupnirProtectedRoomsSet.js.map