"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardManagementRoomDetail = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
class StandardManagementRoomDetail {
    constructor(managementRoom, membershipIssuer, stateIssuer) {
        this.managementRoom = managementRoom;
        this.membershipIssuer = membershipIssuer;
        this.stateIssuer = stateIssuer;
        // nothing to do mare.
    }
    isRoomPublic() {
        const joinRuleEvent = this.stateIssuer.currentRevision.getStateEvent("m.room.join_rules", "");
        if (joinRuleEvent === undefined) {
            return false; // auth rules are fail safe.
        }
        return joinRuleEvent.content.join_rule === "public";
    }
    isModerator(userID) {
        return (this.membershipIssuer.currentRevision.membershipForUser(userID)
            ?.membership === matrix_protection_suite_1.Membership.Join);
    }
    get managementRoomID() {
        return this.managementRoom.toRoomIDOrAlias();
    }
}
exports.StandardManagementRoomDetail = StandardManagementRoomDetail;
//# sourceMappingURL=ManagementRoomDetail.js.map