import { Ensure, Evaluate } from '../helpers/index';
import { type TSchema } from '../schema/index';
import { type TArray } from '../array/index';
import { type TAwaited } from '../awaited/index';
import { type TAsyncIterator } from '../async-iterator/index';
import { TComputed } from '../computed/index';
import { type TConstructor } from '../constructor/index';
import { type TIndex, type TIndexPropertyKeys } from '../indexed/index';
import { TEnum, type TEnumRecord } from '../enum/index';
import { type TFunction } from '../function/index';
import { type TIntersect, type TIntersectEvaluated } from '../intersect/index';
import { type TIterator } from '../iterator/index';
import { type TKeyOf } from '../keyof/index';
import { type TObject, type TProperties } from '../object/index';
import { type TOmit } from '../omit/index';
import { type TOptional } from '../optional/index';
import { type TPick } from '../pick/index';
import { type TNever } from '../never/index';
import { TPartial } from '../partial/index';
import { type TReadonly } from '../readonly/index';
import { type TRecordOrObject } from '../record/index';
import { type TRef } from '../ref/index';
import { TRequired } from '../required/index';
import { type TTuple } from '../tuple/index';
import { type TUnion, type TUnionEvaluated } from '../union/index';
type TDerefParameters<ModuleProperties extends TProperties, Types extends TSchema[], Result extends TSchema[] = []> = (Types extends [infer Left extends TSchema, ...infer Right extends TSchema[]] ? Left extends TRef<infer Key extends string> ? TDerefParameters<ModuleProperties, Right, [...Result, TDeref<ModuleProperties, Key>]> : TDerefParameters<ModuleProperties, Right, [...Result, TFromType<ModuleProperties, Left>]> : Result);
type TDeref<ModuleProperties extends TProperties, Ref extends string, Result extends TSchema = (Ref extends keyof ModuleProperties ? ModuleProperties[Ref] extends TRef<infer Ref2 extends string> ? TDeref<ModuleProperties, Ref2> : TFromType<ModuleProperties, ModuleProperties[Ref]> : TNever)> = Result;
type TFromAwaited<Parameters extends TSchema[]> = (Parameters extends [infer T0 extends TSchema] ? TAwaited<T0> : never);
type TFromIndex<Parameters extends TSchema[]> = (Parameters extends [infer T0 extends TSchema, infer T1 extends TSchema] ? TIndex<T0, TIndexPropertyKeys<T1>> extends infer Result extends TSchema ? Result : never : never);
type TFromKeyOf<Parameters extends TSchema[]> = (Parameters extends [infer T0 extends TSchema] ? TKeyOf<T0> : never);
type TFromPartial<Parameters extends TSchema[]> = (Parameters extends [infer T0 extends TSchema] ? TPartial<T0> : never);
type TFromOmit<Parameters extends TSchema[]> = (Parameters extends [infer T0 extends TSchema, infer T1 extends TSchema] ? TOmit<T0, T1> : never);
type TFromPick<Parameters extends TSchema[]> = (Parameters extends [infer T0 extends TSchema, infer T1 extends TSchema] ? TPick<T0, T1> : never);
type TFromRecord<Parameters extends TSchema[]> = (Parameters extends [infer T0 extends TSchema, infer T1 extends TSchema] ? TRecordOrObject<T0, T1> : never);
type TFromRequired<Parameters extends TSchema[]> = (Parameters extends [infer T0 extends TSchema] ? TRequired<T0> : never);
type TFromComputed<ModuleProperties extends TProperties, Target extends string, Parameters extends TSchema[], Dereferenced extends TSchema[] = TDerefParameters<ModuleProperties, Parameters>> = (Target extends 'Awaited' ? TFromAwaited<Dereferenced> : Target extends 'Index' ? TFromIndex<Dereferenced> : Target extends 'KeyOf' ? TFromKeyOf<Dereferenced> : Target extends 'Partial' ? TFromPartial<Dereferenced> : Target extends 'Omit' ? TFromOmit<Dereferenced> : Target extends 'Pick' ? TFromPick<Dereferenced> : Target extends 'Record' ? TFromRecord<Dereferenced> : Target extends 'Required' ? TFromRequired<Dereferenced> : TNever);
type TFromObject<ModuleProperties extends TProperties, Properties extends TProperties> = Ensure<TObject<Evaluate<{
    [Key in keyof Properties]: TFromType<ModuleProperties, Properties[Key]>;
}>>>;
type TFromConstructor<ModuleProperties extends TProperties, Parameters extends TSchema[], InstanceType extends TSchema> = (TConstructor<TFromRest<ModuleProperties, Parameters>, TFromType<ModuleProperties, InstanceType>>);
type TFromFunction<ModuleProperties extends TProperties, Parameters extends TSchema[], ReturnType extends TSchema> = Ensure<Ensure<TFunction<TFromRest<ModuleProperties, Parameters>, TFromType<ModuleProperties, ReturnType>>>>;
type TFromTuple<ModuleProperties extends TProperties, Types extends TSchema[]> = (Ensure<TTuple<TFromRest<ModuleProperties, Types>>>);
type TFromIntersect<ModuleProperties extends TProperties, Types extends TSchema[]> = (Ensure<TIntersectEvaluated<TFromRest<ModuleProperties, Types>>>);
type TFromUnion<ModuleProperties extends TProperties, Types extends TSchema[]> = (Ensure<TUnionEvaluated<TFromRest<ModuleProperties, Types>>>);
type TFromArray<ModuleProperties extends TProperties, Type extends TSchema> = (Ensure<TArray<TFromType<ModuleProperties, Type>>>);
type TFromAsyncIterator<ModuleProperties extends TProperties, Type extends TSchema> = (TAsyncIterator<TFromType<ModuleProperties, Type>>);
type TFromIterator<ModuleProperties extends TProperties, Type extends TSchema> = (TIterator<TFromType<ModuleProperties, Type>>);
type TFromRest<ModuleProperties extends TProperties, Types extends TSchema[], Result extends TSchema[] = []> = (Types extends [infer Left extends TSchema, ...infer Right extends TSchema[]] ? TFromRest<ModuleProperties, Right, [...Result, TFromType<ModuleProperties, Left>]> : Result);
export type TFromType<ModuleProperties extends TProperties, Type extends TSchema> = (Type extends TOptional<infer Type extends TSchema> ? TOptional<TFromType<ModuleProperties, Type>> : Type extends TReadonly<infer Type extends TSchema> ? TReadonly<TFromType<ModuleProperties, Type>> : Type extends TArray<infer Type extends TSchema> ? TFromArray<ModuleProperties, Type> : Type extends TAsyncIterator<infer Type extends TSchema> ? TFromAsyncIterator<ModuleProperties, Type> : Type extends TComputed<infer Target extends string, infer Parameters extends TSchema[]> ? TFromComputed<ModuleProperties, Target, Parameters> : Type extends TConstructor<infer Parameters extends TSchema[], infer InstanceType extends TSchema> ? TFromConstructor<ModuleProperties, Parameters, InstanceType> : Type extends TFunction<infer Parameters extends TSchema[], infer ReturnType extends TSchema> ? TFromFunction<ModuleProperties, Parameters, ReturnType> : Type extends TIntersect<infer Types extends TSchema[]> ? TFromIntersect<ModuleProperties, Types> : Type extends TIterator<infer Type extends TSchema> ? TFromIterator<ModuleProperties, Type> : Type extends TObject<infer Properties extends TProperties> ? TFromObject<ModuleProperties, Properties> : Type extends TTuple<infer Types extends TSchema[]> ? TFromTuple<ModuleProperties, Types> : Type extends TEnum<infer _ extends TEnumRecord> ? Type : Type extends TUnion<infer Types extends TSchema[]> ? TFromUnion<ModuleProperties, Types> : Type);
export declare function FromType<ModuleProperties extends TProperties, Type extends TSchema>(moduleProperties: ModuleProperties, type: Type): TFromType<ModuleProperties, Type>;
export type TComputeType<ModuleProperties extends TProperties, Key extends PropertyKey> = (Key extends keyof ModuleProperties ? TFromType<ModuleProperties, ModuleProperties[Key]> : TNever);
export declare function ComputeType<ModuleProperties extends TProperties, Key extends PropertyKey>(moduleProperties: ModuleProperties, key: Key): TComputeType<ModuleProperties, Key>;
export type TComputeModuleProperties<ModuleProperties extends TProperties> = Evaluate<{
    [Key in keyof ModuleProperties]: TComputeType<ModuleProperties, Key>;
}>;
export declare function ComputeModuleProperties<ModuleProperties extends TProperties>(moduleProperties: ModuleProperties): TComputeModuleProperties<ModuleProperties>;
export {};
