import { Result } from "@gnuxie/typescript-result";
import { PartialCommand, Presentation, PresentationArgumentStream } from "../Command";
import { CommandInvokerCallbacks } from "./CommandInvokerCallbacks";
import { StringUserID } from "@the-draupnir-project/matrix-basic-types";
export type CommandNormaliser = (body: string) => string | undefined;
export type LogCurentCommandCB<CommandInformation> = (CommandInformation: CommandInformation, commandParts: Presentation[]) => void;
export interface CommandDispatcherCallbacks<CommandInformation> extends CommandInvokerCallbacks<CommandInformation> {
    readonly logCurrentCommandCB?: LogCurentCommandCB<CommandInformation> | undefined;
    /**
     * A function to normalize a command before dispatch.
     * So for example, removing mention pill formatting or
     * special configuration for bot prefixes etc.
     */
    readonly commandNormaliser: CommandNormaliser;
}
export interface CommandDispatcher<CommandInformation> {
    parsePartialCommandFromBody(commandInformation: CommandInformation, body: string): Result<PartialCommand>;
    parsePartialCommandFromStream(commandInformation: CommandInformation, stream: PresentationArgumentStream): Result<PartialCommand>;
}
type StandardPrefixExtractorOptions = {
    symbolPrefixes: string[];
    isAllowedOnlySymbolPrefixes: boolean;
    additionalPrefixes: string[];
    getDisplayName: () => string;
    normalisedPrefix: string;
};
export declare function makeCommandNormaliser(clientUserID: StringUserID, options: StandardPrefixExtractorOptions): CommandNormaliser;
export {};
//# sourceMappingURL=CommandDispatcher.d.ts.map