"use strict";
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
const typescript_result_1 = require("@gnuxie/typescript-result");
const CommandTable_1 = require("./CommandTable");
const describeCommand_1 = require("./describeCommand");
it("Should be able to import commmands from other tables", function () {
    const AdminCommands = new CommandTable_1.StandardCommandTable("admin commands");
    const DeactivateCommand = (0, describeCommand_1.describeCommand)({
        summary: "Deactivate a user",
        parameters: [],
        async executor() {
            return (0, typescript_result_1.Ok)(true);
        },
    });
    const ShutdownRoomCommand = (0, describeCommand_1.describeCommand)({
        summary: "Shutdown a room",
        parameters: [],
        async executor() {
            return (0, typescript_result_1.Ok)(true);
        },
    });
    AdminCommands.internCommand(DeactivateCommand, ["deactivate"]).internCommand(ShutdownRoomCommand, ["shutdown", "room"]);
    const DraupnirCommandTable = new CommandTable_1.StandardCommandTable("Draupnir");
    DraupnirCommandTable.importTable(AdminCommands, []);
    expect(DraupnirCommandTable.getAllCommands().length).toBe(2);
});
//# sourceMappingURL=CommandTable.test.js.map