import { Result } from "@gnuxie/typescript-result";
import { ParameterDescription } from "./ParameterDescription";
import { ParsedKeywords } from "./ParsedKeywords";
import { Presentation, PresentationTypeWithoutWrap } from "./Presentation";
import { RestDescription } from "./RestParameterDescription";
import { PartialCommand } from "./Command";
import { PresentationSchema } from "./PresentationSchema";
import { KeywordPropertyDescriptionsFromKeywordsMeta, KeywordsMeta } from "./CommandMeta";
/**
 * An extension of ParameterDescription, some keyword arguments
 * may just be flags that have no associated property in syntax,
 * and their presence is to associate the value `true`.
 */
export interface KeywordPropertyDescription<ObjectType = unknown> extends ParameterDescription<ObjectType> {
    readonly isFlag: boolean;
}
export interface DescribeKeywordProperty<ObjectType = unknown> {
    readonly acceptor?: PresentationSchema<ObjectType> | PresentationTypeWithoutWrap<ObjectType>;
    readonly isFlag?: boolean;
    readonly description?: string;
}
/**
 * Describes which keyword arguments can be accepted by a command.
 */
export interface KeywordParametersDescription<TKeywordsMeta extends KeywordsMeta = KeywordsMeta> {
    readonly keywordDescriptions: KeywordPropertyDescriptionsFromKeywordsMeta<TKeywordsMeta>;
    readonly allowOtherKeys?: boolean;
    getParser(): KeywordParser;
}
/**
 * A helper that gets instantiated for each command invoccation to parse and build
 * the map representing the association between keywords and their properties.
 */
export declare class KeywordParser<TKeywordsMeta extends KeywordsMeta = KeywordsMeta> {
    readonly description: KeywordParametersDescription<TKeywordsMeta>;
    private readonly arguments;
    constructor(description: KeywordParametersDescription<TKeywordsMeta>);
    getKeywords(): ParsedKeywords;
    private readKeywordAssociatedProperty;
    parseKeywords(partialCommand: PartialCommand): Result<this>;
    parseRest(partialCommand: PartialCommand, restDescription?: RestDescription): Result<Presentation[] | undefined>;
}
export type DescribeKeywordParametersOptions<TKeywordsMeta extends KeywordsMeta = KeywordsMeta> = {
    readonly keywordDescriptions: {
        [I in keyof TKeywordsMeta]: DescribeKeywordProperty<TKeywordsMeta[I]>;
    };
    readonly allowOtherKeys?: boolean;
};
export declare function describeKeywordParameters<TKeywordsMeta extends KeywordsMeta = KeywordsMeta>(options: DescribeKeywordParametersOptions<TKeywordsMeta>): KeywordParametersDescription<TKeywordsMeta>;
//# sourceMappingURL=KeywordParameterDescription.d.ts.map