import { DocumentNode } from "./DeadDocument";
/**
 * Ideally this would call a callback when a page is ready
 * Unfortunatley there's no way to do that (and await) without making the stream
 * all async. Which is annoying af.
 * Therefore it's necessary for the stream to queue pages
 */
export declare class PagedDuplexStream {
    readonly sizeLimit: number;
    private buffer;
    private pages;
    private lastCommittedNode?;
    constructor(sizeLimit?: number);
    private get currentPage();
    private appendToCurrentPage;
    writeString(string: string): this;
    getPosition(): number;
    isPageAndBufferOverSize(): boolean;
    /**
     * Creates a new page from the previously committed text
     * @returns A page with all committed text.
     */
    ensureNewPage(): void;
    /**
     * Commit the buffered text to the current page.
     * If the buffered text is over the `sizeLimit`, then the current
     * page will be returned first, and then replaced with a new one in order
     * to commit the buffer.
     * @param node A DocumentNode to associate with the commit.
     * @throws TypeError if the buffer is larger than the `sizeLimit`.
     * @returns A page if the buffered text will force the current page to go over the size limit.
     */
    commit(node: DocumentNode): void;
    getLastCommittedNode(): DocumentNode | undefined;
    peekPage(): string | undefined;
    readPage(): string | undefined;
}
//# sourceMappingURL=PagedDuplexStream.d.ts.map