import { BasicInvocationInformation, InvocationInformationFromEventContext, MatrixInterfaceAdaptor } from "./MatrixInterfaceAdaptor";
import { CommandDescription, CommandTable, PresentationArgumentStream } from "../Command";
import { CommandDispatcherCallbacks } from "../Adaptor";
export interface MatrixInterfaceCommandDispatcher<MatrixEventContext> {
    handleCommandMessageEvent(eventContext: MatrixEventContext, body: string): void;
    handleCommandFromPresentationStream(eventContext: MatrixEventContext, stream: PresentationArgumentStream): void;
}
export declare class StandardMatrixInterfaceCommandDispatcher<AdaptorContext, MatrixEventContext> implements MatrixInterfaceCommandDispatcher<MatrixEventContext> {
    private readonly interfaceAdaptor;
    private readonly adaptorContext;
    private readonly commandTable;
    private readonly helpCommand;
    private readonly invocationInformationFromEventContext;
    private readonly baseDispatcher;
    constructor(interfaceAdaptor: MatrixInterfaceAdaptor<AdaptorContext, MatrixEventContext>, adaptorContext: AdaptorContext, commandTable: CommandTable, helpCommand: CommandDescription, invocationInformationFromEventContext: InvocationInformationFromEventContext<MatrixEventContext>, callbacks: CommandDispatcherCallbacks<BasicInvocationInformation>, 
    /**
     * Sometimes it is useful to check whether all commands in a table have a renderer, and all renderers have a command in the table.
     * Becuase people can forget to import them properly. This can be disabled if table imports are dynamic.
     */
    verifyOptions?: {
        verifyRenderers?: boolean;
        verifyTable?: boolean;
    });
    handleCommandFromPresentationStream(eventContext: MatrixEventContext, stream: PresentationArgumentStream): void;
    handleCommandMessageEvent(eventContext: MatrixEventContext, body: string): void;
    private verifyAdaptorRenderingAllCommands;
    private verifyTableImportingAllRenderedCommands;
}
//# sourceMappingURL=MatrixInterfaceCommandDispatcher.d.ts.map