"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
const typescript_result_1 = require("@gnuxie/typescript-result");
const StandardCommandDispatcher_1 = require("./StandardCommandDispatcher");
const describeCommand_1 = require("../Command/describeCommand");
const PresentationSchema_1 = require("../Command/PresentationSchema");
const CommandTable_1 = require("../Command/CommandTable");
const HelpCommand = (0, describeCommand_1.describeCommand)({
    summary: "Shows the help for this command table",
    parameters: [],
    rest: {
        name: "command arguments",
        acceptor: PresentationSchema_1.TopPresentationSchema,
    },
    async executor() {
        return (0, typescript_result_1.Ok)("Shows the help for this command table [this is a test].");
    },
});
it("Can parse a partial command", function () {
    var _a;
    const testTable = new CommandTable_1.StandardCommandTable(Symbol("TestTable"));
    testTable.internCommand(HelpCommand, ["testbot", "help"]);
    const dispatcher = new StandardCommandDispatcher_1.StandardCommandDispatcher(testTable, HelpCommand, {
        commandNormaliser: (body) => body,
    });
    const partialCommand = dispatcher.parsePartialCommandFromBody({ commandSender: "test" }, "testbot help unban");
    if ((0, typescript_result_1.isError)(partialCommand)) {
        throw new TypeError("Should be able to parse the command just fine");
    }
    expect(partialCommand.ok.designator.length).toBe(2);
    expect((_a = partialCommand.ok.stream.peekItem()) === null || _a === void 0 ? void 0 : _a.object).toBe("unban");
});
//# sourceMappingURL=StandardCommandDispatcher.test.js.map