import { Presentation } from "../Command/Presentation";
/**
 * Transforms a command from a string to a list of `Presentation`s.
 * The reader works by reading the command word by word (\S),
 * producing a Presentation for each word.
 * The reader doesn't produce an AST because there isn't any syntax that can make a tree,
 * only a flat list can be produced.
 * This allows commands to be dispatched based on `Presentation` and allows
 * for more efficient (in terms of loc) parsing of arguments.
 *
 * @param string The command.
 * @returns Presentations that have been read from this command.
 */
export declare function readCommand(string: string): Presentation[];
//# sourceMappingURL=TextCommandReader.d.ts.map