"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
const typescript_result_1 = require("@gnuxie/typescript-result");
const describeCommand_1 = require("../Command/describeCommand");
const CommandTable_1 = require("../Command/CommandTable");
const TextPresentationTypes_1 = require("./TextPresentationTypes");
const TextTranslators_1 = require("./TextTranslators");
const JSInterfaceCommandDispatcher_1 = require("./JSInterfaceCommandDispatcher");
const Adaptor_1 = require("../Adaptor");
const ReasonAcceptingCommand = (0, describeCommand_1.describeCommand)({
    summary: "accepts a reason as a string",
    parameters: [],
    rest: {
        name: "command arguments",
        acceptor: TextPresentationTypes_1.StringPresentationType,
    },
    async executor(_context, _info, _keywords, rest) {
        expect(rest.join(" ")).toBe("hello 1234 @foo:localhost:9999 https://matrix.to/#/%23bar%3Alocalhost%3A9999 false");
        return (0, typescript_result_1.Ok)("Accepts a reason for a ban or something.");
    },
});
const testTable = new CommandTable_1.StandardCommandTable(Symbol("TestTable"));
const JSDispatcher = new JSInterfaceCommandDispatcher_1.StandardJSInterfaceCommandDispatcher(testTable, ReasonAcceptingCommand, undefined, { commandNormaliser: (body) => body }, new Adaptor_1.StandardAdaptorContextToCommandContextTranslator());
it("Can parse a partial command", async function () {
    testTable.internCommand(ReasonAcceptingCommand, [
        "testbot",
        "reason",
    ]);
    testTable
        .internPresentationTypeTranslator(TextTranslators_1.StringFromNumberTranslator)
        .internPresentationTypeTranslator(TextTranslators_1.StringFromMatrixUserIDTranslator)
        .internPresentationTypeTranslator(TextTranslators_1.StringFromMatrixRoomAliasTranslator)
        .internPresentationTypeTranslator(TextTranslators_1.StringfromBooleanTranslator);
    const commandBody = "testbot reason hello 1234 @foo:localhost:9999 https://matrix.to/#/#bar:localhost:9999 false";
    const result = await JSDispatcher.invokeCommandFromBody({ commandSender: "@foo:localhost:9999" }, commandBody);
    result.expect("Command should have worked");
});
//# sourceMappingURL=TextTranslators.test.js.map