"use strict";
// SPDX-FileCopyrightText: 2023 Gnuxie <Gnuxie@protonmail.com>
// SPDX-FileCopyrightText: 2018 - 2022 Travis Ralston
//
// SPDX-License-Identifier: MIT
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-bot-sdk
// https://github.com/turt2live/matrix-bot-sdk
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatrixUserID = void 0;
const StringlyTypedMatrix_1 = require("../StringlyTypedMatrix");
const Permalinks_1 = require("./Permalinks");
class MatrixUserID {
    constructor(userID) {
        this.userID = userID;
        // nothing to do.
    }
    static fromUserID(userID) {
        return new MatrixUserID(userID);
    }
    toString() {
        return this.userID;
    }
    toPermalink() {
        return Permalinks_1.Permalinks.forUser(this.userID);
    }
    get localpart() {
        return (0, StringlyTypedMatrix_1.userLocalpart)(this.userID);
    }
    get serverName() {
        return (0, StringlyTypedMatrix_1.userServerName)(this.userID);
    }
    isContainingGlobCharacters() {
        return /[*?]/.test(this.userID);
    }
}
exports.MatrixUserID = MatrixUserID;
//# sourceMappingURL=MatrixUserID.js.map