"use strict";
// SPDX-FileCopyrightText: 2023 - 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-basic-types
// https://github.com/the-draupnir-project/matrix-basic-types
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringRoomAlias = StringRoomAlias;
exports.isStringRoomAlias = isStringRoomAlias;
exports.roomAliasLocalpart = roomAliasLocalpart;
exports.roomAliasServerName = roomAliasServerName;
const StringRoomAliasRegex = /^#(?<roomAliasLocalpart>[^:]*):(?<roomAliasServerName>\S*)$/;
function StringRoomAlias(value) {
    if (typeof value === "string" && isStringRoomAlias(value)) {
        return value;
    }
    throw new TypeError("Not a valid StringRoomAlias");
}
function isStringRoomAlias(string) {
    return StringRoomAliasRegex.test(string);
}
function roomAliasLocalpart(alias) {
    var _a, _b;
    const match = (_b = (_a = StringRoomAliasRegex.exec(alias)) === null || _a === void 0 ? void 0 : _a.groups) === null || _b === void 0 ? void 0 : _b.roomAliasLocalpart;
    if (match === undefined) {
        throw new TypeError("Somehow a StringRoomAlias was created that is invalid.");
    }
    return match;
}
function roomAliasServerName(alias) {
    var _a, _b;
    const match = (_b = (_a = StringRoomAliasRegex.exec(alias)) === null || _a === void 0 ? void 0 : _a.groups) === null || _b === void 0 ? void 0 : _b.roomAliasServerName;
    if (match === undefined) {
        throw new TypeError("Somehow a StringRoomAlias was created that is invalid.");
    }
    return match;
}
//# sourceMappingURL=StringRoomAlias.js.map