import { ActionError, ActionResult, DescriptionMeta, ResultForUsersInRoom, RoomSetResult } from "matrix-protection-suite";
import { StringRoomID, StringUserID } from "@the-draupnir-project/matrix-basic-types";
import { DocumentNode } from "@the-draupnir-project/interface-manager";
export declare function renderElaborationTrail(error: ActionError): DocumentNode;
export declare function renderDetailsNotice(error: ActionError): DocumentNode;
export declare function renderExceptionTrail(error: ActionError): DocumentNode;
export declare function renderFailedSingularConsequence(description: DescriptionMeta, title: DocumentNode, error: ActionError): DocumentNode;
export declare function renderOutcome(isOutcomeOk: boolean): DocumentNode;
export declare function renderRoomOutcome(roomID: StringRoomID, result: ActionResult<unknown>): DocumentNode;
export declare function renderUserOutcome(userID: StringUserID, result: ActionResult<unknown>): DocumentNode;
export declare function renderRoomSetResult(roomResults: RoomSetResult, { summary, showOnlyFailed, }: {
    summary: DocumentNode;
    showOnlyFailed?: boolean;
}): DocumentNode;
export declare function renderResultForUsersInRoom(results: ResultForUsersInRoom, { summary }: {
    summary: DocumentNode;
}): DocumentNode;
//# sourceMappingURL=CommonRenderers.d.ts.map