import { MatrixReactionHandler, ReactionListener } from "./MatrixReactionHandler";
import { StaticDecode } from "@sinclair/typebox";
import { MatrixAdaptorContext, MatrixEventContext } from "./MPSMatrixInterfaceAdaptor";
import { MatrixInterfaceCommandDispatcher, ParameterDescription, PartialCommand, Presentation } from "@the-draupnir-project/interface-manager";
import { Result } from "@gnuxie/typescript-result";
import { StringRoomID } from "@the-draupnir-project/matrix-basic-types";
export type CommandPromptContext = StaticDecode<typeof CommandPromptContext>;
export declare const CommandPromptContext: import("@sinclair/typebox").TObject<{
    command_designator: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
    read_items: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
}>;
export declare function continueCommandAcceptingPrompt(eventContext: MatrixEventContext, promptContext: CommandPromptContext, serializedPrompt: string, commandDispatcher: MatrixInterfaceCommandDispatcher<MatrixEventContext>, reactionHandler: MatrixReactionHandler): void;
export declare const DEFAUILT_ARGUMENT_PROMPT_LISTENER = "ge.applied-langua.ge.draupnir.default_argument_prompt";
export declare function makeListenerForPromptDefault(commandRoomID: StringRoomID, commandDispatcher: MatrixInterfaceCommandDispatcher<MatrixEventContext>, reactionHandler: MatrixReactionHandler): ReactionListener;
export declare const ARGUMENT_PROMPT_LISTENER = "ge.applied-langua.ge.draupnir.argument_prompt";
export declare function makeListenerForArgumentPrompt(commandRoomID: StringRoomID, commandDispatcher: MatrixInterfaceCommandDispatcher<MatrixEventContext>, reactionHandler: MatrixReactionHandler): ReactionListener;
export declare function promptDefault<TPresentation extends Presentation>({ clientPlatform, reactionHandler }: MatrixAdaptorContext, eventContext: MatrixEventContext, parameter: ParameterDescription, command: PartialCommand, defaultPrompt: TPresentation, existingArguments: Presentation[]): Promise<Result<void>>;
export declare function promptSuggestions<TPresentation extends Presentation>({ clientPlatform, reactionHandler }: MatrixAdaptorContext, eventContext: MatrixEventContext, parameter: ParameterDescription, command: PartialCommand, suggestions: TPresentation[], existingArguments: Presentation[]): Promise<Result<void>>;
//# sourceMappingURL=MatrixPromptForAccept.d.ts.map