/**
 * Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 */
import { ActionResult, ClientsInRoomMap, EventDecoder, PolicyRoomManager, PolicyRoomRevisionIssuer, PolicyRuleType, RoomEvent, RoomMembershipManager, RoomMembershipRevisionIssuer, RoomStateBackingStore, RoomStateManager, RoomStateRevisionIssuer, SHA256HashStore } from 'matrix-protection-suite';
import { ClientForUserID } from './ClientManagement';
import { StringRoomID, MatrixRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
export declare class RoomStateManagerFactory {
    readonly clientsInRoomMap: ClientsInRoomMap;
    private readonly clientProvider;
    private readonly eventDecoder;
    private readonly roomStateBackingStore;
    private readonly hashStore;
    private readonly roomStateRefresher;
    private readonly roomStateIssuers;
    private readonly policyRoomIssuers;
    private readonly roomMembershipIssuers;
    private readonly sha256Reverser;
    constructor(clientsInRoomMap: ClientsInRoomMap, clientProvider: ClientForUserID, eventDecoder: EventDecoder, roomStateBackingStore: RoomStateBackingStore | undefined, hashStore: SHA256HashStore | undefined);
    private getRoomStateGetterForRevisionIssuer;
    private requestingUserNotJoined;
    getRoomStateRevisionIssuer(room: MatrixRoomID, clientUserID: StringUserID): Promise<ActionResult<RoomStateRevisionIssuer>>;
    getRoomStateManager(clientUserID: StringUserID): Promise<RoomStateManager>;
    getPolicyRoomRevisionIssuer(room: MatrixRoomID, clientUserID: StringUserID): Promise<ActionResult<PolicyRoomRevisionIssuer>>;
    getEditablePolicyRoomIDs(editor: StringUserID, ruleType: PolicyRuleType): MatrixRoomID[];
    getPolicyRoomManager(clientUserID: StringUserID): Promise<PolicyRoomManager>;
    getRoomMembershipRevisionIssuer(room: MatrixRoomID, clientUserID: StringUserID): Promise<ActionResult<RoomMembershipRevisionIssuer>>;
    getRoomMembershipManager(clientUserID: StringUserID): Promise<RoomMembershipManager>;
    handleTimelineEvent(roomID: StringRoomID, event: RoomEvent): void;
}
//# sourceMappingURL=RoomStateManagerFactory.d.ts.map