"use strict";
/**
 * Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BotSDKMatrixStateData = exports.BotSDKRoomStateConfigBackend = exports.BotSDKMatrixAccountData = exports.BotSDKAccountDataConfigBackend = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const BotSDKBaseClient_1 = require("../Client/BotSDKBaseClient");
class BotSDKAccountDataConfigBackend {
    constructor(client, eventType) {
        this.client = client;
        this.eventType = eventType;
        // nothing to do.
    }
    async requestUnparsedConfig() {
        return await this.client
            .getAccountData(this.eventType)
            .then((data) => (0, matrix_protection_suite_1.Ok)(data), BotSDKBaseClient_1.resultifyBotSDKRequestErrorWith404AsUndefined);
    }
    async saveEncodedConfig(data) {
        return await this.client
            .setAccountData(this.eventType, data)
            .then((_) => (0, matrix_protection_suite_1.Ok)(undefined), BotSDKBaseClient_1.resultifyBotSDKRequestError);
    }
    async saveUnparsedConfig(data) {
        return await this.client
            .setAccountData(this.eventType, data)
            .then((_) => (0, matrix_protection_suite_1.Ok)(undefined), BotSDKBaseClient_1.resultifyBotSDKRequestError);
    }
}
exports.BotSDKAccountDataConfigBackend = BotSDKAccountDataConfigBackend;
class BotSDKMatrixAccountData {
    constructor(eventType, eventSchema, client) {
        this.eventType = eventType;
        this.eventSchema = eventSchema;
        this.client = client;
        // nothing to do.
    }
    async requestAccountData() {
        return await this.client.getAccountData(this.eventType).then((data) => matrix_protection_suite_1.Value.Decode(this.eventSchema, data), (error) => (0, BotSDKBaseClient_1.is404)(error)
            ? (0, matrix_protection_suite_1.Ok)(undefined)
            : matrix_protection_suite_1.ActionException.Result(`Encountered an error when requesting matrix account data ${this.eventType}`, { exception: error, exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown }));
    }
    async storeAccountData(data) {
        const encodeResult = matrix_protection_suite_1.Value.Encode(this.eventSchema, data);
        if ((0, matrix_protection_suite_1.isError)(encodeResult)) {
            return encodeResult;
        }
        return await this.client
            .setAccountData(this.eventType, encodeResult.ok)
            .then((_) => (0, matrix_protection_suite_1.Ok)(undefined), (exception) => matrix_protection_suite_1.ActionException.Result(`Unable to store matrix account data ${this.eventType}`, {
            exception,
            exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Unknown,
        }));
    }
}
exports.BotSDKMatrixAccountData = BotSDKMatrixAccountData;
// FIXME: This is incorrect, it's supposed to wrap the standard thingy.
class BotSDKRoomStateConfigBackend {
    constructor(client, roomID, eventType, stateKey) {
        this.client = client;
        this.roomID = roomID;
        this.eventType = eventType;
        this.stateKey = stateKey;
        // nothing to do.
    }
    async requestUnparsedConfig() {
        return await this.client
            .getRoomStateEvent(this.roomID, this.eventType, this.stateKey)
            .then((data) => (0, matrix_protection_suite_1.Ok)(data), BotSDKBaseClient_1.resultifyBotSDKRequestErrorWith404AsUndefined);
    }
    async saveEncodedConfig(data) {
        return await this.client
            .sendStateEvent(this.roomID, this.eventType, this.stateKey, data)
            .then((_) => (0, matrix_protection_suite_1.Ok)(undefined), BotSDKBaseClient_1.resultifyBotSDKRequestError);
    }
}
exports.BotSDKRoomStateConfigBackend = BotSDKRoomStateConfigBackend;
class BotSDKMatrixStateData {
    constructor(eventType, roomStateRevisionIssuer, client) {
        this.eventType = eventType;
        this.roomStateRevisionIssuer = roomStateRevisionIssuer;
        this.client = client;
        // nothing to do.
    }
    requestStateContent(state_key) {
        const event = this.roomStateRevisionIssuer.currentRevision.getStateEvent(this.eventType, state_key);
        return event === null || event === void 0 ? void 0 : event.content;
    }
    async storeStateContent(state_key, content) {
        return await this.client
            .sendStateEvent(this.roomStateRevisionIssuer.room.toRoomIDOrAlias(), this.eventType, state_key, content)
            .then((_) => (0, matrix_protection_suite_1.Ok)(undefined), (exception) => matrix_protection_suite_1.ActionException.Result(`Unable to store the matrix state data ${this.eventType}`, {
            exception,
            exceptionKind: matrix_protection_suite_1.ActionExceptionKind.Known,
        }));
    }
}
exports.BotSDKMatrixStateData = BotSDKMatrixStateData;
//# sourceMappingURL=MatrixData.js.map