"use strict";
/* eslint-disable @typescript-eslint/unified-signatures */
/**
 * Copyright (C) 2022 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 *
 * This file is modified and is NOT licensed under the Apache License.
 * This modified file incorperates work from mjolnir
 * https://github.com/matrix-org/mjolnir
 * which included the following license notice:

Copyright 2019-2022 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 *
 * However, this file is modified and the modifications in this file
 * are NOT distributed, contributed, committed, or licensed under the Apache License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SafeMatrixEmitterWrapper = void 0;
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const events_1 = __importDefault(require("events"));
const matrix_protection_suite_1 = require("matrix-protection-suite");
const log = new matrix_protection_suite_1.Logger('MatrixEmitter');
function makeListenerWrapper(decoder, event, safeEmitter) {
    return function (roomId, mxEvent) {
        if (!(0, matrix_basic_types_1.isStringRoomID)(roomId)) {
            throw new TypeError(`Got a malformed room_id ${roomId}`);
        }
        mxEvent['room_id'] = roomId;
        const decodeResult = decoder.decodeEvent(mxEvent);
        if ((0, matrix_protection_suite_1.isError)(decodeResult)) {
            log.error(`Got an error when decoding an event for a MatrixEmitter`, decodeResult.error.uuid, decodeResult.error);
            return;
        }
        safeEmitter.emit(event, roomId, decodeResult.ok);
    };
}
class SafeMatrixEmitterWrapper extends events_1.default {
    constructor(emitter, decoder) {
        super();
        this.emitter = emitter;
        this.decoder = decoder;
        const events = [
            'room.event',
            'room.message',
            'room.invite',
            'room.join',
            'room.leave',
            'room.archived',
        ];
        for (const event of events) {
            // The overloads for event names in typescript don't quite work.
            // eslint-disable-next-line @typescript-eslint/ban-ts-comment
            //@ts-ignore
            emitter.on(event, makeListenerWrapper(this.decoder, event, this));
        }
    }
    start() {
        return this.emitter.start();
    }
    stop() {
        this.emitter.stop();
    }
}
exports.SafeMatrixEmitterWrapper = SafeMatrixEmitterWrapper;
//# sourceMappingURL=MatrixEmitter.js.map