"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientCapabilitiesResponse = exports.ClientCapabilities = void 0;
const typebox_1 = require("@sinclair/typebox");
const RoomVersionStability = typebox_1.Type.Union([typebox_1.Type.Literal('stable'), typebox_1.Type.Literal('unstable')], { title: 'RoomVersionStability' });
const RoomVersionsCapability = typebox_1.Type.Object({
    default: typebox_1.Type.String({
        description: 'The default room version the server is using for new rooms.',
        example: '1',
    }),
    available: typebox_1.Type.Record(typebox_1.Type.String(), RoomVersionStability),
}, {
    description: 'The room versions the server supports.',
    title: 'RoomVersionsCapability',
});
exports.ClientCapabilities = typebox_1.Type.Object({
    'm.change_password': typebox_1.Type.Object({
        enabled: typebox_1.Type.Boolean(),
    }, {
        description: 'Capability to indicate if the user can change their password.',
    }),
    'm.room_versions': RoomVersionsCapability,
    'm.set_displayname': typebox_1.Type.Object({
        enabled: typebox_1.Type.Boolean(),
    }, {
        description: 'Capability to indicate if the user can change their display name.',
    }),
    'm.set_avatar_url': typebox_1.Type.Object({
        enabled: typebox_1.Type.Boolean(),
    }, {
        description: 'Capability to indicate if the user can change their avatar.',
    }),
    'm.3pid_changes': typebox_1.Type.Object({
        enabled: typebox_1.Type.Boolean(),
    }, {
        description: 'Capability to indicate if the user can change 3PID associations on their account.',
    }),
    'm.get_login_token': typebox_1.Type.Object({
        enabled: typebox_1.Type.Boolean(),
    }, {
        description: 'Capability to indicate if the user can generate tokens to log further clients into their account.',
    }),
}, {
    additionalProperties: true,
});
exports.ClientCapabilitiesResponse = typebox_1.Type.Object({
    capabilities: exports.ClientCapabilities,
}, {
    title: 'ClientCapabilitiesResponse',
});
//# sourceMappingURL=ClientCapabilityNegotiation.js.map