"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.PowerLevelsMirror = exports.PowerLevelPermission = void 0;
const CreateRoom_1 = require("../MatrixTypes/CreateRoom");
var PowerLevelPermission;
(function (PowerLevelPermission) {
    PowerLevelPermission["Ban"] = "ban";
    PowerLevelPermission["Invite"] = "invite";
    PowerLevelPermission["Kick"] = "kick";
    PowerLevelPermission["Redact"] = "redact";
})(PowerLevelPermission || (exports.PowerLevelPermission = PowerLevelPermission = {}));
exports.PowerLevelsMirror = Object.freeze({
    getUserPowerLevel(who, content) {
        var _a, _b, _c;
        return (_c = (_b = (_a = content === null || content === void 0 ? void 0 : content.users) === null || _a === void 0 ? void 0 : _a[who]) !== null && _b !== void 0 ? _b : content === null || content === void 0 ? void 0 : content.users_default) !== null && _c !== void 0 ? _c : 0;
    },
    getStatePowerLevel(eventType, content) {
        var _a, _b, _c;
        return (_c = (_b = (_a = content === null || content === void 0 ? void 0 : content.events) === null || _a === void 0 ? void 0 : _a[eventType]) !== null && _b !== void 0 ? _b : content === null || content === void 0 ? void 0 : content.state_default) !== null && _c !== void 0 ? _c : 50;
    },
    getEventPowerLevel(eventType, content) {
        var _a, _b, _c;
        return (_c = (_b = (_a = content === null || content === void 0 ? void 0 : content.events) === null || _a === void 0 ? void 0 : _a[eventType]) !== null && _b !== void 0 ? _b : content === null || content === void 0 ? void 0 : content.events_default) !== null && _c !== void 0 ? _c : 0;
    },
    isUserAbleToSendState(who, eventType, content) {
        return (this.getUserPowerLevel(who, content) >=
            this.getStatePowerLevel(eventType, content));
    },
    isUserAbleToUse(who, permission, content) {
        var _a;
        const userLevel = this.getUserPowerLevel(who, content);
        const defaultPowerLevel = permission === PowerLevelPermission.Invite ? 0 : 50;
        const permissionLevel = (_a = content === null || content === void 0 ? void 0 : content[permission]) !== null && _a !== void 0 ? _a : defaultPowerLevel;
        return userLevel >= permissionLevel;
    },
    isUserAbleToSendEvent(who, eventType, content) {
        return (this.getUserPowerLevel(who, content) >=
            this.getStatePowerLevel(eventType, content));
    },
    missingPermissions(clientUserID, requiredPermissions, powerLevelsContent) {
        const missingPermissions = [];
        for (const permission of requiredPermissions) {
            if (!exports.PowerLevelsMirror.isUserAbleToUse(clientUserID, permission, powerLevelsContent)) {
                missingPermissions.push(permission);
            }
        }
        return missingPermissions;
    },
    missingStatePermissions(clientUserID, requiredStatePermissions, powerLevelsContent) {
        const missingPermissions = [];
        for (const permission of requiredStatePermissions) {
            if (!exports.PowerLevelsMirror.isUserAbleToSendState(clientUserID, permission, powerLevelsContent)) {
                missingPermissions.push(permission);
            }
        }
        return missingPermissions;
    },
    missingEventPermissions(clientUserID, requiredEventPermissions, powerLevelsContent) {
        const missingPermissions = [];
        for (const permission of requiredEventPermissions) {
            if (!exports.PowerLevelsMirror.isUserAbleToSendEvent(clientUserID, permission, powerLevelsContent)) {
                missingPermissions.push(permission);
            }
        }
        return missingPermissions;
    },
    calculateMissingPermissionsInNewRoom(userID, options) {
        return this.calculateNewMissingPermissions(userID, {
            ...options,
            previousPowerLevelsContent: {
                users_default: -1,
            },
            isNewlyAddedRoom: true,
        });
    },
    calculateNewMissingPermissions(userID, { createEvent, nextPowerLevelsContent, previousPowerLevelsContent, requiredEventPermissions, requiredPermissions, requiredStatePermissions, isNewlyAddedRoom, }) {
        if (CreateRoom_1.RoomVersionMirror.isUserAPrivilidgedCreator(userID, createEvent)) {
            return {
                missingStatePermissions: [],
                missingPermissions: [],
                missingEventPermissions: [],
                isPrivilidgedInNextPowerLevels: true,
                isPrivilidgedInPriorPowerLevels: isNewlyAddedRoom ? false : true,
            };
        }
        const nextMissingPermissions = this.missingPermissions(userID, requiredPermissions, nextPowerLevelsContent);
        const previousMissingPermissions = this.missingPermissions(userID, requiredPermissions, previousPowerLevelsContent);
        const nextMissingStatePermissions = this.missingStatePermissions(userID, requiredStatePermissions, nextPowerLevelsContent);
        const previousMissingStatePermissions = this.missingStatePermissions(userID, requiredStatePermissions, previousPowerLevelsContent);
        const nextMissingEventPermissions = this.missingEventPermissions(userID, requiredEventPermissions, nextPowerLevelsContent);
        const previousMissingEventPermissions = this.missingEventPermissions(userID, requiredEventPermissions, previousPowerLevelsContent);
        const isPrivilidgedInNextRevision = nextMissingStatePermissions.length === 0 &&
            nextMissingEventPermissions.length === 0 &&
            nextMissingPermissions.length === 0;
        const isPrivilidgedInPriorRevision = previousMissingStatePermissions.length === 0 &&
            previousMissingEventPermissions.length === 0 &&
            previousMissingPermissions.length === 0;
        return {
            missingStatePermissions: nextMissingStatePermissions,
            missingPermissions: nextMissingPermissions,
            missingEventPermissions: nextMissingEventPermissions,
            isPrivilidgedInNextPowerLevels: isPrivilidgedInNextRevision,
            isPrivilidgedInPriorPowerLevels: isPrivilidgedInPriorRevision,
        };
    },
});
//# sourceMappingURL=PowerLevelsMirror.js.map