"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
const DeclareRoomState_1 = require("../StateTracking/DeclareRoomState");
const EventGeneration_1 = require("../TestUtilities/EventGeneration");
const PowerLevelsMirror_1 = require("./PowerLevelsMirror");
test('What happens when we are missing all permissions', function () {
    const userID = (0, EventGeneration_1.randomUserID)();
    const powerLevelscontent = {};
    const result = PowerLevelsMirror_1.PowerLevelsMirror.calculateNewMissingPermissions(userID, {
        createEvent: (0, DeclareRoomState_1.describeStateEvent)({
            type: 'm.room.create',
            content: {},
            sender: (0, EventGeneration_1.randomUserID)(),
            state_key: '',
        }),
        nextPowerLevelsContent: powerLevelscontent,
        previousPowerLevelsContent: powerLevelscontent,
        requiredStatePermissions: ['m.room.server_acl'],
        requiredPermissions: [
            PowerLevelsMirror_1.PowerLevelPermission.Ban,
            PowerLevelsMirror_1.PowerLevelPermission.Redact,
        ],
        requiredEventPermissions: [],
    });
    expect(result.isPrivilidgedInNextPowerLevels).toBe(false);
    expect(result.isPrivilidgedInPriorPowerLevels).toBe(false);
    expect(result.missingStatePermissions.length).toBe(1);
    expect(result.missingPermissions.length).toBe(2);
});
//# sourceMappingURL=PowerLevelsMirror.test.js.map